*************************************************************************
*     
*     Common level2.f
*     
*     contains LEVEL2 ntuple variables definitions
*     
*************************************************************************


      PARAMETER (NPLANES=6)
      PARAMETER (NTRKMAX=50)    !ncloyz_max*ncloxz_max)
      PARAMETER (NSINGMAX=500)
*     -----------------------------------------------------------
      logical good2             !flag to mark good or noise events
      integer nev2              !level2 event number
      integer which_calib       !calibration file identifier. see DW_DATE_NUM_calib.txt file
      integer swcode            !version of the software
      logical crc(12)           !DSP crc controll
      common/level2/good2,nev2,which_calib,swcode,crc
c*****************************************************
c     CPU block (only for ground data):
*     -----------------------------------------------------------
      integer pkt_type          !CPU packet type identifier. see http://people.roma2.infn.it/~cpu/HB_list.txt
c     0x12 --> calibration board 0                  
c     0x13 --> calibration board 1              
c     0x10 --> event                            
c     0x30 --> full event for calib special     
c     0x83 --> tracker ALARM (control register) 
      integer pkt_num           !CPU packet number
      integer obt               !CPU on-board time
      logical cpu_crc           !CPU crc controll
      common/level2_cpu/pkt_type,pkt_num,obt,cpu_crc
c****************************************************

*     -----------------------------------------------------------
*     Common to store TRACK info
*     All the variables have a dimention equal to the number of
*     found tracks
*     -----------------------------------------------------------
c     TRACK PARAMETERS      
      integer ntrk              !# identified tracks
      integer image             !flag to tag track-images
      real al	                !track state vector
      real coval                !covariance matrix
      integer xgood	     	!mask of used planes
      integer ygood	        !*
      real xm               	!measured points
      real ym               	!*	
      real zm           	!*	
      real resx         	!spatial resolution
      real resy          	!*
      real chi2                 !chi2
      real xv                   !calculated points
      real yv                   !*
      real zv                   !*
      real axv                  !calculated angles (deg)
      real ayv                  !*
      real dedx_x               !signal in MIP scaled to 300 micrometer
      real dedx_y               !signal in MIP scaled to 300 micrometer
      real bdl
c****************************************************

      common/level2_tracks/
     $      ntrk
     $     ,image(NTRKMAX)
     $     ,xm(nplanes,NTRKMAX)
     $     ,ym(nplanes,NTRKMAX)
     $     ,zm(nplanes,NTRKMAX)
     $     ,resx(nplanes,NTRKMAX)
     $     ,resy(nplanes,NTRKMAX)
     $     ,al(5,NTRKMAX)
     $     ,coval(5,5,NTRKMAX)
     $     ,chi2(NTRKMAX)
     $     ,xgood(nplanes,NTRKMAX)
     $     ,ygood(nplanes,NTRKMAX)
     $     ,xv(nplanes,NTRKMAX)
     $     ,yv(nplanes,NTRKMAX)
     $     ,zv(nplanes,NTRKMAX)
     $     ,axv(nplanes,NTRKMAX)
     $     ,ayv(nplanes,NTRKMAX)
     $     ,dedx_x(nplanes,NTRKMAX)
     $     ,dedx_y(nplanes,NTRKMAX)
     $     ,bdl(NTRKMAX)

*     -----------------------------------------------------------
*     Common to store SINGLET info
*     (clusters not associated with any track) 
*     -----------------------------------------------------------
      
      integer nclsx             !# unassociated clusters  X views
      integer planex            !plane of single x
      real xs                   !center coord of single x
      real sgnlxs               !signal in MIP of single x
      common/level2_singletsx/
     $     nclsx,planex(NSINGMAX),xs(2,NSINGMAX),sgnlxs(NSINGMAX) !(2)

      integer nclsy             !     "            "      Y views
      integer planey            !plane of single y
      real ys                   !center coord of single y
      real sgnlys               !signal in MIP of single y

      common/level2_singletsy/
     $     nclsy,planey(NSINGMAX),ys(2,NSINGMAX),sgnlys(NSINGMAX) !(2)
*********************************************************

