
*************************************************************************
*     Program template.f
*
*     - template to access LEVEL2 tracker data 
*       and use the track parameters to evaluate the 
*       the particle trajectory in the apparatus
*     
*************************************************************************

      program template


      include 'trk_level2.f'

c----- HBOOK
      INTEGER HMEM
      parameter (NWPAWC=8500000)
      common/PAWC/HMEM(NWPAWC)

      parameter (ntp_level2=22)
c------------------------------------------------------------------------
c     
c     local variables
c     
c------------------------------------------------------------------------
      character*74 data_file    !data file name
      character*74 data_dir     !data directory
      character*74 data_file_level2

      parameter (lun_data_level2=72) !data file id number


      logical general,single,column,trackok
      integer l1,s1,l6,s6


      COMMON/QUEST/IQUEST(100) 

c     =======================================
c     variables for tracking routine
c     =======================================
      parameter(NPOINT_MAX=100)
      DOUBLE PRECISION ZIN(NPOINT_MAX)
      DOUBLE PRECISION XOUT(NPOINT_MAX),YOUT(NPOINT_MAX)
      DOUBLE PRECISION AL_P(5)
c     =======================================

c     define TOF Z-coordinates
      parameter (NPTOF=3)
      REAL ZTOF(NPTOF)      
      DATA ZTOF/55.,25.,-23/    !NB!!!  from TOP to BOTTOM

c------------------------------------------------------------------------
c     
c     HBOOK initialization
c     
c------------------------------------------------------------------------
      
      call HLIMIT(NWPAWC)
c------------------------------------------------------------------------
c     
c     reads input informations
c     
c------------------------------------------------------------------------
 111  format(a)
      print*,'Data dir:'      
      read(*,111)data_dir
      print*,data_dir
      print*,'Data file'      
      print*,'(without estention: output_YYMMDD_XXX )'
      read(*,*)data_file     
      print*,data_file
      minevent=1
      print*,'Maximum number of events to be analysed:'
      read(*,*) ntotev
      print*,ntotev    
      print*,'-----------------------------------------'
      print*,''
c------------------------------------------------------------------------
c     
c     opens level2 file
c     
c------------------------------------------------------------------------
 504  format(a,a,'_level2.rz')
      write(data_file_level2,504)
     $     data_dir(1:LNBLNK(data_dir))
     $     ,data_file(1:LNBLNK(data_file))
      print*,'__________ opening LEVEL2 rz file __________'
      print*,data_file_level2
      IQUEST(10)=65000      
      call HROPEN(lun_data_level2,
     $     'LEVEL2',data_file_level2,'QP',4096,istat) !opens rz  
      if(istat.ne.0) goto 19      
      print*,'reading LEVEL2 n-tuple...'
      call HRIN(ntp_level2,9999,0)       

*     -----------------------------------------------
      CALL HBNAME(ntp_level2,' ',0,'$CLEAR')
      CALL HBNAME(ntp_level2,'GENERAL',GOOD2,'$SET')
      CALL HBNAME(ntp_level2,'CPU',pkt_type,'$SET')
      CALL HBNAME(ntp_level2,'TRACKS',ntrk,'$SET')
      CALL HBNAME(ntp_level2,'SINGLETX',nclsx,'$SET')
      CALL HBNAME(ntp_level2,'SINGLETY',nclsy,'$SET')
*     -----------------------------------------------

      call HPRNTU(ntp_level2)  
      call HNOENT(ntp_level2,iemax0)
      print*,'ok'
      print*,' '


c------------------------------------------------------------------------
c     
c     =======================
c     read magnetic field map
c     =======================
c     
c------------------------------------------------------------------------
      print*,'- read magnetic field map'
      print*,' '
      call read_B
      print*,' '

      call HCDIR('//LEVEL2',' ')

c------------------------------------------------------------------------
c     ////////////////////
c     
c     start loop on events
c     
c     \\\\\\\\\\\\\\\\\\\\
c------------------------------------------------------------------------
      maxevent=minevent+ntotev
      do iev = minevent,MIN(iemax0,maxevent) !loop on events

*        ----------------------------------------------
         call HGNT(ntp_level2,iev,ierr) !reads an event
         if(ierr.ne.0) goto 21
*        ----------------------------------------------


*=======> INSTERT HERE YOUR CODE     


*     initializations
         do itof=1,NPTOF
            XOUT(itof) = 0 
            YOUT(itof) = 0
         enddo

*	########################################
*       GENERAL CUTS
	general = .true.
	if (
     +   .not.GOOD2.or.
     +    ntrk.eq.0.or.
     +    .false.) general = .false.
	if(.not.general)goto 100

*	########################################
*       SINGLE TRACK
	single = .false.
	itrk = 0
	if(ntrk.eq.1)then
	   single = .true.
	   itrk = 1
	elseif(ntrk.eq.2..and.image(1).ne.0)then
	   single = .true.
*          -----------------
*          CHOSE THE IMAGE!!
*          -----------------
	   itrk = 1
	   if(CHI2(image(1)).lt.CHI2(1))itrk = 2
*          -----------------
	endif
	if(.not.single)goto 100

*	########################################
*       GEOMETRY

	l1 = int( p1_ladder(XV(1,itrk)))
	l6 = int( p1_ladder(XV(6,itrk)))
	s1 = int( p1_sensor(YV(1,itrk)))
	s6 = int( p1_sensor(YV(6,itrk)))
	column=.false.
	if(
     +      l1.eq.l6.and.
     +      l1.ne.0.and.
     +      s1.eq.s6.and.
     +      s1.ne.0.and.
     +     .true.)column=.true.
c$$$	if(.not.column)goto 100

	
*	########################################
*       TRACK SELECTION
	trackok = .false.
	npx = 0
	npy = 0
	do i=1,6
	   npx = npx + XGOOD(i,itrk)
	   npy = npy + YGOOD(i,itrk)
	enddo
*       POINTS ----------------------------------
	if(
     +    npy.ge.4.and.
     +    npx.ge.5.and.
c     +    npy.ge.6.and.
c     +    npx.ge.6.and.
     +    XGOOD(1,itrk).eq.1.and.
     +    XGOOD(6,itrk).eq.1.and.
     +    CHI2(itrk).gt.0.and.
     +    .true.) trackok = .true.

	rig=abs(1./AL(5,itrk))

*       CHI^2 ------------------------------------
        chicut = 10.             !
        chicut = chicut *( 
     $       3.7032*exp(-0.41911E-01*rig)
     $       +0.85355
     $       +10.905*exp(-0.61893*rig) )
	if(
     +     CHI2(itrk).gt.chicut.and. 
     +    .true.)trackok = .false.
	
*       CLUSTERS OUT OF THE TRACK --------------------------
	ncls=nclsx+nclsy
	if(ncls.gt.0)trackok = .false.

*       RIGIDITY ----------------------------------
*       *******************************************
	if(
     +    rig.lt.5..and.
     +    .true.)trackok = .false.
*       *******************************************

	if(.not.trackok)goto 100 

*    


        print*,'----------------------------------'
        print*,'Event ',iev,' selected'
*     assigned input  parameters for track routine
*     1) Z-coordinates where the trajectory is evaluated
        do itof=1,NPTOF
           ZIN(itof) = ZTOF(itof) 
        enddo
*     2) track status vector
        do i=1,5
           AL_P(i) = AL(i,itrk)
        enddo
*     -------- *** tracking routine *** --------
        call track(NPTOF,ZIN,XOUT,YOUT,AL_P,IFAIL)
*     ------------------------------------------
        do itof=1,NPTOF                  
           print*,'S',itof,' --- (z,x,y) = '
     $          ,ZIN(itof),XOUT(itof),YOUT(itof)
        enddo
        
        
        
        

 100    continue
      enddo                     !end loop on events
      GOTO 9000                 !got to end

c------------------------------------------------------------------------
c     
c     data file opening error
c     
c------------------------------------------------------------------------
 19   continue
      
      print*,' '
      print*,'ERROR OPENING DATA FILE: ',data_file
      print*,' '
      print*,' '
      
      goto 9000                 !the end

c------------------------------------------------------------------------
c     
c     level2 ntuple event reading error
c     
c------------------------------------------------------------------------
      
 21   continue
      
      print*,' '
      print*,'ERROR WHILE READING LEVEL2 NTUPLE, AT EVENT
     $     : ',iev
      print*,' '
      print*,' '
      
      goto 9000                 !the end

c------------------------------------------------------------------------
c     
c     closes files and exits
c     
c------------------------------------------------------------------------

 9000 continue

      call HCDIR('//LEVEL2',' ')
      call HREND('level2')
      close(lun_data_level2)

      return
      end


c      include 'access_level2.f'
c      include 'track.f'

      function p1_ladder(x)
      
      real xlimit(4)
      data xlimit/-7.995,-2.665,2.665,7.995/
      parameter (xmargin=0.5)
c     parameter (xmargin=1.)
      real xlo,xhi
      
	

      nladder=0
      do i=2,4
         xlo=xlimit(i-1)+xmargin
         xhi=xlimit(i)-xmargin
         if(
     +        x.lt.xhi.and.
     +        x.ge.xlo)then
            nladder=i-1
            goto 10
         endif
      enddo
 10   continue
      p1_ladder=nladder
      
      return
      end
      
      function p1_sensor(y)
      
      real ylimit(3)
      data ylimit/-7.,0.,7./
      parameter (ymargin=0.5)
c     parameter (ymargin=2.)
      real ylo,yhi
      
      nsensor=0
      do i=2,3
         ylo=ylimit(i-1)+ymargin
         yhi=ylimit(i)-ymargin
         if(
     +        y.lt.yhi.and.
     +        y.ge.ylo)then
            nsensor=i-1
            goto 10
         endif
      enddo
 10   continue
      p1_sensor=nsensor
      
      return
      end
      
