*************************************************************************
*     
*     Subroutine cncomp.f 
*     
*     iterates common noise computation subroutine (./cnoise.f) and cluster
*     cutting subroutine (./cutcn.f) till no more clusters are found
*          
*************************************************************************

      subroutine cncomp(i,j)    !(view, VA1)

      include '../common/commontracker.f'
      include '../common/common_reduction.f'
      include '../common/calib.f'

      integer errflag           !error flag to mark no signal free VA1

      integer clstr_old(nstrips_va1) !flag storage vector

      real signal(nstrips_va1)  !"signal" (=adc-ped) value storage vector

      real smean, ssigma        !"signal" mean and sigma
      real cut                  !"strange" strip exclusion cut

      integer newclstr          !flag to warn about new found clusters to be
                                ! excluded from common noise computation 


c     call HBOOK1(20000+100*i+j,' ',30,0.,30.,0.) !???

c------------------------------------------------------------------------
c     
c     variables initialization
c     
c------------------------------------------------------------------------
      do k=1,nstrips_va1        !loops on strips
         clstr(i,j,k)=1         !initializes signal affected strips flag
         clstr_old(k)=1         !initializes signal affected strips storage 
         strange(i,j,k)=1       !initializes unusually high or low signal 
      enddo                     ! affected strips flag

      newclstr=1                !flag to warn about new found signal 
                                ! affected strips



c------------------------------------------------------------------------
c     
c     high or low signal affected strips exclusion: computes "signal" (=adc-ped)
c     mean value and sigma, and cuts from common noise computation strips
c     whose ABS(signal) exceeds scut*sigma
c     
c------------------------------------------------------------------------
      countme=0                 !???
 666  continue                  !???

      smean=0.                  !initialization
      ssigma=0.
      nstr=0
      
      do k=1,nstrips_va1
         nstr=nstr+strange(i,j,k) !uses only
         if(mod(i,2).eq.1) then !odd strip ---> Y view
            signal(k)= - (DBLE(adc(i,j,k))-pedestal(i,j,k)) !negative signal
         else                   !even strip ---> X view
            signal(k)= DBLE(adc(i,j,k))-pedestal(i,j,k) !positive signal
         endif
         
         smean=smean+signal(k)*strange(i,j,k)
         ssigma=ssigma+(signal(k)**2)*strange(i,j,k)
         
c     call HFILL(10000+100*i+j,signal(k),0.,1.) !???
      enddo
      
      smean=smean/nstr          !strips value distribution mean
      
      ssigma=SQRT((ssigma/nstr)-smean**2) !strips value distribution sigma
      
      cut=scut*ssigma           !exclusion cut
      
      do k=1,nstrips_va1
c     call HFILL(20000+100*i+j,ABS(signal(k)-smean)/ssigma,0.,1.) !???
         if(ABS(signal(k)-smean).gt.cut) then 
c     print*,i,j,k,signal(k),abs(signal(k)),cut,strange(i,j,k) !???
            strange(i,j,k)=0    !marks strips exceeding cut
         endif
      enddo                     ! in order not to use them in CN computation


      countme=countme+1         !???
      if (countme.le.3) goto 666 !???


c------------------------------------------------------------------------
c     
c     common noise computation
c     
c------------------------------------------------------------------------
      do while(newclstr.eq.1)   !loops on this VA1 till no new signal 
                                ! affected strips are found

         newclstr=0             !to exit from loop if no new cluster is 
                                ! found
         
         errflag=0

         call cnoise(i,j,errflag) !(view, VA1, error flag) computes common
                                ! noise

c     print*,cn(i,j)         !???
         
         if(errflag.eq.1) goto 10 !goes to next VA1: this one has no signal
                                ! free strips...
         
         call cutcn(i,j)        !(view, VA1) excludes clusters from
                                ! common noise calculation
         
         ncs=0                  !initializes number of strips not excluded by cncut

         do k=1,nstrips_va1     !loops on strips
            if(clstr(i,j,k).ne.clstr_old(k)) then !checks if there are
                                ! new found clusters, and if so sets 
               newclstr=1       ! newclstr flag = 1
               
               clstr_old(k)=clstr(i,j,k) !stores cluster flags in
            endif               ! clstr_old variable

            iok=strange(i,j,k)*bad(i,j,k)*clstr(i,j,k)

            ncs=ncs+iok         !counts number of good strips for cn computation

         enddo

      enddo                     !ends do while loop when there are no new 
                                ! clusters

c      call HFILL(666,FLOAT(ncs),0.,1.) !???


c$$$      if(ncs.lt.20) then        !warns if too many strips have been excluded from CN 
c$$$                                ! computation
c$$$         print*,'cncomp: WARNING, LESS THAN 20 STRIPS PASSED CN CUT'
c$$$     $        //' ON VA1 ',j,', VIEW ',i !NB questo errore e' "un po'" in conflitto
c$$$                                ! con quello che setta errflag (vedi cnoise.f)...
c$$$
c$$$      endif

 10   continue

      return
      end
