

#include <stdio.h>       /* include standard i/o library */
#include <stdlib.h>      /* include standard library */


struct trk_ControlRegister{

    unsigned int TrigMask:2;
    unsigned int DSPMask:6;
    unsigned int DSPBusy:6;

    unsigned int FlashShutdown:1;
    unsigned int FlashOn:1;
    unsigned int FlashUpset:1;
    unsigned int FlashData:1;

    unsigned int InterCheck:1;
    unsigned int FinalCheck:1;

    unsigned int UnknownCmd:1;
    unsigned int CmdDuringTrig:1;

    unsigned int DSPSoft:6;

    unsigned int CmdIDMA:6;
    unsigned int TrigIDMA:6;
    

};

struct trk_Trailer{

    unsigned int PNum;
    unsigned int CmdNum;
    unsigned int BID[7];
    unsigned int ALARM[2];
    unsigned int Aswr;

};

void trkalarmpkt_(char* buffer,int* length,int *error){


    struct trk_ControlRegister CR;
    struct trk_Trailer TR;


    char *buff;

    int i;

    buff = buffer;

    *error = 0;


    CR.TrigMask      = (*buff&0xc0) >> 6;
    CR.DSPMask       = (*buff&0x3f);
    buff++;

    CR.FlashShutdown = (*buff&0x80) >> 7;
    CR.FlashOn       = (*buff&0x40) >> 6;
    CR.DSPBusy       = (*buff&0x3f);
    buff++;

    CR.FlashUpset    = (*buff&0x80) >> 7;
    CR.FlashData     = (*buff&0x40) >> 6;
    CR.DSPSoft       = (*buff&0x3f);
    buff++;
    
    CR.InterCheck    = (*buff&0x80) >> 7;
    CR.FinalCheck    = (*buff&0x40) >> 6;
    CR.CmdIDMA       = (*buff&0x3f);
    buff++;

    CR.UnknownCmd    = (*buff&0x80) >> 7;
    CR.CmdDuringTrig = (*buff&0x40) >> 6;
    CR.TrigIDMA      = (*buff&0x3f);
    buff++;

    
    TR.PNum          = (*buff&0xf0) >> 4;
    TR.CmdNum        = (*buff&0x0f);
    buff++;
    
    for(i=0 ; i<4 ; i++){       
	TR.BID[i]    = (*buff&(0x03<<i*2)) >> i*2;
    };
    buff++;

    for(i=1 ; i<4 ; i++){       
	TR.BID[3+i]  = (*buff&(0x03<<i*2)) >> i*2;
    };
    TR.ALARM[0]      = (*buff&0x02) >> 1;
    TR.ALARM[1]      = (*buff&0x01);
    buff++;

    TR.Aswr          = (*buff&0xff) << 8;
    buff++;

    TR.Aswr          = TR.Aswr | (*buff&0xff);


    printf("\n\n TRK CONTROL REGISTER");
    printf("\n ----------------------");
    printf("\n TrigMask      0x%x",CR.TrigMask);
    printf("\n DSPMask       0x%x",CR.DSPMask);
    printf("\n FlashShutdown 0x%x",CR.FlashShutdown);
    printf("\n FlashOn       0x%x",CR.FlashOn);
    printf("\n DSPBusy       0x%x",CR.DSPBusy);
    printf("\n FlashUpset    0x%x",CR.FlashUpset);
    printf("\n FlashData     0x%x",CR.FlashData);
    printf("\n DSPSoft       0x%x",CR.DSPSoft);
    printf("\n InterCheck    0x%x",CR.InterCheck);
    printf("\n FinalCheck    0x%x",CR.FinalCheck);
    printf("\n CmdIDMA       0x%x",CR.CmdIDMA);
    printf("\n UnknownCmd    0x%x",CR.UnknownCmd);
    printf("\n CmdDuringTrig 0x%x",CR.CmdDuringTrig);
    printf("\n TrigIDMA      0x%x",CR.TrigIDMA);
    printf("\n ----------------------");
    printf("\n PNum          0x%x",TR.PNum);    
    printf("\n CmdNum        0x%x",TR.CmdNum);    
    printf("\n BID           0x%x",TR.BID[0]);    
    printf("\n ALARM         0x%x",TR.ALARM[0]);    
    printf("\n Aswr          0x%x",TR.Aswr);    
    printf("\n----------------------\n\n\n");
    


    return;
}
