*************************************************************************
*     
*     Common calib.f
*     
*     contains CALIB variables definitions
*     
*     to be included in:
*     - ../readraw/readraw.F
*     - ../reduction/reduction.f
*     - ../align/prealign.f
*     
*************************************************************************

c------------------------------------------------------------------------
c     
c     pedestal, sigma and badstrip variables
c     
c------------------------------------------------------------------------

      parameter (id_hi_bad=100) !badstrip histo identifier
      parameter (id_hi_ped=200) !pedestal histo identifier
      parameter (id_hi_sig=300) !sigma histo identifier

      real pedestal(nviews,nva1_view,nstrips_va1) !pedestal value
      real pedestal_t(nviews,nva1_view,nstrips_va1) !pedestal truncated value

      real sigma(nviews,nva1_view,nstrips_va1) !sigma value
      real sigma_t(nviews,nva1_view,nstrips_va1) !sigma truncated value

      integer bad(nviews,nva1_view,nstrips_va1) !bad strip flag matrix
                                ! (bad=0 --> good strip, bad=1 --> bad strip)
                                ! NB this is different in 2003 test with respect
                                ! to previous analysis

      common/pedsigbad/pedestal,pedestal_t,sigma,sigma_t,bad

      parameter (clcutx=7.)     !cluster seed cut 
      parameter (clcuty=7.)
      parameter (incutx=4.)     !cut to include strips in cluster definition
      parameter (incuty=4.)


      parameter (id_hi_mask=400) !mask histo identifier

      integer mask(nviews,nva1_view,nstrips_va1) 
      integer mask_vk(nviews,nva1_view) 

      common/mask/mask,mask_vk


c------------------------------------------------------------------------
c     
c     eta2, eta3, eta4 pfa correction parameters
c     
c------------------------------------------------------------------------
*     angular binning
*     NB the angular binning is defined in common_preanalysis.f
*     here are defined variables to retrieve calibration info 
*     (for processing levels next to 1)
      parameter (nangmax=21)    !maximum number of angular bins
      integer nangbin
      real angL(nangmax),angR(nangmax) !Left and Right bin limits

      parameter (netavalmax=150)   !eta2 points 
      integer netaval
      real eta2(netavalmax,nangmax)
      real feta2(netavalmax,nviews,nladders_view,nangmax)
      real eta3(netavalmax,nangmax)
      real feta3(netavalmax,nviews,nladders_view,nangmax)
      real eta4(netavalmax,nangmax)
      real feta4(netavalmax,nviews,nladders_view,nangmax)

      common/angbinning/nangbin,angL,angR
      common/pfa/netaval,eta2,feta2,eta3,feta3,eta4,feta4

c------------------------------------------------------------------------
c     
c     CHARGE CORRELATION
c     
c------------------------------------------------------------------------

c      parameter (chcut=3.)      !cut to associate two clusters
      parameter (chcut=4.)      !cut to associate two clusters
      real kch(nplanes,nladders_view) !angular coeff
      real cch(nplanes,nladders_view) !const
      real sch(nplanes,nladders_view) !sigma
      common/chargeco/kch,cch,sch
c------------------------------------------------------------------------
c     
c     MIP
c
c     (mip signal, scaled to 300 micron, in ADC channels)
c     
c------------------------------------------------------------------------
      real mip(nviews,nladders_view)
      common/adc2mip/mip
