************************************************************

      subroutine readmipparam
            
      include '../common/commontracker.f'
      include '../common/calib.f'

      character*60 fname_param 
 201  format('trk-LADDER',i1,'-mip.dat')
      do ilad=1,nladders_view         
         write(fname_param,201)ilad
         print *,'Opening file: ',fname_param
         open(10,
     $        FILE='./bin-aux/'//fname_param(1:LNBLNK(fname_param))
     $        ,STATUS='UNKNOWN'
     $        ,IOSTAT=iostat
     $        )
         if(iostat.ne.0)then
            print*,'READMIPPARAM: *** Error in opening file ***'
            return
         endif
         do iv=1,nviews
            read(10,*
     $           ,IOSTAT=iostat
     $           )pip,
     $            mip(int(pip),ilad)
c            print*,ilad,iv,pip,mip(int(pip),ilad)
         enddo
         close(10)
      enddo

      return
      end
*** * * * *** * * * *** * * * *** * * * *** * * * *** * * * ***
      subroutine readchargeparam
      
      
      include '../common/commontracker.f'
      include '../common/calib.f'

      character*60 fname_param 
 201  format('charge-l',i1,'.dat')
      do ilad=1,nladders_view         
         write(fname_param,201)ilad
         print *,'Opening file: ',fname_param
         open(10,
     $        FILE='./bin-aux/'//fname_param(1:LNBLNK(fname_param))
     $        ,STATUS='UNKNOWN'
     $        ,IOSTAT=iostat
     $        )
         if(iostat.ne.0)then
            print*,'READCHARGEPARAM: *** Error in opening file ***'
            return
         endif
         do ip=1,nplanes
            read(10,*
     $           ,IOSTAT=iostat
     $           )pip,
     $            kch(ip,ilad),cch(ip,ilad),sch(ip,ilad)         
c            print*,ilad,ip,pip,kch(ip,ilad),
c     $           cch(ip,ilad),sch(ip,ilad) 
         enddo
         close(10)
      enddo

      return
      end
*** * * * *** * * * *** * * * *** * * * *** * * * *** * * * ***
      subroutine readetaparam
*     -----------------------------------------
*     read eta2,3,4 calibration parameters
*     and fill variables:
*
*     eta2(netabin,nladders_view,nviews)
*     eta3(2*netabin,nladders_view,nviews)
*     eta4(2*netabin,nladders_view,nviews)
*
      include '../common/commontracker.f'
      include '../common/calib.f'

      character*40 fname_binning
      character*40 fname_param
c      character*120 cmd1
c      character*120 cmd2


******retrieve ANGULAR BINNING info
      fname_binning='binning.dat'
      print *,'Opening file: ',fname_binning
      open(10,
     $     FILE='./bin-aux/'//fname_binning(1:LNBLNK(fname_binning))
     $     ,STATUS='UNKNOWN'
     $     ,IOSTAT=iostat
     $     )
      if(iostat.ne.0)then
         print*,'READETAPARAM: *** Error in opening file ***'
         return
      endif
      print*,'---- ANGULAR BINNING ----'
      print*,'Bin   -   angL   -   angR'
 101  format(i2,'       ',f6.2,'     ',f6.2)
      do ibin=1,nangmax
         read(10,*
     $        ,IOSTAT=iostat
     $        )xnn,angL(ibin),angR(ibin)
         if(iostat.ne.0)goto 1000
         write(*,101)int(xnn),angL(ibin),angR(ibin)
      enddo         
 1000 nangbin=int(xnn)
      close(10)
      print*,'-------------------------'
      


      do ieta=2,4               !loop on eta 2,3,4        
******retrieve correction parameters
 200     format(' Opening eta',i1,' files...')
         write(*,200)ieta

 201     format('eta',i1,'-bin',i1,'-l',i1,'.dat')
 202     format('eta',i1,'-bin',i2,'-l',i1,'.dat')
         do iang=1,nangbin
            do ilad=1,nladders_view
               if(iang.lt.10)write(fname_param,201)ieta,iang,ilad
               if(iang.ge.10)write(fname_param,202)ieta,iang,ilad
c               print *,'Opening file: ',fname_param
               open(10,
     $             FILE='./bin-aux/'//fname_param(1:LNBLNK(fname_param))
     $              ,STATUS='UNKNOWN'
     $              ,IOSTAT=iostat
     $              )
               if(iostat.ne.0)then
                  print*,'READETAPARAM: *** Error in opening file ***'
                  return
               endif
               do ival=1,netavalmax
                  if(ieta.eq.2)read(10,*
     $                 ,IOSTAT=iostat
     $                 )
     $                 eta2(ival,iang),
     $                 (feta2(ival,iv,ilad,iang),iv=1,nviews)
                  if(ieta.eq.3)read(10,*
     $                 ,IOSTAT=iostat
     $                 )
     $                 eta3(ival,iang),
     $                 (feta3(ival,iv,ilad,iang),iv=1,nviews)
                  if(ieta.eq.4)read(10,*
     $                 ,IOSTAT=iostat
     $                 )
     $                 eta4(ival,iang),
     $                 (feta4(ival,iv,ilad,iang),iv=1,nviews)
                  if(iostat.ne.0)then
                     netaval=ival-1
c$$$                     if(eta2(1,iang).ne.-eta2(netaval,iang))
c$$$     $                    print*,'**** ERROR on parameters !!! ****' 
                     goto 2000
                  endif
               enddo
 2000          close(10)
*               print*,'... done'
            enddo
         enddo

      enddo                     !end loop on eta 2,3,4


      return
      end

*** * * * *** * * * *** * * * *** * * * *** * * * *** * * * ***
      subroutine readalignparam

      include '../common/commontracker.f'
      include '../common/common_align.f'

      character*50 fname_param
      integer sensor
c      character*120 cmd1
c      character*120 cmd2
      
c 100  format('../common/align_param/parameters_l',i1,'s',i1,'.dat')
 100  format('parameters_l',i1,'s',i1,'.dat')

      do ilad=1,nladders_view
         do is=1,2

            write(fname_param,100)ilad,is
c$$$            cmd1='cp $TRK_GRND/source/common/align_param/'
c$$$     $           //fname_param(1:LNBLNK(fname_param))//' .'         
c$$$            call system(cmd1)         
            print *,'Opening file: ',fname_param

            open(10,
     $           FILE='./bin-aux/'//fname_param(1:LNBLNK(fname_param))
     $           ,STATUS='UNKNOWN'
     $           )
            
            do ip=1,nplanes
*
*     NB! NB! NB! NB! NB!
*     The file labelled for example "l1s1" include the alignment
*     parameters of the column of sensors:
*
*     PLANE LADDER SENSOR
*     -------------------
*     1     1      2
*     2     1      1
*     3     1      1
*     4     1      1
*     5     1      1
*     6     1      1
*
*     This is becouse the plane 1 (bottom plane) is up-side-down
*
               sensor=is
               if(ip.eq.1)sensor=mod(is,2)+1 
               read(10,*)omega(ip,ilad,sensor)
               read(10,*)beta(ip,ilad,sensor)
               read(10,*)gamma(ip,ilad,sensor)
               
c     N.B. I convert angles from microradiants to radiant
               omega(ip,ilad,sensor)=omega(ip,ilad,sensor)/1.d6
               beta(ip,ilad,sensor)=beta(ip,ilad,sensor)/1.d6
               gamma(ip,ilad,sensor)=gamma(ip,ilad,sensor)/1.d6

               read(10,*)dx(ip,ilad,sensor)
               read(10,*)dy(ip,ilad,sensor)
               read(10,*)dz(ip,ilad,sensor)
            enddo
            
            close(10)
c$$$            cmd2='rm -f '
c$$$     $           //fname_param(1:LNBLNK(fname_param))
c$$$            call system(cmd2)
         enddo
      enddo
      
  

      end
c------------------------------------------------------------------------

c     NB: le coordinate in mech_pos.dat sono calcolate a partire da alcuni dati
c     contenuti in commontracker.f. forse si puo' evitare mech_pos.dat e mettere
c     tutto in commontracker.f


      subroutine mech_sensor    
c     !it reads sensors coordinates (in PAMELA reference
c     ! frame) from a text file and it uses them to fill
c     ! x/y/z_mech_sensor variables, taking into account
c     ! last plane inversion

      include './commontracker.f'
      include './common_tracks.f'

      real xvec(nladders_view),yvec(2),zvec(nplanes)

      integer id                !file identifier
      logical od                !.true. if the specified unit is connected to a file

      do id=20,100,1            !opens the file using a free file id
        inquire (id, opened=od)
        if(.not.od) goto 666
      enddo      
 666  continue

c      open(id,FILE='../common/mech_pos.dat') !sensors centres coordinates in mm in 
c      open(id,FILE='source/common/mech_pos.dat') 
c      call system('cp $TRK_GRND/source/common/mech_pos.dat .')
      print *,'Opening file: mech_pos.dat'
      open(id,FILE='./bin-aux/mech_pos.dat',IOSTAT=iostat) 
c     !sensors centres coordinates in mm in 
c     ! PAMELA reference frame:
c     ! the first plane is the one with lowest Z (the one
c     ! nearest the calorimeter)
c     ! the first ladder is the one with lowest X (the
c     ! one on which the first X strip is)
c     ! the first sensor is the one with lowest Y (the
c     ! one on which the first Y strip is) for planes
c     ! 2..6. for plane 1 the first sensor has higher Y
      
      if(iostat.ne.0)then
         print*,'MECH_SENSOR: *** Error in opening file ***'
         return
      endif

      read(id,*) xvec
      read(id,*) yvec
      read(id,*) zvec

      do i=1,nplanes
        do j=1,nladders_view
          do k=1,2
            x_mech_sensor(i,j,k)=xvec(j)
            y_mech_sensor(i,j,k)=yvec(k)
            z_mech_sensor(i,j,k)=zvec(i)
            if(i.eq.1) then     !y coordinates of first plane (11th view) are
              y_mech_sensor(i,j,k)=-yvec(k) ! exchanged due to last plane inversion
            endif              
          enddo
        enddo
      enddo

      close(id)
c      call system('rm -f mech_pos.dat')

c$$$                                ! *** INIZIO DEBUG ***
c$$$      do i=1,6
c$$$c        do j=1,3
c$$$          do k=1,2
c$$$            j=1
c$$$c            print*,x_mech_sensor(1,j,k)
c$$$            print*,y_mech_sensor(i,j,k)
c$$$c            print*,z_mech_sensor(i,j,k)
c$$$          enddo
c$$$c        enddo
c$$$        print*,' '
c$$$      enddo
c$$$                                ! *** FINE DEBUG ***

      
      return
      end

