*************************************************************************
*     10/9/2005 modified by david fedele to read buffer-data
*     instead raw-data-file 
*     29/11/2005 modified by david fedele to include crc control 
*************************************************************************

c*****************************************************
cccccc 10/9/2005 modified by david fedele
c      subroutine trkeventpkt(YODAflag,event_file_name)
      subroutine trkeventpkt(YODAflag,buffer,length_buffer,curpos,
     $     startcrc,stopcrc,crctemp)
c*****************************************************

      include '../common/commontracker.f'
      include '../common/common_readraw.f'
      include '../common/level0.f'


*     ---------------------------------------------------
*     the general flag YODAflag contains information 
*     about the integrity of the packet. 
*     
*     It is coded in bits:
*     x xxxx xxxx xxxx xxxx
*     | |||| |||| |||| ||||
*     | |||| |||| |||| |||- integrity flag of 1  st DSP packet
*     | |||| |||| |||| ||--     "       "   " 2  nd  "    "
*     | |||| |||| |||| |---     "       "   " 3  rd  "    "
*     | |||| ..............
*     | |..................
*     | ------------------- integrity flag of 12 th DSP packet
*     |
*     --------------------- flag that indicates if more than 12  
*                           packets have been found
*
*     EXAMPLE 1.
*     If the event packet is truncated and only three DSP packets 
*     are present in the fragment, the last being TRUNCATED, 
*     the YODAflag will be:
*
*     YODAflag = b#00000000000000100 = 4
*     
*     and only the two integer packets will be stored.
*
*     EXAMPLE 2.
*     If instead the corruption of a packet results from 
*     checksum or crc, the YODAflag will be asserted as explained,
*     but the packet will be stored.
*     ---------------------------------------------------
      integer YODAflag

      logical DEBUG,ALARMs
      common/DEBUGflag/DEBUG,ALARMS

      
      integer runerror          !readevent error flag

c*****************************************************
cccccc 10/9/2005 modified by david fedele
c*      integer ffd_pkt           !pkt file descriptor
c*                               (file temporaneo)     
c*      character*60 event_file_name !nome file
c*      integer lun_pkt
c*      data lun_pkt/20/
      parameter (MAXBUFFLEN=z'172c8')
      integer*4 length_buffer
      integer*1 buffer(MAXBUFFLEN)
      integer curpos            !current position in buffer
      integer startcrc
      integer stopcrc
      integer*1 crctemp
c****************************************************

      integer last_trigger(nviews)
      common/trigger_counter/last_trigger


      YODAflag=0

c*****************************************************
cccccc 10/9/2005 modified by david fedele
c      open(unit=lun_pkt, 
c     $     name=EVENT_FILE_NAME(1:lnblnk(EVENT_FILE_NAME)), 
c     $     status='old', 
c     $     form='unformatted'
c     $     )
c      ffd_pkt = FNum(lun_pkt)   !reads unix file descriptor
c*****************************************************

      call initlevel0

      TOTDATAlength = 0.        !total length of data buffer
      do iview=1,nviews!ndummy         !loop on views 
c*****************************************************
cccccc 10/9/2005 modified by david fedele              
c         call searchtrkheader(runerror,ffd_pkt)
        call searchtrkheader(runerror,buffer,length_buffer,curpos,
     $       startcrc)
c*****************************************************
         if(runerror.eq.1.or.runerror.eq.-1) then                  
*        --------------------------------------------------
*        no further DSP packet has been found ==> go to end
*        --------------------------------------------------
            goto 2222           !go to end
         endif
         
         if(checkheader.ne.2) then
            print*,'>>>> ERROR <<<< (trkeventpkt)'
            print*,'>>>> CPU packet type ',!pkt_type, 
     $           ' does not match DSP packet type ',checkheader
            DAQmode_temp = ishft(iand(header(1),z'03f0'),-4)
            DSPnumber_temp = iand(header(1),z'000f')
            print*,'  -----------------------------------'
     $           ,iview
            print*,'  DSP number-----',int(DSPnumber_temp)
            print*,'  DAQ mode-------',int(DAQmode_temp)
            print*,'  -----------------------------------'
            goto 2525           !next view (==> search another DSP header)
         endif
         
c*****************************************************
cccccc 10/9/2005 modified by david fedele                
c         call unpackdata(runerror,ffd_pkt)
         call unpackdata(runerror,buffer,length_buffer,curpos,
     $        startcrc,stopcrc,crctemp)
c        write(*,100),crctemp,crc_dat
c 100    format('calc',z2,'      dat',z2)
c******************************************************
         if(runerror.eq.-1.or.runerror.eq.1)then 
*        -----------------------------------------------
*        an error occurred while reading the packet data
*        ===> assert packet error bit ===> go to end
*        -----------------------------------------------
            YODAflag=ior(YODAflag,int(2**(iview-1)))
            goto 2222           !end
         endif
                          
         if(ALARMs)then
            print*,'  '
            print*,'  -----------------------------------',iview
            print*,'  DSP number-----',DSPnumber_dat
            print*,'  DAQ mode-------',DAQmode_dat
            print*,'  event number   ',eventn_dat
            print*,'  datalength (13-bit w) ---- ',datalength_dat
            print*,'  L-1  addr---',addrcluster_dat(1)
            print*,'       signal-',signcluster_dat(1)
            print*,'  L-2  addr---',addrcluster_dat(2)
            print*,'       signal-',signcluster_dat(2)
            print*,'  L-3  addr---',addrcluster_dat(3)
            print*,'       signal-',signcluster_dat(3)
            print*,'  FC------',fc_dat 
            print*,'  compression time ',compressiontime_dat 
            print*,'  FL1--',fl1_dat
            print*,'  FL2--',fl2_dat
            print*,'  FL3--',fl3_dat
            print*,'  FL4--',fl4_dat
            print*,'  FL5--',fl5_dat
            print*,'  FL6--',fl6_dat

            print*,'*-*-*-*-*-*-TRAILER-*-*-*-*-*-*'
            print*,'*  PNUM   (periferal num) ',pnum_dat
            print*,'*  CMDNUM (command)       ',cmdnum_dat
            print*,'*  BID    (board id)      ',bid_dat
            print*,'*  ALARM                  ',alarm_dat
            print*,'*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*'

            DEBUG = .true.
         endif         

         trk_DSP_ok(DSPnumber_dat)=1

         call fillview(iview,crctemp)
         
 2525    continue
      enddo                     !end loop on views
      
 2222 continue

c*****************************************************
cccccc 10/9/2005 modified by david fedele
c      close (lun_pkt)
c*****************************************************
      return
      end

*     **********************************************

c*****************************************************
cccccc 10/9/2005 modified by david fedele
c     subroutine trkcalibpkt(runerror,event_file_name)
      subroutine trkcalibpkt(runerror,buffer,length_buffer,curpos,
     $     startcrc,stopcrc,crctemp)
c*****************************************************
      include '../common/commontracker.f'
      include '../common/common_readraw.f'
      
      integer runerror          !readevent error flag
c******************************************************
cccccc 10/9/2005 modified by david fedele
c      integer ffd_pkt           !pkt file descriptor
c                                !(file temporaneo)     
c      character*60 event_file_name !nome file
c      integer lun_pkt
c      data lun_pkt/10/
      parameter (MAXBUFFLEN=z'172c8')
      integer*4 length_buffer
      integer*1 buffer(MAXBUFFLEN)
      integer curpos            !current position in buffer
      integer startcrc
      integer stopcrc
      integer*1 crctemp
c******************************************************
      logical DEBUG,ALARMs
      common/DEBUGflag/DEBUG,ALARMs
      data DEBUG/.false./
      

      integer ndummy
      data ndummy/10/

    
c******************************************************
cccccc 10/9/2005 modified by david fedele
c      open(unit=lun_pkt, 
c     $     name=EVENT_FILE_NAME(1:lnblnk(EVENT_FILE_NAME)), 
c     $     status='old', 
c     $     form='unformatted'
c     $     )
c      ffd_pkt = FNum(lun_pkt)   !reads unix file descriptor
c******************************************************      

      npa=0                     !packet counter
      do iview=1,ndummy         !loop on views (DSP pkt)

         ALARMS=.false.

c******************************************************
cccccc 10/9/2005 modified by david fedele         
c         call searchtrkheader(runerror,ffd_pkt)
       call searchtrkheader(runerror,buffer,length_buffer,curpos,
     $        startcrc)
c******************************************************


         if(runerror.eq.-1) goto 2222
         if(runerror.eq.1) then                  
            goto 2222           !end loop on views (DSP pkt)
         endif
         if(checkheader.ne.3) then
            print*,'>>>> ERROR <<<< (trkcalibpkt)'
            print*,'>>>> CPU packet type ',!pkt_type, 
     $           ' does not match DSP type ',checkheader
            DAQmode_temp = ishft(iand(header(1),z'03f0'),-4)
            DSPnumber_temp = iand(header(1),z'000f')
            print*,'  -----------------------------------'
     $           ,iview
            print*,'  DSP number-----',int(DSPnumber_temp)
            print*,'  DAQ mode-------',int(DAQmode_temp)
            print*,'  -----------------------------------'
            goto 2424           !next view (==> search another DSP header)
         endif                     
         
c******************************************************
cccccc 10/9/2005 modified by david fedele     
c      call unpackcalibration(runerror,ffd_pkt)  
         call unpackcalibration(runerror,buffer,length_buffer,curpos,
     $        startcrc,stopcrc,crctemp)
c******************************************************
         if(runerror.eq.-1) goto 2222
         if(runerror.eq.1) goto 2222
                  
         if(nused_event.ne.0.or.ff.ne.0)then
            print*,'*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*'
            print*,'*     !!! CALIBRATION FAILURE !!!     *'
            print*,'*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*'
c            ALARMS=.true.
         endif
         if(ALARMS)then

            print*,'Calibration packet ==> ',iview
            
            print*,'---- Calibration packet ',iview,' ----'
            print*,'  DSP number       ',DSPnumber_cal
            print*,'  DAQ mode         ',DAQmode_cal
            print*,'  calibration run  ',calibrationnumber
            print*,'  n. event used    ',nused_event
            print*,'  <PED> ladder 1   ',ped_1
            print*,'  <PED> ladder 2   ',ped_2
            print*,'  <PED> ladder 3   ',ped_3
            print*,'  <SIG> ladder 1   ',sig_1
            print*,'  <SIG> ladder 2   ',sig_2
            print*,'  <SIG> ladder 3   ',sig_3
            print*,'  n.BAD ladder 1   ',nbad_1
            print*,'  n.BAD ladder 2   ',nbad_2      
            print*,'  n.BAD ladder 3   ',nbad_3
            print*,'  error flag       ',ff
         endif
c        
         npa=npa+1
         trk_DSP_ok(DSPnumber_cal)=1
 2424    continue
      enddo                     ! end loop on views (calibration pkt)
 2222 continue

      if(npa.ne.6)print*,'**** READRAW: WARNING (in trkcalibpkt) ' 
     $                 //'- Found only ',npa,' calibration pkts!'
c*****************************************************
cccccc 10/9/2005 modified by david fedele
c      close (lun_pkt)
c*****************************************************
      return
      end

***...***...***...***...***...***...***...***...***...***...***...***...***...***...***...***
*
*
*
*
*
*
*
*
***...***...***...***...***...***...***...***...***...***...***...***...***...***...***...***

c*****************************************************
cccccc 10/9/2005 modified by david fedele
c     subroutine searchtrkheader(runerror,ffd)
      subroutine searchtrkheader(runerror,buffer,length_buffer,
     + curpos,startcrc)
c*****************************************************
C.............................................................
C     Search for a valid tracker DSP header (=>one view) 
C     and return the type of header
C.............................................................

      include '../common/commontracker.f'
      include '../common/common_readraw.f'

c*****************************************************
cccccc 10/9/2005 modified by david fedele
c   integer ffd               !input file descriptor
      parameter (MAXBUFFLEN=z'172c8')
      integer*4 length_buffer
      integer*1 buffer(MAXBUFFLEN)
      integer curpos            !current position in buffer
      integer startcrc
c*****************************************************

      integer runerror          !readevent error flag

c--------------------------------------------------
c     N.B.13 bit packing is done for each DSP header+datablock, 
C     so each DSP 13 bit 
c     first word starts at the beginnig of a 16 bit word
c--------------------------------------------------

 9100 continue
      runerror=0                !error flag initialization
      checkheader=0

c--------------------------------------------------
c     looks for a DSP header beginning 
C     (a word beginning with 1110)
c--------------------------------------------------
      
c*****************************************************
cccccc 10/9/2005 modified by david fedele
c     call findstart(runerror,ffd)
      call findstart(runerror,buffer,length_buffer,curpos)
c*****************************************************
      
      
      if(runerror.eq.1) goto 200 !end
      if(runerror.eq.-1)goto 200 !end
c--------------------------------------------------
c     the first word could be a DSP header first word: 
C     reads 13 8-bit words and 
c     writes them in 16 13-bit words to check for all 
C     DSP header features
c--------------------------------------------------
         
c*****************************************************
cccccc 10/9/2005 modified by david fedele
c     call hunpacker(header,runerror,ffd)
      call hunpacker(header,runerror,buffer,length_buffer,curpos,
     +     startcrc)
c*****************************************************
            
      if(runerror.eq.1) goto 200 !end
      if(runerror.eq.-1)goto 200 !end
c--------------------------------------------------
c     extracts and controls header:
c--------------------------------------------------
C     last header word must be:
c     |0001|1100|0000|0000| for acquisition
c     |0001|1111|1111|1111| for calibration
c--------------------------------------------------
      if(iand(header(16),z'ffff').eq.z'1c00') then 
         checkheader=2          ! event packet
      elseif(iand(header(16),z'ffff').eq.z'1fff') then 
         checkheader=3          ! calibration packet
      else
         checkheader=1          ! not a valid DSP header
      endif
c--------------------------------------------------
c     first header word must be:  
c     |0001|110x|xxxx|xxxx|
c--------------------------------------------------
      if(iand(header(1),z'fe00').ne.z'1c00') 
     $     checkheader=1        !not a valid DSP header
c--------------------------------------------------
c     intermediate header words must be:  
c     |0001|010x|xxxx|xxxx|
c--------------------------------------------------
      do i=2,15    
         if(iand(header(i),z'fc00').ne.z'1400') 
     $        checkheader=1     !not a valid DSP header
      enddo
c--------------------------------------------------
c     if checkheader = 1 
c     then this is not a DSP header (or some 
c     noise lurks around) so go a word ahead and 
c     try again
c--------------------------------------------------
      if(checkheader.eq.1) then
   
c*****************************************************
cccccc 10/9/2005 modified by david fedele
c        call skipbyte(ffd)      !new search
        curpos=curpos-(13*2)+1  !goes back 13 words, then half 16 bit word ahead 
c*****************************************************
         goto 9100
      endif
      
 200  continue
      end

*.............................................................


*.............................................................
c*****************************************************
cccccc 10/9/2005 modified by david fedele
c     subroutine unpackcalibration(runerror,ffd)
      subroutine unpackcalibration(runerror,buffer,length_buffer,curpos,
     $     startcrc,stopcrc,crctemp)
c*****************************************************

*.............................................................
*     decode calibration data
*     header + data(PED SIG BAD) + trailer
*............................................................
      include '../common/commontracker.f'
      include '../common/common_readraw.f'

     
c*****************************************************
cccccc 10/9/2005 modified by david fedele
c      integer ffd               !input file descriptor
      parameter (MAXBUFFLEN=z'172c8')
      integer*4 length_buffer
      integer*1 buffer(MAXBUFFLEN)
      integer curpos            !current position in buffer
      integer startcrc
      integer stopcrc
      integer*1 crctemp
      integer*1 crc_trail
c*****************************************************
 
      integer runerror          !readevent error flag
c     buffer temporanei
      integer*2 templ(nstrips_ladder) 
      real*4 tempf(nstrips_ladder)
      

 12   format(z4)

*-----------------------------------------------------------
*     HEADER
*     (N.B. during test 2003 the header of calibration packets
*     was only partially filled)
*
*     the following is the final calibration header
*-----------------------------------------------------------
      DAQmode_cal = ishft(iand(header(1),z'03f0'),-4)
      DSPnumber_cal = iand(header(1),z'000f')
      dataword = ior(ishft(iand(header(2),z'03ff')
     $     ,10),iand(header(3),z'03ff'))
      calibrationnumber = iand(header(4),z'03ff')
      nused_event = iand(header(5),z'03ff')
      ped_1 = iand(header(6),z'03ff')
      ped_2 = iand(header(7),z'03ff')
      ped_3 = iand(header(8),z'03ff')
      ped_1 = ped_1 * 4
      ped_2 = ped_2 * 4
      ped_3 = ped_3 * 4
      sig_1 = iand(header(9),z'03ff')
      sig_2 = iand(header(10),z'03ff')
      sig_3 = iand(header(11),z'03ff')
      nbad_1 = iand(header(12),z'03ff')
      nbad_2 = iand(header(13),z'03ff')
      nbad_3 = iand(header(14),z'03ff')
      ff = ishft(iand(header(15),z'0300'),-8)
      checksum_cal = iand(header(15),z'00ff') 
c-----------------------------------------------------------
c     the checksum is a 8-bit word calculated as the 
c     XOR of the 16-bit data words,
c     hence the XOR between the two halfs
C----------------------------------------------------------

      runerror=0

c*****************************************************
cccccc 10/9/2005 modified by david fedele
c     call readtrailer(trailer,runerror,ffd)
      call readtrailer(trailer,runerror,buffer,length_buffer,curpos,
     $     startcrc,stopcrc,crctemp) 

      crc_trail=iand(trailer(3),z'00ff')

      if (crctemp.eq. crc_trail)then
        crc_hcalib=.true.
      else
        crc_hcalib=.false.
        print*,'**** READRAW: WARNING crc_hcalib=.false.'
        write(*,102),il,crctemp,iand(trailer(3),z'00ff')
 102    format('        crctemp=',z2
     $       ,'        crc-trailer=',z2)
      endif
c*****************************************************

      do il=1,3                 !loop on ladders
c*****************************************************
cccccc 30/11/2005 modified by david fedele
        startcrc=curpos
c*****************************************************
cccccc 10/9/2005 modified by david fedele
c     call readped(tempf,runerror,ffd)
        call readped(tempf,runerror,buffer,length_buffer,curpos)
c*****************************************************
         do is=1,nstrips_ladder
            iss=is+nstrips_ladder*(il-1)
            DSPped_o(DSPnumber_cal,iss)=tempf(is)
         enddo

        
c*****************************************************
cccccc 10/9/2005 modified by david fedele
c     call readsig(tempf,runerror,ffd)
         call readsig(tempf,runerror,buffer,length_buffer,curpos)
c*****************************************************
         do is=1,nstrips_ladder
            iss=is+nstrips_ladder*(il-1)
            DSPsig_o(DSPnumber_cal,iss)=tempf(is)
         enddo

         
c*****************************************************
cccccc 10/9/2005 modified by david fedele
c     call readbad(templ,runerror,ffd)
         call readbad(templ,runerror,buffer,length_buffer,curpos)
c*****************************************************
         do is=1,nstrips_ladder
            iss=is+nstrips_ladder*(il-1)
            DSPbad_o(DSPnumber_cal,iss)=templ(is)
         enddo

 11      format(i1,'   ',z4)
         
c*****************************************************
cccccc 10/9/2005 modified by david fedele
c     call readtrailer(trailer,runerror,ffd)
         call readtrailer(trailer,runerror,buffer,length_buffer,curpos,
     $        startcrc,stopcrc,crctemp)

         crc_trail=iand(trailer(3),z'00ff')
         
         if (crctemp.eq. crc_trail)then
           crc_calib(il)=.true.
         else
           crc_calib(il)=.false.
           print*,'**** READRAW: WARNING crc_cal(',il,')=.false. '
           write(*,101),il,crctemp,iand(trailer(3),z'00ff')
 101       format('ladder ',i2,'        crctemp=',z2
     $          ,'        crc-trailer=',z2)
         endif
c*****************************************************
           
      enddo                     !end loop on ladders
      
      return
      end
*.............................................................      


c*****************************************************
cccccc 10/9/2005 modified by david fedele
c      subroutine unpackdata(runerror,ffd)
      subroutine unpackdata(runerror,buffer,length_buffer,curpos,
     $     startcrc,stopcrc,crctemp)
c*****************************************************

*.............................................................
*     decode event data
*     header + data + trailer
*............................................................

      include '../common/commontracker.f'
      include '../common/common_readraw.f'
      include '../common/level0.f'

c*****************************************************
cccccc 10/9/2005 modified by david fedele
c      integer ffd               !input file descriptor
      parameter (MAXBUFFLEN=z'172c8')
      integer*4 length_buffer
      integer*1 buffer(MAXBUFFLEN)
      integer curpos            !current position in buffer
      integer startcrc
      integer stopcrc
      integer*1 crctemp
c*****************************************************

      integer runerror          !readevent error flag
      integer l_tra

      integer bid1_dat,bid2_dat,bid3_dat,bid4_dat,bid5_dat,bid6_dat
     $     ,bid7_dat,bid_dat_sum
      
      logical DEBUG,ALARMs
      common/DEBUGflag/DEBUG,ALARMs
c      data ALARMs/.false./


      ALARMs = .false.
      
 12   format(z4)

*-----------------------------------------------------------
*     HEADER
*-----------------------------------------------------------

      DAQmode_dat = ishft(iand(header(1),z'03f0'),-4)
      DSPnumber_dat = iand(header(1),z'000f')
C     ------------------------------------------------------
c     words 2 and 3 give the number of transmitted 16-bit
c     words ( 13 header words + data )
c     NB: data are packed from 13-bit to 16-bit words, 
c     so the stream is complited with zeros in order to have 
c     a number of bits multiple of 16
C     ------------------------------------------------------
      l_tra = ior(ishft(iand(header(2),z'03ff')
     $     ,10),iand(header(3),z'03ff'))
      l_tra=l_tra-13            
C     ------------------------------------------------------
      eventn_dat = ior(ishft(iand(header(4),z'03ff')
     $     ,10),iand(header(5),z'03ff'))
      nclust_dat = ishft(iand(header(6),z'0380'),-7)
      cutc_dat = ishft(iand(header(6),z'0070'),-4)
      cutcl_dat = iand(header(6),z'000f')
      addrcluster_dat(1) = iand(header(7),z'03ff')
      signcluster_dat(1) = iand(header(8),z'03ff')
      addrcluster_dat(2) = iand(header(9),z'03ff')
      signcluster_dat(2) = iand(header(10),z'03ff')
      addrcluster_dat(3) = iand(header(11),z'03ff')
      signcluster_dat(3) = iand(header(12),z'03ff')
      fc_dat = ishft(iand(header(13),z'0300'),-8)
      compressiontime_dat = iand(header(13),z'00ff')
      fl5_dat = ishft(iand(header(14),z'0300'),-8)
      fl4_dat = ishft(iand(header(14),z'0300'),-6)
      fl3_dat = ishft(iand(header(14),z'0300'),-4)
      fl2_dat = ishft(iand(header(14),z'0300'),-2)
      fl1_dat = iand(header(14),z'0300')
      fl6_dat = ishft(iand(header(15),z'0300'),-8)
      checksum_dat = iand(header(15),z'00ff') 

      if(
     $     fc_dat.ne.0.or.
     $     fl1_dat.ne.0.or. 
     $     fl2_dat.ne.0.or. 
     $     fl3_dat.ne.0.or. 
     $     fl4_dat.ne.0.or. 
     $     fl5_dat.ne.0.or. 
     $     fl6_dat.ne.0.or. 
     $     .false.)ALARMs=.true.
c-----------------------------------------------------------
c     the cheacksum is a 8-bit word calculated as the 
c     XOR of the 16-bit data words,
c     hence the XOR between the two halfs
C----------------------------------------------------------
      runerror=0
      nqualcosa=0
      if(l_tra.eq.0)then 
         ALARMs=.true.
         goto 18                !empty buffer
      endif
     
c*****************************************************
cccccc 10/9/2005 modified by david fedele
c     call dunpacker(l_tra,b_tra,runerror,ffd)
      call dunpacker(l_tra,b_tra,runerror,buffer,length_buffer,curpos)
c*****************************************************
      if(runerror.eq.1.or.runerror.eq.-1) then                  
         goto 50                !go to end
      endif

      nqualcosa = (real(l_tra))/13*16
      xx = b_tra(nqualcosa)
      if (xx.eq.0) nqualcosa=nqualcosa -1
      
 18   datalength_dat= nqualcosa
 11   format(i1,'   ',z4)
     
c*****************************************************
cccccc 10/9/2005 modified by david fedele
c     call readtrailer(trailer,runerror,ffd)
      call readtrailer(trailer,runerror,buffer,length_buffer,curpos,
     $     startcrc,stopcrc,crctemp)
c*****************************************************
      
***************************************************************      
*                      TRAILER                                *
***************************************************************

      pnum_dat=ishft(iand(trailer(1),z'f000'),-12)
      cmdnum_dat=ishft(iand(trailer(1),z'0f00'),-8)
      bid1_dat=ishft(iand(trailer(1),z'00c0'),-6)
      bid2_dat=ishft(iand(trailer(1),z'0030'),-4)
      bid3_dat=ishft(iand(trailer(1),z'000c'),-2)
      bid4_dat=iand(trailer(1),z'0003')
      bid5_dat=ishft(iand(trailer(2),z'c000'),-14)
      bid6_dat=ishft(iand(trailer(2),z'3000'),-12)
      bid7_dat=ishft(iand(trailer(2),z'0c00'),-10)
      alarm_dat=ishft(iand(trailer(2),z'0300'),-8)   
      aswr_dat=ior(ishft(iand(trailer(2),z'00ff'),8)
     $      ,ishft(iand(trailer(3),z'ff00'),-8))
      crc_dat=iand(trailer(3),z'00ff')

      bid_dat_sum = (bid1_dat + bid2_dat + bid3_dat + bid4_dat +
     &     bid5_dat + bid6_dat + bid7_dat) 

      bid_dat = bid_dat_sum/7

      if ((bid_dat.ne.1.and.bid_dat.ne.2).or.
     $    (mod(bid_dat_sum,7).ne.0).or.
     $     .false.) then
         write(*,*) '*** *** *** *** *** *** *** *** *** *** *** ***'
         write(*,*) 'unpack_data: TRAILER PACKET CORRUPTED - <BID> '
     $        ,bid_dat
         write(*,*) '*** *** *** *** *** *** *** *** *** *** *** ***'
         ALARMs=.true.
      endif

      
      if (alarm_dat.eq.3) then
         write(*,*) '--- --- --- --- --- --- --- --- --- --- ---'
         write(*,*) 'unpack_data: TRAILER --- AQUISITION ALARM!!!'
         write(*,*) '--- --- --- --- --- --- --- --- --- --- ---'     
         write(*,*) alarm_dat
         ALARMs=.true.

      endif
       
      if (alarm_dat.ne.3.and.alarm_dat.ne.0) then
         write(*,*) '*** *** *** *** *** *** *** *** *** *** *** *** **'
         write(*,*) 'unpack_data: TRAILER PACKET CORRUPTED - ALARM '
     $        ,alarm_dat
         write(*,*) '*** *** *** *** *** *** *** *** *** *** *** *** **'
         ALARMs=.true.
      endif

      
 50   return
      end


*.............................................................................
      subroutine initlevel0

      include '../common/commontracker.f'
      include '../common/level0.f'

      do i=1, nviews
         
         DAQmode(i) = 0
         DSPnumber(i) = 0
         eventn(i) = 0
         nclust(i) = 0
         cutc(i) = 0
         cutcl(i) = 0
         addrcluster(i,1) = 0
         signcluster(i,1) = 0
         addrcluster(i,2) = 0
         signcluster(i,2) = 0
         addrcluster(i,3) = 0
         signcluster(i,3) = 0
         fc(i) = 0
         compressiontime(i) = 0
         fl5(i) = 0
         fl4(i) = 0 
         fl3(i) = 0  
         fl2(i) = 0  
         fl1(i) = 0  
         fl6(i) = 0  
         checksum(i) = 0
         DATAlength(i) = 0
         pnum(i)= 0
         cmdnum(i)= 0
         bid(i) = 1 
         alarm(i)= 0
         aswr(i) = 0
c*****************************************************
cccccc 10/9/2005 modified by david fedele
         crc(i)=.true.
c*****************************************************
      enddo

      TOTDATAlength = 0
      good0=.true.

      return
      end


*     *** *** *** *** *** *** *** *** *** 
*
*
*
*
*
*
*     *** *** *** *** *** *** *** *** *** 
      subroutine fillview(i,crctemp)
c     -----------------------------------------------------
c     fill variables related to view i
c     which will be stored in the level0 nt-ple
c     at the end of loop on views
c     ----------------------------------------------------

      include '../common/commontracker.f'
      include '../common/level0.f'
      include '../common/common_readraw.f'

      integer*1 crctemp

      DAQmode(i) = DAQmode_dat
      DSPnumber(i) =  DSPnumber_dat
      eventn(i) = eventn_dat
      nclust(i) = nclust_dat
      cutc(i) = cutc_dat
      cutcl(i) = cutcl_dat
      addrcluster(i,1) = addrcluster_dat(1)
      signcluster(i,1) = signcluster_dat(1)
      addrcluster(i,2) = addrcluster_dat(2)
      signcluster(i,2) = signcluster_dat(2)
      addrcluster(i,3) = addrcluster_dat(3)
      signcluster(i,3) = signcluster_dat(3)
      fc(i) = fc_dat
      compressiontime(i) = compressiontime_dat
      fl5(i) = fl5_dat
      fl4(i) = fl4_dat
      fl3(i) = fl3_dat  
      fl2(i) = fl2_dat
      fl1(i) = fl1_dat
      fl6(i) = fl6_dat
      checksum(i) = checksum_dat
      DATAlength(i) = datalength_dat
c*****************************************************
cccccc 1/12/2005 modified by david fedele
      if(crctemp.eq.crc_dat)then 
        crc(i)=.true.
      else
        print*,'**** READRAW: WARNING crc(',i,')=.false. '
        write(*,100),crctemp,crc_dat
 100    format('crctemp=',z2,'     crc_dat=',z6)
        crc(i)=.false.
      endif
c*****************************************************

c    -----------------------------------------------------------------------
c     filling TRAILER variables
c     ----------------------------------------------------------------------

      pnum(i)= pnum_dat
      cmdnum(i)= cmdnum_dat
      bid(i) = bid_dat 
      alarm(i)= alarm_dat
      aswr(i) = aswr_dat

      do idat=1,datalength_dat  
         id =  TOTDATAlength + idat
         datatracker(id) = b_tra(idat)
      enddo
      TOTDATAlength = TOTDATAlength + datalength_dat

      return
      end

