************************************************************************
*     
*     Program readraw.F
*     
*     - creates output files data structure with RUNINFO and LEVEL0 ntuples
*     - reads raw data input files (FILENAME.DAT, FILENAME.PEDSIG##, 
*     ##=1..12)
*     - fills ped, sig and bad histograms with online computed (DSP) values
*     - fills RUNINFO and LEVEL0 ntuples
*     
*     needs:
*     - ./go_readraw                        go file
*     - ../data/FILENAME.DAT                input data file
*     - ../data/FILENAME.PEDSIG##, ##=1..12 input pedsig files
*     - ../common/commontracker.f           tracker general common
*     - ../common/runinfo.f                 runinfo ntuple common
*     - ../common/level0.f                  level0 ntuple common
*     - ./readevent.c                       C routine to read input file
*     
*     output:
*     - ../rz/FILENAME.rz                   ntuples out file
*     
*************************************************************************


      program readraw

      include '../common/commontracker.f'
      include '../common/common_readraw.f'
      include '../common/level0.f'
      include '../common/calib.f'

      include '../tof/common_tof.f'


      integer trk_DSP_ok(nviews) !mask of found DSP packets
      common/DSPok/trk_DSP_ok

c------------------------------------------------------------------------
c     
c     local variables
c     
c------------------------------------------------------------------------
      parameter (nfile_max=20)

      character*24 processing_date

c     local variables for input files
      character*60 name_temp
      character*3 aa(nfile_max)
      character*2 aaa
      character*40 in_file(nfile_max) !input data file
      character*40 in_dir       !input data dir
      character*40 out_dir      !output dir
      character*60 out_file     !output rz file
      character*60 out_file_runinfo !output log file
      character*60 out_file_level0 !output rz file (level 0)
      character*60 out_file_calib !output rz file (calibration)
      character*60 out_file_tof !output rz file (TOF)


      character*8 date 
c     character*3 particle

      integer file_id(nfile_max),file_events(nfile_max)

      character*200 copystring

c     integer this_eventn
c     integer this_calib

c     local variables for data unpacking 
      logical found_cal_pkt     !flag for calibration packets
      integer ffd               !input file descriptor
      integer runerror          !readevent error flag
c     integer ffd_pkt           !pkt file descriptor
c     !(file temporaneo)     
      parameter (MAXBUFFLEN=z'172c8')
      integer*4 CPU_pkt_counter
c     integer pkt_type
      integer*4 length_buffer
      integer trk_calib_used
      integer acq_build_info
      integer*1 buffer(MAXBUFFLEN)

c     integer ndummy
c     data ndummy/1000/

      logical DEBUG,ALARMs
      common/DEBUGflag/DEBUG,ALARMS

      logical trk_link(2)

      
c     local parameters
      parameter (lun_out_file_runinfo=49) !txt log file id number
      parameter (lun_out_file_calib=50) !output file id number
      parameter (lun_out_file_level0=51) !output file id number
      parameter (lun_out_file_tof=52) !output file id number

      parameter (lun_in_file=53) !input file id number


      parameter (max_event_number=50000) !maximum number of events
      
      integer last_trigger(nviews)
      common/trigger_counter/last_trigger
      data last_trigger/12*0./
      

      COMMON/QUEST/IQUEST(100)  !permette di ottenere ntuple funzionanti nonostante
                                ! il messaggio dei 64K di RZOUT...!???


c------------------------------------------------------------------------
c     
c     HBOOK initialization
c     
c------------------------------------------------------------------------

      call HLIMIT(NWPAWC)


c------------------------------------------------------------------------
c     
c     reads input informations (through < go_readraw)
c     
c------------------------------------------------------------------------

      print*,'______________________________________________'

      print*,'Number of files to be analysed:'
      read(*,*)nfile
      print*,nfile
      print*,'Date YYMMDD:'
 300  format(a6)
      read(*,300)date
      print*,date
      print*,'List of file identifiers:'
c     401  format('output_',A6,'_',A3,'.dat') !file name
 401  format('DW_',A6,'_',A3,'.dat') !file name
c     402  format('dt_temp/')        !directory
      read(*,*)(file_id(i),i=1,nfile)
      write(*,*)(file_id(i),i=1,nfile)
c     write(in_dir,402)date
c     in_dir='dt_temp/'
      in_dir='raw-data/'
      do i=1,nfile
         iii = file_id(i)
         call intstr(iii,aa(i),3)
c     write(name_temp,400)date,date,aa(i)
         write(name_temp,401)date,aa(i)
         in_file(i)=name_temp(1:LNBLNK(name_temp))
         print*,in_file(i)
         file_events(i)=0
      enddo 
      
 499  format(A40)
      print*,'output directory:'
      read(*,499)out_dir
      print*,out_dir
c     out_dir='rz/'
      print*,'output files:'    !../rz/PART_E_##
      print*,'(name only, without extention)'
 500  format(A40)
      read(*,500)out_file
      print*,out_file
 501  format(a,'_RUNINFO.txt')
      write(out_file_runinfo,501)out_file(1:LNBLNK(out_file))
      print*,'RUN INFORMATION:'
      print*,out_file_runinfo

      print*,'Total number of events to be analized:'
      read(*,*)nev_total
      print*,nev_total
      print*,'______________________________________________'


c------------------------------------------------------------------------
c     
c     Opening log-file RUNINFO
c     
c     
c------------------------------------------------------------------------

      call fdate(processing_date)
      open(UNIT=lun_out_file_runinfo
     $     ,FILE=out_dir(1:LNBLNK(out_dir))
     $     //out_file_runinfo(1:LNBLNK(out_file_runinfo))
     $     ,ACCESS='APPEND'
     $     ,FORM='FORMATTED'
     $     ,STATUS='UNKNOWN'
     $     )
      write(lun_out_file_runinfo,101)
     $     processing_date
     $     ,nfile
     $     ,date
     $     ,(file_id(i),i=1,nfile)
 101  format(/
     $     ,'*** *** *** *** *** *** *** *** *** *** *** *** ***',/
     $     ,'*                                                 *',/
     $     ,'* READRAW                                         *',/     
     $     ,'*                                                 *',/
     $     ,'*** *** *** *** *** *** *** *** *** *** *** *** ***',/
     $     ,a24,/
     $     ,/
     $     ,'Data info',/
     $     ,'...................................................',/
     $     ,'Number of reduced files         ',i6,/
     $     ,'Date                            ',a6,/
     $     ,'List of file identifiers        ',/
     $     ,10i5/
     $     )

c------------------------------------------------------------------------
c     
c     read run information
c     
c------------------------------------------------------------------------
c     level0=.true.             !data elaboration level
c     level1=.false.            
c     level2=.false.
c     level3=.false.

c     call read_runinfo         !some information about the run is from prompt


*-------------------------------------------------------------
*     
*     start loop on data files
*     
*     
*------------------------------------------------------------
*     some flags to check the data stream
      found_cal_pkt=.false.
      n_cal_pkt=0
      n_cal_pkt_last=0

      nev0_c = 0                !global event counter
      nev0_good = 0
      trk_link(1)=.false.
      trk_link(2)=.false.


      
      this_CPU_pkt = 0
      do ifile = 1,nfile        !loop on data files

         write(lun_out_file_runinfo,104)
     $        ifile
     $        ,in_file(ifile)
 104     format(/
     $        ,/
     $        '+...+...+...+...+...+...+...+...+...+...+...+...+',/
     $        ,'      Processing file    ',i2,/
     $        ,'      ',a40,/
     $        '+...+...+...+...+...+...+...+...+...+...+...+...+'
     $        )
         
         
         print*,' '
         print*,'OPENING PARTICLE FILE:'
         print*,in_file(ifile)
         print*,' '
         
         open(unit=lun_in_file, 
     $        file=in_dir(1:LNBLNK(in_dir))
     $        //in_file(ifile)(1:LNBLNK(in_file(ifile))), 
     $        status='old', 
     $        form='unformatted', 
     $        err=22)
         ffd = FNum(lun_in_file) !reads unix file descriptor
         
         file_events(ifile)=0   !sigle-file event counter 
         nev_file_good = 0
c     this_eventn=0
         
c     this_CPU_pkt = 0
         do iev = 1,min(nev_total,max_event_number) !events loop
            
            
            
****************************************************************
*     this routine search for a cpu header pointing to a tracker
*     packet, and save the content in a temp file
*     >>>>>>  packet.dat  <<<<<<
            call findcpuheader(runerror,ffd,pkt_type,CPU_pkt_counter
     $           ,obt,buffer,length_buffer)
            
            
c     if(runerror.eq.-1) goto 24
            if(runerror.eq.-1) then                  
               print*,' '
               print*,'readraw: ERROR ON READING FILE: ',in_file(ifile)
               print*,'_____________________________________ '
               goto 9900        !end loop on files 
            endif
            if(runerror.eq.1) then                  
               print*,' '
               print*,'readraw: FILE: ',in_file(ifile)
               print*,'readraw: END OF FILE AT EVENT ',iev-1
               print*,'_____________________________________ '
               goto 9900        !end loop on files 
            endif
            if(CPU_pkt_counter.le.this_CPU_pkt)then
               print*,'  '
               print*,' Non consecutive cpu packet! '
               print*,' From ',this_CPU_pkt,' to ',CPU_pkt_counter
               goto 9900        !next file
            endif
            
            this_CPU_pkt = CPU_pkt_counter
            name_temp='packet.dat'
            
            pkt_num=CPU_pkt_counter
            
******************************************************
******************************************************
******************************************************
******************************************************
******************************************************
******************************************************
******************************************************
******************************************************
            
            
            
******************************************************
******************************************************
******************************************************
******************************************************
******************************************************
******************************************************
            
            
            if(pkt_type.eq.z'12'.or.pkt_type.eq.z'13')then
               if(pkt_type.eq.z'12')then
                  trk_link(1)=.true.
               else
                  trk_link(2)=.true.
               endif
c--   **--**--**--**--**--**--**--**--**--**--**--**--**--**--**
c     -----------
c     CALIBRATION
c     -----------
c--   **--**--**--**--**--**--**--**--**--**--**--**--**--**--**

               call trkcalibpkt(runerror,name_temp)
               
 2222          continue
               
            elseif(pkt_type.eq.z'10'.or.pkt_type.eq.z'30')then
               
               good0=.true.
               call trkeventpkt(runerror,name_temp)
               if(runerror.ne.0)then 
                  good0=.false.
                  DEBUG = .true.
               endif
               
               call init_tof
               good=.true.
               call triggerunpack(buffer,length_buffer,me)
               if(me.eq.1)good=.false.
               call tofunpack(buffer,length_buffer,me)
               if(me.eq.1)good=.false.
               
****  CHECK TRIGGER SEQUENCE  ****
               do idsp=1,nviews
                  if(trk_DSP_ok(idsp).eq.1)then
                     if(eventn(idsp).ne.(last_trigger(idsp)+1)
     $                    .and.eventn(idsp).ne.1)
     $                    write(*,8181)
     $                    idsp,last_trigger(idsp),eventn(idsp)
                     last_trigger(idsp)=eventn(idsp)
                  endif
               enddo
 8181          format(i2,' >> JUMP from trigger ',i6,' to ',i6)
               
c$$$  c--   **--**--**--**--**--**--**--**--**--**--**--**--**--**--**
c$$$  c     -----
c$$$  c     EVENT
c$$$  c     -----
c$$$  c--   **--**--**--**--**--**--**--**--**--**--**--**--**--**--**
            elseif(pkt_type.eq.z'83')then
               
               call trkalarmpkt(buffer,length_buffer,runerror)
               
c$$$  c--   **--**--**--**--**--**--**--**--**--**--**--**--**--**--**
c$$$  c     -----
c$$$  c     ALARM
c$$$  c     -----
c$$$  c--   **--**--**--**--**--**--**--**--**--**--**--**--**--**--**

            elseif(pkt_type.eq.z'20')then
               
               call runheaderpkt(buffer,length_buffer
     $              ,trk_calib_used,acq_build_info)
c     this gives the TRK_CALIB_USED field and the ACQ_BUILD_INFO only 
c     inside the runheader packet
c$$$  c--   **--**--**--**--**--**--**--**--**--**--**--**--**--**--**
c$$$  c     -----
c$$$  c     RUNHEADER PACKET
c$$$  c     -----
c$$$  c--   **--**--**--**--**--**--**--**--**--**--**--**--**--**--**

c$$$  6667          format(z1,' ',z8)
c$$$  write(*,6667) trk_calib_used,acq_build_info


            endif               !end pkt type conditions
            
            
******************************************************
******************************************************
******************************************************
******************************************************
******************************************************
******************************************************

*     format of output files
 502        format(a,'_',a2,'_LEVEL0.rz')
 5022       format(a,'_',a2,'_TOF.rz')
 503        format(a,'_',a2,'_calib.rz')
            
            
            if(
     $           (pkt_type.eq.z'10'.or.pkt_type.eq.z'30').and.
     $           .true.) then
c----------------------------------------------------------------
c     an EVENT was found, fill the n-tuple
c----------------------------------------------------------------
C     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C     if no calib pkts have been found
C     a data file labelled "00" is opened
C     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
               if(
     $              (n_cal_pkt_last.eq.0.and.nev0_c.eq.0).or.
     $              (n_cal_pkt_last.ne.n_cal_pkt).or.
     $              .false.)then
                  
C     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C     if new calib pkts have been found
C     and a new one is opened with an increased label
C     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
                  n_cal_pkt_last = n_cal_pkt
                  nev0_c = 0
                  nev0_good = 0
                  
                  if(n_cal_pkt.ge.1)then
C     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C     in this case a calibration pkt has already been found
C     --> the previous data file is closed
C     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
                     print*,' '
                     print*,'CLOSING FILES:'
                     print*,out_file_level0
                     print*,out_file_tof
                     print*,' '
                     call HCDIR('//LEVEL0',' ')
                     call HPRNTU(ntp_level0) !prints ntuple structure
                     call RZPURG(-1)    
                     call HROUT(ntp_level0,ICYCLE,'T')
                     call HREND('LEVEL0')
                     close(lun_out_file_level0)               
                     call HCDIR('//TOF',' ')
                     call HPRNTU(ntp_tof) !prints ntuple structure
                     call RZPURG(-1)    
                     call HROUT(ntp_tof,ICYCLE,'T')
                     call HREND('TOF')
                     close(lun_out_file_tof)               
                     
                  elseif(n_cal_pkt.eq.0.and.pkt_type.ne.z'30')then
C     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C     if no calib pkts have been found
C     and the pkt type is "physics", a calibration labelled "00" is open
C     with default calibration parameters
C     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
                     
                     nnnn=n_cal_pkt
c     print*,nnnn,n_cal_pkt
                     call intstr(nnnn,aaa,2)
c     print*,aaa,out_file
                     write(out_file_calib,503)
     $                    out_file(1:LNBLNK(out_file)),aaa
c     write(out_file_calib,503)out_file(1:LNBLNK(out_file))
c     print*,'CREATING DEFAULT CALIBRATION FILE:'
c     print*,out_file_calib
                     
                     write(lun_out_file_runinfo,1033)
     $                    out_file_calib
                     write(*,1033)
     $                    out_file_calib
 1033                format(
     $                    '*---------------------------------------------/
     $                    ----*',/
     $                    ,'   Creating DEFAULT calibration rz file',/
     $                    ,'   ',a40,/
     $                    '*---------------------------------------------/
     $                    ----*',/
c     $           ,/
c     $           'Processing events from 1 to ',i6,/
c     $           ,/
     $                    )
                     
                     copystring='cp '
     $                    //out_dir(1:LNBLNK(out_dir))
     $                    //'output_040707_010_01_calib.rz '
     $                    //out_dir(1:LNBLNK(out_dir))
     $                    //out_file_calib(1:LNBLNK(out_file_calib))
c     print*,copystring
                     call system(copystring)
                     
                  endif
                  
c------------------------------------------------------------------------
c     
c     ntuples and histos booking
c     
c------------------------------------------------------------------------
                  nnnn=n_cal_pkt
                  call intstr(nnnn,aaa,2)
                  write(out_file_level0,502)
     $                 out_file(1:LNBLNK(out_file)),aaa
c     print*,'LEVEL0 EVENT DATA:'
c     print*,out_file_level0
                  
                  write(out_file_tof,5022)
     $                 out_file(1:LNBLNK(out_file)),aaa
c     print*,'TOF EVENT DATA:'
c     print*,out_file_tof
                  
                  IQUEST(10)=64000          
c     permette di ottenere ntuple funzionanti nonostante
c     il messaggio dei 64K di RZOUT... !???
                  
                  
                  write(lun_out_file_runinfo,103)
     $                 out_file_level0,out_file_tof
                  write(*,103)
     $                 out_file_level0,out_file_tof
 103              format(
     $                 '*---------------------------------------------/
     $                 ----*',/
     $                 ,'   Creating rz files',/
     $                 ,'   ',a40,/
     $                 ,'   ',a40,/
     $                 '*---------------------------------------------/
     $                 ----*',/
c     $           ,/
c     $           'Processing events from 1 to ',i6,/
c     $           ,/
     $                 )
                  
                  
*     create LEVEL0 tracker file
                  call HROPEN(lun_out_file_level0,
     $                 'LEVEL0',
     $                 out_dir(1:LNBLNK(out_dir))
     $                 //out_file_level0(1:LNBLNK(out_file_level0)),
     $                 'QN',4096,istat) !opens rz
                  if(istat.ne.0) goto 19      
                  call HCDIR('//LEVEL0',' ')
                  call book_level0
                  
*     create TOF tracker file
                  
                  
                  call HROPEN(lun_out_file_tof,
     $                 'TOF',
     $                 out_dir(1:LNBLNK(out_dir))
     $                 //out_file_tof(1:LNBLNK(out_file_tof)),
     $                 'QN',4096,istat) !opens rz
                  if(istat.ne.0) goto 19      
                  call HCDIR('//TOF',' ')
                  call book_tof
                  
c     print*,'DONE'
                  print*,' '
                  
                  
                  
                  
               endif            !end condition for opening a new data file
               

C     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C     then the nt-uple is filled
C     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
               file_events(ifile) =  
     $              file_events(ifile) +1 !sigle-file event counter 
               if(good0.eqv..true.)nev_file_good = nev_file_good +1
               nev0_c = nev0_c + 1 !global event counter
               nev0 =  1000000*file_id(ifile) + nev0_c
               nev_trk = nev0
               
               call HCDIR('//LEVEL0',' ')            
c     print*,'CALL HFILL --- event ',nev0_c
               call HFNT(ntp_level0) !ntuple filling
               
               call HCDIR('//TOF',' ')            
               call HFNT(ntp_tof) !ntuple filling
               
               if(mod(nev0_c,10).eq.0)print*,nev0_c
               if(nev0_c.eq.nev_total)then
                  write(lun_out_file_runinfo,107)
     $                 file_events(ifile),
     $                 nev_file_good
                  nev0_good = nev0_good + nev_file_good
                  goto 9990
               endif
               dsptot=0
               do iview=1,nviews
                  dsptot=dsptot+trk_DSP_ok(iview)
                  trk_DSP_ok(iview)=0 !init DSP flag
               enddo
               
               if(dsptot.lt.nviews)then
                  print *,'DSP pkt found: '
     $                 ,(trk_DSP_ok(iview),iview=1,12)
                  print *,'---> CPU physics pkt --- ',this_CPU_pkt
                  print *,''
               elseif(DEBUG)then
                  print *,'---> CPU physics pkt --- ',this_CPU_pkt
                  print *,''
                  DEBUG = .false.
               endif
               
               
               
            elseif(
     $              pkt_type.eq.z'83'.and.
     $              .true.) then
               
               print*,''
               print*,'@@@@@@@@@@@@ ALARM @@@@@@@@@@@@@@@'
               print*,''
               
            elseif(
     $              (pkt_type.eq.z'12'.or.pkt_type.eq.z'13').and.
     $              trk_link(1).eqv..true..and.
     $              trk_link(2).eqv..true..and.
     $              .true.) then
c     print*,trk_link(1),trk_link(2),pkt_type
c----------------------------------------------------------------
c     a calibration packet was found
c     --> book and fill histos
c----------------------------------------------------------------
               n_cal_pkt = n_cal_pkt + 1
               nnnn=n_cal_pkt 
               call intstr(nnnn,aaa,2)
               write(out_file_calib,503)
     $              out_file(1:LNBLNK(out_file)),
     $              aaa
               
               write(lun_out_file_runinfo,106)out_file_calib
               write(*,106)out_file_calib
 106           format(
     $              '*--------------------------------------------/
     $              -----*',/
     $              ,'   Creating CALIBRATION rz file',/
     $              ,'   ',a40,/
     $              ,'*-------------------------------------------/
     $              ------*'
     $              )
               
               call HROPEN(lun_out_file_calib,
     $              'RUNINFO',
     $              out_dir(1:LNBLNK(out_dir))
     $              //out_file_calib(1:LNBLNK(out_file_calib)),
     $              'QN',4096,istat) !opens rz
               if(istat.ne.0) goto 19      
               call HCDIR('//RUNINFO',' ')
               
               call book_histos
               call fill_histos
               
               call HCDIR('//RUNINFO',' ')
               do iview=1,nviews
c     if(trk_DSP_ok(iview).eq.1)then
                  call HROUT(id_hi_bad+iview,ICYCLE,'T')
                  call HROUT(id_hi_ped+iview,ICYCLE,'T')
                  call HROUT(id_hi_sig+iview,ICYCLE,'T')
c     endif
               enddo
               call HREND('RUNINFO')
               close(lun_out_file_calib)
               do iview=1,nviews
                  trk_DSP_ok(iview)=0 !init DSP flag
               enddo
               trk_link(1)=.false.
               trk_link(2)=.false.
               
c     print*,'///////////////////////'
c     stop
               
            endif
 9909       continue
c     close(lun_pkt)
         enddo                  !end loop on events
 9900    continue
         close(lun_in_file)
         
         nev0_good = nev0_good + nev_file_good
         write(lun_out_file_runinfo,107)
     $        file_events(ifile),
     $        nev_file_good
 107     format(
     $        'Number of events                ',i8,/
     $        ,'Good events                     ',i8,/
     $        ,'...................................................',/
     $        )
         
      enddo                     !end loop on data files
      
 9990 continue
      write(lun_out_file_runinfo,108)
     $     nev0_c,nev0_good
 108  format(/
     $     ,'|------------------------------------------------|',/
     $     ,'|  Number of processed events                    |',/
     $     ,'|  Total ',i8,'                                |'/
     $     ,'|  Good  ',i8,'                                |'/
     $     ,'|------------------------------------------------|',/
     $     )


      goto 9000                 !go to end
c-----------------------------------------
c     output file creation error
c-----------------------------------------
 19   continue      
      print*,' '
      print*,'readraw: ERROR CREATING OUTPUT FILE: ',out_file
      print*,istat
      print*,' '
      print*,' '
      goto 9000                 !the end
c-----------------------------------------
c     particle input file opening error     
c-----------------------------------------
 22   continue
      print*,' '
      print*,'readraw: ERROR OPENING PARTICLE FILE: ',in_file(ifile)
      print *,in_dir
      print *,in_dir(1:LNBLNK(in_dir))
     $     //in_file(ifile)(1:LNBLNK(in_file(ifile)))
      print*,' '
      goto 9000                 !the end
c-----------------------------------------
c     event found before calibration packet  
c-----------------------------------------
 20   continue
      print*,' '
      print*,'readraw: EVENT FOUND BEFORE CALIBRATION PACKET: '
      print*,in_file(ifile)
      print*,' '
      goto 9000                 !the end
c-----------------------------------------
c     particle input file reading error     
c-----------------------------------------
 23   continue
      print*,' '
      print*,'readraw: END OF FILE: ',in_file(ifile)
      print*,'readraw: FOWND AT EVENT ',iev
      print*,' '
      goto 9000                 !the end
 24   continue
      print*,' '
      print*,'readraw: ERROR READING PARTICLE FILE: ',in_file(ifile)
      print*,'readraw: READ ERROR AT EVENT ',iev
      print*,' '
      goto 9000                 !the end

c------------------------------------------------------------------------
c     
c     closes files and exits
c     
c------------------------------------------------------------------------
 9000 continue
      
      print*,' '
      print*,'CLOSING FILES:'
      print*,out_file_level0
      print*,out_file_tof
      print*,' '
      
      call HCDIR('//LEVEL0',' ')
      call HPRNTU(ntp_level0)   !prints ntuple structure
c     deletes all but the last cycles of all key 
c     from the current working RZ directory
      call RZPURG(-1)    
      call HROUT(ntp_level0,ICYCLE,'T')
      call HREND('LEVEL0')
      close(lun_out_file_level0)

      call HCDIR('//TOF',' ')
      call HPRNTU(ntp_tof)      !prints ntuple structure
c     deletes all but the last cycles of all key 
c     from the current working RZ directory
      call RZPURG(-1)    
      call HROUT(ntp_tof,ICYCLE,'T')
      call HREND('TOF')
      close(lun_out_file_tof)


      close(lun_out_file_runinfo)



      stop
      end

