*************************************************************************
*     
*     Common level2.f
*     
*     contains LEVEL2 ntuple variables definitions
*     
*    
*     11/09/2005 modified by david fedele to include general variables
*     07/10/2005 modified by elena vannuccini --> (2)
*
*************************************************************************

      PARAMETER (NTRKMAX=50)    !ncloyz_max*ncloxz_max)
c*****************************************************
cccccc 11/9/2005 modified by david fedele
      PARAMETER (NSINGMAX=500)
ccc   EVENT block*********
c     GENERAL block:
c***************************************************
*     -----------------------------------------------------------
      logical good2             !flag to mark good or noise events
      integer nev2              !level2 event number
c*****************************************************
cccccc 11/9/2005 modified by david fedele
      integer which_calib       !calibration file identifier. see DW_DATE_NUM_calib.txt file
      integer swcode            !version of the software
      logical crc(12)           !DSP crc controll
c      common/level2/good2,nev2
cccccc 06/10/2005 modified by elena vannuccini
c      common/level2/good2,nev2,which_calib,swcode
      common/level2/good2,nev2,which_calib,swcode,crc
c*****************************************************



c     CPU block (only for ground data):
*     -----------------------------------------------------------
      integer pkt_type          !CPU packet type identifier. see http://people.roma2.infn.it/~cpu/HB_list.txt
c     0x12 --> calibration board 0                  
c     0x13 --> calibration board 1              
c     0x10 --> event                            
c     0x30 --> full event for calib special     
c     0x83 --> tracker ALARM (control register) 
      integer pkt_num           !CPU packet number
      integer obt               !CPU on-board time
c*****************************************************
cccccc 11/9/2005 modified by david fedele
c      integer which_calib       !calibration file identifier. see DW_DATE_NUM_calib.txt file
c      common/level2_cpu/pkt_type,pkt_num,obt,which_calib
      logical cpu_crc           !CPU crc controll
      common/level2_cpu/pkt_type,pkt_num,obt,cpu_crc
c****************************************************

*     -----------------------------------------------------------
*     Common to store TRACK info
*     All the variables have a dimention equal to the number of
*     found tracks
*     -----------------------------------------------------------
c     TRACK PARAMETERS      
      integer ntrk              !# identified tracks
      integer image             !flag to tag track-images
      real al_nt                !track state vector
      real coval                !covariance matrix
      integer xgood_nt          !mask of used planes
      integer ygood_nt          !*
      real xm_nt                !measured points
      real ym_nt                !*
      real zm_nt                !*
      real resx_nt              !spatial resolution
      real resy_nt              !*
      real chi2_nt              !chi2
      real xv_nt                !calculated points
      real yv_nt                !*
      real zv_nt                !*
      real axv_nt               !calculated angles (deg)
      real ayv_nt               !*
c*****************************************************
cccccc 11/9/2005 modified by david fedele
c      real dedxp                !signal in MIP scaled to 300 micrometer
      real dedx_x              !signal in MIP scaled to 300 micrometer
      real dedx_y              !signal in MIP scaled to 300 micrometer
cccccc 06/10/2005 add by elena vannuccini
      real bdl
c****************************************************

      common/level2_tracks/
     $      ntrk
     $     ,image(NTRKMAX)
     $     ,xm_nt(nplanes,NTRKMAX)
     $     ,ym_nt(nplanes,NTRKMAX)
     $     ,zm_nt(nplanes,NTRKMAX)
     $     ,resx_nt(nplanes,NTRKMAX)
     $     ,resy_nt(nplanes,NTRKMAX)
     $     ,al_nt(5,NTRKMAX)
     $     ,coval(5,5,NTRKMAX)
     $     ,chi2_nt(NTRKMAX)
     $     ,xgood_nt(nplanes,NTRKMAX)
     $     ,ygood_nt(nplanes,NTRKMAX)
     $     ,xv_nt(nplanes,NTRKMAX)
     $     ,yv_nt(nplanes,NTRKMAX)
     $     ,zv_nt(nplanes,NTRKMAX)
     $     ,axv_nt(nplanes,NTRKMAX)
     $     ,ayv_nt(nplanes,NTRKMAX)
c*****************************************************
cccccc 27/9/2005 modified by david fedele
c     $     ,dedxp(nplanes,NTRKMAX)
     $     ,dedx_x(nplanes,NTRKMAX)
     $     ,dedx_y(nplanes,NTRKMAX)
c*****************************************************
cccccc 06/10/2005 modified by elena vannuccini
c     $     ,crc(12)
     $     ,bdl(NTRKMAX)

*     -----------------------------------------------------------
*     Common to store SINGLET info
*     (clusters not associated with any track) 
*     -----------------------------------------------------------
      
      integer nclsx             !# unassociated clusters  X views
c*****************************************************
cccccc 11/9/2005 modified by david fedele
      integer planex            !plane of single x
      real xs                   !center coord of single x
      real sgnlxs               !signal in MIP of single x
      common/level2_singletsx/
c    $     nclsx,planex(NSINGMAX),xs(NSINGMAX),sgnlxs(NSINGMAX)   !(2)
     $     nclsx,planex(NSINGMAX),xs(2,NSINGMAX),sgnlxs(NSINGMAX) !(2)

      integer nclsy             !     "            "      Y views
      integer planey            !plane of single y
      real ys                   !center coord of single y
      real sgnlys               !signal in MIP of single y

      common/level2_singletsy/
c    $     nclsy,planey(NSINGMAX),ys(NSINGMAX),sgnlys(NSINGMAX)   !(2)
     $     nclsy,planey(NSINGMAX),ys(2,NSINGMAX),sgnlys(NSINGMAX) !(2)
*********************************************************

