*************************************************************************
*     
*     Common level1.f
*     
*     contains LEVEL1 ntuple variables definitions
*     
*     to be included in:
*     - ../reduction/reduction.f
*     - ../analysis/analysis.f
*     - !???
*     
*     parameters:
*     - nclstrmax
*     - nclstrp
*     
*************************************************************************


c     EVENT block:
      logical good1             !flag to mark good or noise events
      integer nev1              !level1 event number

c     CPU block (only for ground data):
      integer pkt_type1         !CPU packet type identifier. see http://people.roma2.infn.it/~cpu/HB_list.txt
c     0x12 --> calibration board 0                  
c     0x13 --> calibration board 1              
c     0x10 --> event                            
c     0x30 --> full event for calib special     
c     0x83 --> tracker ALARM (control register) 
      integer pkt_num1          !CPU packet number
      integer obt1              !CPU on-board time
      integer which_calib1      !calibration file identifier. see DW_DATE_NUM_calib.txt file

c     CLUSTER block:
      integer nclstr1           !cluster number
      integer view(nclstrmax)   !view the cluster belongs to
      integer ladder(nclstrmax) !ladder the strip carrying the largest signal 
                                ! value belongs to
      integer maxs(nclstrmax)   !cluster strip carrying the largest signal value
      integer mult(nclstrmax)   !cluster multiplicity
      real dedx(nclstrmax)      !cluster multiplicity
      integer indstart(nclstrmax) !cluster starting point index in clsignal array
      integer indmax(nclstrmax) !cluster maximum point index in clsignal array
      integer totCLlength       !sum of all clusters length (to assign
                                ! dimension to clsignal array)
      real clsignal(maxlength)  !signal values of all strips belonging to clusters

c     CNOISE block:
      real cnev(nviews,nva1_view) !common noise of the event for a certain view and
                                ! VA1
      common/level1_general/good1,nev1
      common/level1_cpu/pkt_type1,pkt_num1,obt1,which_calib1
      common/level1_cluster/nclstr1,view,ladder,maxs,mult,dedx,indstart
     $     ,indmax,totCLlength,clsignal,cnev
