*************************************************************************
*     
*     Common common_B_2maps.f
*     
*     to be included in:
*     - ../magnet/read_B_2maps.f
*     - ../magnet/inter_B_2maps.f
*
*     parameters:
*     - nx, ny, nz : number of measures along X, Y and Z axes
*  
*************************************************************************

      implicit double precision (a-h,o-z)


      parameter (nx=29, ny=23, nz=101) !number of measures along X, Y and Z 
                                ! axes

************
c     first map      
      real*8 px1(nx,3),py1(ny,3),pz1(nz,3) !coordinates of measure points:
                                ! e.g. py(ny,1) = Y coordinates of Bx (=1)
                                ! component of magnetic field

      real*8 b1(nx,ny,nz,3),db1(nx,ny,nz,3) !magnetic field values and error:
                                ! e.g. b(nx,ny,nz,2) = By (=2) component of
                                ! magnetic field measured in (nx, ny, nz)

      common/interpolation1/px1,py1,pz1,b1,db1

************
c     second map
      real*8 px2(nx,3),py2(ny,3),pz2(nz,3)
      real*8 b2(nx,ny,nz,3),db2(nx,ny,nz,3)

      common/interpolation2/px2,py2,pz2,b2,db2
