#################################################################
#	Shell script to run the tracker reduction programs
#################################################################
#
#
#
#----------------------------------------------------------------
#local variables:
rawdata_dir='raw-data/'
rzdata_dir='rz-test/'

if [ -n "$1" -a -n "$2" ] ;then
    
    lines=$(grep -n -c $ $1)
    list=`more $1`

#################################################################
# ------------------------- LEVEL0 ------------------------------
#
# This part of the script creates the input to level0.exe and run it, 
# starting from a txt list of file IDs (format: YYMMDD_XXX). 
# 
# Tipical input of level0.exe is as follows:
# ../level0.exe << EOF
# 5               # N. of downlink to process
# raw-data/       # raw-data directory
# 050323_011      # 1^ file id
# 050324_001      # 2^ 
# 050324_002      # ....
# 050324_003      #
# 050324_004      #
# rz-test/        # output rz directory
# 100000          # maximum number of events to be processed
# EOF
#################################################################
    if [ $2 = 'level0' ]; then
	echo $lines        > input 
	echo $rawdata_dir >> input
	for dnlk in $list
	  do
	  echo $dnlk      >> input
	done
	echo $rzdata_dir  >> input
	echo '100000'     >> input
	./level0.exe < input > $1-level0 
#	rm -f input

#################################################################
# ------------------------- LEVEL1 ------------------------------
#
# This script creates the input to level1.exe and run it 
# starting from a txt list of file IDs (format: YYMMDD_XXX). 
# 
# Tipical input of level1.exe is as follows:
# ../level1.exe << EOF
# raw-data/       # raw-data directory
# 050323_011      # file id
# rz-test/        # input/output rz directory
# 100000          # maximum number of events to be processed
# EOF
#################################################################
    elif [ $2 = 'level1' ]; then
	if [ -f $1-level1 ];then
	    rm $1-level1
	fi
	touch $1-level1
	for dnlk in $list
	  do
	  ./level1.exe  >> $1-level1 <<EOF 
$rzdata_dir
$dnlk 
100000
EOF
	done
#################################################################
# ------------------------- LEVEL2 ------------------------------
#
# This script creates the input to level2.exe and run it 
# starting from a txt list of file IDs (format: YYMMDD_XXX). 
# 
# Tipical input of level1.exe is as follows:
# ../level2.exe << EOF
# raw-data/       # raw-data directory
# 050323_011      # file id
# rz-test/        # input/output rz directory
# 100000          # maximum number of events to be processed
# F               # (debug flag) 
# EOF
#################################################################
    elif [ $2 = 'level2' ]; then
	if [ -f $1-level2 ];then
	    rm $1-level2
	fi
	touch $1-level2
	for dnlk in $list
	  do
	  ./level2.exe  >> $1-level2 <<EOF 
$rzdata_dir
$dnlk 
1000000
ETA
F
EOF
	done	
    fi
else
    echo ""
    echo "*** new!!! ***"
    echo "apply eta algorythm!!"
    echo ""
    echo "USAGE:"
    echo "./run-test.sh downlink-list-file-name level0/1/2"    
    echo "( ex: ./run-test.sh 050323.txt level0 & )"    
    echo "( ex: ./run-test.sh 050323.txt level1 & )"    
    echo "( ex: ./run-test.sh 050323.txt level2 & )"    
    echo ""    
fi

