#ifndef trknuclei_h
#define trknuclei_h


#if !defined(__CINT__) || defined(__MAKECINT__)

#include <PamLevel2.h>

#include <TF2.h>
#include <TGraph.h>
#include <TMath.h>
#include <TSpline.h>
#include <stdlib.h>


#include <iostream>
#include <iomanip>
using namespace std;

#endif
///////////////////////////////////////////////////
///
///
///  CLASS FOR INITIALIZATIONS & PARAMETERS
///
///
///////////////////////////////////////////////////

class TrkNuclei_parameters : public TObject{

 private:
    
    TrkNuclei_parameters(){ SetDefault(); };
    
    static TrkNuclei_parameters * _parameters;

 public:

    static TrkNuclei_parameters *Get(){
	if(_parameters==0) {
//	    cout << "**NEW**"<<endl;
	    _parameters = new TrkNuclei_parameters();
	}
	return _parameters;
    }
    
    // ----------
    // PARAMETERS
    // ----------
    TF2 *charge_vs_beta;
    TF2 *charge_vs_rig;


    bool SetZ_Beta( TF2* f );
    bool SetZ_Beta( const char* formula );
    TF2 *GetZ_Beta(){return charge_vs_beta;};

    bool SetZ_Rigidity( TF2* f );
    bool SetZ_Rigidity( const char* formula );
    TF2 *GetZ_Rigidity(){return charge_vs_rig;};

    void SetDefault();
    
    void Delete();
    
    ClassDef(TrkNuclei_parameters,1);

};
///////////////////////////////////////////////////
///
///
///  CLASS INPLEMENTATION
///
///
///////////////////////////////////////////////////
class TrkNuclei : public TObject{

 private:
    
/*     float dedx_x[6]; */
/*     float dedx_y[6]; */
/*     int   maxs_x[6]; */
/*     int   maxs_y[6]; */

    TrkTrack *nutrk;

 public:


    TrkNuclei(){ Reset(); };
    TrkNuclei(PamLevel2 *l2, int ntr){ Reset(); Set(l2,ntr); }; 
    TrkNuclei(PamTrack* trk){ Reset(); Set(trk); }; 
    TrkNuclei(TrkTrack *trk){ Reset(); Set(trk); }; 

    ~TrkNuclei(){ Reset(); };
    
    void Reset();
    void Clear(){ Reset(); };
    void Delete(){ Reset(); };

    TrkTrack *GetTrkTrack(){ return nutrk; };

    bool Set(TrkTrack*);
    bool Set(PamTrack*);
    bool Set(PamLevel2*,int);


    Float_t GetZ_Beta(int ip, int iv, float beta);
    Float_t GetZ_Beta(int ip, float beta);
    Float_t GetZ_Beta(float beta);

    Float_t GetZ_Rigidity(int ip, int iv, float rig);
    Float_t GetZ_Rigidity(int ip, float rig);
    Float_t GetZ_Rigidity(float rig);
    Float_t GetZ_Rigidity(int ip, int iv){return GetZ_Rigidity(ip,iv,nutrk->GetRigidity());};
    Float_t GetZ_Rigidity(int ip){return GetZ_Rigidity(ip,nutrk->GetRigidity());};
    Float_t GetZ_Rigidity(){return GetZ_Rigidity(nutrk->GetRigidity());};

    ClassDef(TrkNuclei,1);

};
#endif
