/**
 * \file ToFViewer.cpp
 * \author Elena Vannuccini
 */
#include <ToFViewer.h>


#define COLO 5
#define LCOL 13 // color of tof-volume lines


void GetToFPaddlePosition(Int_t iplane, Int_t ipaddle,Float_t &cornerx, Float_t &cornery, Float_t &cornerz,Float_t &dx, Float_t &dy, Float_t &dz){

    if(iplane==0){
	cornerx = -NTOF11*DXTOF11/2.+ipaddle*DXTOF11;
	cornery = -DYTOF11/2.;
	cornerz = ZTOF11 - DTTOF11/2.;
	dx = DXTOF11; 
	dy = DYTOF11;
	dz = DTTOF11;
    }
    if(iplane==1){
	cornery = -NTOF12*DYTOF12/2.+ipaddle*DYTOF12;
	cornerx = -DXTOF12/2.;
	cornerz = ZTOF12 - DTTOF12/2.;
	dx = DXTOF12; 
	dy = DYTOF12;
	dz = DTTOF12;
    }
    if(iplane==2){
	cornery = -NTOF21*DYTOF21/2.+(NTOF21-ipaddle-1)*DYTOF21;
	cornerx = -DXTOF21/2.;
	cornerz = ZTOF21 - DTTOF21/2.;
	dx = DXTOF21; 
	dy = DYTOF21;
	dz = DTTOF21;
    }
    if(iplane==3){
	cornerx = -NTOF22*DXTOF22/2.+ipaddle*DXTOF22;
	cornery = -DYTOF22/2.;
	cornerz = ZTOF22 - DTTOF22/2.;
	dx = DXTOF22; 
	dy = DYTOF22;
	dz = DTTOF22;
    }
    if(iplane==4){
	cornerx = -NTOF31*DXTOF31/2.+ipaddle*DXTOF31;
	cornery = -DYTOF31/2.;
	cornerz = ZTOF31 - DTTOF31/2.;
	dx = DXTOF31; 
	dy = DYTOF31;
	dz = DTTOF31;
    }
    if(iplane==5){
	cornery = -NTOF32*DYTOF32/2.+ipaddle*DYTOF32;
	cornerx = -DXTOF32/2.;
	cornerz = ZTOF32 - DTTOF32/2.;
	dx = DXTOF32; 
	dy = DYTOF32;
	dz = DTTOF32;
    }

}

/**
 * ToF volume (projections) constructor
 */
GToFVolume::GToFVolume(){

//  ==================================== TOF-11
    for ( Int_t j=0; j<NTOF11; j++){
	Float_t corner = -NTOF11*DXTOF11/2.+j*DXTOF11;
	ftof11x[j] = new TBox(corner,ZTOF11-DTTOF11/2.,corner+DXTOF11,ZTOF11+DTTOF11/2.);
	ftof11x[j]->SetFillStyle(0);
	ftof11x[j]->SetLineColor(LCOL);
//	ftof11x[j]->SetLineWidth(1);
    };
    ftof11y = new TBox(-DYTOF11/2.,ZTOF11-DTTOF11/2.,DYTOF11/2.,ZTOF11+DTTOF11/2.);
    ftof11y->SetFillStyle(0);
    ftof11y->SetLineColor(LCOL);
//  ftof11y->SetLineWidth(1);
    ftof11t = new TBox(-NTOF11*DXTOF11/2.,-DYTOF11/2.,+NTOF11*DXTOF11/2.,+DYTOF11/2.);
    ftof11t->SetFillStyle(0);
    ftof11t->SetLineColor(LCOL);
    
//  ==================================== TOF-12
    for ( Int_t j=0; j<NTOF12; j++){
	Float_t corner = -NTOF12*DYTOF12/2.+j*DYTOF12;
	ftof12y[j] = new TBox(corner,ZTOF12-DTTOF12/2.,corner+DYTOF12,ZTOF12+DTTOF12/2.);
	ftof12y[j]->SetFillStyle(0);
	ftof12y[j]->SetLineColor(LCOL);
//	ftof12y[j]->SetLineWidth(1);
    };
    ftof12x = new TBox(-DXTOF12/2.,ZTOF12-DTTOF12/2.,DXTOF12/2.,ZTOF12+DTTOF12/2.);
    ftof12x->SetFillStyle(0);
    ftof12x->SetLineColor(LCOL);
//  ftof12x->SetLineWidth(1);
    ftof12t = new TBox(-DXTOF12/2.,-NTOF12*DYTOF12/2.,+DXTOF12/2.,+NTOF12*DYTOF12/2.);
    ftof12t->SetFillStyle(0);
    ftof12t->SetLineColor(LCOL);
//  ==================================== TOF-21
    for ( Int_t j=0; j<NTOF21; j++){
	Float_t corner = -NTOF21*DYTOF21/2.+j*DYTOF21;
	ftof21y[j] = new TBox(corner,ZTOF21-DTTOF21/2.,corner+DYTOF21,ZTOF21+DTTOF21/2.);
	ftof21y[j]->SetFillStyle(0);
	ftof21y[j]->SetLineColor(LCOL);
//	ftof21y[j]->SetLineWidth(1);
    };
    ftof21x = new TBox(-DXTOF21/2.,ZTOF21-DTTOF21/2.,DXTOF21/2.,ZTOF21+DTTOF21/2.);
    ftof21x->SetFillStyle(0);
    ftof21x->SetLineColor(LCOL);
//  ftof21x->SetLineWidth(1);
    ftof21t = new TBox(-DXTOF21/2.,-NTOF21*DYTOF21/2.,+DXTOF21/2.,+NTOF21*DYTOF21/2.);
    ftof21t->SetFillStyle(0);
    ftof21t->SetLineColor(LCOL);
//  ==================================== TOF-22
    for ( Int_t j=0; j<NTOF22; j++){
	Float_t corner = -NTOF22*DXTOF22/2.+j*DXTOF22;
	ftof22x[j] = new TBox(corner,ZTOF22-DTTOF22/2.,corner+DXTOF22,ZTOF22+DTTOF22/2.);
	ftof22x[j]->SetFillStyle(0);
	ftof22x[j]->SetLineColor(LCOL);
//	ftof22x[j]->SetLineWidth(1);
    };
    ftof22y = new TBox(-DYTOF22/2.,ZTOF22-DTTOF22/2.,DYTOF22/2.,ZTOF22+DTTOF22/2.);
    ftof22y->SetFillStyle(0);
    ftof22y->SetLineColor(LCOL);
//  ftof22y->SetLineWidth(1);
    ftof22t = new TBox(-NTOF22*DXTOF22/2.,-DYTOF22/2.,+NTOF22*DXTOF22/2.,+DYTOF22/2.);
    ftof22t->SetFillStyle(0);
    ftof22t->SetLineColor(LCOL);
//  ==================================== TOF-31
    for ( Int_t j=0; j<NTOF31; j++){
	Float_t corner = -NTOF31*DXTOF31/2.+j*DXTOF31;
	ftof31x[j] = new TBox(corner,ZTOF31-DTTOF31/2.,corner+DXTOF31,ZTOF31+DTTOF31/2.);
	ftof31x[j]->SetFillStyle(0);
	ftof31x[j]->SetLineColor(LCOL);
//	ftof31x[j]->SetLineWidth(1);
    };
    ftof31y = new TBox(-DYTOF31/2.,ZTOF31-DTTOF31/2.,DYTOF31/2.,ZTOF31+DTTOF31/2.);
    ftof31y->SetFillStyle(0);
    ftof31y->SetLineColor(LCOL);
//  ftof31y->SetLineWidth(1);
    ftof31t = new TBox(-NTOF31*DXTOF31/2.,-DYTOF31/2.,+NTOF31*DXTOF31/2.,+DYTOF31/2.);
    ftof31t->SetFillStyle(0);
    ftof31t->SetLineColor(LCOL);
//  ==================================== TOF-32
    for ( Int_t j=0; j<NTOF32; j++){
	Float_t corner = -NTOF32*DYTOF32/2.+j*DYTOF32;
	ftof32y[j] = new TBox(corner,ZTOF32-DTTOF32/2.,corner+DYTOF32,ZTOF32+DTTOF32/2.);
	ftof32y[j]->SetFillStyle(0);
	ftof32y[j]->SetLineColor(LCOL);
//	ftof32y[j]->SetLineWidth(1);
    };
    ftof32x = new TBox(-DXTOF32/2.,ZTOF32-DTTOF32/2.,DXTOF32/2.,ZTOF32+DTTOF32/2.);
    ftof32x->SetFillStyle(0);
    ftof32x->SetLineColor(LCOL);
//  ftof32x->SetLineWidth(1);
    ftof32t = new TBox(-DXTOF32/2.,-NTOF32*DYTOF32/2.,+DXTOF32/2.,+NTOF32*DYTOF32/2.);
    ftof32t->SetFillStyle(0);
    ftof32t->SetLineColor(LCOL);
}
//
void GToFVolume::DrawProjectionX(){
    for(Int_t ip=0; ip<NTOF11; ip++)ftof11x[ip]->Draw();//S11
    ftof12x->Draw();                                    //S12
    ftof21x->Draw();                                    //S21
    for(Int_t ip=0; ip<NTOF22; ip++)ftof22x[ip]->Draw();//S22
    for(Int_t ip=0; ip<NTOF31; ip++)ftof31x[ip]->Draw();//S31
    ftof32x->Draw();                                    //S32
}
//
void GToFVolume::DrawProjectionY(){
    ftof11y->Draw();                                    //S11
    for(Int_t ip=0; ip<NTOF12; ip++)ftof12y[ip]->Draw();//S12
    for(Int_t ip=0; ip<NTOF21; ip++)ftof21y[ip]->Draw();//S21
    ftof22y->Draw();                                    //S22
    ftof31y->Draw();                                    //S31
    for(Int_t ip=0; ip<NTOF32; ip++)ftof32y[ip]->Draw();//S32
}
//
void GToFVolume::DrawProjectionT(){
    ftof11t->Draw();                                    //S11
    ftof12t->Draw();                                    //S12
    ftof21t->Draw();                                    //S21
    ftof22t->Draw();                                    //S22
    ftof31t->Draw();                                    //S31
    ftof32t->Draw();                                    //S32
}
//
void GToFVolume::Delete(){
    for(Int_t ip=0; ip<NTOF11; ip++)ftof11x[ip]->Delete();//S11
    ftof11y->Delete();                                    //S11
    ftof11t->Delete();                                    //S11
    for(Int_t ip=0; ip<NTOF12; ip++)ftof12y[ip]->Delete();//S12
    ftof12x->Delete();                                    //S12
    ftof12t->Delete();                                    //S12
    for(Int_t ip=0; ip<NTOF21; ip++)ftof21y[ip]->Delete();//S21
    ftof21x->Delete();                                    //S21
    ftof21t->Delete();                                    //S21
    for(Int_t ip=0; ip<NTOF22; ip++)ftof22x[ip]->Delete();//S22
    ftof22y->Delete();                                    //S22
    ftof22t->Delete();                                    //S22
    for(Int_t ip=0; ip<NTOF31; ip++)ftof31x[ip]->Delete();//S31
    ftof31y->Delete();                                    //S31
    ftof31t->Delete();                                    //S31
    for(Int_t ip=0; ip<NTOF32; ip++)ftof32y[ip]->Delete();//S32
    ftof32x->Delete();                                    //S32
    ftof32t->Delete();                                    //S32
};





//===============================================================
//
//
//===============================================================


/**
 * Constructor
 */
GToFLevel2::GToFLevel2(){

    for(Int_t ipa=0; ipa<24; ipa++) tofmip[ipa]=0;
    for(Int_t ipa=0; ipa<24; ipa++) toftdc[ipa]=0;

    HitX = new TClonesArray("GToFHit");
    HitY = new TClonesArray("GToFHit");

}

/**
 * Constructor
 */
GToFLevel2::GToFLevel2(ToFLevel2* l2){

    for(Int_t ipa=0; ipa<24; ipa++) tofmip[ipa]=0;
    for(Int_t ipa=0; ipa<24; ipa++) toftdc[ipa]=0;
    
    HitX = new TClonesArray("GToFHit");
    HitY = new TClonesArray("GToFHit");
    SetLevel2(l2);

};

/**
 * Constructor
 */
GToFLevel2::GToFLevel2(PamLevel2* l2){

    for(Int_t ipa=0; ipa<24; ipa++) tofmip[ipa]=0;
    for(Int_t ipa=0; ipa<24; ipa++) toftdc[ipa]=0;
    
    HitX = new TClonesArray("GToFHit");
    HitY = new TClonesArray("GToFHit");
    SetLevel2(l2->GetToFLevel2());

};

void GToFLevel2::SetLevel2(ToFLevel2* l2){

    TClonesArray &hx = *HitX; //Int_t nhx =0;
    TClonesArray &hy = *HitY; //Int_t nhy =0;
    
//     cout<<"ToF event: "<<l2->npmt()<<" hit PMTs \n";
    // --------------------------------------------
    // fill a matrix with energy-release per paddle
    // --------------------------------------------
    // (<0 if both PMTs have been hit) 
    for(Int_t ih=0; ih<l2->npmt(); ih++){//loop over hit PMTs (ADC||TDC)

	ToFPMT *pmt = l2->GetToFPMT(ih);

	Float_t mip  = 70;
	Bool_t twice = false;
	if( tofmip[(int)(pmt->pmt_id/2)]!=0 )twice = true;
	tofmip[(int)(pmt->pmt_id/2)] += (Float_t)pmt->adc/mip;
	if( twice )tofmip[(int)(pmt->pmt_id/2)] = -tofmip[(int)(pmt->pmt_id/2)]/2.;

	if( (Float_t)pmt->tdc < 4095 ) toftdc[(int)(pmt->pmt_id/2)]=1;
	
    }    

    // --------------------------------------------
    // loop over paddles
    // --------------------------------------------
    Int_t nhitx = 0;
    Int_t nhity = 0;
    for(Int_t ipa=0; ipa<24; ipa++){
	if(tofmip[ipa]!=0){
	    Int_t iplane  = -1;
	    Int_t ipaddle = -1;
	    Int_t ipmt    = -1;
	    Int_t id      = ipa*2;

	    GetPMTName(id,iplane,ipaddle,ipmt);
// 	    cout << GetPMTName(id,iplane,ipaddle,ipmt) << " "<< tofmip[ipa] << " "<<l2->HitPaddle(iplane,ipaddle)<<  endl;
	    
	    if( iplane==0 || iplane==3 || iplane==4 ){
		
		GToFHit hitx = GToFHit(id,(Int_t)(l2->HitPaddle(iplane,ipaddle)),tofmip[ipa],toftdc[ipa]);
		new((hx[nhitx])) GToFHit(&hitx);  // << PADDLE HIT X
		nhitx++;

	    }
	    if( iplane==1 || iplane==2 || iplane==5 ){

		GToFHit hity = GToFHit(id,(Int_t)(l2->HitPaddle(iplane,ipaddle)),tofmip[ipa],toftdc[ipa]);
		new((hy[nhity])) GToFHit(&hity);  // << PADDLE HIT X
		nhity++;

	    }	    
	}
    }

}

void GToFLevel2::Delete(){
    HitX->Delete();
    HitY->Delete();
}
void GToFLevel2::Clear(){
    HitX->Clear("C");
    HitY->Clear("C");
}

void GToFLevel2::DrawProjectionX(){
    TClonesArray &s = *(HitX);
//    cout<<"ToF: X paddles: "<<HitX->GetEntries()<<endl;
//     for(Int_t is=0; is<HitX->GetEntries(); is++){
// 	((GToFHit*)s[is])->Draw();
//     };    
     for(Int_t is=0; is<HitX->GetEntries(); is++){
// 	((TBox*)s[is])->Draw();
 	((GToFHit*)s[is])->DrawProjectionX();
     };    
}

void GToFLevel2::DrawProjectionY(){
    TClonesArray &s = *(HitY);
//    cout<<"ToF: Y paddles: "<<HitY->GetEntries()<<endl;
//     for(Int_t is=0; is<HitY->GetEntries(); is++){
// 	((GToFHit*)s[is])->Draw();
//     };    
     for(Int_t is=0; is<HitY->GetEntries(); is++){
// 	((TBox*)s[is])->Draw();
 	((GToFHit*)s[is])->DrawProjectionY();
     };    
};

TString GToFLevel2::GetPMTName(Int_t ind, Int_t &iplane, Int_t &ipaddle, Int_t &ipmt){
  
  TString pmtname = " ";
  
  TString photoS[48] = {
    "S11_1A", "S11_1B", "S11_2A", "S11_2B", "S11_3A", "S11_3B", "S11_4A", "S11_4B", 
    "S11_5A", "S11_5B", "S11_6A", "S11_6B", "S11_7A", "S11_7B", "S11_8A", "S11_8B", 
    "S12_1A", "S12_1B", "S12_2A", "S12_2B", "S12_3A", "S12_3B", "S12_4A", "S12_4B", "S12_5A",  "S12_5B", "S12_6A", "S12_6B",
    "S21_1A", "S21_1B", "S21_2A", "S21_2B", 
    "S22_1A", "S22_1B", "S22_2A", "S22_2B",
    "S31_1A", "S31_1B", "S31_2A", "S31_2B", "S31_3A", "S31_3B", 
    "S32_1A", "S32_1B", "S32_2A", "S32_2B", "S32_3A", "S32_3B"
  };
  

  pmtname = photoS[ind].Data();

  TString ss = pmtname(1,2);
  iplane  = (int)(atoi(ss.Data())/10)*2-3+atoi(ss.Data())%10;
  ss = pmtname(4);
  ipaddle = atoi(ss.Data())-1 ;
  if( pmtname.Contains("A") )ipmt=0;
  if( pmtname.Contains("B") )ipmt=1;

  return pmtname;
};
//===============================================================
//
//
//===============================================================
GToFTrack::GToFTrack(){
    for(Int_t i=0; i<6; i++){
	ttof_x[i]=NULL;
	ttof_y[i]=NULL;
	ttof_t[i]=NULL;
    }
}
GToFTrack::GToFTrack(ToFTrkVar* track){
    for(Int_t i=0; i<6; i++){
	ttof_x[i]=NULL;
	ttof_y[i]=NULL;
	ttof_t[i]=NULL;
    }
    Set(track);
}
GToFTrack::GToFTrack(PamTrack* track){
    
    for(Int_t i=0; i<6; i++){
	ttof_x[i]=NULL;
	ttof_y[i]=NULL;
	ttof_t[i]=NULL;
    }
    Set(track->GetToFTrack());
}

void GToFTrack::Set(ToFTrkVar* track){


    if(!track)return;

//    cout << "ToF track : seqno "<<track->trkseqno<<endl;
//    Dump(track);
    ToFLevel2 *l2 = new ToFLevel2();

    /// ---- copiata dalla classe... per la disperazione
//     TString pmtname = " ";   
//     TString photoS[48] = {
// 	"S11_1A", "S11_1B", "S11_2A", "S11_2B", "S11_3A", "S11_3B", "S11_4A",
// 	"S11_4B",
// 	"S11_5A", "S11_5B", "S11_6A", "S11_6B", "S11_7A", "S11_7B", "S11_8A",
// 	"S11_8B",
// 	"S12_1A", "S12_1B", "S12_2A", "S12_2B", "S12_3A", "S12_3B", "S12_4A",
// 	"S12_4B", "S12_5A",  "S12_5B", "S12_6A", "S12_6B",
// 	"S21_1A", "S21_1B", "S21_2A", "S21_2B",
// 	"S22_1A", "S22_1B", "S22_2A", "S22_2B",
// 	"S31_1A", "S31_1B", "S31_2A", "S31_2B", "S31_3A", "S31_3B",
// 	"S32_1A", "S32_1B", "S32_2A", "S32_2B", "S32_3A", "S32_3B"
//     };
    
   
   
//     cout << " %%%%%%%%%%%%%%%%%%%% npmttdc "<<track->npmttdc<<endl;

    int pmtids[48]; for (int id=0; id<48; id++)pmtids[id]=0;

//     cout << endl<< "n. tdc hits :"<<track->npmttdc;
//     cout << endl<< "PMTs        :";
//     for(Int_t ip=0; ip< track->npmttdc; ip++)cout << " "<< track->pmttdc[ip];
//     cout << endl<< "n. adc hits :"<<track->npmtadc;
//     cout << endl<< "PMTs        :";
//     for(Int_t ip=0; ip< track->npmtadc; ip++)cout << " "<< track->pmtadc[ip];
//     cout << endl;
    for(Int_t ip=0; ip< track->npmtadc; ip++)if( track->pmtadc[ip]>=0 && track->pmtadc[ip]<48 )pmtids[track->pmtadc[ip]] = 1;
    for(Int_t ip=0; ip< track->npmttdc; ip++)if( track->pmttdc[ip]>=0 && track->pmttdc[ip]<48 )pmtids[track->pmttdc[ip]] = 1;

    for (int id=0; id<48; id++) {
//    for(Int_t ip=0; ip< track->npmtadc; ip++){///XX
	
//	cout << id << " - "<<pmtids[id]<<endl;
//	continue;
//	if(track->adcflag[ip] == 1)continue;
	if(pmtids[id]==0)continue;

	Int_t iplane  = -1;
	Int_t ipaddle = -1;
	Int_t ipmt    = -1;
//	Int_t ind     = id; //track->pmtadc[ip];///XX
//	cout << l2->GetPMTName(id,iplane,ipaddle,ipmt) <<endl;     
	l2->GetPMTName(id,iplane,ipaddle,ipmt);

	Float_t cornerx =0;
	Float_t cornery =0;
	Float_t cornerz =0;
	Float_t dx =0;
	Float_t dy =0;
	Float_t dz =0;
	GetToFPaddlePosition(iplane,ipaddle,cornerx,cornery,cornerz,dx,dy,dz);
	Float_t tofres = 1.; //cm
	Int_t fillstylex = 0;
	Int_t fillstyley = 0;
	if( iplane==0 || iplane==3 || iplane==4 ){
	    cornery = track->ytofpos[(Int_t)(iplane/2)] -  tofres/2.;
	    dy      = tofres;
	    fillstyley = 1;
//	    cout << track->ytofpos[(Int_t)(iplane/2)] << " " << (Int_t)(iplane/2) << endl;
	}
	if( iplane==1 || iplane==2 || iplane==5 ){
	    cornerx = track->xtofpos[(Int_t)(iplane/2)] -  tofres/2.;
	    dx      = tofres;
	    fillstylex = 1;
//	    cout << track->xtofpos[(Int_t)(iplane/2)] << " "<<(Int_t)(iplane/2)<<endl;
	}
	Int_t col =2;	
	if( iplane==0 || iplane==1 )col=2;
	if( iplane==2 || iplane==3 )col=46;
	if( iplane==4 || iplane==5 )col=45;
//	cout << cornerx << " "<<cornery << " "<<cornerz << " "<<dx<<" "<<dy<<" "<<dz << endl; 
	if(!ttof_x[iplane]){
//	    printf(" iplane %i x %f %f %f %f \n",iplane,cornerx,cornerz,cornerx+dx,cornerz+dz);
	    ttof_x[iplane]= new TBox(cornerx,cornerz,cornerx+dx,cornerz+dz);
	    ttof_x[iplane]->SetFillStyle(fillstylex); 
	    ttof_x[iplane]->SetFillColor(col);
	    ttof_x[iplane]->SetLineColor(col);
	    ttof_x[iplane]->SetLineWidth(1); 	    
	}
	if(!ttof_y[iplane]){
//	    printf(" iplane %i y %f %f %f %f \n",iplane,cornery,cornerz,cornery+dy,cornerz+dz);
	    ttof_y[iplane]= new TBox(cornery,cornerz,cornery+dy,cornerz+dz);
	    ttof_y[iplane]->SetFillStyle(fillstyley); 
	    ttof_y[iplane]->SetFillColor(col);
	    ttof_y[iplane]->SetLineColor(col);	    
	    ttof_y[iplane]->SetLineWidth(1); 	    
	}
	if(!ttof_t[iplane]){
//	    printf(" iplane %i t %f %f %f %f \n",iplane,cornerx,cornery,cornerx+dx,cornery+dy);
	    ttof_t[iplane]= new TBox(cornerx,cornery,cornerx+dx,cornery+dy);
	    ttof_t[iplane]->SetFillStyle(0); 
	    ttof_t[iplane]->SetFillColor(col);
	    ttof_t[iplane]->SetLineColor(col);	    
	    ttof_t[iplane]->SetLineWidth(1);
	}
    }
    delete l2;


};
void GToFTrack::DrawProjectionX(){
    for(Int_t i=0; i<6; i++)if(ttof_x[i])ttof_x[i]->Draw();
};
void GToFTrack::DrawProjectionY(){
    for(Int_t i=0; i<6; i++)if(ttof_y[i])ttof_y[i]->Draw();
};
void GToFTrack::DrawProjectionT(){
    for(Int_t i=0; i<6; i++)if(ttof_t[i])ttof_t[i]->Draw();
};
void GToFTrack::Delete(){
    for(Int_t i=0; i<6; i++){
 	if( ttof_x[i] )ttof_x[i]->Delete();
 	if( ttof_y[i] )ttof_y[i]->Delete();
 	if( ttof_t[i] )ttof_t[i]->Delete();
// 	if( ttof_x[i] )cout << ttof_x[i]<<endl;
// 	if( ttof_y[i] )cout << ttof_y[i]<<endl;
// 	if( ttof_t[i] )cout << ttof_t[i]<<endl;
    }
};
void GToFTrack::Dump(ToFTrkVar *tof){

    cout << endl<< "n. tdc hits :"<<tof->npmttdc;
    cout << endl<< "PMTs        :";
    for(Int_t ip=0; ip< tof->npmttdc; ip++)cout << " "<< tof->pmttdc[ip];
    cout << endl<< "n. adc hits :"<<tof->npmtadc;
    cout << endl<< "PMTs        :";
    for(Int_t ip=0; ip< tof->npmtadc; ip++)cout << " "<< tof->pmtadc[ip];
    cout << endl<< "dedx        :";
    for(Int_t ib=0; ib< tof->npmtadc; ib++)cout << " "<< tof->dedx[ib];
    cout << endl<< "beta        :";
    for(Int_t ib=0; ib<13 ; ib++)cout << " "<< tof->beta[ib];
    cout << endl<< "xtofpos     :";
    for(Int_t ib=0; ib<3 ; ib++)cout << " "<< tof->xtofpos[ib];
    cout << endl<< "ytofpos     :";
    for(Int_t ib=0; ib<3 ; ib++)cout << " "<<tof->ytofpos[ib];
    cout << endl;
}


//===============================================================
//
//
//===============================================================
GToFHit::GToFHit(){
    adchit_x = NULL;
    tdchit_x = NULL;
    adchit_y = NULL;
    tdchit_y = NULL;
}

GToFHit::GToFHit(Int_t id_pmt, Int_t ishit, Float_t w, Float_t tdc){

    //---------------------------------------
    // retrieve paddle positions
    //---------------------------------------
    Int_t iplane  = -1;
    Int_t ipaddle = -1;
    Int_t ipmt    = -1;
    Int_t id      = id_pmt;
    GToFLevel2 temp = GToFLevel2();
    temp.GetPMTName(id,iplane,ipaddle,ipmt); 
//    cout << id << " #### "<< temp.GetPMTName(id,iplane,ipaddle,ipmt) <<endl;;
    
    Float_t cornerx =0;
    Float_t cornery =0;
    Float_t cornerz =0;
    Float_t dx =0;
    Float_t dy =0;
    Float_t dz =0;
    if(iplane==0){
	cornerx = -NTOF11*DXTOF11/2.+ipaddle*DXTOF11;
	cornery = -DYTOF11/2.;
	cornerz = ZTOF11 - DTTOF11/2.;
	dx = DXTOF11; 
	dy = DYTOF11;
	dz = DTTOF11;
    }
    if(iplane==1){
	cornery = -NTOF12*DYTOF12/2.+ipaddle*DYTOF12;
	cornerx = -DXTOF12/2.;
	cornerz = ZTOF12 - DTTOF12/2.;
	dx = DXTOF12; 
	dy = DYTOF12;
	dz = DTTOF12;
    }
    if(iplane==2){
	cornery = -NTOF21*DYTOF21/2.+(NTOF21-ipaddle-1)*DYTOF21;
	cornerx = -DXTOF21/2.;
	cornerz = ZTOF21 - DTTOF21/2.;
	dx = DXTOF21; 
	dy = DYTOF21;
	dz = DTTOF21;
    }
    if(iplane==3){
	cornerx = -NTOF22*DXTOF22/2.+ipaddle*DXTOF22;
	cornery = -DYTOF22/2.;
	cornerz = ZTOF22 - DTTOF22/2.;
	dx = DXTOF22; 
	dy = DYTOF22;
	dz = DTTOF22;
    }
    if(iplane==4){
	cornerx = -NTOF31*DXTOF31/2.+ipaddle*DXTOF31;
	cornery = -DYTOF31/2.;
	cornerz = ZTOF31 - DTTOF31/2.;
	dx = DXTOF31; 
	dy = DYTOF31;
	dz = DTTOF31;
    }
    if(iplane==5){
	cornery = -NTOF32*DYTOF32/2.+ipaddle*DYTOF32;
	cornerx = -DXTOF32/2.;
	cornerz = ZTOF32 - DTTOF32/2.;
	dx = DXTOF32; 
	dy = DYTOF32;
	dz = DTTOF32;
    }

    adchit_x = new TBox(cornerx,cornerz,cornerx+dx,cornerz+dz);
    adchit_y = new TBox(cornery,cornerz,cornery+dy,cornerz+dz);

    tdchit_x = new TBox(cornerx,cornerz,cornerx+dx,cornerz+dz);
    tdchit_y = new TBox(cornery,cornerz,cornery+dy,cornerz+dz);

    //set color according to w
    Int_t colo = 0;
    Float_t ww = fabs(w);
    if ( ww > 0.7  ) colo = 38;
    if ( ww > 2.   ) colo = 4;    
    if ( ww > 10.  ) colo = 3;
    if ( ww > 100. ) colo = 2;
    if ( ww > 500. ) colo = 6;
    
    if(w<0){      // both PMT hit
	adchit_x->SetFillStyle(1001);
	adchit_x->SetFillColor(colo);
	adchit_y->SetFillStyle(1001);
	adchit_y->SetFillColor(colo);
    }else{       // single PMT hit
	adchit_x->SetFillStyle(3356);
	adchit_x->SetFillColor(colo);
	adchit_y->SetFillStyle(3356);
	adchit_y->SetFillColor(colo);	
    }

    tdchit_x->SetFillStyle(0); 
    tdchit_x->SetLineColor(LCOL); 
    tdchit_y->SetFillStyle(0); 
    tdchit_y->SetLineColor(LCOL); 
    if(ishit){
	tdchit_x->SetLineWidth(1); 
	tdchit_x->SetLineColor(1); 
	tdchit_y->SetLineWidth(1); 
	tdchit_y->SetLineColor(1); 	
    }
    if(tdc>0){
	tdchit_x->SetLineWidth(1); 
	tdchit_x->SetLineColor(1); 
	tdchit_x->SetLineStyle(7); 
	tdchit_y->SetLineWidth(1); 
	tdchit_y->SetLineColor(1); 	
	tdchit_y->SetLineStyle(7); 
    }


}

GToFHit::GToFHit( GToFHit* gc ){
    adchit_x = new TBox(*(gc->adchit_x));
    adchit_y = new TBox(*(gc->adchit_y));
    tdchit_x = new TBox(*(gc->tdchit_x));
    tdchit_y = new TBox(*(gc->tdchit_y));
};

void GToFHit::Delete(){
    adchit_x->Delete();
    adchit_y->Delete();
    tdchit_x->Delete();
    tdchit_y->Delete(); 
};

void GToFHit::DrawProjectionX(){
    adchit_x->Draw();
    tdchit_x->Draw();
};
void GToFHit::DrawProjectionY(){
    adchit_y->Draw();
    tdchit_y->Draw();
};


ClassImp(GToFVolume);
ClassImp(GToFLevel2);
ClassImp(GToFTrack);
ClassImp(GToFHit);
