/**
 * \file CaloViewer.h
 * \author Elena Vannuccini
 */
#ifndef caloviewer_h
#define caloviewer_h

#if !defined(__CINT__) || defined(__MAKECINT__)

/* #include <CaloLevel2.h> */
/* #include <CaloLevel1.h> */

#include <PamLevel2.h>

#include <TObject.h>
#include <TObjArray.h>
#include <TBox.h>
#include <TColor.h>
#include <TPolyMarker.h>

#include <iostream>
using namespace std;
#endif

class GCaloVolume : public TObject{
    
 private:
    
    TBox *cavity_l;
    TBox *cavity_r;

    TBox *tplane_l[22];
    TBox *tplane_r[22];
//    TBox *cavity_c;
    
 public:
    
    GCaloVolume();
    void DrawProjectionX();
    void DrawProjectionY();
//    void DrawProjectionT();
    void Delete();
    
    ClassDef(GCaloVolume,1);
    
};

//
class GCaloLevel2 : public TObject{
    
 private:
    
    TClonesArray *HitX;     ///< x hit
    TClonesArray *HitY;     ///< y hit
    
    TPolyMarker *cbarX;
    TPolyMarker *cbarY;

    Bool_t DRAWCBAR;

/*     TMarker *mx[22]; */
/*     TMarker *my[22]; */

 public:
    
    GCaloLevel2();
//    GCaloLevel2(CaloLevel1*);  //implementare
    GCaloLevel2(CaloLevel1*);
//    GCaloLevel2(CaloLevel2*);
    GCaloLevel2(PamLevel2*);

    void SetLevel1(CaloLevel1*);
    void SetLevel2(CaloLevel2*);

    void SetDrawAxis(Bool_t doit){ DRAWCBAR=doit; };

    void DrawProjectionX();
    void DrawProjectionY();
//    void DrawProjectionT();
    
    void Delete();
    void Clear();
    
    ClassDef(GCaloLevel2,1);
    
};
//
class GCaloHit : public TObject{
    
 private:
    
    TBox *hit; 
    
 public:
    GCaloHit();
    GCaloHit(Float_t,Float_t,Float_t);
    GCaloHit(GCaloHit*);
//    void SetColor(Int_t col){m1->SetMarkerColor(col);};
    void Delete(){ hit->Delete(); };
    void Draw()  { hit->Draw();   };

    ~GCaloHit() {Delete();};
    
    ClassDef(GCaloHit,1);
};

#endif
