/**
 * \file ToFViewer.h
 * \author Elena Vannuccini
 */
#ifndef tofviewer_h
#define tofviewer_h

#if !defined(__CINT__) || defined(__MAKECINT__)

#include <PamLevel2.h>

#include <TObject.h>
#include <TObjArray.h>
#include <TBox.h>

#include <iostream>
using namespace std;
#endif

#define ZTOF11 53.74
#define ZTOF12 53.04
#define ZTOF21 23.94
#define ZTOF22 23.44
#define ZTOF31 -23.49
#define ZTOF32 -24.34
//---------------------
#define NTOF11  8  //x
#define DXTOF11 5.1
#define DYTOF11 33.0
#define DTTOF11 0.7
//---------------------
#define NTOF12  6 //y
#define DXTOF12 40.8
#define DYTOF12 5.5
#define DTTOF12 0.7
//---------------------
#define NTOF21  2 //y
#define DXTOF21 18.
#define DYTOF21 7.5
#define DTTOF21 0.5
//---------------------
#define NTOF22  2 //x
#define DXTOF22 9.
#define DYTOF22 15.
#define DTTOF22 0.5
//---------------------
#define NTOF31  3  //x
#define DXTOF31 6.
#define DYTOF31 15.0
#define DTTOF31 0.7
//---------------------
#define NTOF32  3 //y
#define DXTOF32 18.0
#define DYTOF32 5.0
#define DTTOF32 0.7
//---------------------


/*
 * Class to draw the ToF volume (2-D projections)
 */
class GToFVolume : public TObject{
    
 private:
    
//  --- S11 ---
    TBox *ftof11x[NTOF11];
    TBox *ftof11y;
    TBox *ftof11t;
//  --- S12 ---
    TBox *ftof12x;
    TBox *ftof12y[NTOF12];
    TBox *ftof12t;
//  --- S21 ---
    TBox *ftof21x;
    TBox *ftof21y[NTOF21];
    TBox *ftof21t;
//  --- S22 ---
    TBox *ftof22x[NTOF22];
    TBox *ftof22y;
    TBox *ftof22t;
//  --- S31 ---
    TBox *ftof31x[NTOF31];
    TBox *ftof31y;
    TBox *ftof31t;
//  --- S32 ---
    TBox *ftof32x;
    TBox *ftof32y[NTOF32];
    TBox *ftof32t;
    
 public:
    
    GToFVolume();
    void DrawProjectionX();
    void DrawProjectionY();
    void DrawProjectionT();
    void Delete();
    
    ClassDef(GToFVolume,1);
    
};


//
class GToFLevel2 : public TObject{
    
 private:
    
/*     Float_t S11mip[NTOF11]; */
/*     Float_t S12mip[NTOF12]; */
/*     Float_t S21mip[NTOF21]; */
/*     Float_t S22mip[NTOF22]; */
/*     Float_t S31mip[NTOF31]; */
/*     Float_t S32mip[NTOF32]; */

    Float_t tofmip[24]; ///< map of paddle energy-releases
    Float_t toftdc[24]; ///< map of paddle time signals

    TClonesArray *HitX;     ///< x hit
    TClonesArray *HitY;     ///< y hit
    
 public:
    
    GToFLevel2();
    GToFLevel2(ToFLevel2*);
    GToFLevel2(PamLevel2*);

    void SetLevel2(ToFLevel2*);

//    TString GetPMTName(Int_t ind, Int_t &iplane, Int_t &ipaddle, Int_t &ipmt);
    TString GetPMTName(Int_t, Int_t&, Int_t&, Int_t&);

    void DrawProjectionX();
    void DrawProjectionY();
//    void DrawProjectionT();
    
    void Delete();
    void Clear();
    
    ClassDef(GToFLevel2,1);
    
};
//
/**
 * Class to draw a ToF-paddle hit.
 * Two independent informations are displayed: adc and tdc.
 * ADC:  fill color, full (both PMTs) or dashed (single PMT)
 * TDC:  line color, black (both PMTs) or default (none) 
 */
class GToFHit : public TObject{
    
 private:
    
    TBox *adchit_x;
    TBox *tdchit_x;
    
    TBox *adchit_y;
    TBox *tdchit_y;

 public:
    GToFHit();
//    GToFHit(Float_t,Float_t,Float_t);
    GToFHit(Int_t id,Int_t hit,Float_t adc,Float_t tdc);
    GToFHit(Int_t id,Int_t hit,Float_t adc){GToFHit(id,hit,adc,0.);};
    GToFHit(GToFHit*);
//    void SetColor(Int_t col){m1->SetMarkerColor(col);};
    void Delete();
//    void Draw(); 
    void DrawProjectionX();
    void DrawProjectionY();

    ~GToFHit() {Delete();};
    
    ClassDef(GToFHit,1);
};

class GToFTrack : public TObject{

 private:
    TBox *ttof_x[6];   
    TBox *ttof_y[6];   
    TBox *ttof_t[6];   

 public:
    GToFTrack();
    ~GToFTrack(){Delete();};
    GToFTrack(ToFTrkVar*);
    GToFTrack(PamTrack*);

    void Set(ToFTrkVar*);
    void Dump(ToFTrkVar*);
    void DrawProjectionX();
    void DrawProjectionY();
    void DrawProjectionT();
    
    void Delete();
    void Clear(){Delete();};
    
    ClassDef(GToFTrack,1);
        
};

#endif

