/**
 * \file TrkViewer.h
 * \author Elena Vannuccini
 */
#ifndef trkviewer_h
#define trkviewer_h

#if !defined(__CINT__) || defined(__MAKECINT__)

#include <TrkHough.h>
#include <PamLevel2.h>

/* #include <TrkLevel2.h> */
/* #include <TrkLevel1.h> */

#include <TObject.h>
#include <TObjArray.h>
#include <TBox.h>
#include <TLine.h>
#include <TPolyLine.h>
#include <TPolyMarker.h>
#include <TMarker.h>
#include <TEllipse.h>
#include <TColor.h>
#include <TMultiGraph.h>
#include <TGraph.h>

#include <TROOT.h>
#include <TVirtualX.h>
#include <Buttons.h>
#include <TVirtualPad.h>

#include <TPad.h>
#include <TCanvas.h>
#include <TH1F.h>

#include <iostream>
using namespace std;
#endif


/*
 * Class to draw the tracker volume (2-D projections)
 */
class GTrkVolume : public TObject{
    
 private:
    
    TBox*  cavity_l;
    TLine* plane_l[6];

    TBox*  cavity_r;
    TLine* plane_r[6];

    TBox*  cavity_c;
    
    TLine* column_l[2];
    TLine* column_r[1];
    TLine* column_c[3];

 public:
    
    GTrkVolume();
    void DrawProjectionX();
    void DrawProjectionY();
    void DrawProjectionT();
    void Delete();
    
    ClassDef(GTrkVolume,1);
    
};
//
/*
 * Class to draw the tracker signals
 */
class GTrkLevel2 : public TObject{
    
 private:
    
    TClonesArray *Track;        ///< fitted tracks
    TClonesArray *SingletX;     ///< x singlets
    TClonesArray *SingletY;     ///< y singlets
    TClonesArray *Image;        ///< fitted tracks (images)
    
    Bool_t DRAWIMAGE;

 public:
    
    GTrkLevel2();
    GTrkLevel2(TrkLevel2*);
    GTrkLevel2(PamLevel2*);
//		Int_t Set(TrkLevel2*);
    
    void SetTracks(TrkLevel2*);
    void SetTracks(PamLevel2*);
    void SetSinglets(TrkLevel2*);


    void SetDrawImage(Bool_t doit){ DRAWIMAGE=doit; };

    void DrawProjectionX();
    void DrawProjectionY();
    void DrawProjectionT();
    
    void Delete();
    void Clear();
    
    ClassDef(GTrkLevel2,1);
    
};
//
/*
 * Class to draw the tracker clusters
 */
class GTrkCluster : public TObject{
    
 private:
    TH1F *sgnl;
    TH1F *cut;
    TH1F *seed;
    TH1F *sat;
    
    TLine *maxs;
    TLine *zero;
    
 public:
    GTrkCluster();
    ~GTrkCluster();
    GTrkCluster(GTrkCluster*);
    GTrkCluster(TrkCluster*);
    void Draw();
    void Delete();
    
    ClassDef(GTrkCluster,1);
};
class GTrkHit : public TObject{
    
 private:
    
    GTrkCluster *cl; 
    TMarker     *m1;
    TEllipse    *m2;
    
 public:
    GTrkHit();
    GTrkHit(Float_t,Float_t,Float_t);
    GTrkHit(GTrkHit*);
    void SetColor(Int_t col){m1->SetMarkerColor(col);};
    void SetSize(Float_t size){m1->SetMarkerSize(size);};
    void Delete();
    void Draw();
    void SetCluster(TrkCluster* pt){cl = new GTrkCluster(pt);};
    void ExecuteEvent(Int_t,Int_t,Int_t,TObject*);

    ~GTrkHit() {Delete();};
    
    ClassDef(GTrkHit,1);
};

//
/*
 * Class to draw the tracker fitted tracks
 */
class GTrkTrack : public TObject{
    
 private:
    TPolyLine  *tr_l;
    TPolyLine  *tr_r;
    TPolyLine  *tr_c;

    TMarker    *mt_l[6];
    TMarker    *mt_r[6];
    TMarker    *mt_c[6];
       
 public:
    GTrkTrack();
    ~GTrkTrack();
    GTrkTrack(TrkTrack*);
    GTrkTrack(GTrkTrack*);

    TPolyLine *GetProjectionX(){ return tr_l; };
    TPolyLine *GetProjectionY(){ return tr_r; };
    TPolyLine *GetProjectionT(){ return tr_c; };
    TMarker   *GetProjectionX_Points(int ip){ return mt_l[ip]; };
    TMarker   *GetProjectionY_Points(int ip){ return mt_r[ip]; };
    TMarker   *GetProjectionT_Points(int ip){ return mt_c[ip]; };

    void DrawProjectionX();
    void DrawProjectionY();
    void DrawProjectionT();
    
    void Delete();
    void Clear();
    
    ClassDef(GTrkTrack,1);
};

 
/*
 * Class to draw hough transform
 */
class GTrkHough : public TObject{

 private:

    TMultiGraph *trip;
    TMultiGraph *doub;

    TGraph *gtrip[100];
    TGraph *gdoub[100];

    TClonesArray *TrackCandidates;        ///< track candidates
        
 public:

    GTrkHough();
     
    GTrkHough(TrkHough*);

    void Delete();
    void Clear();

    ~GTrkHough();

    void SetCandidates(TrkHough*);
    void SetHough(TrkHough*);

    TMultiGraph *GetProjectionX_Hough(){return trip;};
    TMultiGraph *GetProjectionY_Hough(){return doub;};

    void DrawProjectionX();
    void DrawProjectionY();
    void DrawProjectionT();

    ClassDef(GTrkHough,1);

};


#endif


