/**
 * \file AcViewer.h
 * \author Elena Vannuccini
 */
#ifndef acviewer_h
#define acviewer_h

#if !defined(__CINT__) || defined(__MAKECINT__)

#include <PamLevel2.h>

#include <TObject.h>
#include <TObjArray.h>
#include <TBox.h>

#include <iostream>
using namespace std;
#endif

/* #define ZTOF11 53.74 */
/* #define ZTOF12 53.04 */
/* #define ZTOF21 23.94 */
/* #define ZTOF22 23.44 */
/* #define ZTOF31 -23.49 */
/* #define ZTOF32 -24.34 */
/* //--------------------- */
/* #define NTOF11  8  //x */
/* #define DXTOF11 5.1 */
/* #define DYTOF11 33.0 */
/* #define DTTOF11 0.7 */
/* //--------------------- */
/* #define NTOF12  6 //y */
/* #define DXTOF12 40.8 */
/* #define DYTOF12 5.5 */
/* #define DTTOF12 0.7 */
/* //--------------------- */
/* #define NTOF21  2 //y */
/* #define DXTOF21 18. */
/* #define DYTOF21 7.5 */
/* #define DTTOF21 0.5 */
/* //--------------------- */
/* #define NTOF22  2 //x */
/* #define DXTOF22 9. */
/* #define DYTOF22 15. */
/* #define DTTOF22 0.5 */
/* //--------------------- */
/* #define NTOF31  3  //x */
/* #define DXTOF31 6. */
/* #define DYTOF31 15.0 */
/* #define DTTOF31 0.7 */
/* //--------------------- */
/* #define NTOF32  3 //y */
/* #define DXTOF32 18.0 */
/* #define DYTOF32 5.0 */
/* #define DTTOF32 0.7 */
/* //--------------------- */

class GAcVolume : public TObject{
    
 private:
    
/* //  --- S11 --- */
/*     TBox *ftof11x[NTOF11]; */
/*     TBox *ftof11y; */
/* //  --- S12 --- */
/*     TBox *ftof12x; */
/*     TBox *ftof12y[NTOF12]; */
/* //  --- S21 --- */
/*     TBox *ftof21x; */
/*     TBox *ftof21y[NTOF21]; */
/* //  --- S22 --- */
/*     TBox *ftof22x[NTOF22]; */
/*     TBox *ftof22y; */
/* //  --- S31 --- */
/*     TBox *ftof31x[NTOF31]; */
/*     TBox *ftof31y; */
/* //  --- S32 --- */
/*     TBox *ftof32x; */
/*     TBox *ftof32y[NTOF32]; */
    
 public:
    
    GAcVolume();
    void DrawProjectionX();
    void DrawProjectionY();
//    void DrawProjectionT();
    void Delete();
    
    ClassDef(GAcVolume,1);
    
};


//
class GAcLevel2 : public TObject{
    
 private:
    
    TClonesArray *HitX;     ///< x hit
    TClonesArray *HitY;     ///< y hit
    
 public:
    
    GAcLevel2();
    GAcLevel2(AcLevel2*);
    GAcLevel2(PamLevel2*);

    void SetLevel2(AcLevel2*);

    void DrawProjectionX();
    void DrawProjectionY();
//    void DrawProjectionT();
    
    void Delete();
    void Clear();
    
    ClassDef(GAcLevel2,1);
    
};
//


class GAcHit : public TObject{
    
 private:
    
    TBox *hit_x;
    TBox *hit_y;

 public:
    GAcHit();
    GAcHit(Int_t,Int_t);
    GAcHit(GToFHit*);
    void Delete();
    void DrawProjectionX();
    void DrawProjectionY();

    ~GAcHit() {Delete();};
    
    ClassDef(GAcHit,1);
};


#endif
