/**
 * \file AcViewer.cpp
 * \author Elena Vannuccini
 */
#include <AcViewer.h>


#define COLO 5
#define LCOL 13 // color of tof-volume lines



/**
 * Ac volume (projections) constructor
 */
GAcVolume::GAcVolume(){

}
//
void GAcVolume::DrawProjectionX(){
}
//
void GAcVolume::DrawProjectionY(){
}
//
void GAcVolume::Delete(){
};





//===============================================================
//
//
//===============================================================


/**
 * Constructor
 */
GAcLevel2::GAcLevel2(){

    HitX = new TClonesArray("GAcHit");
    HitY = new TClonesArray("GAcHit");

}

/**
 * Constructor
 */
GAcLevel2::GAcLevel2(AcLevel2* l2){
    
    HitX = new TClonesArray("GAcHit");
    HitY = new TClonesArray("GAcHit");
    SetLevel2(l2);

};

/**
 * Constructor
 */
GAcLevel2::GAcLevel2(PamLevel2* l2){
    
    HitX = new TClonesArray("GAcHit");
    HitY = new TClonesArray("GAcHit");
    SetLevel2(l2->GetAcLevel2());

};

void GAcLevel2::SetLevel2(AcLevel2* l2){

    TClonesArray &hx = *HitX; //Int_t nhx =0;
    TClonesArray &hy = *HitY; //Int_t nhy =0;
    
    // --------------------------------------------
    // loop over anticounters
    // --------------------------------------------
    Int_t nhitx = 0;
    Int_t nhity = 0;
    for(Int_t ipa=0; ipa<16; ipa++){
	for(Int_t ibo=0; ibo<2; ibo++){
	    GAcHit hitx = GAcHit(ipa,(Int_t)(l2->HitPaddle(iplane,ipaddle)));
	    new((hx[nhitx])) GAcHit(&hitx);  // << PADDLE HIT X
	    nhitx++;
	    
	    GAcHit hity = GAcHit(ipa,(Int_t)(l2->HitPaddle(iplane,ipaddle)));
	    new((hy[nhity])) GAcHit(&hity);  // << PADDLE HIT X
	    nhity++;
	}
    }

}

void GAcLevel2::Delete(){
    HitX->Delete();
    HitY->Delete();
}
void GAcLevel2::Clear(){
    HitX->Clear("C");
    HitY->Clear("C");
}

void GAcLevel2::DrawProjectionX(){
    TClonesArray &s = *(HitX);
    cout<<"Ac: X paddles: "<<HitX->GetEntries()<<endl;
//     for(Int_t is=0; is<HitX->GetEntries(); is++){
// 	((GAcHit*)s[is])->Draw();
//     };    
     for(Int_t is=0; is<HitX->GetEntries(); is++){
// 	((TBox*)s[is])->Draw();
 	((GAcHit*)s[is])->DrawProjectionX();
     };    
}

void GAcLevel2::DrawProjectionY(){
    TClonesArray &s = *(HitY);
    cout<<"Ac: Y paddles: "<<HitY->GetEntries()<<endl;
//     for(Int_t is=0; is<HitY->GetEntries(); is++){
// 	((GAcHit*)s[is])->Draw();
//     };    
     for(Int_t is=0; is<HitY->GetEntries(); is++){
// 	((TBox*)s[is])->Draw();
 	((GAcHit*)s[is])->DrawProjectionY();
     };    
};



//===============================================================
//
//
//===============================================================
GAcHit::GAcHit(){
    hit_x = new TBox();
    hit_y = new TBox();
}

GAcHit::GAcHit(Int_t iboard, Int_t ipaddle){

    //---------------------------------------
    // retrieve paddle positions
    //---------------------------------------

}

GAcHit::GAcHit( GAcHit* gc ){
    hit_x = new TBox(*(gc->hit_x));
    hit_y = new TBox(*(gc->hit_y));
};

void GAcHit::Delete(){
    hit_x->Delete();
    hit_y->Delete();
};

void GAcHit::DrawProjectionX(){
    hit_x->Draw();
};
void GAcHit::DrawProjectionY(){
    hit_y->Draw();
};


ClassImp(GAcVolume);
ClassImp(GAcLevel2);
