*************************************************************************
*     
*     Subroutine cnoise.f!DA COMMENTARE!???
*     
*     uses adc(nviews,nva1_view,nstrips_va1) and 
*     pedestal(nviews,nva1_view,nstrips_va1) variables to compute common noise,
*     and fills cn(nviews,nva1_view) variable. in the computation only 
*     not-bad and not-signal-affected strips are used
*     (bad(nviews,nva1_view,nstrips_va1) and 
*     clstr(nviews,nva1_view,nstrips_va1) flags)
*     
*     needs:
*     - ./common_calib.f
*     
*     to be called inside ./cncomp.f
*     
*************************************************************************

      subroutine cnoise(i,j,gulp) !(view, VA1)

      include '../common/commontracker.f'
      include '../common/common_reduction.f'
      include '../common/calib.f'
      

      integer gulp              !error flag

      ncn=0                     !number of strips in cn computation
      cn(i,j)=0                 !initializes cn variable


      do k=1,nstrips_va1        !loops on strips
         iok=strange(i,j,k)*bad(i,j,k)*clstr(i,j,k) !flag to mark strange, bad
                                ! or signal affected strips
c     print*,i,j,k,strange(i,j,k),bad(i,j,k),clstr(i,j,k),iok !???

         cn(i,j)=cn(i,j) + (DBLE(adc(i,j,k)) - pedestal(i,j,k))*iok !sums ADC-PED
                                ! values to compute common noise
         ncn=ncn+iok            !counts number of strips in cn computation
      enddo

      if(ncn.eq.0) then         !no signal free strips on this VA1...
         print*,'cnoise: WARNING, NO SIGNAL FREE STRIPS ON VA1 ',j,
     $        ', VIEW ',i
         gulp=1
      else
         cn(i,j)=cn(i,j)/DBLE(ncn) !computes common noise
         gulp=0                 !resets error flag
      endif

      return
      end
