*************************************************************************
*     
*     Common level2.f
*     
*     contains LEVEL2 ntuple variables definitions
*     
*     
*************************************************************************

      PARAMETER (NTRKMAX=50)    !ncloyz_max*ncloxz_max)

c     EVENT block:
*     -----------------------------------------------------------
      logical good2             !flag to mark good or noise events
      integer nev2              !level2 event number
      common/level2/good2,nev2

c     CPU block (only for ground data):
*     -----------------------------------------------------------
      integer pkt_type          !CPU packet type identifier. see http://people.roma2.infn.it/~cpu/HB_list.txt
c     0x12 --> calibration board 0                  
c     0x13 --> calibration board 1              
c     0x10 --> event                            
c     0x30 --> full event for calib special     
c     0x83 --> tracker ALARM (control register) 
      integer pkt_num           !CPU packet number
      integer obt               !CPU on-board time
      integer which_calib       !calibration file identifier. see DW_DATE_NUM_calib.txt file
      common/level2_cpu/pkt_type,pkt_num,obt,which_calib


*     -----------------------------------------------------------
*     Common to store TRACK info
*     All the variables have a dimention equal to the number of
*     found tracks
*     -----------------------------------------------------------
c     TRACK PARAMETERS      
      integer ntrk              !# identified tracks
      integer image             !flag to tag track-images
      real al  	              	!track state vector
      integer xgood          	!mask of used planes
      integer ygood    		!*
      real xm           	!me	asured points
      real ym                	!*
      real zm                	!*
      real resx              	!spatial resolution
      real resy              	!*
      real chi2              	!chi2
      real xv                	!calculated points
      real yv                	!*
      real zv                	!*
      real axv               	!calculated angles (deg)
      real ayv               	!*
      real dedxp
      common/level2_tracks/
     $      ntrk
     $     ,image(NTRKMAX)
     $     ,xm(6,NTRKMAX)
     $     ,ym(6,NTRKMAX)
     $     ,zm(6,NTRKMAX)
     $     ,resx(6,NTRKMAX)
     $     ,resy(6,NTRKMAX)
     $     ,al(5,NTRKMAX)
     $     ,chi2(NTRKMAX)
     $     ,xgood(6,NTRKMAX)
     $     ,ygood(6,NTRKMAX)
     $     ,xv(6,NTRKMAX)
     $     ,yv(6,NTRKMAX)
     $     ,zv(6,NTRKMAX)
     $     ,axv(6,NTRKMAX)
     $     ,ayv(6,NTRKMAX)
     $     ,dedxp(6,NTRKMAX)
*     -----------------------------------------------------------
*     Common to store SINGLET info
*     (clusters not associated with any track) 
*     -----------------------------------------------------------
      integer nclsx             !# unassociated clusters per plane X views
      integer nclsy             !     "            "      "   "    Y views
      common/level2_singlets/
     $     nclsx(6),nclsy(6)

