

/**
 * \file ToFPatch.h
 * \authors Wolfgang Menn
 */
#ifndef tofpatch_h
#define tofpatch_h

#include <PamLevel2.h>

#include <TTree.h>
#include <TFriendElement.h>
#include <TChain.h>
#include <TFile.h>
#include <TList.h>
#include <TKey.h>
#include <TSystemFile.h>
#include <TSystemDirectory.h>
#include <TSQLServer.h>

#include <iostream>

using namespace std;


/**
 *
 * Class to store and calculate variables
 */
class ToFPatch : public TObject {         //class definition

 private:
    //
    PamLevel2  *L2;
    Int_t      eNtr;   // number of tracker tracks
    const char*  trkAlg; 
   //

    UInt_t OBT;
    UInt_t PKT;
    UInt_t atime;

    Int_t tr;
    
    Float_t  adc_he;

// Trk dependent values
    TArrayF eDEDXpmt;  // 0-47  pmt dEdx
    TArrayF eDEDXpmtraw; // 0-47 pmt dEdx before 2nd corr
    TArrayF eDEDXpad;  // 0-23  paddle dEdx
    TArrayF eDEDXlayer;  // 0-5 layer dEdx

    TArrayF INFOpmt;  // 0-47 pmt status
    TArrayF INFOlayer;  //0-5 layer status
     
// ToF standalone values
    TArrayF eDEDXpmtstd;  // 0-47  pmt dEdx  
    TArrayF eDEDXpmtrawstd; // 0-47 pmt dEdx before 2nd corr To
    TArrayF eDEDXpadstd;  // 0-23  paddle dEdx
    TArrayF eDEDXlayerstd;  // 0-5 layer dEdx

    TArrayF INFOpmtstd;  // 0-47 pmt status
    TArrayF INFOlayerstd;  //0-5 layer status

    // parameters:
    TArrayF PMTsat;  // 0-47  saturation parameters


    TArrayF A0_array[100];  //  48 x 100  define an array of 48 elements per each time interval
    TArrayF A1_array[100];   
    TArrayF A2_array[100];
    TArrayF A3_array[100];

    Float_t A0[48];  
    Float_t A1[48];   
    Float_t A2[48];
    Float_t A3[48];

    UInt_t T_int_min[100];  
    UInt_t T_int_max[100];
    UInt_t tmin_atten,tmax_atten;
    Int_t ical_atten;

    TArrayF dedx_corr_m[1500];  // 48 x 1500  define an array of 48 elements per each time interval

    UInt_t mtime[2000];
    Int_t ical_2nd;
    UInt_t tmin_2nd,tmax_2nd;
    

 public:
    ToFPatch() {Clear();}   // class constructor
    ~ToFPatch(){ Delete(); };  // class distructor
    //
    void Clear(Option_t *option="");
    void Delete(Option_t *option="") { Clear(); }

    void InitPar(const char *pardir, const char  *param);  // init parameters
    void Define_PMTsat();

    void ReadParAtt(const char *pardir, const char *param);
  



//    void Process( PamLevel2 *l2p, Int_t itr=0 ); ///< Process data for track number itr
    void Process( PamLevel2 *l2p, const char* alg ); ///< Process data 10th red 
    void Print(Option_t *option="");
// track dependent results
    Float_t GetdEdxraw_pmt(Int_t ipmt) { return eDEDXpmtraw[ipmt]; } // 0-47 dEdx for each PMT for tracked events before 2nd order corr
    Float_t GetdEdx_pmt(Int_t ipmt) { return eDEDXpmt[ipmt]; }  // 0-47 dEdx for each PMT for tracked events
    Float_t GetdEdx_pad(Int_t ipad) {return eDEDXpad[ipad];}  // 0-23 dEdx for each paddle for tracked events (no request of consistency between PMT's response when both on!)
    Float_t GetdEdx_layer(Int_t ilay) {return eDEDXlayer[ilay];}  // 0-5 dEdx for each layer for tracked events
// ToF standalone results
    Float_t GetdEdxraw_pmtstd(Int_t ipmt) { return eDEDXpmtrawstd[ipmt]; } // 0-47 dEdx for each PMT for tracked events before 2nd order corr
    Float_t GetdEdx_pmtstd(Int_t ipmt) { return eDEDXpmtstd[ipmt]; }  // 0-47 dEdx for each PMT for tracked events
    Float_t GetdEdx_padstd(Int_t ipad) {return eDEDXpadstd[ipad];}  // 0-23 dEdx for each paddle for tracked events (no request of consistency between PMT's response when both on!)
    Float_t GetdEdx_layerstd(Int_t ilay) {return eDEDXlayerstd[ilay];}  // 0-5 dEdx for each layer for tracked events
    
    Float_t GetInfo_pmt(Int_t ipmt) {return INFOpmt[ipmt];} // 0-47 pmt status  

    /* INFOpmt table:
       
       INFOpmt[ii]=0  --->  everything is ok!
       INFOpmt[ii]=1  --->  beta not good (<0.05 || >2)
       INFOpmt[ii]=2  --->  PMT OFF
       INFOpmt[ii]=3  --->  PMT saturated
       INFOpmt[ii]=4  --->  error during the correction for the incidence angle
       INFOpmt[ii]=5  --->  error during the correction for the dependence on the position
       INFOpmt[ii]=6  --->  error in dEdx reconstruction
       INFOpmt[ii]=7  --->  error in Z reconstruction 
    */

    Float_t GetInfo_layer(Int_t ilay) {return INFOlayer[ilay];}  // 0-5 layer status

    /* INFOlayer table:
       
       INFOlayer[ii]=0  --->  everithing is ok!
       INFOlayer[ii]=1  --->  beta not good (<0.05 || >2)
       INFOlayer[ii]=2  --->  only one PMT is OFF (but you get the other one to have the measurement)
       INFOlayer[ii]=3  --->  only one PMT is saturated (but you get the other one to have the measurement)
       INFOlayer[ii]=4  --->  only one PMT with a wrong reconstruction  (but you get the other one to have the measurement)
       INFOlayer[ii]=5  --->  the 2 PMTs involved give different measurement (actually they differ for more then 1.5, to be tuned...)
       INFOlayer[ii]=6  --->  saturated layer (both PMTs)
       INFOlayer[ii]=7  --->  all PMTs show some error during reconstruction
       INFOlayer[ii]=8  --->  1 PMT is OFF and 1 is saturated (it happens quiet only on S115...)
       INFOlayer[ii]=9  --->  OFF layer
    */

 private:
    double f_adcPC( float x );
    double atten(float C0, float C1, float C2, float C3, float x ) ;
 
    
    ClassDef(ToFPatch,1);
};

#endif

