/**
 * \file ToFNuclei.h
 * \author Emiliano Mocchiutti / Wolfgang Menn
 */

//*****************************************************
// WM 24-feb-2009: introduced "Set_Beta":
// The user can set beta used in the code with "Set_Beta", 
// this beta is taken for the calculations.
// WM 06-aug-2009: charge_layer_trk_raw  and charge_layer_std_raw
// added: These are the "raw" values before doing the 2nd-order
// correction
//*****************************************************


#ifndef tofnuclei_h
#define tofnuclei_h

#include <PamLevel2.h>

#include <TTree.h>
#include <TFriendElement.h>
#include <TChain.h>
#include <TFile.h>
#include <TGraph.h>
#include <TSpline.h>
#include <TList.h>
#include <TKey.h>
#include <TSystemFile.h>
#include <TSystemDirectory.h>
#include <TSQLServer.h>

#include <iostream>

using namespace std;

/**
 *
 */
class ToFNuclei : public TObject {

 private:
    //
    PamLevel2 *L2;
    Bool_t debug;
    const char*  trkAlg;
    //
    // needed to avoid reprocessing the same event over and over to obtain the variables
    //
    UInt_t OBT;
    UInt_t PKT;
    UInt_t atime;
    Int_t tr;
    Int_t sntr;

    Float_t  beta_in;
    //
    Int_t   ncount_trk;
    Float_t charge_trk;
    Float_t charge_layer_trk[6];
    Float_t charge_layer_trk_raw[6];
    Float_t charge_PMT_trk[48];
    Int_t layerinfo_trk[6];

    Int_t   ncount_std;
    Float_t charge_std;
    Float_t charge_layer_std[6];
    Float_t charge_layer_std_raw[6];
    Float_t charge_PMT_std[48];
    Int_t layerinfo_std[6];
    //

 public:
    //

    void Set_Beta(Float_t beta){ beta_in=beta;};
    //
    Int_t Get_Ncount_ToF_trk(){ Process(); return ncount_trk;}; 
    Float_t Get_Charge_ToF_trk(){ Process(); return charge_trk;}; 
    Float_t *Get_Charge_ToF_trk_layer(){ Process(); return charge_layer_trk;}; 
    Float_t Get_Charge_ToF_trk_layer(Int_t layer){ Process(); return charge_layer_trk[layer];};
    Float_t *Get_Charge_ToF_trk_layer_raw(){ Process(); return charge_layer_trk_raw;}; 
    Float_t Get_Charge_ToF_trk_layer_raw(Int_t layer){ Process(); return charge_layer_trk_raw[layer];};
    Float_t *Get_Charge_ToF_trk_PMT(){ Process(); return charge_PMT_trk;}; 
    Float_t Get_Charge_ToF_trk_PMT(Int_t ipmt){ Process(); return charge_PMT_trk[ipmt];};
    Int_t *Get_Layerinfo_trk(){ Process(); return layerinfo_trk;}; 
    Int_t Get_Layerinfo_trk(Int_t layer){ Process(); return layerinfo_trk[layer];}; 
    // 
    Int_t Get_Ncount_ToF_std(){ Process(); return ncount_std;}; 
    Float_t Get_Charge_ToF_std(){ Process(); return charge_std;}; 
    Float_t *Get_Charge_ToF_std_layer(){ Process(); return charge_layer_std;}; 
    Float_t Get_Charge_ToF_std_layer(Int_t layer){ Process(); return charge_layer_std[layer];};
    Float_t *Get_Charge_ToF_std_layer_raw(){ Process(); return charge_layer_std_raw;}; 
    Float_t Get_Charge_ToF_std_layer_raw(Int_t layer){ Process(); return charge_layer_std_raw[layer];};
    Float_t *Get_Charge_ToF_std_PMT(){ Process(); return charge_PMT_std;}; 
    Float_t Get_Charge_ToF_std_PMT(Int_t ipmt){ Process(); return charge_PMT_std[ipmt];};
    Int_t *Get_Layerinfo_std(){ Process(); return layerinfo_std;}; 
    Int_t Get_Layerinfo_std(Int_t layer){ Process(); return layerinfo_std[layer];}; 

    //
    //ToFNuclei();
    ToFNuclei(PamLevel2 *L2,const char* alg);
    ~ToFNuclei(){ Delete(); };
    //
    void SetDebug(Bool_t d){ debug=d; };
    //
    void Clear();
    void Clear(Option_t *option){Clear();};
    void Delete();
    void Delete(Option_t *option){Delete();};
    //
    void Process(); ///< Process data for track number 0
    void Process(Int_t ntr); ///< Process data for track number ntr
    void Print();
    void Print(Option_t *option){Print();};
    //
    ClassDef(ToFNuclei,1);
};

#endif

