//
// GroundDataConvert.cc -- standalone program to call the GroundDataConvert macro. 
//    by Emiliano Mocchiutti
//
//   Version 1.00 (2005/11/29)
//
// Changelog: 
//
// 0.00 - 1.00 : working.
//
#include <TSystem.h>
#include <caloclasses.h>
#include <iostream>
//
extern int GroundDataConvert(TString, TString, TString, TString, Int_t);
extern void info();
using namespace std;
//
int main(int numinp, char *inps[]){
  TString name;
  TString outdir;
  TString det;
  TString lev;
  int force;
  if ( numinp < 6 ){
    if ( numinp > 1 ){
      if ( !strcmp(inps[1],"--version") ){
	info();
	return(0);
      };
      if ( !strcmp(inps[1],"-h") || !strcmp(inps[1],"--help") ){
	printf("\nUsage:\n\n GroundDataConvert file detector level outDir force \n");
	printf("\n - file         can be in the form: /path/to/filesfromyoda/dw_000000_00000/  or, for \n");
	printf(  "                TOF and tracker, can be the full path and name of the rz file\n");
	printf(  " - detector     can be tracker, tof or anticounter \n");
	printf(  " - level        can be 1 or 2 for tracker, 1 for AC and TOF\n");
	printf(  " - outDir       output directory\n");
	printf(  " - force        force flag (1 = force, 0 do not force) \n");
	printf("\nExample: \n\nGroundDataConvert /home/pamela/filesfromyoda/dw_050301_00100/ anticounter 1 /home/pamela/ 1 \n\n");
	return(0);
      };
    };
    printf("\n Welcome to the PAMELA ground data converter! \n");
    //
    printf("\n You must provide the following input parameters: \n\n");
    //
    char input[256];
    //
    printf(" Path to YODA unpacked directory (if files are in Physics/LevelX/...)\n or full path and name of the rz file: \n ");
    cin.getline(input,256);
    name = (TString)input;
    printf(" Detector (tracker/tof/anticounter)?: \n ");
    cin.getline(input,256);
    det = (TString)input;
    printf(" Data level (1/2)?: \n ");
    cin.getline(input,256);
    lev = (TString)input;
    printf(" Output directory?: \n ");
    cin.getline(input,256);
    outdir = (TString)input;
    printf(" Force processing (1=yes, 0=no)?: \n ");
    cin.getline(input,256);
    force = atoi(input);
    //
  } else {
    printf("\n Welcome to the PAMELA ground data converter! \n");
    name = (TString)inps[1];
    det = (TString)inps[2];
    lev = (TString)inps[3];
    outdir = (TString)inps[4];
    force = atoi(inps[5]);
  };
  //
  Int_t ERR=GroundDataConvert(name,det,lev,outdir,force);
  //
  return(ERR);
}
