//
// this include is needed to read tracker NTUPLES
//
#include <ctrkstruct.h>
//
// how to open and read the tracker LEVEL1 NTUPLE from ROOT
//
void trktesting(TString filename){    
    TString startingdir = gSystem->WorkingDirectory();
    char *bdir;
    char *sdir=gSystem->Getenv("PAM_LIB");
    bdir = Form("%s/liboptrklev1.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/liboptrklev1_C.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/libretrklev1.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/libretrklev1_C.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/libcltrklev1.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/libcltrklev1_C.so",sdir);
    gSystem->Load(bdir);   
    Int_t trnev = 0;
    struct Tracklev1 trklev1;
    char *name;
    name = filename;
    //
    coptrklev1(name,trklev1,trnev);
    //
    printf("The tracker ntuple contains %i events\n",trnev);
    for ( Int_t i = 1; i < trnev+1; i++){
	cretrklev1(i,trklev1);
	printf("Event number %i ---> OBT %i \n",i,trklev1.obt1);
	printf("                ---> PKTnum %i \n",trklev1.pkt_num1);
	printf("                ---> PKTtype %x \n",trklev1.pkt_type1);
	printf("                ---> nev1 %i \n",trklev1.nev1);
	printf("                ---> good %i \n",trklev1.good1);
	printf("                ---> nclstr %i \n",trklev1.nclstr1);
    };
    ccltrklev1(trklev1);        
}

//
// how to open and read the tracker LEVEL2 NTUPLE from ROOT
//
void trktesting2(TString filename){    
    TString startingdir = gSystem->WorkingDirectory();
    char *bdir;
    char *sdir;
    sdir = startingdir;
    bdir = Form("%s/tracker/liboptrklev2.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/tracker/coptrklev2_C.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/tracker/libretrklev2.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/tracker/cretrklev2_C.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/tracker/libcltrklev2.so",sdir);
    gSystem->Load(bdir);
    bdir = Form("%s/tracker/ccltrklev2_C.so",sdir);
    gSystem->Load(bdir);
    Int_t trnev = 0;
    struct Tracklev2 trklev2;
    char *name;
    name = filename;
    coptrklev2(name,trklev2,trnev);
    printf("The tracker ntuple contains %i events\n",trnev);
    for ( Int_t i = 1; i < trnev+1; i++){
	cretrklev2(i,trklev2);
	printf("Event number %i ---> OBT %i \n",i,trklev2.obt);
	printf("                ---> PKTnum %i \n",trklev2.pkt_num);
	printf("                ---> PKTtype %x \n",trklev2.pkt_type);
	printf("                ---> nev2 %i \n",trklev2.nev2);
	printf("                ---> good2 %i \n",trklev2.good2);
	printf("                ---> ntrk %i \n",trklev2.ntrk);
	if ( trklev2.ntrk == 1 && trklev2.al[0][4] != 0. ) printf("c-> RIG = %.9f \n",1./trklev2.al[0][4]);
    };
    ccltrklev2(trklev2);        
}




//
// this include is needed to read tracker ROOTPLES
//
#include <ctrkinclude.h>
//
// how to open and read the tracker LEVEL2 ROOTPLE from ROOT
//
void trkhtestlev2(TString filename){
    TFile *f = getFile(filename,"Physics.Level2","Tracker");
    TTree *tr = (TTree*) f->Get("TrkLevel2");
    struct Tracklev2 trk;
    struct CTracklev2 track;
    //
    // settrklev2 allows you to have all variables in trk.nameofvariable
    // BUT all matrixes have columns inverted with rows (instead of al[5][ntrk] you have al[ntrk][5]).
    //
    settrklev2(tr,trk);
    Int_t nevents = tr->GetEntries();    
    for ( Int_t i = 0; i<nevents ; i++){
	tr->GetEntry(i);
	//
	// accesstrklev2 put in trak.nameofvariable the same variables you have in trk but with
	// matrixes in the correct order. You can skip this accesstrklev2 and use directly trk instead of track
	// but you must remember to invert all matrixes columns and rows.
	//
	accesstrklev2(trk,track);
	printf("Event %i tracker OBT = %i \n",i,track.obt);
	if ( track.ntrk>0 ) printf("Event %i tracker RIG = %f \n",i,1./track.al[4][0]);
    };
}

//
// how to open and read the tracker LEVEL1 ROOTPLE from ROOT
//
void trkhtest(TString filename){
    TFile *f = getFile(filename,"Physics.Level1","Tracker");
    TTree *tr = (TTree*) f->Get("TrkLevel1");
    struct Tracklev1 trk;
    struct CTracklev1 track;
    settrklev1(tr,trk);
    Int_t nevents = tr->GetEntries();    
    for ( Int_t i = 0; i<nevents ; i++){
	tr->GetEntry(i);
	accesstrklev1(trk,track);
	printf("Event %i tracker OBT1 = %i \n",i,track.obt1);
    };
}


