#include <TTree.h>

void settrklev1(TTree *tree, Tracklev1 & trklev1){
    tree->SetBranchAddress("good1",&trklev1.good1);
    tree->SetBranchAddress("nev1",&trklev1.nev1);
    tree->SetBranchAddress("pkt_type1",&trklev1.pkt_type1);
    tree->SetBranchAddress("pkt_num1",&trklev1.pkt_num1);
    tree->SetBranchAddress("obt1",&trklev1.obt1);
    tree->SetBranchAddress("which_calib1",&trklev1.which_calib1);
    tree->SetBranchAddress("nclstr1",&trklev1.nclstr1);
    tree->SetBranchAddress("view",trklev1.view);
    tree->SetBranchAddress("ladder",trklev1.ladder);
    tree->SetBranchAddress("maxs",trklev1.maxs);
    tree->SetBranchAddress("mult",trklev1.mult);
    tree->SetBranchAddress("dedx",trklev1.dedx);
    tree->SetBranchAddress("indstart",trklev1.indstart);
    tree->SetBranchAddress("indmax",trklev1.indmax);
    tree->SetBranchAddress("totcllength",&trklev1.totcllength);
    tree->SetBranchAddress("clsignal",trklev1.clsignal);
    tree->SetBranchAddress("cnev",trklev1.cnev);
}

void accesstrklev1(Tracklev1 & trklev1, CTracklev1 & ctrklev1){
    ctrklev1.good1 = trklev1.good1;
    ctrklev1.nev1 = trklev1.nev1;    
    ctrklev1.pkt_type1 = trklev1.pkt_type1;
    ctrklev1.pkt_num1 = trklev1.pkt_num1;
    ctrklev1.obt1 = trklev1.obt1;
    ctrklev1.nclstr1 = trklev1.nclstr1;
    for (Int_t i = 0; i<trklev1.nclstr1; i++){
	ctrklev1.view[i] = trklev1.view[i];
	ctrklev1.ladder[i] = trklev1.ladder[i];
	ctrklev1.maxs[i] = trklev1.maxs[i];
	ctrklev1.mult[i] = trklev1.mult[i];
	ctrklev1.dedx[i] = trklev1.dedx[i];
	ctrklev1.indstart[i] = trklev1.indstart[i];
	ctrklev1.indmax[i] = trklev1.indmax[i];
    };
    ctrklev1.totcllength = trklev1.totcllength;
    for (Int_t i = 0; i<trklev1.totcllength; i++){
	ctrklev1.clsignal[i] = trklev1.clsignal[i];
    };
    for (Int_t i = 0; i<12; i++){
	for (Int_t j = 0; j<24; j++){
	    ctrklev1.cnev[i][j] = trklev1.cnev[j][i];
	};
    };
}

void settrklev2(TTree *tree, Tracklev2 & trklev2){
   tree->SetBranchAddress("good2",&trklev2.good2);
   tree->SetBranchAddress("nev2",&trklev2.nev2);
   tree->SetBranchAddress("pkt_type",&trklev2.pkt_type);
   tree->SetBranchAddress("pkt_num",&trklev2.pkt_num);
   tree->SetBranchAddress("obt",&trklev2.obt);
   tree->SetBranchAddress("which_calib",&trklev2.which_calib);
   tree->SetBranchAddress("ntrk",&trklev2.ntrk);
   tree->SetBranchAddress("image",&trklev2.image);
   tree->SetBranchAddress("xm",trklev2.xm);
   tree->SetBranchAddress("ym",trklev2.ym);
   tree->SetBranchAddress("zm",trklev2.zm);
   tree->SetBranchAddress("resx",trklev2.resx);
   tree->SetBranchAddress("resy",trklev2.resy);
   tree->SetBranchAddress("al",trklev2.al);
   tree->SetBranchAddress("coval",trklev2.coval);
   tree->SetBranchAddress("chi2",trklev2.chi2);
   tree->SetBranchAddress("xgood",trklev2.xgood);
   tree->SetBranchAddress("ygood",trklev2.ygood);
   tree->SetBranchAddress("xv",trklev2.xv);
   tree->SetBranchAddress("yv",trklev2.yv);
   tree->SetBranchAddress("zv",trklev2.zv);
   tree->SetBranchAddress("axv",trklev2.axv);
   tree->SetBranchAddress("ayv",trklev2.ayv);
   tree->SetBranchAddress("dedxp",trklev2.dedxp);
   tree->SetBranchAddress("nclsx",trklev2.nclsx);
   tree->SetBranchAddress("nclsy",trklev2.nclsy);
}

void accesstrklev2(Tracklev2 & trklev2, CTracklev2 & ctrklev2){
    ctrklev2.good2 = trklev2.good2;
    ctrklev2.nev2 = trklev2.nev2;
    ctrklev2.pkt_type = trklev2.pkt_type;
    ctrklev2.pkt_num = trklev2.pkt_num;
    ctrklev2.obt = trklev2.obt;
    ctrklev2.which_calib = trklev2.which_calib;
    ctrklev2.ntrk = trklev2.ntrk;
    for (Int_t i = 0; i<trklev2.ntrk; i++){
	ctrklev2.chi2[i] = trklev2.chi2[i];
	ctrklev2.image[i] = trklev2.image[i];
	for (Int_t j = 0; j<6; j++){
	    ctrklev2.xm[j][i] = trklev2.xm[i][j];
	    ctrklev2.ym[j][i] = trklev2.ym[i][j];
	    ctrklev2.zm[j][i] = trklev2.zm[i][j];
	    ctrklev2.resx[j][i] = trklev2.resx[i][j];
	    ctrklev2.resy[j][i] = trklev2.resy[i][j];
	    ctrklev2.dedxp[j][i] = trklev2.dedxp[i][j];
	    if ( j<5 ) {
		ctrklev2.al[j][i] = trklev2.al[i][j];
		for (Int_t jp = 0; jp<5; jp++){
		    ctrklev2.coval[j][jp][i] = trklev2.coval[i][jp][j];
		};
	    };
	    ctrklev2.xgood[j][i] = trklev2.xgood[i][j];
	    ctrklev2.ygood[j][i] = trklev2.ygood[i][j];
	    ctrklev2.xv[j][i] = trklev2.xv[i][j];
	    ctrklev2.yv[j][i] = trklev2.yv[i][j];
	    ctrklev2.zv[j][i] = trklev2.zv[i][j];
	    ctrklev2.axv[j][i] = trklev2.axv[i][j];
	    ctrklev2.ayv[j][i] = trklev2.ayv[i][j];
	    if ( j == 0 ){
		ctrklev2.nclsx[j] = trklev2.nclsx[j];
		ctrklev2.nclsy[j] = trklev2.nclsy[j];
	    };
	};
    };
}
