#include "descript.h"
#include "flag.h"

void filename(char [], char [], char [], char[], int, char[]);
void FindRoute(int[], int*);
short int CRC(int []);
int restrict(int [], long long int[], int);

extern char database[80];
extern char MYSQL[80];
extern int print_flag;

void read(char fni[], char fno[], char INF[],
          char protocol[], char path[], char name[], char nnnnn_TMP[], float quality[], int real_route[], int &Rcount)
{
 FILE *fo, *fout, *foRout, *foMiss, *fo_log_kadr, *fo_route, *fo_tmp;
 ifstream fin;
 ofstream fo_cln1, fokadr_cln1, fo_info;
 
 char buf[1024];
 //  char stop1;
 char ch1,ch2,ch3,ch, ch4[80], ch5[5];
 char file_route[80];  /*protocol binary filesm nnnnn_mmm_xxx_cln1Er.log*/
 char miss_file[80];   /*protocol files nnnnn_mmm_xxx_mis_cln1.dat*/
 char cln1_file[80];   /*route binary data files nnnnn_mmm_xxx_cln1.pam*/
 char cln1_kadr[80];   /*route binary data files nnnnn_mmm_xxx_cln1.bin*/
 char log_kadr[80];    /*log binary data files nnnnn_mmm_xxx_cln1.log*/
 char log_route[80];   /*log binary file for number of routes*/
 char Short_Buf[8], Name_Buf[4]; 
 char temp[10], temp1[80], connection[80], command[80], name11[80];
 short int CalcCheckSum;

 int LenthBuf=1015, flag_help=0;
 int i, j, k, file_length=0, Hex[3];
 int N_er=0;              /*Number of cadre with name error*/
 int CRC0_er=0;           /*Number of cadre with CRC0 error*/
 int P_er=0;              /*Number of cadre with packet error number*/
 int end=0;               /*End of last pamela packet*/
 // Buffers for Cadre analysis
 int buffer1[1024], buffer2[1024], buffer3[1024]; 
 int rr=0;
 int cirquit_no=0, route=0;
 
 int header1, header2, header3, CRC_0[3], CRC_1[3];
 long long int icount_int;
 long long int icount_frac, tmpP, numP[3];	      
 long int N1=0;                  /* Number of identified cadres*/
 long long int icount=0;         /* Number of bytes in identified cadres*/ 
 long long int icount_total=0;   /* Total number of bytes*/
 long long int packet_first[100];/* First cadre number for each route*/
 long long int packet_last[100]; /* Second cadre number for each route*/
 long int count_missed[100];     /* Number of missed cadres in each route*/
 long int count_sec_missed[100];
 unsigned long long int count_ident[100]; /* Number of good bytes in each route*/
 unsigned long long int count_tot[100];   /* Total number of bytes in each route*/
 int NumRout[1000];              /* Number of route*/
 long long int Num_kadrs[1000];  /* Number of identified cadres in each route*/
 long int Num_good_kadrs[1000];  /* Number of normal cadres in each route*/
 long long int Num_bad_kadrs[1000]; /* Bad cadres number in each route*/

 int counter=0;                  /* Last byte position in truncated cadre*/
 int adr1=0;                     /* Initial byte of cadre in cln1.bin*/
 int adr2=0;                     /* Last byte of cadre in cln2.bin*/
 int tmp=0;
 int numPack[4];                 /* Number of cadre in given route*/
 int good_pack=0;
 long long int good_number=0;
 int good_route=0;
 int adress[4];
 int R_er[100];           /* Route errors number in given route*/
 int R_er_interf1[100];   /* Interface Route error at the begining of the route*/
 int R_er_interf2[100];   /* Interface Route error at end of route*/
 int Mis_group[1000];     /* Number of missed cadres group
                             for each route*/
 float first_missed[100];			     
 int Pack_Er[1000];       /* Number of packets with packet number
                             error for each route*/
 int CRC_bad_kadr[3];     /* Current CRC bad cadre number*/
 int flag_pack[3];        /* Flag for error in packet number*/
 int flag_rout[3];        /* Flag for error in route number*/
 int flag_name[3];        /* Flag for name error*/
 int flag_CRC0[3];        /* Flag for CRC0 error*/
 int flag_CRC[3];         /* Flag for CRC error*/
 int flag_CRC_cor[3];     /* Flag for CRC error correction*/
 int flag_tr[3];          /* Truncate flag*/
 short int flags;         /* Number for all errors*/

 for (j=0; j<4; j++) {adress[j]=0; numPack[j]=0;}
 for (j=0; j<1024; j++) 
 {buffer1[j]=0; buffer2[j]=0; buffer3[j]=0;}
 for (i=0; i<100; i++) 
 {Num_kadrs[i]=0;
  NumRout[i]=0;
  packet_first[i]=0;
  packet_last[i]=0;
  count_missed[i]=0;
  count_sec_missed[i]=0;
  first_missed[i]=0;
  count_ident[i]=0;
  count_tot[i]=0;
  R_er[i]=0;
  R_er_interf1[i]=0;
  Num_bad_kadrs[i]=0;
  Num_good_kadrs[i]=0;
  quality[i]=0; Mis_group[i]=0; Pack_Er[i]=0;
  R_er_interf2[i]=0;}
 for (i=0; i<3; i++)
 {numP[i]=0; CRC_bad_kadr[i]=0; Hex[i]=0;
  flag_pack[i]=0; flag_rout[i]=0;
  flag_name[i]=0; flag_CRC0[i]=0; flag_tr[i]=0;
  flag_CRC[i]=0; flag_CRC_cor[i]=0;} 

 stringstream oss;

 strcpy(connection,MYSQL);
 strcat(connection,database);
 TSQLServer *sqlServer = TSQLServer::Connect(connection, "pamelaprod", "rawprod");
 // open input file "nnnnnmmm.pam"
 fin.open(fni, ifstream::binary);
 if(fin.good()==0) {cerr<<"can not open input file"; exit(0);}
 //open output file "nnnnnmmm_work.dat"
 fout=fopen(fno, "wb");
 if(fout==0) {cerr<<"can not open work file"; exit(0);}

 strcpy(ch5,"info");
 strcpy(ch4,fno);
 for(i=0;i<4;i++){ch4[strlen(ch4)-8+i]=ch5[i];} 
 // open input file "nnnnnmmm_info.dat"
 fo_info.open(ch4, ifstream::binary); 
 if(fo_info.good()==0) {cerr<<"can not open info file"; exit(0);} 

 //open output file "nnnnnmmm_protocol.txt"
 fo=fopen(protocol, "wb");
 if(fo==0) {cerr<<"can not open protocol file"; exit(0);}
 //open output file "nnnnnmmm_route.log"
 strncpy(log_route,INF,strlen(INF)-9);
 log_route[strlen(INF)-9]='\0';
 strcat(log_route,"_route.log");
 fo_route=fopen(log_route, "wb");
 if(fo_route==0) {cerr<<"can not open file for routes number"; exit(0);}
 /////////////////////////////////////////////////////////////////
 // cin>>stop1;
 k=0;
 while(fin.eof()==0)
 {
  counter=0;          //pounter for position of cadre truncation
  N_er=0;           
  P_er=0;
  CRC0_er=0;
  if (N1==0) Rcount=1;
/**********************data reading********************************/
  fin.read(Name_Buf,3);
  if (fin.eof()) break;
  fin.read(Short_Buf,5);	
  if (fin.eof()) break;
  ch1=Name_Buf[0];
  ch2=Name_Buf[1];
  ch3=Name_Buf[2];
  tmpP=(long int)(unsigned char)(Short_Buf[1])+
     	256*(long int)(unsigned char)(Short_Buf[2])+
        256*256*(long int)(unsigned char)(Short_Buf[3]);
  icount+=8; icount_total+=8;
  count_ident[Rcount-1]+=8; count_tot[Rcount-1]+=8;

  while((ch1!=(char)(CODE1)&&ch2!=(char)(CODE2)&&
  (N1==0||buffer3[1023]!=(int)(unsigned char)(Short_Buf[4])||buffer3[3]!=(int)(unsigned char)(Short_Buf[0])))
	     ||
  (ch2!=(char)(CODE2)&&ch3!=(char)(CODE3)&&(buffer3[1023]!=(int)(unsigned char)(Short_Buf[4])||(numP[2]+1)!=tmpP))
	     ||
  (ch3!=(char)(CODE3)&&ch1!=(char)(CODE1)&&((numP[2]+1)!=tmpP||buffer3[1023]!=(int)(unsigned char)(Short_Buf[4])))
	     ||
  (ch1!=(char)(CODE1)&&
   (buffer3[1023]!=(int)(unsigned char)(Short_Buf[4])||buffer3[3]!=(int)(unsigned char)(Short_Buf[0])||(numP[2]+1)!=tmpP))
  	     ||
  (ch2!=(char)(CODE2)&&
   (buffer3[1023]!=(int)(unsigned char)(Short_Buf[4])||buffer3[3]!=(int)(unsigned char)(Short_Buf[0])||(numP[2]+1)!=tmpP))
	     ||
  (ch3!=(char)(CODE3)&&
   (buffer3[1023]!=(int)(unsigned char)(Short_Buf[4])||buffer3[3]!=(int)(unsigned char)(Short_Buf[0])||(numP[2]+1)!=tmpP))
	     ||
  (ch1!=(char)(CODE1)&&ch2!=(char)(CODE2)&&ch3!=(char)(CODE3)))
  {fin.get(ch);
   if (fin.eof()) {break;}
   ch1=ch2; ch2=ch3; ch3=Short_Buf[0];
   for (i=0;i<4;i++) Short_Buf[i]=Short_Buf[i+1]; Short_Buf[4]=ch;
   icount_total+=1; count_tot[Rcount-1]+=1;
   tmpP=(long int)(unsigned char)(Short_Buf[1])+
  	    256*(long int)(unsigned char)(Short_Buf[2])+
        256*256*(long int)(unsigned char)(Short_Buf[3]);
  }
  if ((fin.eof())&&(N1==0)) 
  {
   fclose(fout);
   fo_info.close();   
   remove(fno);
   fclose(fo);
   remove(protocol);
   remove(INF);
   exit(0);
  }

  /*****************************************************************/
  /*********************data reading********************************/
  fin.read(buf,LenthBuf); 
  if (fin.eof()) break;
  icount+=1015; icount_total+=1015;
  count_ident[Rcount-1]+=1015; count_tot[Rcount-1]+=1015;
  /****************************************************************/
  /********************data reading********************************/
  fin.get(ch);
  icount+=1; icount_total+=1;
  count_ident[Rcount-1]+=1; count_tot[Rcount-1]+=1;
  if (fin.eof()) break;
  /***************************************************************/
  N1+=1; Num_kadrs[Rcount-1]+=1;
 
  /**********************DATA ANALYSIS****************************/
  /***************************************************************/
  header1=(unsigned char)(ch1);
  header2=(unsigned char)(ch2);
  header3=(unsigned char)(ch3);
  switch (N1)
  { 
   case 1:{
   	   buffer3[0]=(int)(unsigned char)(ch1);
           buffer3[1]=(int)(unsigned char)(ch2);
           buffer3[2]=(int)(unsigned char)(ch3);
           buffer3[3]=(int)(unsigned char)(Short_Buf[0]);
           buffer3[4]=(int)(unsigned char)(Short_Buf[1]);
           buffer3[5]=(int)(unsigned char)(Short_Buf[2]);
           buffer3[6]=(int)(unsigned char)(Short_Buf[3]);
           buffer3[7]=(int)(unsigned char)(Short_Buf[4]);
           for (i=0; i<1015; i++)
		   {buffer3[i+8]=(int)(unsigned char)(buf[i]);}
           buffer3[1023]=(int)(unsigned char)(ch);			  
		   for (i=0; i<1024; i++)
		   {buffer1[i]=buffer3[i];buffer2[i]=buffer3[i];}

		   NumRout[Rcount-1]=1;
           numP[2]=(long int)(unsigned char)(Short_Buf[1])+
   	       256*(long int)(unsigned char)(Short_Buf[2])+
           256*256*(long int)(unsigned char)(Short_Buf[3]);
		   CRC_bad_kadr[2]=0;
		   flag_pack[2]=0; flag_rout[2]=0;
		   flag_name[2]=0; flag_CRC0[2]=0; flag_tr[2]=0;
		   flag_CRC[2]=0; flag_CRC_cor[2]=0;	   
           for (i=0; i<2; i++)
		   {numP[i]=numP[2];CRC_bad_kadr[i]=CRC_bad_kadr[2];
		    flag_pack[i]=flag_pack[2]; flag_rout[i]=flag_rout[2];
		    flag_name[i]=flag_name[2]; flag_CRC0[i]=flag_CRC0[2];
		    flag_CRC[i]=flag_CRC[2]; flag_tr[i]=flag_tr[2];
		    flag_CRC_cor[i]=flag_CRC_cor[2];}
           CRC_0[2]=(int)(unsigned char)(Short_Buf[4]);
		   for (i=0; i<2; i++)
		   {CRC_0[i]=CRC_0[2];}
           CRC_1[2]=(int)(unsigned char)(ch);
		   for (i=0; i<2; i++)
		   {CRC_1[i]=CRC_1[2];}
           packet_first[Rcount-1]=numP[2];
		   break;
          }
   default:{
   	    for (i=0; i<1024; i++)
	    {buffer1[i]=buffer2[i];buffer2[i]=buffer3[i];}
	    buffer3[0]=(int)(unsigned char)(ch1);
            buffer3[1]=(int)(unsigned char)(ch2);
            buffer3[2]=(int)(unsigned char)(ch3);
            buffer3[3]=(int)(unsigned char)(Short_Buf[0]);
            buffer3[4]=(int)(unsigned char)(Short_Buf[1]);
            buffer3[5]=(int)(unsigned char)(Short_Buf[2]);
            buffer3[6]=(int)(unsigned char)(Short_Buf[3]);
            buffer3[7]=(int)(unsigned char)(Short_Buf[4]);
            for (i=0; i<1015; i++)
		    {buffer3[i+8]=(int)(unsigned char)(buf[i]);}
            buffer3[1023]=(int)(unsigned char)(ch);

            for (i=0; i<2; i++)
		    {numP[i]=numP[i+1]; CRC_bad_kadr[i]=CRC_bad_kadr[i+1];
		     flag_pack[i]=flag_pack[i+1];
		     flag_rout[i]=flag_rout[i+1];
		     flag_name[i]=flag_name[i+1];
		     flag_CRC0[i]=flag_CRC0[i+1];
		     flag_tr[i]=flag_tr[i+1];
		     flag_CRC[i]=flag_CRC[i+1];
		     flag_CRC_cor[i]=flag_CRC_cor[i+1];}
            numP[2]=(long int)(unsigned char)(Short_Buf[1])+
   	        256*(long int)(unsigned char)(Short_Buf[2])+
            256*256*(long int)(unsigned char)(Short_Buf[3]);
		    CRC_bad_kadr[2]=0;
		    flag_pack[2]=0; flag_rout[2]=0;
		    flag_name[2]=0; flag_CRC0[2]=0;
		    flag_CRC[2]=0; flag_CRC_cor[2]=0; flag_tr[2]=0;
		    for (i=0; i<2; i++) CRC_0[i]=CRC_0[i+1];
            CRC_0[2]=(int)(unsigned char)(Short_Buf[4]);
		    for (i=0; i<2; i++) {CRC_1[i]=CRC_1[i+1];}
            CRC_1[2]=(int)(unsigned char)(ch);    
           }
  }  
  if (print_flag>0 && fmod(N1,10000)==0.) cout<<N1<<"\n";	  

/******************CRC ERROR ANALYSIS***************************/
  CalcCheckSum=CRC(buffer3);
  if (CalcCheckSum!=(short int)(buffer3[1023]))
  {    
//write in file nnnnnmmm_info.dat    
   fo_info<<"real CRC = "<<hex<<buffer3[1023]<<" (calculated CRC ="<<CalcCheckSum<<") in cadre "<<dec<<numP[2]<<"\n";
//write in file nnnnnmmm_work.dat       
   fprintf(fout,"%i %x (%x)", numP[2], CalcCheckSum, buffer3[1023]);

   flag_CRC[2]=1;
   Num_bad_kadrs[Rcount-1]+=1;
   CRC_bad_kadr[2]=numP[2];
   counter=restrict(buffer3,numP,buffer2[3]);
   if (counter!=0)
   {fo_info<<" truncate byte="<<counter<<" in cadre "<<numP[2]<<"\n";
    if (print_flag>0) 
    {cout<<" truncate counter="<<counter<<" route="<<buffer2[3]<<" "<<buffer3[3]<<" kadr="<<numP[2]<<" "<<numP[1]<<" "<<numP[0]<<"\n";}
    fin.seekg(-(1024-counter),ios::cur);
    icount-=1024;
    count_ident[Rcount-1]-=1024;
    count_tot[Rcount-1]-=1024-counter;
    icount_total-=1024-counter;
    N1-=1;
    CRC_bad_kadr[2]=0;
    flag_tr[2]=1;
    Num_kadrs[Rcount-1]-=1;
    Num_bad_kadrs[Rcount-1]-=1;}
  }

  /******************HEADER ANALYSIS*******************************/
  if ((header1!=(int)(CODE1))||(header2!=(int)(CODE2))||(header3!=(int)(CODE3))) 
  {flag_name[2]=1; N_er=N1;}
  /****************************************************************/

  /******************CRC0 ANALYSIS*********************************/
  if ((buffer2[7]!=buffer1[1023])&&
      ((numP[1]==numP[0]+1)||(numP[1]==numP[2]-1))&&(flag_tr[1]!=1)&&(flag_tr[0]!=1)&&(N1>2))
  {flag_CRC0[1]=1; CRC0_er=N1-1;}
  /****************************************************************/

  /******************KADR NUMBER ANALYSIS**************************/
  if ((numP[1]!=(numP[0]+1))&&(numP[1]!=(numP[2]-1))&&(N1!=1)&&(CRC_bad_kadr[1]==numP[1])&&(numP[1]!=0)) 
  {P_er=N1-1; flag_pack[1]=1;
  //Correct error packet number//
   tmpP=numP[0]+1;
   for (i=0;i<3;i++) Hex[i]=0;
   for (i=0;i<3;i++)
   {if (tmpP/(long int)(pow(256.,2-i))>=1) 
    {Hex[2-i]=(int)(tmpP/(long int)(pow(256.,2-i)));
     tmpP=tmpP-(long int)pow(256.,2-i)*(int)(tmpP/(long int)(pow(256.,2-i)));}}
   for (i=4;i<7;i++) (buffer2[i]=Hex[i-4]);
   if (buffer2[1023]==(int)(CRC(buffer2))) flag_CRC_cor[1]=1;

   tmpP=numP[2]-1;
   for (i=0;i<3;i++) Hex[i]=0;
   for (i=0;i<3;i++)
   {if (tmpP/(long int)(pow(256.,2-i))>=1) 
    {Hex[2-i]=(int)(tmpP/(long int)(pow(256.,2-i)));
	 tmpP=tmpP-(long int)pow(256.,2-i)*(int)(tmpP/(long int)(pow(256.,2-i)));}}
   for (i=4;i<7;i++) (buffer2[i]=Hex[i-4]);
   if (buffer2[1023]==(int)(CRC(buffer2))) flag_CRC_cor[1]=1;
  }
  /////////////////////////////////////////////////////////////////////
  if ((numP[2]!=(numP[1]+1))&&(N1!=1)&&(buffer3[3]==buffer2[3])&&(CRC_bad_kadr[2]==numP[2])&&(numP[2]!=0)) flag_pack[2]=1;
  if (flag_pack[2]!=1) packet_last[Rcount-1]=numP[2];
  ////////Missing cadre analysis////////////////////////////////////
  /**route number:  10 (10 19 10) 10 ******************************/
  /**cadre number:  21 (22 17 18) 19 ******************************/
  /**missed cadres: 21  20 19 18  17 ******************************/  
  if ((numP[1]<numP[0])&&(numP[1]==numP[2]-1)&&(buffer1[3]==buffer3[3])&&(flag_tr[1]==0)&&
 	  (flag_pack[0]==0)&&(flag_pack[1]==0)&&(flag_pack[2]==0))
  {Mis_group[Rcount-1]+=1;
   count_sec_missed[Rcount-1]+=numP[0]-1-numP[1];
   fprintf(foMiss,"secondary transmitted cadres may be %lli - %lli number of cadres=%lli\n",numP[1],numP[0],numP[0]-1-numP[1]);
  }  
   
  /**route number: 10 (10 19 10) 10 ******************************/
  /**cadre number: 11 (12 15 20) 21 ******************************/
  /**missed cadres:   16 17 18 19   ******************************/  
  if ((numP[1]>numP[0]+1)&&(numP[1]<numP[2]-1)&&(buffer1[3]==buffer3[3])&&(flag_tr[1]==0)&&
 	  (flag_pack[0]==0)&&(flag_pack[1]==0)&&(flag_pack[2]==0))
  {Mis_group[Rcount-1]+=1;
   fprintf(foMiss,"1) %9lli%9lli\n",numP[1]+1,numP[2]-1);
   count_missed[Rcount-1]+=numP[2]-numP[1]-1;}
  /**route number: (10 10 10) 10 10 ******************************/
  /**cadre number: (11 12 15) 20 21 ******************************/
  /**missed kadrs:     13 14        ******************************/  
  else if ((numP[1]>=numP[0]+1)&&(numP[1]<numP[2]-1)&&
	       (buffer1[3]==buffer3[3])&&(buffer1[3]==buffer2[3])&&
		   (flag_tr[1]==0)&&(flag_pack[2]==0)&&(flag_pack[1]==0)&&(flag_pack[0]==0))
  {Mis_group[Rcount-1]+=1;
   fprintf(foMiss,"2) %9lli%9lli\n",numP[0]+2,numP[2]-1);
   count_missed[Rcount-1]+=numP[2]-numP[0]-1-1;}
  /**route number: (10 10 10) 10 10 ******************************/
  /**cadre number:  (11 29 15) 14 15 ******************************/
  /**number of missed cadres:2       ******************************/  
  else if (((numP[1]<numP[0]+1)||(numP[1]>numP[2]-1))&&(numP[2]-numP[0]>2)&&
           (buffer1[3]==buffer3[3])&&(buffer1[3]==buffer2[3])&&(flag_tr[1]==0)&&
     	   (flag_pack[2]==0)&&(flag_pack[1]==1)&&(flag_pack[0]==0))
  {Mis_group[Rcount-1]+=1;
   fprintf(foMiss,"3) %9lli%9lli -1\n",numP[0]+1,numP[2]-1);
   count_missed[Rcount-1]+=numP[2]-numP[0]-1-1;}
  /**route number:(10 10 )10 10 10 10 ******************************/
  /**cadre number:( 1 11 )12 13 14 15 ******************************/
  /**number of missed cadres: 10       ******************************/   
  else if ((N1>1)&&(abs(numP[2]-good_pack-2)>abs(Num_kadrs[Rcount-1]-good_number))&&
           (buffer2[3]==good_route)&&(flag_tr[2]==0)&&(flag_pack[2]==0))
  {Mis_group[Rcount-1]+=1;  
   count_missed[Rcount-1]+=abs(numP[2]-good_pack)-1;
   fprintf(foMiss,"4) %9i%9lli number of missed cadres=%i\n", good_pack, numP[2], abs(numP[2]-good_pack)-1);
  }
  //truncate cadres
  /**route number: 10 (10 10 10) 10 ******************************/
  /**cadre number:  11 (12 13 14) 15 ******************************/
  /**missed truncate cadre:13        ******************************/  
  else if ((numP[0]<numP[2]-1)&&(buffer1[3]==buffer3[3])&&
	       (flag_tr[0]==0)&&(flag_tr[1]==1)&&(flag_tr[2]==0)&&
		   (flag_pack[2]==0)&&(flag_pack[1]==0)&&(flag_pack[0]==0)) 
  {Mis_group[Rcount-1]+=1;
   fprintf(foMiss,"5) %9lli%9lli\n",numP[0]+1,numP[2]-1);
   count_missed[Rcount-1]+=numP[2]-numP[0]-1;}
  /***************************************************************/

  if (flag_CRC[2]!=1) {good_pack=numP[2]; good_route=buffer3[3]; good_number=Num_kadrs[Rcount-1];}

  /******************ROUTE NUMBER ANALYSIS**************************/
  if ((buffer2[3]!=buffer1[3])&&(buffer2[3]!=buffer3[3])&&(buffer1[3]!=buffer3[3])&&
      (flag_pack[2]==0)&&(flag_pack[1]==0)&&(flag_pack[0]==0))
  {

  }
  /**************First route***************************************/
  /**route number: (0 4) 4*****************************************/
  /**cadre number: (0 1) 2*****************************************/
  if (N1==2)
  {packet_first[Rcount-1]=numP[1];
   packet_last[Rcount-1]=numP[2];
   NumRout[Rcount-1]=1;
   // CREATE FILE NAMES
   filename(file_route, miss_file, cln1_file, path, NumRout[Rcount-1], name);			 
   strncpy(cln1_kadr,cln1_file,strlen(cln1_file)-3);
   cln1_kadr[strlen(cln1_file)-3]='\0';
   strcat(cln1_kadr,"bin");
   strncpy(log_kadr,file_route,strlen(file_route)-6);
   log_kadr[strlen(file_route)-6]='\0';
   strcat(log_kadr,"_bin.log");
   //Open files for new route
   foRout=fopen(file_route, "wb");          //nnnnn_mmm_xxx_cln1Er.log
   foMiss=fopen(miss_file, "wb");           //nnnnn_mmm_xxx_mis_cln1.dat 
   if (CLN1_MEPHI>0)
   {strcpy(ch4,"");
    strncat(ch4,path,strlen(path)-6);
    strcat(strcpy(temp1,ch4),"Cln1/tmp.dat");
    if ((fo_tmp=fopen(temp1,"w"))==NULL)
    {strcat(strcat(strcpy(command,"mkdir "),ch4),"Cln1");
     //Creata special directory for cln1 files
     system(command);
    }
    else
    {
     fclose(fo_tmp);
     remove(temp1);
    }
    for(i=0;i<22;i++)
    {name11[i]=cln1_file[i+strlen(cln1_file)-22];}
    name11[22]='\0';
    strcat(strcat(ch4,"Cln1/"),name11);
    strcpy(cln1_file,ch4);
   }
   fo_cln1.open(cln1_file, ios::binary);   //nnnnn_mmm_xxx_cln1.pam
   
   if (!fo_cln1) cout<<"can not open "<<cln1_file<<"\n";
   fokadr_cln1.open(cln1_kadr,ios::binary); //nnnnn_mmm_xxx_cln1.bin
   if (!fokadr_cln1) cout<<"can not open "<<cln1_kadr<<"\n";
   fo_log_kadr=fopen(log_kadr,"wb");        //nnnnn_mmm_xxx_cln1_bin.log
  } 
  /***************New route****************************************/
  /**route number:   7 ( 7  0 8) 8*********************************/
  /**cadre number: 199 (200 0 1) 2*********************************/
  /**route number:   7 ( 7  8 8) 8*********************************/
  /**cadre number: 199 (200 0 1) 2*********************************/
  if ( ((buffer1[3]!=buffer3[3])&&(buffer2[3]==0)&&(N1>3)&&(numP[1]!=numP[0]+1)&&(numP[1]<10))||
       ((buffer1[3]!=buffer2[3])&&(buffer2[3]==buffer3[3])&&(buffer1[3]!=0)&&(numP[1]!=numP[0]+1)&&(numP[1]<10))||
       ((numP[2]==numP[1]+1)&&(numP[1]==0)&&(Num_kadrs[Rcount-1]>1000000)) )
  {Rcount+=1;
   packet_last[Rcount-2]=numP[0]; 
   packet_first[Rcount-1]=numP[1]; 
   NumRout[Rcount-1]=Rcount;
   if (print_flag>0) 
   {cout<<"New route="<<Rcount<<" "<<buffer1[3]<<" "<<buffer2[3]<<" "<<buffer3[3]<<"\n";
    cout<<numP[0]<<" "<<numP[1]<<" "<<numP[2]<<"\n";}
   if (flag_tr[1]==0)
   {Num_kadrs[Rcount-2]-=2;
    Num_kadrs[Rcount-1]+=2;
    count_ident[Rcount-1]+=2048; count_ident[Rcount-2]-=2048;
    count_tot[Rcount-1]+=2048; count_tot[Rcount-2]-=2048;}
   else
   {Num_kadrs[Rcount-2]-=1;
    Num_kadrs[Rcount-1]+=1;
    count_ident[Rcount-1]+=1024; count_ident[Rcount-2]-=1024;
    count_tot[Rcount-1]+=1024; count_tot[Rcount-2]-=1024;}
   // CREATE FILE NAMES
   filename(file_route, miss_file, cln1_file, path, NumRout[Rcount-1], name);			 
   strncpy(cln1_kadr,cln1_file,strlen(cln1_file)-3);
   cln1_kadr[strlen(cln1_file)-3]='\0';
   strcat(cln1_kadr,"bin");
   strncpy(log_kadr,file_route,strlen(file_route)-6);
   log_kadr[strlen(file_route)-6]='\0';
   strcat(log_kadr,"_bin.log");
   fclose(foRout);                    //Close files 
   fo_cln1.close();                   //for old
   fclose(foMiss);                    //route
   fokadr_cln1.close();
   fclose(fo_log_kadr);
   //Open files for new route
   foRout=fopen(file_route, "wb");          //nnnnn_mmm_xxx_cln1Er.log
   foMiss=fopen(miss_file, "wb");           //nnnnn_mmm_xxx_mis_cln1.dat    
   fo_cln1.open(cln1_file, ios::binary);    //nnnnn_mmm_xxx_cln1.pam
   fokadr_cln1.open(cln1_kadr,ios::binary); //nnnnn_mmm_xxx_cln1.bin
   fo_log_kadr=fopen(log_kadr,"wb");        //nnnnn_mmm_xxx_cln1_bin.log
   if ((CRC_bad_kadr[2]==numP[2])&&(numP[2]!=0)) {Num_bad_kadrs[Rcount-1]+=1; Num_bad_kadrs[Rcount-2]-=1;}
   if ((CRC_bad_kadr[1]==numP[1])&&(numP[1]!=0))
   {Num_bad_kadrs[Rcount-1]+=1; Num_bad_kadrs[Rcount-2]-=1;
    flags=(short int)(pow((float)(2*flag_name[1]),4)+
	       pow((float)(2*flag_rout[1]),1)+
	       pow((float)(2*flag_pack[1]),2)+
	       pow((float)(2*flag_CRC0[1]),3)+
	       pow((float)(2*flag_CRC[1]),5)+
	       pow((float)(2*flag_CRC_cor[1]),6));
    fprintf(foRout,"%1c%1c%1c%1c",(char)(buffer2[4]),(char)(buffer2[5]),(char)(buffer2[6]),(char)(flags));
    fo_info<<"New route: cadre="<<CRC_bad_kadr[1]<<" error flag="<<flags<<"\n";
    CRC_bad_kadr[1]-=1;}
  }
  
  if (((numP[1]==0)&&(N1>1))||(N1==2))
  {rr=0;
   FindRoute(buffer2, &rr);
   if (rr>0)
   {
    real_route[Rcount]=rr;
   }
   else
   {
    real_route[Rcount]=0;
   }
  }   
  /***************************************************************/
  if (CRC_bad_kadr[1]==numP[1])
  {
   //Correct CRC0 error/////////////////////////////////////////////////
   if (flag_CRC0[1]!=0)
   {
    buffer2[7]=buffer1[1023];
    if (buffer2[1023]==(int)(CRC(buffer2))) flag_CRC_cor[1]=1;
   }
   //Correct name error/////////////////////////////////////////////////
   if (flag_name[1]!=0)
   {buffer2[0]=(int)(CODE1);
    buffer2[1]=(int)(CODE2);
    buffer2[2]=(int)(CODE3);
    if (buffer2[1023]==(int)(CRC(buffer2))) flag_CRC_cor[1]=1;
   }
  }
  ////////////////////////////////////////////////////////////////////
  /*******************************************************************/
  if ((CRC_bad_kadr[1]==numP[1])&&(numP[1]!=0)&&(N1>1))
  {
   flags=(short int)(pow((float)(2*flag_name[1]),4)+
    	             pow((float)(2*flag_rout[1]),1)+
	                 pow((float)(2*flag_pack[1]),2)+
		             pow((float)(2*flag_CRC0[1]),3)+
			         pow((float)(2*flag_CRC[1]),5)+
			         pow((float)(2*flag_CRC_cor[1]),6));
   fprintf(foRout,"%1c%1c%1c%1c",(char)(buffer2[4]),
           (char)(buffer2[5]),(char)(buffer2[6]),(char)(flags));
   fo_info<<"CRC error in cadre "<<CRC_bad_kadr[1]<<" error flag="<<flags<<"\n";}
 
  /***************************************************************/
  //*Packet analysis**********************************************
  if (N_er!=0) fo_info<<"Name error "<<N_er<<" in cadre "<<numP[2]<<"\n";
  if (P_er!=0) fo_info<<"Number packet error "<<numP[1]<<" in cadre "<<P_er<<"\n";
  if (CRC0_er!=0) fo_info<<"CRC0 error "<<numP[1]<<" in cadre "<<CRC0_er<<"\n";

  /***************PAMELA data extracting for each route***********/
//  if (N1!=1&&(flag_CRC[1]==0||(flag_rout[1]==0&&flag_pack[1]==0)||
//	  (flag_CRC[1]!=0&&flag_CRC_cor[1]==1))) 
  if ((N1!=1)&&(flag_tr[1]==0))
  {end=0;
   if (buffer2[3]!=buffer1[3]||buffer2[3]!=buffer3[3])
   {for (i=8;i<1020;i++)
    {
//     if (fmodf(float((Num_kadrs[Rcount-1]-1)*1015+i-8),float(64))==0.&&buffer2[i]==0&&buffer2[i+1]==0&&
//   	     buffer2[i+2]==0&&buffer2[i+3]==0) end=1;
     if (end!=1) fo_cln1<<(unsigned char)buffer2[i];
    }
    if (end!=1) for(i=1020;i<1023;i++) {fo_cln1<<(unsigned char)buffer2[i];}
   }
   else {for(i=8;i<1023;i++) fo_cln1<<(unsigned char)buffer2[i];}
   for (i=0;i<1024;i++) {fokadr_cln1<<(unsigned char)buffer2[i];}
   //Write in file nnnnn_mmm_xxx_cln1_bin.log
   tmp=numP[1]; 
   for (k=0;k<4;k++) numPack[k]=0;
   for (k=0;k<3;k++)
   {if (tmp/(long int)(pow(256.,2-k))>=1) 
	{numPack[2-k]=(int)(tmp/(long int)(pow(256.,2-k)));
	 tmp=tmp-(long int)pow(256.,2-k)*(int)(tmp/(long int)(pow(256.,2-k)));}}	
   for (i=0;i<3;i++) fputc((int)(unsigned char)(numPack[i]),fo_log_kadr);
   adr1=icount-1024*2; 
   for (k=0;k<4;k++) adress[k]=0;
   for (k=0;k<4;k++)
   {if (adr1/(long int)(pow(256.,3-k))>=1) 
	{adress[3-k]=(int)(adr1/(long int)(pow(256.,3-k)));
	 adr1=adr1-(long int)pow(256.,3-k)*
	 (int)(adr1/(long int)(pow(256.,3-k)));}}	
   for (i=0;i<4;i++) fputc((int)(unsigned char)(adress[i]),fo_log_kadr);
   adr2=icount-1024;
   for (k=0;k<4;k++) adress[k]=0;
   for (k=0;k<4;k++)
   {if (adr2/(long int)(pow(256.,3-k))>=1) 
    {adress[3-k]=(int)(adr2/(long int)(pow(256.,3-k)));
	 adr2=adr2-(long int)pow(256.,3-k)*
	 (int)(adr2/(long int)(pow(256.,3-k)));}}
   for (i=0;i<4;i++) fputc((int)(unsigned char)(adress[i]),fo_log_kadr);
   fputc(flags,fo_log_kadr);
  }
 }
/***************************************************************/
/***************************************************************/
 if (flag_CRC[2]==0||(flag_rout[2]==0&&flag_pack[2]==0)||
     (flag_CRC[2]!=0&&flag_CRC_cor[2]==1)) 
 {end=0;
  for (i=0;i<1024;i++) fokadr_cln1<<(unsigned char)buffer3[i];
  //Write in file nnnnn_mmm_xxx_cln1_bin.log
  tmp=numP[2];
  for (k=0;k<4;k++) numPack[k]=0;
  for (k=0;k<3;k++)
   {if (tmp/(long int)(pow(256.,2-k))>=1) 
    {numPack[2-k]=(int)(tmp/(long int)(pow(256.,2-k)));
     tmp=tmp-(long int)pow(256.,2-k)*
     (int)(tmp/(long int)(pow(256.,2-k)));}}	
   for (i=0;i<3;i++) fputc((int)(unsigned char)(numPack[i]),fo_log_kadr);
   adr1=icount-1024; 
   for (k=0;k<4;k++) adress[k]=0;
   for (k=0;k<4;k++)
   {if (adr1/(long int)(pow(256.,3-k))>=1) 
    {adress[3-k]=(int)(adr1/(long int)(pow(256.,3-k)));
     adr1=adr1-(long int)pow(256.,3-k)*
     (int)(adr1/(long int)(pow(256.,3-k)));}}	
   for (i=0;i<4;i++) fputc((int)(unsigned char)(adress[i]),fo_log_kadr);
   adr2=icount;
   for (k=0;k<4;k++) adress[k]=0;
   for (k=0;k<4;k++)
   {if (adr2/(long int)(pow(256.,3-k))>=1) 
    {adress[3-k]=(int)(adr2/(long int)(pow(256.,3-k)));
     adr2=adr2-(long int)pow(256.,3-k)*
     (int)(adr2/(long int)(pow(256.,3-k)));}}
   for (i=0;i<4;i++) fputc((int)(unsigned char)(adress[i]),fo_log_kadr);
   fputc(flags,fo_log_kadr);

  for (i=8;i<1019;i++)
	{
//	 if (fmodf(float((Num_kadrs[Rcount-1]-1)*1015+i-8),
//		 float(64))==0.&&buffer3[i]==0&&buffer3[i+1]==0&&
//		 buffer3[i+2]==0&&buffer3[i+3]==0&&buffer3[i+4]==0) end=1;
         if (end!=1) fo_cln1<<(unsigned char)buffer3[i];
	}
  if (end!=1) {for(i=1019;i<1023;i++) {fo_cln1<<(unsigned char)buffer3[i];}}
 }

 icount_int = (int)(icount/1024);
 icount_frac= icount%1024;

//***protocol file***********************************************
 file_length=(int)(strlen(name));
 fprintf(fo,"file name=/home/ntsomz/downlinks/%s\n",name);
 fprintf(fo,"file size= %i,%i kByte \n", icount_int, icount_frac);
 fprintf(fo,"number identified cadres= %i\n", N1);
 fprintf(fo,"number of routes= %i\n", Rcount); 

 for(i=0;i<5;i++) {temp[i]=name[i]; temp[5]='\0';}
 sscanf(temp,"%5d", &cirquit_no);
 for(i=0;i<3;i++) {temp[i]=name[i+5]; temp[3]='\0';}
 sscanf(temp,"%3i", &route);
  
 for (i=0;i<Rcount;i++) 
 {
  for(j=0;j<22;j++) temp[j]=cln1_file[j+strlen(cln1_file)-22]; 
  temp[22]='\0';
  oss.str("");
  oss << "INSERT INTO RAW_FILES (cirquit_n, route_n, counter, NumCadr, CRCerr, cln1_name, cln1_size)"
  << " VALUES ("<< cirquit_no << ","<< route << ","<< i+1 <<","<< Num_kadrs[i]<< "," << Num_bad_kadrs[i] << ",'"
  << temp << "'," << count_ident[i]-Num_kadrs[i]*9 << ")"; 
  if (print_flag>0) cout<<oss.str().c_str()<<" table RAW_FILES\n";       
  TSQLResult *res=sqlServer->Query(oss.str().c_str());
 
  Num_good_kadrs[i]=Num_kadrs[i]-Num_bad_kadrs[i];
  if (packet_first[i]>1) 
  {first_missed[i]=(float)(1.)-float(packet_first[i]-1.)/(float)(packet_last[i]);}
  else if (packet_first[i]==0)
  {first_missed[i]=1.;}
  

  quality[i]=(float)(1.)-(float)(Num_bad_kadrs[i])/(float)(Num_kadrs[i]);
  fprintf(fo,"\nRoute number=%i: number of normal cadres= %i: number of errors=%i; \n",NumRout[i],Num_good_kadrs[i],Num_bad_kadrs[i]); 
  fprintf(fo,"size of identified cadres =%lli bytes;",count_ident[i]);
  fprintf(fo," total size of route=%lli bytes;\n",count_tot[i]);
  fprintf(fo,"first cadre number= %lli:", packet_first[i]);
  fprintf(fo," last cadre number= %lli:", packet_last[i]);
  fprintf(fo," Number of missed cadres= %lli:\n", count_missed[i]);  
  fprintf(fo,"number of identified cadres=%lli: quality index=%f: completness=%f \n", Num_kadrs[i], quality[i], 
          first_missed[i]);  
 }

 //***route's number log file**************************************
 for (i=0;i<Rcount;i++) {fprintf(fo_route,"%1c",(char)(NumRout[i]));}

	 
//***************************************************************
  fin.close();
  fclose(fout);  
  fo_info.close();
  fclose(fo);
  fclose(foRout);
  fclose(foMiss);
  fo_cln1.close();
  fclose(fo_log_kadr);
  fokadr_cln1.close();
  fclose(fo_route);
}

