/**
 * FTrkCalibQLook_EXPERT.cc
 *
 * autor: D.Fedele
 * version 2.0
 * Parameters:
 *      file - path of the root file to analyze (give at least this parameter)
 *      step - select =1 in order to analyze one event at time
 *      fromevent - first event to analyze
 *      toevent - last event to analyze
 *      outdir - total path of output file 
 * 	format - extension of output file (pdf,ps,gif,jpg)
 * 
 */
#include <TString.h>
#include <fcntl.h>

extern void FTrkCalibQLook_EXPERT(TString file, Int_t step, Int_t fromevent, Int_t toevent, TString outdir, TString format);
extern void info();

void usage(){   
  printf("\nUsage:\n FTrkCalibQLook_EXPERT file [OPTIONS] \n\n");
  printf("\t --help:       print this help and exit \n");
  printf("\t file:         path of the root file to analyze (give at least this parameter)  \n");
  printf("\nOPTIONS:\n");
  printf("\t -v:           be verbose \n");  
  printf("\t -step:        select =1 in order to analyze one event at time [default = 0] \n");
  printf("\t -fromev:      first event to analyze [default = 0] \n");
  printf("\t -toev:        last event to analyze  [default = 0] \n");
  printf("\t -outdir:      output directory [default = ./] \n");
  printf("\t -format:      format for output file (without . )[default = pdf] \n");
  printf("\nExamples:\n\tFTrkCalibQLook_EXPERT /home/pamela/filesfromyoda/DW_050523_01600.root -v \n\n");
  printf("\tFTrkCalibQLook_EXPERT /home/pamela/filesfromyoda/DW_050523_01600.root -v -format jpg\n\n");
  printf("\tFTrkCalibQLook_EXPERT /home/pamela/filesfromyoda/DW_050523_01600.root -v -format jpg -outdir ~/tmp/ \n\n");
}


int main(int argc,char* argv[]){
  
  TString FILE,OUTDIR="./",FORMAT="pdf";
  Int_t FROMEVENT=0,TOEVENT=0,STEP=0;
  bool beverbose = false;
  int nul = 0;

  
  if(argc>1){
    if ( !strcmp(argv[1],"--version") ){
      info();
      return(0);
    };
    if(!strcmp(argv[1], "-h") || !strcmp(argv[1], "--help") || argc>13){
      usage();
      return(0);
    }
    if ( (!strcmp(argv[1],"-v") || !strcmp(argv[1],"--verbose"))&& argc == 2 ){
      info();
      return(0);    
    }
    else {
      
      FILE = argv[1];
      for(int i=2; i<argc;i++){

      	if ( !strcmp(argv[i],"-v") || !strcmp(argv[i],"--verbose") )
	  beverbose = true;
		
	if (!strcmp(argv[i], "-outdir")){
	  if (++i >= argc || !strcmp(argv[i],"-v") || !strcmp(argv[i], "-format") || !strcmp(argv[i], "-fromev") || !strcmp(argv[i], "-toev") || !strcmp(argv[i], "-step")){
	    printf( "\n-outdir needs arguments. \n");
	    usage();
	    return(0);
	  } 
	  else{
	    OUTDIR = argv[i];
	    continue;
	  }
	}
	
	if (!strcmp(argv[i], "-step")){
	  if (++i >= argc || !strcmp(argv[i],"-v") || !strcmp(argv[i], "-format") || !strcmp(argv[i], "-fromev") || !strcmp(argv[i], "-toev") || !strcmp(argv[i], "-outdir")){
	    printf( "\n-step needs arguments. \n");
	    usage();
	    return(0);
	  } 
	  else{
	    STEP = atoi(argv[i]);
	    continue;
	  }
	}

	if (!strcmp(argv[i], "-fromev")){
	  if (++i >= argc || !strcmp(argv[i],"-v") || !strcmp(argv[i], "-format") || !strcmp(argv[i], "-outdir") || !strcmp(argv[i], "-toev") || !strcmp(argv[i], "-step")){
	    printf( "\n-fromev needs arguments. \n");
	    usage();
	    return(0);
	  } 
	  else{
	    FROMEVENT = atoi(argv[i]);
	    continue;
	  }
	}
	
	if (!strcmp(argv[i], "-toev")){
	  if (++i >= argc || !strcmp(argv[i],"-v") || !strcmp(argv[i], "-format") || !strcmp(argv[i], "-fromev") || !strcmp(argv[i], "-outdir") || !strcmp(argv[i], "-step")){
	    printf( "\n-toev needs arguments. \n");
	    usage();
	    return(0);
	  } 
	  else{
	    TOEVENT = atoi(argv[i]);
	    continue;
	  }
	}

	if (!strcmp(argv[i], "-format")){
	  if (++i >= argc || !strcmp(argv[i],"-v") || !strcmp(argv[i], "-outdir") || !strcmp(argv[i], "-fromev") || !strcmp(argv[i], "-toev") || !strcmp(argv[i], "-step")){
	    printf( "\n-format needs arguments. \n");
	    usage();
	    return(0);
	  } 
	  else{
	    FORMAT = argv[i];
	    continue;
	  }
	}
      }
    }
  }

  else if(argc==1){
    printf("\n\tYou have to insert at least the file to analyze \n");
    usage();
    return(0);
  }
  if ( !beverbose ){
    //
    // redirect to /dev/null the stdout and stderr
    //
    nul = open("/dev/null", O_CREAT | O_RDWR,S_IREAD | S_IWRITE);
    dup2(nul,1);
    dup2(nul,2);
  };
  printf("\n Welcome to FTrkCalibQLook_EXPERT! \n\n");
  //
  FTrkCalibQLook_EXPERT(FILE,STEP,FROMEVENT,TOEVENT,OUTDIR,FORMAT);
  //
  if ( !beverbose ) close(nul);
  return(0);
}
