/**
 * FTrkCalibQLookExpert.cxx
 *
 * autor: D.Fedele
 * version v1r13
 * Parameters:
 * 	file - the data file to analyze
 *      step - select =1 in order to analyze one event at time
 *      fromevent - first event to analyze
 *      toevent - last event to analyze
 *      outdir - total path of output file 
 * 	outfile - extension of output file (pdf,ps,gif,jpg)
 * 
 */
//
#include <iostream>
//
#include <TPaveText.h>
#include <TLatex.h>
#include <TCanvas.h>
#include <TFile.h>
#include <TTree.h>
#include <TGraph.h>
#include <TStyle.h>
#include <TString.h>
//
#include <PscuHeader.h>
#include <EventHeader.h>
#include <CalibTrk1Event.h>
#include <CalibTrk2Event.h>
//

typedef struct caltrk_def{
  Int_t good0[2];
  Int_t daqmode[12];
  Int_t dspnum[12];
  Int_t calibnum[12];
  Int_t ncalev[12];
  Int_t calfl[12];
  Int_t ped1[12];
  Int_t ped2[12];
  Int_t ped3[12];
  Int_t sig1[12];
  Int_t sig2[12];
  Int_t sig3[12];
  Int_t nbad1[12];
  Int_t nbad2[12];
  Int_t nbad3[12];
  Float_t dspped[12][3702];
  Float_t dspsig[12][3702];
  Float_t dspbad[12][3702];
  Int_t crc_c[12][3];
  Int_t crc_hc[12];
};


void FTrkCalibQLook_EXPERT(TString file,Int_t step,Int_t fromevent, Int_t toevent,TString outdir,TString outfile)
{  
  // 
  //   obtain information about the data file and select the output dir
  Int_t dwpos = file.Last('/');
  Int_t dwpos1 = file.Last('.');
  TString base,ffile ;
  ffile=file(dwpos+1,dwpos1-(dwpos+1));
  if(dwpos>0) base=file(0,dwpos);

  TString out;
  if(outdir.Length()==0){
    out = base;
  }else{
    out = outdir;
  }
  if(out.Last('/')+1<out.Length()) out+="/";

  //
  // inizialise the variables and open the file
  Int_t nevents=0;
  Int_t minevent = 0;
  Int_t maxevent = 0;
  ULong64_t FOBT[2];
  
  FOBT[0]=0;
  FOBT[1]=0;

  struct caltrk_def ctrk;
  ctrk.good0[0]=0;
  ctrk.good0[1]=0;
  for(Int_t i=0;i<12;i++){ 
    ctrk.daqmode[i]=0;
    ctrk.dspnum[i]=0;
    ctrk.calibnum[i]=0;
    ctrk.ncalev[i]=0;
    ctrk.calfl[i]=0;
    ctrk.ped1[i]=0;
    ctrk.ped2[i]=0;
    ctrk.ped3[i]=0;
    ctrk.sig1[i]=0;
    ctrk.sig2[i]=0;
    ctrk.sig3[i]=0;
    ctrk.nbad1[i]=0;
    ctrk.nbad2[i]=0;
    ctrk.nbad3[i]=0;
    ctrk.crc_c[i][0]=0;
    ctrk.crc_c[i][1]=0;
    ctrk.crc_c[i][2]=0;
    ctrk.crc_hc[i]=0;
    for(Int_t iii=0;iii<3072;iii++){
      ctrk.dspped[i][iii]=0;
      ctrk.dspsig[i][iii]=0;
      ctrk.dspbad[i][iii]=0;
    };
    
  };

  TFile *calibFile = new TFile(file);
  if ( !calibFile ){
    printf("No data file, exiting...\n");
    return;
  };
  TTree *otr1,*otr2,*hotr,*totr;
  pamela::EventHeader *eh1=0,*eh2=0,*eh4=0,*eh3=0;
  pamela::PscuHeader *ph=0;
  pamela::CalibTrk1Event *trk1 = 0;
  pamela::CalibTrk2Event *trk2 = 0;
  pamela::EventCounter *cod=0;	
  
  pamela::PacketType *pctp=0;  
  
  hotr = (TTree*)calibFile->Get("CalibHeader");
  hotr->SetBranchAddress("Header", &eh4);
  
  totr = (TTree*)calibFile->Get("CalibTrailer");
  totr->SetBranchAddress("Header", &eh3);

  otr1 = (TTree*)calibFile->Get("CalibTrk1");
  otr1->SetBranchAddress("CalibTrk1", &trk1);
  otr1->SetBranchAddress("Header",&eh1);
  otr2 = (TTree*)calibFile->Get("CalibTrk2");
  otr2->SetBranchAddress("CalibTrk2", &trk2);
  otr2->SetBranchAddress("Header",&eh2);
    
  if(otr1->GetEntries()==otr2->GetEntries())
    nevents = otr1->GetEntries();
  else{
    printf("WARNING: CalibTrk1 entries is different from CalibTrk2 entries");
    return;}
  if (nevents<=0) {
    calibFile->Close();
    printf("No calibration packets found, exiting...\n");
    return;
  };

  printf("Number of calibration packets: %i\n",nevents);

  if ( fromevent > toevent && toevent ){
    printf("It must be fromevent < toevent \n");
    return;
  };
    
  if ( fromevent > nevents || fromevent < 0 ) {
    printf("You can choose fromevent between 0 (all) and %i \n",nevents);
    return;
  };
    
  if ( toevent > nevents || toevent < 0 ) {
    printf("You can choose toevent between 0 (all) and %i \n",nevents);
    return;
  };
  if ( fromevent == 0 ) {
    minevent = 0;
    maxevent = nevents;
  } else {
    minevent = fromevent - 1;
    if ( toevent > 0 ){
      maxevent = toevent;
    } else if (toevent > nevents) {	   
      maxevent = nevents;
    } else {	   
      maxevent = nevents;
    };
  };
    
  //**********************************************************************
  //
  //   LOOP OVER EVENTS
  //
  //**********************************************************************
    
  Int_t hcevent=hotr->GetEntries();
  Int_t tcevent=totr->GetEntries();
  ULong64_t HOBT[hcevent], TOBT[tcevent];
  for (Int_t i = 0; i < hcevent; i++){ 
    hotr->GetEntry(i); 
    ph = eh4->GetPscuHeader();
    HOBT[i]= ph->GetOrbitalTime();
  }
  for (Int_t i = 0; i < tcevent; i++){ 
    totr->GetEntry(i); 
    ph = eh3->GetPscuHeader();
    TOBT[i]= ph->GetOrbitalTime();
  }
    
  printf("\n Scan of calibration packets from %i to %i ... \n\n",minevent+1,maxevent);
  for (Int_t i = minevent; i < maxevent; i++){     
     
    otr1->GetEntry(i); 
    otr2->GetEntry(i);
    
    ctrk.good0[0]=trk1->good0;
    ctrk.good0[1]=trk2->good0;
    for (Int_t m = 0; m < 6; m++){
      ph = eh1->GetPscuHeader();
      cod = eh1->GetCounter();
      FOBT[0]= ph->GetOrbitalTime();
      if(trk1->DSPnumber[m]>0){
	if(trk1->DSPnumber[m]<13){
	  ctrk.daqmode[trk1->DSPnumber[m]-1]=trk1->DAQmode[m];
	  ctrk.dspnum[trk1->DSPnumber[m]-1]=trk1->DSPnumber[m];
	  ctrk.calibnum[trk1->DSPnumber[m]-1]=trk1->calibnumber[m];
	  ctrk.ncalev[trk1->DSPnumber[m]-1]=trk1->ncalib_event[m];
	  ctrk.ped1[trk1->DSPnumber[m]-1]=trk1->ped_l1[m];
	  ctrk.ped2[trk1->DSPnumber[m]-1]=trk1->ped_l2[m];
	  ctrk.ped3[trk1->DSPnumber[m]-1]=trk1->ped_l3[m];
	  ctrk.sig1[trk1->DSPnumber[m]-1]=trk1->sig_l1[m];
	  ctrk.sig2[trk1->DSPnumber[m]-1]=trk1->sig_l2[m];
	  ctrk.sig3[trk1->DSPnumber[m]-1]=trk1->sig_l3[m];
	  ctrk.nbad1[trk1->DSPnumber[m]-1]=trk1->nbad_l1[m];
	  ctrk.nbad2[trk1->DSPnumber[m]-1]=trk1->nbad_l2[m];
	  ctrk.nbad3[trk1->DSPnumber[m]-1]=trk1->nbad_l3[m];
	  ctrk.calfl[trk1->DSPnumber[m]-1]=trk1->cal_flag[m];
	  ctrk.crc_c[trk1->DSPnumber[m]-1][0]=trk1->crc_cal[m][0];
	  ctrk.crc_c[trk1->DSPnumber[m]-1][1]=trk1->crc_cal[m][1];
	  ctrk.crc_c[trk1->DSPnumber[m]-1][2]=trk1->crc_cal[m][2];
	  ctrk.crc_hc[trk1->DSPnumber[m]-1]=trk1->crc_hcal[m];
	  for (Int_t j = 0; j < 3072; j++){
	    ctrk.dspped[trk1->DSPnumber[m]-1][j]=trk1->DSPped_par[m][j];
	    ctrk.dspsig[trk1->DSPnumber[m]-1][j]=trk1->DSPsig_par[m][j];
	    ctrk.dspbad[trk1->DSPnumber[m]-1][j]=trk1->DSPbad_par[m][j];
	  };
	}
      }
      ph = eh2->GetPscuHeader();
      FOBT[1]= ph->GetOrbitalTime();
      if(trk2->DSPnumber[m]>0){
	if(trk2->DSPnumber[m]<13){
	  ctrk.daqmode[trk2->DSPnumber[m]-1]=trk2->DAQmode[m];
	  ctrk.dspnum[trk2->DSPnumber[m]-1]=trk2->DSPnumber[m];
	  ctrk.calibnum[trk2->DSPnumber[m]-1]=trk2->calibnumber[m];
	  ctrk.ncalev[trk2->DSPnumber[m]-1]=trk2->ncalib_event[m];
	  ctrk.ped1[trk2->DSPnumber[m]-1]=trk2->ped_l1[m];
	  ctrk.ped2[trk2->DSPnumber[m]-1]=trk2->ped_l2[m];
	  ctrk.ped3[trk2->DSPnumber[m]-1]=trk2->ped_l3[m];
	  ctrk.sig1[trk2->DSPnumber[m]-1]=trk2->sig_l1[m];
	  ctrk.sig2[trk2->DSPnumber[m]-1]=trk2->sig_l2[m];
	  ctrk.sig3[trk2->DSPnumber[m]-1]=trk2->sig_l3[m];
	  ctrk.nbad1[trk2->DSPnumber[m]-1]=trk2->nbad_l1[m];
	  ctrk.nbad2[trk2->DSPnumber[m]-1]=trk2->nbad_l2[m];
	  ctrk.nbad3[trk2->DSPnumber[m]-1]=trk2->nbad_l3[m];
	  ctrk.calfl[trk2->DSPnumber[m]-1]=trk2->cal_flag[m];
	  ctrk.crc_c[trk1->DSPnumber[m]-1][0]=trk2->crc_cal[m][0];
	  ctrk.crc_c[trk1->DSPnumber[m]-1][1]=trk2->crc_cal[m][1];
	  ctrk.crc_c[trk1->DSPnumber[m]-1][2]=trk2->crc_cal[m][2];
	  ctrk.crc_hc[trk1->DSPnumber[m]-1]=trk2->crc_hcal[m];
	  for (Int_t j = 0; j < 3072; j++){
	    ctrk.dspped[trk2->DSPnumber[m]-1][j]=trk2->DSPped_par[m][j];
	    ctrk.dspsig[trk2->DSPnumber[m]-1][j]=trk2->DSPsig_par[m][j];
	    ctrk.dspbad[trk2->DSPnumber[m]-1][j]=trk2->DSPbad_par[m][j];
	  }
	}
      }
    }
              

    //
    // other variables definitions
    Int_t risposta=0;
    stringstream fromfile;

    fromfile<<"FTrkCalibQLook_EXPERT      File: "<<ffile<<"        -- CalibHeader OBT= "<<HOBT[(cod->Get(pctp->CalibHeader))-1]<<" -- Calib pkt OBT= "<<FOBT[0]<<" -- CalibTrailer OBT= "<<TOBT[(cod->Get(pctp->CalibTrailer))]<<" --";
    
    gStyle->SetLabelSize(0.07,"x");
    gStyle->SetLabelSize(0.07,"y");
    gStyle->SetTitleFillColor(10); 
    gStyle->SetTitleFontSize(0.08);
    gStyle->SetTitleOffset(0.8,"y");
    gStyle->SetTitleOffset(0.9,"x");
    gStyle->SetTitleSize(0.06,"y");
    gStyle->SetTitleSize(0.06,"x");
    gStyle->SetOptStat(101110);  
    gStyle->SetStatX(0.9);   
    gStyle->SetStatW(0.4);    
    gStyle->SetStatColor(10); 
    gStyle->SetStatFontSize(0.1);
    
    //
    //  draw display area

    TLatex *tzz=new TLatex();
    tzz->SetTextFont(32);
    tzz->SetTextColor(1);
    tzz->SetTextAlign(12);
    tzz->SetTextSize(0.019);
    Int_t canvasx=1200;
    Int_t canvasy=900;
    TCanvas *c1 = new TCanvas("c1","FTrkCalibQLook_EXPERT_ped",canvasx,canvasy);
    c1->SetFillColor(10);
    tzz->DrawLatex(.01,0.98,fromfile.str().c_str());
    tzz->DrawLatex(.90,0.98,"PEDESTAL");
    TCanvas *c2 = new TCanvas("c2","FTrkCalibQLook_EXPERT_sig",canvasx,canvasy);
    c2->SetFillColor(10);
    tzz->DrawLatex(.01,0.98,fromfile.str().c_str());
    tzz->DrawLatex(.90,0.98,"SIGMA");

   
    TCanvas *sig=new TCanvas("sig","FTrkCalibQLook_EXPERT_histosig",canvasx,canvasy);
    sig->SetFillColor(10);
    tzz->DrawLatex(.01,0.98,fromfile.str().c_str());
    tzz->DrawLatex(.85,0.97,"Histograms of the sigmas");
    


    //  draw pads
    TPad *trkpad1[12],*trkpad2[12],*trkpad3[36];        //pad for histos
    TPaveText *trkpadtext[12]; //pad for header
    TH1F *histosig[12];           //histos of sigma 
    TH1F *histoped[12];          //histos of pedestals  
    TH1F *histoasig[12];           //histos of sigma 
    TH1F *histoaped[12];          //histos of pedestals

    TH1F *histosiglad[12][3];           //histos of sigma 
    stringstream title;
    stringstream hid;
    
    Float_t posy = 0.95;    // up y-coord - top pads
    Float_t hpad = 0.15;   // pad height
    Float_t posx1=0;          // left  x-coord - pad column
    Float_t posx2=0;          // right x-coord - pad olumn
    Float_t posx0=0;          //       x-coord - column division
    Float_t wrel = 0.6;     // relative x size of first sub-column
    Float_t marg = 0.004;   // margin among pads

    
    for(Int_t n = 0; n<12; n++){
      if ( (n+1)%2 ) {
	if(n>1)posy = posy-(marg*2+hpad);
	posx1 = marg;
	posx2 = 0.5 - marg;
	posx0 = 0.5*wrel;

      } else {
	posx1 = posx1 + 0.5;
	posx2 = posx2 + 0.5;
	posx0 = posx0 + 0.5;

      };
      /* -----------> pad for histograms  */
      trkpad1[n] = new TPad("pad1"," ",posx1,posy-hpad,posx0-marg,posy,18,0,0);
      trkpad2[n] = new TPad("pad2"," ",posx1,posy-hpad,posx0-marg,posy,18,0,0);
      /* -----------> pad for header dump */
      trkpadtext[n] = new TPaveText((posx0+marg),(posy-hpad),posx2,posy);
      /* -----------> HISTOGRAMS          */
      /* calibration parameters */
      title<<"DSP "<<n+1;
      hid<<"h"<<n<<"i"<<i;
      histosig[n] = new TH1F(hid.str().c_str(),title.str().c_str(),3072,0.5,3072.5);
      hid.str("");
      hid<<"hh"<<n<<"i"<<i;
      histoped[n] = new TH1F(hid.str().c_str(),title.str().c_str(),3072,0.5,3072.5);
      hid.str("");
      hid<<"hhh"<<n<<"i"<<i;
      hid.str("");
      /* AVERAGE calibration parameters */    
      hid<<"ah"<<n<<"i"<<i;
      histoasig[n] = new TH1F(hid.str().c_str(),title.str().c_str(),3,0.5,3072.5);
      hid.str("");
      hid<<"ahh"<<n<<"i"<<i;
      histoaped[n] = new TH1F(hid.str().c_str(),title.str().c_str(),3,0.5,3072.5);
      hid.str("");
      for(int ii=0;ii<3;ii++){
	title.str("");
	title<<"DSP "<<n+1<<" / Lad "<<ii+1;
	hid<<"hhhh"<<n<<"i"<<i<<"ii"<<ii;
	histosiglad[n][ii] = new TH1F(hid.str().c_str(),title.str().c_str(),32,-0.5,30.5);
	hid.str("");
      }
      title.str("");
    };                     //end loop on views
    
    Float_t tposy = 0.95;    // up y-coord - top pads
    Float_t thpad = 0.;   // pad height
    Float_t tposx1=0;          // left  x-coord - pad column
    Float_t tposx0=0;          //       x-coord - column division
    Float_t twrel = 0.;     // relative x size of first sub-column
    Float_t tmarg = 0.002;   // margin among pads
    thpad = (tposy-tmarg*11)/6;
    twrel = (1-tmarg*12)/6;

    for(Int_t n = 0; n<36; n++){
      if ( (n+1)%6==1 ) {
	if(n>1) tposy = tposy-(tmarg*2+thpad);
	tposx1 = tmarg;
	tposx0 = tposx1 + twrel;
      } else {
	tposx1 = tposx0 + 2*tmarg;
	tposx0 = tposx1 + twrel;
      }
      trkpad3[n]= new TPad("pad3"," ",tposx1,tposy-thpad,tposx0,tposy,18,0,0);
    }
    
  
    stringstream message;
  
    //--------------------------------
    //CHECK CALIBRATION procedure
    //--------------------------------
    Int_t nn=0;
    Int_t calok = 0;//BAD  
    for(Int_t n = 0; n<12; n++){
      if(ctrk.ncalev[n]==0 && ctrk.calfl[n]==0)calok = 1;//GOOD
    
      
      nn=ctrk.dspnum[n]-1;
      /*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*
       *
       * Write event LEVEL0 report
       *
       *.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*/
      trkpadtext[nn]->SetTextFont(40);
      trkpadtext[nn]->SetFillColor(33);
      if(calok==0)trkpadtext[nn]->SetFillColor(2);
      trkpadtext[nn]->SetTextSize(0.013);
      trkpadtext[nn]->SetTextAlign(13);
      trkpadtext[nn]->SetTextColor(1);
      
      trkpadtext[nn]->AddText(" ");
      message<<"DSP num -------->  "<<ctrk.dspnum[n];
      trkpadtext[nn]->AddText(message.str().c_str());
      message.str("");
      message<<"DAQ mode -------> "<<ctrk.daqmode[n];
      trkpadtext[nn]->AddText(message.str().c_str());
      message.str("");
      message<<"Calibnumber ----> "<<ctrk.calibnum[n];
      trkpadtext[nn]->AddText(message.str().c_str());
      message.str("");
      message<<"ncalib_event ---> "<<ctrk.ncalev[n];
      trkpadtext[nn]->AddText(message.str().c_str());
      message.str("");
      message<<"Cal_flag -------> "<<ctrk.calfl[n];
      trkpadtext[nn]->AddText(message.str().c_str());
      message.str("");
      message<<"crc_hcal -------> "<<ctrk.crc_hc[n];
      trkpadtext[nn]->AddText(message.str().c_str());
      message.str("");
      message<<"crc_cal: l1-  ";message.width(5);message<< ctrk.crc_c[n][0];
      message<<"       l2-  ";message.width(5);message<< ctrk.crc_c[n][1];
      message<<"       l3-  ";message.width(5);message<< ctrk.crc_c[n][2];
      trkpadtext[nn]->AddText(message.str().c_str());
      message.str("");
      message<<"<PED>: l1- "; message.width(5);message<< ctrk.ped1[n];
      message<<"     l2-";        message.width(5);message<< ctrk.ped2[n];
      message<<"     l3-";        message.width(5);message<< ctrk.ped3[n];
      trkpadtext[nn]->AddText(message.str().c_str());
      message.str("");
      message<<"<SIG>: l1- "; message.width(5);message<< ctrk.sig1[n];
      message<<"     l2-";        message.width(5);message<< ctrk.sig2[n];
      message<<"     l3-";        message.width(5);message<< ctrk.sig3[n];
      trkpadtext[nn]->AddText(message.str().c_str());
      message.str("");
      message<<"n.BAD: l1- "; message.width(5);message<<ctrk.nbad1[n];
      message<<"     l2-";        message.width(5);message<< ctrk.nbad2[n];
      message<<"     l3-";        message.width(5);message<< ctrk.nbad3[n];
      trkpadtext[nn]->AddText(message.str().c_str());
      message.str("");
      
      if(calok==0){
	
	message.str("*** FAILED ***");
	TText *t=trkpadtext[nn]->AddText(message.str().c_str());            
	t->SetTextSize(0.02);
	t->SetTextAlign(23);
	t->SetTextColor(5);
      };
      
      /*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*
       *
       * Plot  histo
       *
       *.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*.*/

      
      /******************************************************/
      /* fill histos */
      for(Int_t j = 0; j < 3072; j++){
	histosig[nn]->Fill((Float_t)j,ctrk.dspsig[nn][j]);
	histoped[nn]->Fill((Float_t)j,ctrk.dspped[nn][j]);
	if(j<1024) histosiglad[nn][0]->Fill(ctrk.dspsig[nn][j]);
	if(j>=1024 && j<2048) histosiglad[nn][1]->Fill(ctrk.dspsig[nn][j]);
	if(j>=2048 && j<3072) histosiglad[nn][2]->Fill(ctrk.dspsig[nn][j]);
      };
      histoasig[nn]->Fill(1,ctrk.sig1[nn]);
      histoasig[nn]->Fill(1025,ctrk.sig2[nn]);
      histoasig[nn]->Fill(2049,ctrk.sig3[nn]);
      histoaped[nn]->Fill(1,ctrk.ped1[nn]);
      histoaped[nn]->Fill(1025,ctrk.ped2[nn]);
      histoaped[nn]->Fill(2049,ctrk.ped3[nn]);
      /******************************************************/
      
      TLine li;
      li.SetLineColor(38);
      li.SetLineStyle(3);
      li.SetLineWidth(2);
      
      Float_t maxhist=0;
      TBox b;
      /* plot PEDESTAL */
      c1->cd();
      trkpadtext[nn]->Draw();
      trkpad1[nn]->Draw();
      trkpad1[nn]->cd();
      trkpad1[nn]->SetFillColor(10);
      trkpad1[nn]->SetFrameFillColor(10);
      histoped[nn]->SetStats(kFALSE);
      histoped[nn]->SetLineColor(1);
      histoped[nn]->SetFillColor(12);
      histoped[nn]->SetLineWidth(1);
      histoped[nn]->GetYaxis()->SetTitle("PED (ADC channels)");
      histoped[nn]->GetYaxis()->CenterTitle();
      if((nn+1)%2==1)  histoped[nn]->GetYaxis()->SetRangeUser(2200,3200);
      if((nn+1)%2==0)  histoped[nn]->GetYaxis()->SetRangeUser(700,1700);
      histoaped[nn]->SetLineColor(5);
      histoaped[nn]->SetLineWidth(1);
      if(ctrk.good0[0]==1 && ctrk.good0[1]==1){
	histoped[nn]->Draw("b");
	if(nn==1){
	  maxhist=histoped[nn]->GetMaximum();
	  b.SetFillColor(6);
	  b.SetFillStyle(3945);
	  b.DrawBox(2944.,700.,3060.,maxhist);

	  b.SetFillColor(107);
	  b.SetFillStyle(3954);
	  b.DrawBox(2816.,700.,2944.,maxhist);
	  b.DrawBox(2048.,700.,2176.,maxhist);
	}
	else if(nn==4){
	  maxhist=histoped[nn]->GetMaximum();
	  b.SetFillColor(107);
	  b.SetFillStyle(3954);
	  b.DrawBox(384.,2200.,512.,maxhist);
	}
	else if(nn==6){
	  maxhist=histoped[nn]->GetMaximum();
	  b.SetFillColor(6);
	  b.SetFillStyle(3945);
	  b.DrawBox(2560.,2200.,2816.,maxhist);
	  b.DrawBox(1024.,2200.,1535.,maxhist);
	  
	  b.SetFillColor(107);
	  b.SetFillStyle(3954);
	  b.DrawBox(512.,2200.,768.,maxhist);
	  b.DrawBox(1536.,2200.,1792.,maxhist);
	}
	else if(nn==7){
	  maxhist=histoped[nn]->GetMaximum();
	  b.SetFillColor(107);
	  b.SetFillStyle(3954);
	  b.DrawBox(512.,700.,768.,maxhist);
	}
	else if(nn==9){
	  maxhist=histoped[nn]->GetMaximum();
	  b.SetFillColor(107);
	  b.SetFillStyle(3954);
	  b.DrawBox(256.,700.,384.,maxhist);
	}
	else if(nn==11){
	  maxhist=histoped[nn]->GetMaximum();
	  b.SetFillColor(6);
	  b.SetFillStyle(3945);
	  b.DrawBox(768.,700.,1024.,maxhist);
	  
	  b.SetFillColor(107);
	  b.SetFillStyle(3954);
	  b.DrawBox(0.,700.,512.,maxhist);
	  b.DrawBox(1920.,700.,2048.,maxhist);
	  b.DrawBox(2176.,700.,2304.,maxhist);
	}
      }
      else histoped[nn]->Draw("axis");
      histoaped[nn]->Draw("same");
      if((nn+1)%2==1) {
	li.DrawLine(1024.5,2200,1024.5,3200);
	li.DrawLine(2048.5,2200,2048.5,3200);
      }
      if((nn+1)%2==0) {
	li.DrawLine(1024.5,700,1024.5,1700);
	li.DrawLine(2048.5,700,2048.5,1700);
      }
      
 
      
      /* plot SIGMA */
      Float_t max=500.;
      c2->cd();
      trkpadtext[nn]->Draw();
      trkpad2[nn]->SetLogy();
      trkpad2[nn]->Draw();
      trkpad2[nn]->cd();
      trkpad2[nn]->SetFillColor(10);
      trkpad2[nn]->SetFrameFillColor(10);
      histosig[nn]->SetStats(kFALSE);
      histosig[nn]->SetLineColor(1);
      histosig[nn]->SetFillColor(12);
      histosig[nn]->SetLineWidth(1);
      histosig[nn]->SetMaximum(max);
      histosig[nn]->SetMinimum(0.5);
      histosig[nn]->GetYaxis()->SetTitle("SIG (ADC channels)");
      histosig[nn]->GetYaxis()->CenterTitle();
      histoasig[nn]->SetLineColor(5);
      histoasig[nn]->SetLineWidth(1);
      if(ctrk.good0[0]==1 && ctrk.good0[1]==1){
	histosig[nn]->Draw("b");
	if(nn==1){
	  maxhist=histosig[nn]->GetMaximum();
	  b.SetFillColor(6);
	  b.SetFillStyle(3945);
	  b.DrawBox(2944.,0.,3060.,maxhist);

	  b.SetFillColor(107);
	  b.SetFillStyle(3954);
	  b.DrawBox(2816.,0.,2944.,maxhist);
	  b.DrawBox(2048.,0.,2176.,maxhist);
	}
	else if(nn==4){
	  maxhist=histosig[nn]->GetMaximum();
	  b.SetFillColor(107);
	  b.SetFillStyle(3954);
	  b.DrawBox(384.,0.,512.,maxhist);
	}
	else if(nn==6){
	  maxhist=histosig[nn]->GetMaximum();
	  b.SetFillColor(6);
	  b.SetFillStyle(3945);
	  b.DrawBox(2560.,0.,2816.,maxhist);
	  b.DrawBox(1024.,0.,1535.,maxhist);
	  
	  b.SetFillColor(107);
	  b.SetFillStyle(3954);
	  b.DrawBox(512.,0.,768.,maxhist);
	  b.DrawBox(1536.,0.,1792.,maxhist);
	}
	else if(nn==7){
	  maxhist=histosig[nn]->GetMaximum();
	  b.SetFillColor(107);
	  b.SetFillStyle(3954);
	  b.DrawBox(512.,0.,768.,maxhist);
	}
	else if(nn==9){
	  maxhist=histosig[nn]->GetMaximum();
	  b.SetFillColor(107);
	  b.SetFillStyle(3954);
	  b.DrawBox(256.,0.,384.,maxhist);
	}
	else if(nn==11){
	  maxhist=histosig[nn]->GetMaximum();
	  b.SetFillColor(6);
	  b.SetFillStyle(3945);
	  b.DrawBox(768.,0.,1024.,maxhist);
	  
	  b.SetFillColor(107);
	  b.SetFillStyle(3954);
	  b.DrawBox(0.,0.,512.,maxhist);
	  b.DrawBox(1920.,0.,2048.,maxhist);
	  b.DrawBox(2176.,0.,2304.,maxhist);
	}
      }
      else histosig[nn]->Draw("axis");
      histoasig[nn]->Draw("same");
      li.DrawLine(1024.5,0,1024.5,max);
      li.DrawLine(2048.5,0,2048.5,max);
       
      for(int ii=0;ii<3;ii++){
	sig->cd();
	trkpad3[nn*3+ii]->Draw();
	trkpad3[nn*3+ii]->cd();
	trkpad3[nn*3+ii]->SetFillColor(10);
	trkpad3[nn*3+ii]->SetFrameFillColor(10);
	trkpad3[nn*3+ii]->SetLogy();
	histosiglad[nn][ii]->SetLineColor(1);
	histosiglad[nn][ii]->SetFillColor(1);
	histosiglad[nn][ii]->SetLineWidth(1);
	histosiglad[nn][ii]->GetXaxis()->SetTitle("SIG (ADC channels)");
	histosiglad[nn][ii]->GetXaxis()->CenterTitle();
	histosiglad[nn][ii]->Draw("");	
      }
    
    };//end loop on views
    c1->Update();//draw pads in canvas 
    c2->Update();//draw pads in canvas
    sig->Update();//draw pads in canvas 
    
    stringstream nom1,nom2,nom3;
    
    if(!strcmp(outfile.Data(),"ps")||!strcmp(outfile.Data(),"pdf")){
      nom1.str("");
      nom2.str("");
      nom3.str("");
      nom1<<out<<ffile<<"_FTrkCalibQLook_EXPERT-pkt"<<i+1<<".ps(";
      nom2<<out<<ffile<<"_FTrkCalibQLook_EXPERT-pkt"<<i+1<<".ps";
      nom3<<out<<ffile<<"_FTrkCalibQLook_EXPERT-pkt"<<i+1<<".ps)";
      c1->Print(nom1.str().c_str(),"Landscape");
      c2->Print(nom2.str().c_str(),"Landscape");
      sig->Print(nom3.str().c_str(),"Landscape");
      
      if(!strcmp(outfile.Data(),"pdf")){
	stringstream com;
	com<<"ps2pdf13 "<<out<<ffile<<"_FTrkCalibQLook_EXPERT-pkt"<<i+1<<".ps "<<out<<ffile<<"_FTrkCalibQlook_EXPERT-pkt"<<i+1<<".pdf";
	system(com.str().c_str());
	printf("\n---> ps file converted in pdf format!\n");
	com.str("");
	com<<"rm -f "<<out<<ffile<<"_FTrkCalibQLook_EXPERT-pkt"<<i+1<<".ps";
	system(com.str().c_str());
	printf("---> ps file removed!\n\n");
	com.str("");
      }
    }
    else{
      nom1.str("");
      nom2.str("");
      nom3.str("");
      nom1<<out<<ffile<<"_FTrkCalibQLook_EXPERT-ped-pkt"<<i+1<<"."<<outfile.Data();
      nom2<<out<<ffile<<"_FTrkCalibQLook_EXPERT-sig-pkt"<<i+1<<"."<<outfile.Data();
      nom3<<out<<ffile<<"_FTrkCalibQLook_EXPERT-histosig-pkt"<<i+1<<"."<<outfile.Data();
      c1->Print(nom1.str().c_str());
      c2->Print(nom2.str().c_str());
      sig->Print(nom3.str().c_str());
    } 
    
    if(step==1 && i!=maxevent-1 ){  
      printf("\n Press 1<enter> to continue, 2<enter> to quit.\n");
      cin>>risposta;
      if ( i != maxevent-1 ) {
	if ( risposta == 2 ) {
	  gROOT->Reset();
	  printf("Exiting...\n");
	  return;
	}
      }
    }
  };//end loop on events  
  
  gROOT->Reset();
  printf("... end of packets. \n");
  return;
}


