/**
 * FTrkScanQLook_EXPERT.cc
 *
 * autor: D.Fedele
 * version v1r..
 * Parameters:
 * 	file - the path to the root file to analyze
 *      outDir - total path of output file 
 *      event - the number of the single event to analyze
 *      va1 - the number of the single va1 to analyze
 * 	format - extension of output file (pdf,ps,gif,jpg)
 * 
 */
#include <TString.h>
#include <fcntl.h>
#include <unistd.h>
#include <cstdlib>
#include <sys/stat.h>
extern void FTrkScanQLook_EXPERT(TString file, TString outdir, Int_t event, Int_t va1, Int_t value, TString format);
extern void info();

void usage(){  
  printf("\nUsage:\n\n FTrkScanQLook_EXPERT file [OPTIONS] \n\n");
  printf("\t --help:       print this help and exit \n");
  printf("\t file:         path of the root file to analyze (give at least this parameter)  \n");
  printf("\nOPTIONS:\n");
  printf("\t -v            be verbose \n");  
  printf("\t -event:       which event to analyze [default = 0] (if negative analyze |event| events after a calibration)\n");  
  printf("\t -va1:         which va1 to analyze [default = 0] (the standard is: DSP*100+VA1)\n");   
  printf("\t -value:       number of events to store in the .dat file with va1 values*10 + # of calibration (if #of cal = 0, select all calibrations)\n"); 
  printf("\t -outDir:      path of the output directory [default = ./] (with or without final '/')\n");
  printf("\t -format:      format of the output file (without .) [default = pdf] (accepted formats: pdf, ps, png, jpg, gif)\n");
  printf("\nExamples:\n\tFTrkScanQLook_EXPERT /home/pamela/filesfromyoda/DW_xxxxxx_yyyy.root \n\n");
  printf("\tFTrkScanQLook_EXPERT /home/pamela/filesfromyoda/DW_xxxxxx_yyyy.root -v -va1 1123 -outDir ~/tmp/\n\n");
}

int main(int argc, char* argv[]){

  TString FILE,OUTDIR="./",FORMAT="pdf";
  Int_t EVENT=0,VA1=0,VALUE=0;
  bool beverbose = false;
  int nul = 0;

  if(argc>1){
    if ( !strcmp(argv[1],"--version") ){
      info();
      return(0);
    };
    if (!strcmp(argv[1], "-h") || !strcmp(argv[1], "--help") || argc>13){
      usage();
      return(0);
    }
    if ( (!strcmp(argv[1],"-v") || !strcmp(argv[1],"--verbose"))&& argc == 2 ){
      info();
      return(0);    
    }
    else {
      
      FILE = argv[1];
      for(int i=2; i<argc;i++){
	
      	if ( !strcmp(argv[i],"-v") || !strcmp(argv[i],"--verbose") )
	  beverbose = true;
	
	if (!strcmp(argv[i], "-outDir")){
	  if (++i >= argc || !strcmp(argv[i],"-v") || !strcmp(argv[i], "-format")||!strcmp(argv[i], "-event") || !strcmp(argv[i], "-value") || !strcmp(argv[i], "-va1")){
	    printf( "\n-outDir needs arguments. \n");
	    usage();
	    return(0);
	  } 
	  else{
	    OUTDIR = argv[i];
	    continue;
	  }
	}
	if (!strcmp(argv[i], "-format")){
	  if (++i >= argc || !strcmp(argv[i],"-v") || !strcmp(argv[i], "-outDir")||!strcmp(argv[i], "-event") || !strcmp(argv[i], "-value") || !strcmp(argv[i], "-va1")){
	    printf( "\n-format needs arguments. \n");
	    usage();
	    return(0);
	  } 
	  else{
	    FORMAT = argv[i];
	    continue;
	  }
	}

	if (!strcmp(argv[i], "-event")){
	  if (++i >= argc || !strcmp(argv[i],"-v") || !strcmp(argv[i], "-outDir")|| !strcmp(argv[i], "-format") || !strcmp(argv[i], "-va1") || !strcmp(argv[i], "-value")){
	    printf( "\n-event needs arguments. \n");
	    usage();
	    return(0);
	  } 
	  else{
	    EVENT = atoi(argv[i]);
	    continue;
	  }
	}

	if (!strcmp(argv[i], "-va1")){
	  if (++i >= argc || !strcmp(argv[i],"-v") || !strcmp(argv[i], "-outDir")|| !strcmp(argv[i], "-format") || !strcmp(argv[i], "-event") || !strcmp(argv[i], "-value")){
	    printf( "\n-va1 needs arguments. \n");
	    usage();
	    return(0);
	  } 
	  else{
	    VA1 = atoi(argv[i]);
	    continue;
	  }
	}	

	if (!strcmp(argv[i], "-value")){
	  if (++i >= argc || !strcmp(argv[i],"-v") || !strcmp(argv[i], "-outDir")|| !strcmp(argv[i], "-format") || !strcmp(argv[i], "-event") || !strcmp(argv[i], "-va1")){
	    printf( "\n-value needs arguments. \n");
	    usage();
	    return(0);
	  } 
	  else{
	    VALUE = atoi(argv[i]);
	    continue;
	  }
	}
	
	if( strcmp(argv[i], "-format") && strcmp(argv[i], "-outDir") && strcmp(argv[i],"-v") && strcmp(argv[i],"--verbose") && strcmp(argv[i], "-event") && strcmp(argv[i], "-va1") && strcmp(argv[i], "-value")){
	  printf( "\n------>Warning: WRONG OPTIONS!\n");
	  usage();
	  return(0);
	} 
      }
    }
  }

  else if(argc==1){
    printf("\n\tYou have to insert at least the file to analyze \n");
    usage();
    return(0);
  }
      
  
  if ( !beverbose ){
    //
    // redirect to /dev/null the stdout and stderr
    //
    nul = open("/dev/null", O_CREAT | O_RDWR,S_IREAD | S_IWRITE);
    dup2(nul,1);
    dup2(nul,2);
  };
  printf("\n Welcome to FTrkScanQLook! \n\n");
  //
  FTrkScanQLook_EXPERT(FILE,OUTDIR,EVENT,VA1,VALUE,FORMAT);
  //
  if ( !beverbose ) close(nul);
  return(0);
}
