/**
 * FTrkCalibQLook_BASIC.cc
 *
 * autor: D.Fedele
 * version v1r06
 * Parameters:
 *      file - path of the root file to analyze (give at least this parameter)
 *      fromevent - first event to analyze
 *      toevent - last event to analyze
 *      outDir - total path of output file 
 * 	format - extension of output file (pdf,ps,gif,jpg)
 * 
 */
#include <TString.h>
#include <fcntl.h>
#include <unistd.h>

extern void FTrkCalibQLook_BASIC(TString file, Int_t fromevent, Int_t toevent, TString outdir, TString format);
extern void info();

void usage(){  
  printf("\nUsage:\n FTrkCalibQLook_BASIC file [OPTIONS] \n\n");
  printf("\t --help:       print this help and exit \n");
  printf("\t file:         path of the root file to analyze (give at least this parameter)  \n");
  printf("\nOPTIONS:\n");
  printf("\t -v:           be verbose \n");  
  printf("\t -fromev:      first event to analyze [default = 0] \n");
  printf("\t -toev:        last event to analyze  [default = 0] \n");
  printf("\t -outDir:      path of the output directory [default = ./] (with or without final '/')\n");
  printf("\t -format:      format for output file (without . )[default = pdf] (accepted formats: pdf, ps, png, jpg, gif)\n");
  printf("\nExamples:\n\tFTrkCalibQLook_BASIC /home/pamela/filesfromyoda/DW_050523_01600.root -v \n\n");
  printf("\tFTrkCalibQLook_BASIC /home/pamela/filesfromyoda/DW_050523_01600.root -v -format jpg\n\n");
  printf("\tFTrkCalibQLook_BASIC /home/pamela/filesfromyoda/DW_050523_01600.root -v -format jpg -outDir ~/tmp/ \n\n");
}


int main(int argc, char* argv[]){
  
  TString FILE,OUTDIR="./",FORMAT="pdf";
  Int_t FROMEVENT=0,TOEVENT=0;
  bool beverbose = false;
  int nul = 0;

  if(argc>1){
    if ( !strcmp(argv[1],"--version") ){
      info();
      return(0);
    };
    if(!strcmp(argv[1], "-h") || !strcmp(argv[1], "--help") || argc>11){
      usage();
      return(0);
    }
    if ( (!strcmp(argv[1],"-v") || !strcmp(argv[1],"--verbose"))&& argc == 2 ){
      info();
      return(0);    
    }
    else {
      
      FILE = argv[1];
      for(int i=2; i<argc;i++){

      	if ( !strcmp(argv[i],"-v") || !strcmp(argv[i],"--verbose") )
	  beverbose = true;
		
	if (!strcmp(argv[i], "-outDir")){
	  if (++i >= argc || !strcmp(argv[i],"-v") || !strcmp(argv[i], "-format") || !strcmp(argv[i], "-fromev") || !strcmp(argv[i], "-toev")){
	    printf( "\n-outDir needs arguments. \n");
	    usage();
	    return(0);
	  } 
	  else{
	    OUTDIR = argv[i];
	    continue;
	  }
	}
	
	if (!strcmp(argv[i], "-fromev")){
	  if (++i >= argc || !strcmp(argv[i],"-v") || !strcmp(argv[i], "-format") || !strcmp(argv[i], "-toev") || !strcmp(argv[i], "-outDir")){
	    printf( "\n-fromev needs arguments. \n");
	    usage();
	    return(0);
	  } 
	  else{
	    FROMEVENT = atoi(argv[i]);
	    continue;
	  }
	}
	
	if (!strcmp(argv[i], "-toev")){
	  if (++i >= argc || !strcmp(argv[i],"-v") || !strcmp(argv[i], "-format") || !strcmp(argv[i], "-fromev") || !strcmp(argv[i], "-outDir")){
	    printf( "\n-toev needs arguments. \n");
	    usage();
	    return(0);
	  } 
	  else{
	    TOEVENT = atoi(argv[i]);
	    continue;
	  }
	}

	if (!strcmp(argv[i], "-format")){
	  if (++i >= argc || !strcmp(argv[i],"-v") || !strcmp(argv[i], "-fromev") || !strcmp(argv[i], "-toev") || !strcmp(argv[i], "-outDir")){
	    printf( "\n-format needs arguments. \n");
	    usage();
	    return(0);
	  } 
	  else{
	    FORMAT = argv[i];
	    continue;
	  }
	}

	if(strcmp(argv[i], "-format") && strcmp(argv[i], "-outDir") && strcmp(argv[i],"-v") && strcmp(argv[i],"--verbose") &&  strcmp(argv[i], "-fromev") && strcmp(argv[i], "-toev") ){
	  printf( "\n------>Warning: WRONG OPTIONS!\n");
	  usage();
	  return(0);
	} 
      }
    }
  }

  else if(argc==1){
    printf("\n\tYou have to insert at least the file to analyze \n");
    usage();
    return(0);
  }
  if ( !beverbose ){
    //
    // redirect to /dev/null the stdout and stderr
    //
    nul = open("/dev/null", O_CREAT | O_RDWR,S_IREAD | S_IWRITE);
    dup2(nul,1);
    dup2(nul,2);
  };
  printf("\n Welcome to FTrkCalibQLook_BASIC! \n\n");
  //
  FTrkCalibQLook_BASIC(FILE,FROMEVENT,TOEVENT,OUTDIR,FORMAT);
  //
  if ( !beverbose ) close(nul);
  return(0);
}
  
