#include <utils/yodaUtility.h>
#include "TrkFunctions.cpp"
#include <iostream>
#include <fstream>
#include <TPaveText.h>
#include <TLatex.h>
#include <TCanvas.h>
#include <TGraph.h>
#include <TStyle.h>
#include <TObjString.h>
#include <PscuHeader.h>
#include <EventHeader.h>
#include <CalibTrk1Event.h>
#include <CalibTrk2Event.h>


/**
 * readpedsig --> is a function to read the calculated mean value for
 *                sigma, variance of sigma, pedestal and variance of pedestal
 *                from the pedsig.root file and draw these values vs. the time
 *
 * autor: D.Fedele
 * version 1.0
 * Parameters:
 * 	file - the path to the root file to analyse
 *      outdir - total path of output file 
 * 
 */


void readpedsig(TString file,TString outdir)
{  
  // 
  //   obtain information about the data file and select the output dir
  const string filepath=file.Data(); 
  Int_t dwpos = filepath.find("pedsig");
  TString fpath=(filepath.c_str());
  TString base;
  stringcopy(base,fpath,0,dwpos);

  TString out;
  if(outdir.Length()==0){
    out = base;
  }else{
    out = outdir;
  };

  stringstream fromfile,rep,tit;
  fromfile<<"readpedsig from File: "<<file;

  //
  // Set some ROOT variables and create the canvases
  gStyle->SetFillColor(10); 
  gStyle->SetTitleFillColor(10); 
  gStyle->SetTitleFontSize(0.06);
  gStyle->SetOptStat(0);
  gStyle->SetLabelSize(0.05,"x");
  gStyle->SetLabelSize(0.05,"y");
  gStyle->SetLabelOffset(0.01,"x");
  gStyle->SetLabelOffset(0.01,"y");
  gStyle->SetTitleOffset(1.,"y");
  gStyle->SetTitleOffset(0.9,"x");
  gStyle->SetTitleSize(0.05,"y");
  gStyle->SetTitleSize(0.05,"x");

  TLatex *tzz=new TLatex();
  tzz->SetTextFont(32);
  tzz->SetTextColor(1);
  tzz->SetTextAlign(12);
  tzz->SetTextSize(0.02);

  Int_t canvasx=900;
  Int_t canvasy=1200;
  TCanvas *c[12][3][2];
  TCanvas *cb[12];

  for(Int_t i=0;i<12;i++){
    rep.str("");
    tit.str("");
    tit<<"readpedsig bad "<<i;
    rep<<"c["<<i<<"]";
    cb[i]=new TCanvas(rep.str().c_str(),tit.str().c_str(),canvasx,canvasy);
    cb[i]->Range(0,0,100,100);
    tzz->DrawLatex(1,98.5,fromfile.str().c_str());
    rep.str("");
    rep<<"number of BAD strip "<<"----> DSP "<<i+1;
    tzz->DrawLatex(65,98.5,rep.str().c_str());

    for(Int_t ii=0;ii<3;ii++){
      for(Int_t iii=0;iii<2;iii++){
	rep.str("");
	tit.str("");
	tit<<"readpedsig "<<i<<"-"<<ii<<"-"<<iii;
	rep<<"c["<<i<<"]["<<ii<<"]["<<iii<<"]";
	c[i][ii][iii] = new TCanvas(rep.str().c_str(),tit.str().c_str(),canvasx,canvasy);
	c[i][ii][iii]->Range(0,0,100,100);
	tzz->DrawLatex(1,98.5,fromfile.str().c_str());
	if(iii==0){
	  rep.str("");
	  rep<<"<SIG> e varianza "<<"----> DSP "<<i+1<<"   ladder "<<ii+1;
	  tzz->DrawLatex(60,98.5,rep.str().c_str());
	}
	else{
	  rep.str("");
	  rep<<"<PED> e varianza "<<"----> DSP "<<i+1<<"   ladder "<<ii+1;
	  tzz->DrawLatex(60,98.5,rep.str().c_str());
	}
      }
    }
  }

  //
  // inizialise the variables and open the file

  Int_t numbad[12][12];
  Float_t pedav[12][12],sigav[12][12];
  Float_t pedvar[12][12],sigvar[12][12];

  for(Int_t i=0;i<12;i++){
    for(Int_t ii=0;ii<12;ii++){
      pedav[i][ii]=0;
      sigav[i][ii]=0;
      pedvar[i][ii]=0;
      sigvar[i][ii]=0;
      numbad[i][ii]=0;
    }
  }
    
  TFile *pedsig = new TFile("/home/fedele/compiledScripts/pedsig.root");

  TTree *pstree = (TTree*)pedsig->Get("pstree");
  pstree->SetBranchAddress("pedav",pedav);
  pstree->SetBranchAddress("pedvar",pedvar);
  pstree->SetBranchAddress("sigav",sigav);
  pstree->SetBranchAddress("sigvar",sigvar);
  pstree->SetBranchAddress("numbad",numbad);

  Int_t totev=pstree->GetEntries();
  const Int_t nev=totev;

  Float_t pedavtemp[nev],sigavtemp[nev],pedvartemp[nev],sigvartemp[nev];
  Float_t x[nev];
  Float_t numbadtemp[nev];

  for(Int_t vii=0;vii<nev;vii++){
    x[vii]=0;
    pedavtemp[vii]= 0;
    pedvartemp[vii]= 0;
    sigavtemp[vii]=0;
    sigvartemp[vii]=0;
    numbadtemp[vii]=0;
  }
  
  //
  //  Create Pads and Graphs
  TPad *pad1[12][3][8];
  TPad *pad2[12][3][8];
  TPad *pad3[12][12];
  TGraph *histosigav[12][3][4];
  TGraph *histopedav[12][3][4];
  TGraph *histosigvar[12][3][4];
  TGraph *histopedvar[12][3][4];
  TGraph *histobad[12][12];

  Float_t posy = 0.95;    // up y-coord - top pads
  Float_t hpad = 0;   // pad height
  Float_t posx1=0;          // left  x-coord - pad column
  Float_t posx0=0;          //       x-coord - column division
  Float_t wrel = 0;     // relative x size of first sub-column
  Float_t marg = 0.004;   // margin among pads

  hpad = (posy-marg*7)/4;
  wrel = (1-marg*4)/2;
  
  for(Int_t n = 0; n<8; n++){
    if ( (n+1)%2==1 ) {
      if(n>1)posy = posy-(marg*2+hpad);
      posx1 = marg;
      posx0 = posx1 +wrel;
    } else {
      posx1 = posx0 + 2*marg;
      posx0 = posx1 + wrel;
    };
    for(Int_t i=0;i<12;i++){
      for(Int_t ii=0;ii<3;ii++){
	pad1[i][ii][n] = new TPad("pad1"," ",posx1,posy-hpad,posx0,posy,18,0,0);
	pad2[i][ii][n] = new TPad("pad2"," ",posx1,posy-hpad,posx0,posy,18,0,0);
      }
    }
  }  

  posy = 0.95;
  posx1=0;
  posx0=0;
  hpad = (posy-marg*11)/6;
  wrel = (1-marg*4)/2;
  
  for(Int_t n = 0; n<12; n++){
    if ( (n+1)%2==1 ) {
      if(n>1)posy = posy-(marg*2+hpad);
      posx1 = marg;
      posx0 = posx1 +wrel;
    } else {
      posx1 = posx0 + 2*marg;
      posx0 = posx1 + wrel;
    };
    for(Int_t i=0;i<12;i++){
	pad3[i][n] = new TPad("pad3"," ",posx1,posy-hpad,posx0,posy,18,0,0);
      }
  }  
  
  //**********************************************************************
  //
  //   LOOP OVER EVENTS
  //
  //**********************************************************************

  for(Int_t i=0;i<12;i++){
    for(Int_t ii=0;ii<3;ii++){      
      for(Int_t iv=0;iv<4;iv++){
	for(Int_t ev = 0; ev < nev; ev++){     
	  x[0]=1.;
	  pstree->GetEntry(ev); 
	  
	  //
	  // fill the graphs whit the right values
	  
	  if(ev>0)  x[ev]=x[ev-1]+1.;	      
	  pedavtemp[ev]= pedav[i][(ii*4)+iv];
	  pedvartemp[ev]= pedvar[i][(ii*4)+iv];
	  sigavtemp[ev]=sigav[i][(ii*4)+iv];
	  sigvartemp[ev]=sigvar[i][(ii*4)+iv];
	}
	  
	c[i][ii][1]->cd();
	pad1[i][ii][iv*2]->SetFillColor(10);
	pad1[i][ii][iv*2]->SetFrameFillColor(10);
	pad1[i][ii][iv*2]->Draw();
	pad1[i][ii][iv*2]->cd();
	tit.str("");
	histopedav[i][ii][iv] = new TGraph(nev,x,pedavtemp);
	tit<<"<PED> --> DSP "<<i+1<<" - VA1 pair # "<<iv+1;
	histopedav[i][ii][iv]->SetTitle(tit.str().c_str());
	histopedav[i][ii][iv]->GetXaxis()->SetTitle("time (arbitrary unit)");
	histopedav[i][ii][iv]->GetXaxis()->CenterTitle();
	histopedav[i][ii][iv]->GetYaxis()->SetTitle("<PED>");
	histopedav[i][ii][iv]->GetYaxis()->SetTitleOffset(1.1);
	histopedav[i][ii][iv]->GetYaxis()->CenterTitle();
	histopedav[i][ii][iv]->SetMarkerStyle(23);
	histopedav[i][ii][iv]->SetMarkerSize(0.4);
	histopedav[i][ii][iv]->SetMarkerColor(2);
	histopedav[i][ii][iv]->Draw("acp");
	tit.str("");
	c[i][ii][1]->Update();

	c[i][ii][1]->cd();
 	pad1[i][ii][iv*2+1]->SetFillColor(10);
 	pad1[i][ii][iv*2+1]->SetFrameFillColor(10);
 	pad1[i][ii][iv*2+1]->Draw();
 	pad1[i][ii][iv*2+1]->cd();
	tit.str("");
	histopedvar[i][ii][iv]= new TGraph(nev,x,pedvartemp);
	tit<<"VAR PED --> DSP "<<i+1<<" - VA1 pair # "<<iv+1;
	histopedvar[i][ii][iv]->SetTitle(tit.str().c_str());
	histopedvar[i][ii][iv]->GetXaxis()->SetTitle("time (arbitrary unit)");
	histopedvar[i][ii][iv]->GetXaxis()->CenterTitle();
	histopedvar[i][ii][iv]->GetYaxis()->SetTitle("VAR <PED>");
	histopedvar[i][ii][iv]->GetYaxis()->CenterTitle();
	histopedvar[i][ii][iv]->SetMarkerStyle(23);
	histopedvar[i][ii][iv]->SetMarkerSize(0.4);
	histopedvar[i][ii][iv]->SetMarkerColor(2);
	histopedvar[i][ii][iv]->Draw("acp");
	tit.str("");
	c[i][ii][1]->Update();
	
	c[i][ii][0]->cd();
	pad2[i][ii][iv*2]->SetFillColor(10);
	pad2[i][ii][iv*2]->SetFrameFillColor(10);
	pad2[i][ii][iv*2]->Draw();
	pad2[i][ii][iv*2]->cd();
	tit.str("");
	histosigav[i][ii][iv]= new TGraph(nev,x,sigavtemp);
	tit<<"<SIG> --> DSP "<<i+1<<" - VA1 pair # "<<iv+1;
	histosigav[i][ii][iv]->SetTitle(tit.str().c_str());
	histosigav[i][ii][iv]->GetXaxis()->SetTitle("time (arbitrary unit)");
	histosigav[i][ii][iv]->GetXaxis()->CenterTitle();
	histosigav[i][ii][iv]->GetYaxis()->SetTitle("<SIG>");
	histosigav[i][ii][iv]->GetYaxis()->SetTitleOffset(0.8);
	histosigav[i][ii][iv]->GetYaxis()->CenterTitle();
	histosigav[i][ii][iv]->SetMarkerStyle(23);
	histosigav[i][ii][iv]->SetMarkerSize(0.4);
	histosigav[i][ii][iv]->SetMarkerColor(2);
	histosigav[i][ii][iv]->Draw("acp");
	tit.str("");
	c[i][ii][0]->Update();

	c[i][ii][0]->cd();
	pad2[i][ii][iv*2+1]->SetFillColor(10);
 	pad2[i][ii][iv*2+1]->SetFrameFillColor(10);
 	pad2[i][ii][iv*2+1]->Draw();
 	pad2[i][ii][iv*2+1]->cd();
	tit.str("");
	histosigvar[i][ii][iv]= new TGraph(nev,x,sigvartemp);
	tit<<"VAR SIG --> DSP "<<i+1<<" - VA1 pair # "<<iv+1;
	histosigvar[i][ii][iv]->SetTitle(tit.str().c_str());
	histosigvar[i][ii][iv]->GetXaxis()->SetTitle("time (arbitrary unit)");
	histosigvar[i][ii][iv]->GetXaxis()->CenterTitle();
	histosigvar[i][ii][iv]->GetYaxis()->SetTitle("VAR <SIG>");
	histosigvar[i][ii][iv]->GetYaxis()->SetTitleOffset(0.9);
	histosigvar[i][ii][iv]->GetYaxis()->CenterTitle();
	histosigvar[i][ii][iv]->SetMarkerStyle(23);
	histosigvar[i][ii][iv]->SetMarkerSize(0.4);
	histosigvar[i][ii][iv]->SetMarkerColor(2);
	histosigvar[i][ii][iv]->Draw("acp");
	tit.str("");
	c[i][ii][0]->Update();
      }
    }
    
    for(Int_t ix=0;ix<12;ix++){
      for (Int_t ev = 0; ev < nev; ev++)
	numbadtemp[ev]=(Float_t)numbad[i][ix];
      
      cb[i]->cd();
      pad3[i][ix]->SetFillColor(10);
      pad3[i][ix]->SetFrameFillColor(10);
      pad3[i][ix]->Draw();
      pad3[i][ix]->cd();
      tit.str("");
      histobad[i][ix]= new TGraph(nev,x,numbadtemp);
      tit<<"VA1 pair # "<<ix+1;
      histobad[i][ix]->SetTitle(tit.str().c_str());
      histobad[i][ix]->GetXaxis()->SetTitle("time (arbitrary unit)");
      histobad[i][ix]->GetXaxis()->CenterTitle();
      histobad[i][ix]->GetYaxis()->SetTitle("number of bads");
      histobad[i][ix]->GetYaxis()->CenterTitle();
      histobad[i][ix]->SetMarkerStyle(23);
      histobad[i][ix]->SetMarkerSize(0.4);
      histobad[i][ix]->SetMarkerColor(2);
      histobad[i][ix]->Draw("acp");
      tit.str("");
      cb[i]->Update();
    }
  }
  
  //
  // Close the input file and update the canvases
  pedsig->Close();

  for(Int_t i=0;i<12;i++){
    for(Int_t ii=0;ii<3;ii++){
      for(Int_t iii=0;iii<2;iii++)
	c[i][ii][iii]->Update(); 
    }
    cb[i]->Update();
  }

  //
  // Create the output files 
  stringstream nom1,nom2,nom3;
  
  nom1<<"readpedsig.ps(";
  nom2<<"readpedsig.ps";
  nom3<<"readpedsig.ps)";
  c[0][0][0]->Print(out+nom1.str().c_str());
  for(Int_t i=0;i<12;i++){
    for(Int_t ii=0;ii<3;ii++){
      for(Int_t iii=0;iii<2;iii++){
	if(i==11 && ii==2 && iii==1)
	  continue;
	if( i==0 && ii==0 && iii==0)
	  continue;
	c[i][ii][iii]->Print(out+nom2.str().c_str());
      }
    }
    cb[i]->Print(out+nom2.str().c_str());
  }
  c[11][2][1]->Print(out+nom3.str().c_str());
  nom1.str("");
  nom2.str("");
  nom3.str("");
  
  for(Int_t i=0;i<12;i++){
    for(Int_t ii=0;ii<3;ii++){
      for(Int_t iii=0;iii<2;iii++)
	delete c[i][ii][iii];
    }
    delete cb[i];
  }
  nom1<<"ps2pdf13 "<<out<<"readpedsig.ps "<<out<<"readpedsig.pdf";
  system(nom1.str().c_str());
  nom2<<"rm -f "<<out<<"readpedsig.ps";
  system(nom2.str().c_str());
   
  return;
}
