//#include <utils/yodaUtility.h>
//#include "TrkFunctions.cpp"
#include <TPaveText.h>
#include <TLatex.h>
#include <TCanvas.h>
#include <TGraph.h>
#include <TStyle.h>
#include <TObjString.h>
#include <fstream>
#include <iostream>
#include <PscuHeader.h>
#include <EventHeader.h>
#include <CalibTrk1Event.h>
#include <CalibTrk2Event.h>

/**
 * readpedsig-limits --> is a function to read the calculated mean value for
 *                       sigma, variance of sigma, pedestal and variance of pedestal
 *                       from the pedsig.root file and draw the distribution of these values
 *                       to calculate the limits to put in the TrkCalibQLook_BASIC script
 *
 * autor: D.Fedele
 * version 1.0
 * Parameters:
 * 	file - the path to the root file to analyse
 *      outdir - total path of output file 
 * 
 */

void readpedsiglimits(TString file,TString outdir)
{
  // 
  //   obtain information about the data file and select the output dir
  const string filepath=file.Data(); 
  Int_t dwpos = filepath.find("pedsig");
  TString fpath=(filepath.c_str());
  TString base;
  stringcopy(base,fpath,0,dwpos);

  TString out;
  if(outdir.Length()==0){
    out = base;
  }else{
    out = outdir;
  };

  stringstream fromfile,rep,tit;
  fromfile<<"readpedsig from File: "<<file;

  //
  // Set some ROOT variables and create the canvases  
  gStyle->SetFillColor(10); 
  gStyle->SetTitleFillColor(10); 
  gStyle->SetTitleFontSize(0.06);
  gStyle->SetOptStat(1110);
  gStyle->SetLabelSize(0.05,"x");
  gStyle->SetLabelSize(0.06,"y");
  gStyle->SetLabelOffset(0.01,"x");
  gStyle->SetLabelOffset(0.005,"y");
  gStyle->SetTitleOffset(0.7,"y");
  gStyle->SetTitleOffset(0.85,"x");
  gStyle->SetTitleSize(0.06,"y");
  gStyle->SetTitleSize(0.05,"x");

  TLatex *tzz=new TLatex();
  tzz->SetTextFont(32);
  tzz->SetTextColor(1);
  tzz->SetTextAlign(12);
  tzz->SetTextSize(0.02);

  Int_t canvasx=900;
  Int_t canvasy=1200;
  TCanvas *c[12][3];
  for(Int_t i=0;i<12;i++){
    for(Int_t ii=0;ii<3;ii++){
      rep.str("");
      tit.str("");
      tit<<"readpedsig "<<i<<"-"<<ii;
      rep<<"c["<<i<<"]["<<ii<<"]";
      c[i][ii] = new TCanvas(rep.str().c_str(),tit.str().c_str(),canvasx,canvasy);
      c[i][ii]->Range(0,0,100,100);
      tzz->DrawLatex(1,98.5,fromfile.str().c_str());
      rep.str("");
      rep<<"<SIG> e <PED>"<<"----> DSP "<<i+1<<"   ladder "<<ii+1;
      tzz->DrawLatex(60,98.5,rep.str().c_str());
    }
  }
  
  //
  // inizialise the variables and open the file
  Float_t pedav[12][12],sigav[12][12];

  for(Int_t i=0;i<12;i++){
    for(Int_t ii=0;ii<12;ii++){
      pedav[i][ii]=0;
      sigav[i][ii]=0;
    }
  }
    
  TFile *pedsig = new TFile("/home/fedele/compiledScripts/pedsig.root");

  TTree *pstree = (TTree*)pedsig->Get("pstree");
  pstree->SetBranchAddress("pedav",pedav);
  pstree->SetBranchAddress("sigav",sigav);

  Int_t totev=pstree->GetEntries();
  const Int_t nev=totev;

  
  
  //
  //  Create Pads and Histos
  TPad *pad1[12][3][8];
  TH1F *histosigav[12][3][4];
  TH1F *histopedav[12][3][4];

  Float_t posy = 0.95;    // up y-coord - top pads
  Float_t hpad = 0;   // pad height
  Float_t posx1=0;          // left  x-coord - pad column
  Float_t posx0=0;          //       x-coord - column division
  Float_t wrel = 0;     // relative x size of first sub-column
  Float_t marg = 0.004;   // margin among pads
  stringstream oss1,oss2,oss3,oss4;

  hpad = (posy-marg*7)/4;
  wrel = (1-marg*4)/2;
  
  for(Int_t n = 0; n<8; n++){
    if ( (n+1)%2==1 ) {
      if(n>1)posy = posy-(marg*2+hpad);
      posx1 = marg;
      posx0 = posx1 +wrel;
    } else {
      posx1 = posx0 + 2*marg;
      posx0 = posx1 + wrel;
    };
    for(Int_t i=0;i<12;i++){
      for(Int_t ii=0;ii<3;ii++){
 	oss1<<"DSP  "<<n+1<<i<<ii;
 	oss2<<"DSPh  "<<n+1<<i<<ii;
	pad1[i][ii][n] = new TPad("pad1"," ",posx1,posy-hpad,posx0,posy,18,0,0);
	if(n<4){
	  tit.str("");
	  tit<<"<SIG> --> VA1 #"<<n+1;
	  histosigav[i][ii][n]=new TH1F(oss1.str().c_str(),tit.str().c_str(),100,0.5,0.);
	  tit.str("");
	  tit<<"<PED> --> VA1 #"<<n+1;
	  histopedav[i][ii][n]=new TH1F(oss2.str().c_str(),tit.str().c_str(),100,0.5,0.);
	}
       	oss1.str("");
 	oss2.str("");
      }
    }
  }
  
  //**********************************************************************
  //
  //   LOOP OVER EVENTS
  //
  //**********************************************************************
  for(Int_t i=0;i<12;i++){
    for(Int_t ii=0;ii<3;ii++){      
      for(Int_t iv=0;iv<4;iv++){
	for(Int_t ev = 0; ev < nev; ev++){  
	  pstree->GetEntry(ev); 
	  if(sigav[i][(ii*4)+iv]!=0)
	    histosigav[i][ii][iv]->Fill(sigav[i][(ii*4)+iv]);
	  if(pedav[i][(ii*4)+iv]!=0)
	    histopedav[i][ii][iv]->Fill(pedav[i][(ii*4)+iv]);
	}
  
	//
	// fill the histos whit the right values
	c[i][ii]->cd();
	pad1[i][ii][iv*2]->SetFillColor(10);
	pad1[i][ii][iv*2]->SetFrameFillColor(10);
	pad1[i][ii][iv*2]->Draw();
	pad1[i][ii][iv*2]->cd();
	histosigav[i][ii][iv]->GetXaxis()->SetTitle("<SIG>");
	histosigav[i][ii][iv]->GetXaxis()->CenterTitle();
	histosigav[i][ii][iv]->Draw();

	c[i][ii]->Update();
	c[i][ii]->cd();
 	pad1[i][ii][iv*2+1]->SetFillColor(10);
 	pad1[i][ii][iv*2+1]->SetFrameFillColor(10);
 	pad1[i][ii][iv*2+1]->Draw();
 	pad1[i][ii][iv*2+1]->cd();
	histopedav[i][ii][iv]->GetXaxis()->SetTitle("<PED>");
	histopedav[i][ii][iv]->GetXaxis()->CenterTitle();
	histopedav[i][ii][iv]->Draw("");
	c[i][ii]->Update();
	
      }
    }
  }

  //
  // Close the input file and update the canvases
  pedsig->Close();
  for(Int_t i=0;i<12;i++){
    for(Int_t ii=0;ii<3;ii++)
      c[i][ii]->Update();//draw pads in canvas 
  }

  //
  // Create the output files 
  stringstream nom1,nom2,nom3;
  
  nom1<<"readpedsig-limits.ps(";
  nom2<<"readpedsig-limits.ps";
  nom3<<"readpedsig-limits.ps)";
  c[0][0]->Print(out+nom1.str().c_str());
  for(Int_t i=0;i<12;i++){
    for(Int_t ii=0;ii<3;ii++){
	if(i==11 && ii==2)
	  continue;
	if( i==0 && ii==0)
	  continue;
	c[i][ii]->Print(out+nom2.str().c_str());
    }
  }

  c[11][2]->Print(out+nom3.str().c_str());
  nom1.str("");
  nom2.str("");
  nom3.str("");
  
  for(Int_t i=0;i<12;i++){
    for(Int_t ii=0;ii<3;ii++)
	delete c[i][ii];
  }

  nom1<<"ps2pdf13 "<<out<<"readpedsig-limits.ps "<<out<<"readpedsig-limits.pdf";
  system(nom1.str().c_str());
  nom2<<"rm -f "<<out<<"readpedsig-limits.ps";
  system(nom2.str().c_str());

  return;
}
