/**
 * TrkFunctions.cpp  --> some useful tracker functions
 *
 * version 1.0
 * Parameters:
 * 	file - the path to the root file to analyse
 *      outdir - total path of output file 
 * 
 */

#include <Rtypes.h>
#include <TString.h>
typedef struct trkword{

    int type;
    int decode;

};

 typedef struct caltrk_def{
  Int_t good0[2];
  Int_t daqmode[12];
  Int_t dspnum[12];
  Int_t calibnum[12];
  Int_t ncalev[12];
  Int_t calfl[12];
  Int_t ped1[12];
  Int_t ped2[12];
  Int_t ped3[12];
  Int_t sig1[12];
  Int_t sig2[12];
  Int_t sig3[12];
  Int_t nbad1[12];
  Int_t nbad2[12];
  Int_t nbad3[12];
  Float_t dspped[12][3702];
  Float_t dspsig[12][3702];
  Float_t dspbad[12][3702];
  Int_t crc_c[12][3];
  Int_t crc_hc[12];
};

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
*
|   The function "datadecode" decodes the tracker words.
*   
|   Tracker words are of three types:
*   - ADC data 
|   - strip address
*   - end of ladder
|   
*   The function returns a struct variable (trkword) 
|   that contains two quantities, type and decode, which are assigned 
*   the following values:
|   
*   type                     decode              
|   ----------------------------------------------------
*   -1     error             0          
|    0     data              0-4095   ADC values
*    1     address           0-1023   strip address (relative to ladder)
|    2     end-of-ladder     1,2,3    ladder number     (compressed acq mode)      
*                            4,5,6    ladder number + 3 (full acq mode)
|       
*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
trkword datadecode(int word){
    int type =0;
    int data =0;
    int nodata = word&0xf000;
    int zero = 0;

    trkword thisword;
    
    switch (nodata>>12){

    case 0:      
	
	thisword.decode = word;
	thisword.type = 0;
//	cout << thisword.decode << "\n";
	return (thisword);              //>>>>> ADC data (0)

    case 1:       

        type = word&0xC00;
	data = word&0x3ff;

	switch(type>>10){

	case 0:   
	    thisword.decode = data;
	    thisword.type = 1; //>>> address (1)
	    return (thisword);          

	case 2:  
//	    if(data>=4)data = data-3;
	    if(data>6){
		printf("Error on data \n");
		thisword.decode = zero;
		thisword.type = -1;
		return (thisword);     //>>>>> error (-1)
	    }
	    thisword.decode = data;	    
	    thisword.type = 2;
	    return (thisword);       //>>> end-of-ladder 

	default:
	    printf("Error on data \n");
	    thisword.decode = zero;
	    thisword.type = -1;
	    return (thisword);              //>>>>> error (-1)
	    
	}

    default:

	printf("Error on data \n");
	thisword.decode = zero;
	thisword.type = -1;
	return (thisword);              //>>>>> error (-1)

    };
};


void stringcopy(TString& s1, const TString& s2, Int_t from=0, Int_t to=0){    
    if ( to == 0 ){
	Int_t t2length = s2.Length();
	s1 = "";
	to = t2length;
    };
    for (Int_t i = from; i<to; i++){
	s1.Append(s2[i],1);
    };
};


