/**
 * FTrkScanQLook_EXPERT.cc
 *
 * autor: D.Fedele
 * version 2.0
 * Parameters:
 * 	file - the path to the root file to analyze
 *      outdir - total path of output file 
 *      event - the number of the single event to analyze
 *      DSPprint - the number of a particular DSP to draw (0 don't draw)
 * 	format - extension of output file (pdf,ps,gif,jpg)
 * 
 */
#include <TString.h>
#include <fcntl.h>

extern void FTrkScanQLook_EXPERT(TString file, TString outdir, Int_t event, Int_t DSPprint, TString format);
extern void info();

void usage(){  
  printf("\nUsage:\n\n FTrkScanQLook_EXPERT file [OPTIONS] \n\n");
  printf("\t --help:       print this help and exit \n");
  printf("\t file:         path of the root file to analyze (give at least this parameter)  \n");
  printf("\nOPTIONS:\n");
  printf("\t -v            be verbose \n");  
  printf("\t -outdir:      output directory [default = ./] \n");
  printf("\t -format:      format of the output file (without .) [default = pdf] \n");
  printf("\nExamples:\n\tFTrkScanQLook_EXPERT /home/pamela/filesfromyoda/DW_xxxxxx_yyyy.root \n\n");
  printf("\tFTrkScanQLook_EXPERT /home/pamela/filesfromyoda/DW_xxxxxx_yyyy.root -v -outdir ~/tmp/\n\n");
}

int main(int argc, char* argv[]){

  TString FILE,OUTDIR="./",FORMAT="pdf";
  bool beverbose = false;
  int nul = 0;

  if(argc>1){
    if(argc<3){
      printf("\n\tYou have to insert at least the file to analyze \n");
      usage();
      return(0);
    }
    if ( !strcmp(argv[1],"--version") ){
      info();
      return(0);
    };
    if (!strcmp(argv[1], "-h") || !strcmp(argv[1], "--help") || argc>7){
      usage();
      return(0);
    }
    if ( (!strcmp(argv[1],"-v") || !strcmp(argv[1],"--verbose"))&& argc == 2 ){
      info();
      return(0);    
    }
    else {
      
      FILE = argv[1];
      for(int i=2; i<argc;i++){
	
      	if ( !strcmp(argv[i],"-v") || !strcmp(argv[i],"--verbose") )
	  beverbose = true;
	
	if (!strcmp(argv[i], "-outdir")){
	  if (++i >= argc || !strcmp(argv[i],"-v") || !strcmp(argv[i], "-format")){
	    printf( "\n-outdir needs arguments. \n");
	    usage();
	    return(0);
	  } 
	  else{
	    OUTDIR = argv[i];
	    continue;
	  }
	}
	if (!strcmp(argv[i], "-format")){
	  if (++i >= argc || !strcmp(argv[i],"-v") || !strcmp(argv[i], "-outdir")){
	    printf( "\n-format needs arguments. \n");
	    usage();
	    return(0);
	  } 
	  else{
	    FORMAT = argv[i];
	    continue;
	  }
	}
      }
    }
  }
      
  
  if ( !beverbose ){
    //
    // redirect to /dev/null the stdout and stderr
    //
    nul = open("/dev/null", O_CREAT | O_RDWR,S_IREAD | S_IWRITE);
    dup2(nul,1);
    dup2(nul,2);
  };
  printf("\n Welcome to FTrkScanQLook! \n\n");
  //
  FTrkScanQLook_EXPERT(FILE,OUTDIR,2,0,FORMAT);
  FTrkScanQLook_EXPERT(FILE,OUTDIR,3,0,FORMAT);
  //
  if ( !beverbose ) close(nul);
  return(0);
}
