#include "TrkCalibQLook_EXPERT.cpp"
#include <TString.h>

/**
 * TrkCalibQLookExpert.cpp
 *
 * autor: D.Fedele
 * version 1.0
 * Parameters:
 * 	base - the path to the root directory for the specific
 *	       Pamela unpack session
 *      step - select =1 in order to analyse one event at time
 *      fromevent - first event to analyse
 *      toevent - last event to analyse
 *      outdir - total path of output file 
 * 	outfile - extension of output file (pdf,ps,gif,jpg)
 * 
 */

int main(int argc,char* argv[]){
  
  TString FILE,OUTDIR="",OUTFILE="gif";
  Int_t FROMEVENT=0,TOEVENT=0,STEP=0;
  
  if(argc>1){
    if (!strcmp(argv[1], "-h")||!strcmp(argv[1], "--help")){
      printf("Usage: TrkCalibQlookExpert FILE STEP FROMEVENT TOEVENT OUTDIR OUTFILE \n");
      printf("\t FILE:         path of the root file to analize (give at least this parameter)  \n");
      printf("\t STEP:         select =1 in order to analyze one event at time [default = 0] \n");
      printf("\t FROMEVENT:    first event to analize [default = 0] \n");
      printf("\t TOEVENT:      last event to analize  [default = 0] \n");
      printf("\t OUTDIR:       output directory [default = same directory of the root file] \n");
      printf("\t OUTFILE:      type of output file (without . )[default = gif] \n");
      return(0);
    }
    
    if(argc>=2){
      for(int i=1; i<argc;i++){
	if(i==1) FILE = argv[i];
	else if(i==2) STEP = atoi(argv[i]);
	else if(i==3) FROMEVENT = atoi(argv[i]);
	else if(i==4) TOEVENT = atoi(argv[i]);
	else if(i==5) OUTDIR = argv[i];
	else if(i==6) OUTFILE = argv[i];
      }
    }
  }
  
  else if(argc==1){
    printf("Usage: TrkCalibQlookExpert FILE STEP FROMEVENT TOEVENT OUTDIR OUTFILE \n");
    printf("\t FILE:         path of the root file to analize (give at least this parameter)  \n");
    printf("\t STEP:         select =1 in order to analyze one event at time [default = 0] \n");
    printf("\t FROMEVENT:    first event to analize [default = 0] \n");
    printf("\t TOEVENT:      last event to analize  [default = 0] \n");
    printf("\t OUTDIR:       output directory [default = same directory of the root file] \n");
    printf("\t OUTFILE:      type of output file (without . )[default = gif] \n");
    return(0);
  }
  
  TrkCalibQLook_EXPERT(FILE,STEP,FROMEVENT,TOEVENT,OUTDIR,OUTFILE);
}
