/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       :  SRAMManager                                                
/*  C.I. No.     :                                                           
/*  $Revision: 1.12 $
/*  $Date: 2005/01/26 18:46:56 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: SM_SRAMPageManager_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: sebastiani $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: SM_SRAMPageManager_p.c,v $
/*  Revision 1.12  2005/01/26 18:46:56  sebastiani
/*  new bug fixes for WS
/*
/*  Revision 1.11  2004/11/05 16:43:08  sebastiani
/*  *** empty log message ***
/*
/*  Revision 1.10  2004/08/09 08:30:29  sebastiani
/*  fix calo alarm procedure
/*
/*  Revision 1.9  2004/06/01 16:41:24  sebastiani
/*  EventReceive ANY
/*
/*  Revision 1.8  2004/05/25 14:07:18  faber
/*  *** empty log message ***
/*
/*  Revision 1.7  2004/05/20 09:04:23  sebastiani
/*  ok
/*
/*  Revision 1.6  2004/02/13 10:11:30  alfarano
/*  calorimeter initialization func and more
/*
/*  Revision 1.5  2003/11/10 12:13:25  sebastiani
/*  PM_pi_SetPktType and SM_PktType global variable introdused
/*
/*  Revision 1.4  2003/10/17 09:16:43  sebastiani
/*  SKETCHBOARD_FREE event introduced
/*
/*  Revision 1.3  2003/09/17 16:38:53  faber
/*  PM_pi_ExpPageAvail() introduced
/*
/*  Revision 1.2  2003/09/10 10:30:43  faber
/*  -introduced:
/*  	void PM_pi_DisableStore_In_DataTimeOut(),
/*  	void PM_pi_EnableStore_In_DataTimeOut(),
/*  	UINT32 PM_pi_GetDataLength(SM_PAGEID page);
/*  - fixed: Bug in PreparePage, EXP64 mode "one page only use".
/*  the fixing consist of the subsitution
/*  of the istruction
/*      	    SM_SelectedPage <<= 2;
/*  with
/*  	    SM_SelectedPage += 4;
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.6  2003/06/09 10:20:34  aurora
/*  improved the management of data acquisition.
/*  Fixed the dalay when copy the data in to ERC32 memory
/*
/*  Revision 1.5  2002/07/31 14:34:09  zulia
/*  send data to CMD I/F after Event Trigger
/*  set header to 12 Bytes
/*  packet counter to 32 bits
/*  provided interface for copy buffer from micro to PIF sram
/*
/*  Revision 1.4  2002/06/19 08:25:31  zulia
/*  added provided interface PM_pi_GetAndIncrPckCnt that
/*  get and increase the packet counter
/*
/*  Revision 1.3  2002/05/09 08:16:35  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/

#include <src/SRAMManager/SRAMPageManager/SM_SRAMPageManager_p.h>
#include <src/SRAMManager/SRAMPageManager/SM_SRAMPageManager_op.h>

/*****************************************************************************/
/*===== S R A M P a g e M a n a g e r P R O V I D E D    I N T E R F A C E ==*/

/*****************************************************************************/
/* @Function: SM_piSRAMPageManagerInit                                       */
/* @Purpose :                                                                */
/*  This function initializes the SRAM Page Manager object (its variables).  */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* SM_EXITCODE          OUT     Return code                                  */
/* RstPktCounter        IN      Flag used to enable the lost packets         */
/*                               counter reset                               */
/* @@                                                                        */
/*****************************************************************************/

SM_EXITCODE PM_piSRAMPageManagerInit(BOOL RstPktCounter)
{
SM_EXITCODE status;

  status = PM_opSRAMPageManagerInit(RstPktCounter);
  return (status);
}

/*****************************************************************************/
/* @Function: SM_piPreparePage                                               */
/* @Purpose :                                                                */
/*  The function selects a new SRAM page to hold the new data coming from    */
/*  the DAQ I/F.                                                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code PM_piPreparePage          (BOOL daq_dmain) {
  return PM_opPreparePage(daq_dmain);
}


/*****************************************************************************/
/* @Function: PM_piPageHasData                                               */
/* @Purpose :                                                                */
/*  The function is used to tell the Page Manager that the last selected page*/
/*  contains data written by the DAQ I/F. The Page Manager checks the data,  */
/*  write the page header and send a "store" request to the MMSUManager.     */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

void PM_piPageHasData(void)
{
  PM_opPageHasData();
}

/*****************************************************************************/
/* @Function: PM_piPageIsEmpty                                               */
/* @Purpose :                                                                */
/*  The function is used to tell the Page Manager that the last selected page*/
/*  was not written by the DAQ I/F.                                          */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

void PM_piPageIsEmpty(void)
{
  PM_opPageIsEmpty();
}

/*****************************************************************************/
/* @Function: PM_piPageWasSaved                                              */
/* @Purpose :                                                                */
/*  The function tels the Page Manager that a SRAM page was stored in MMSU   */
/*  or CMD I/F and can be reused                                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/
SM_EXITCODE PM_piPageWasSaved(FS_FILEID FileId)
{
SM_EXITCODE status = SM_SUCCESS;

  PM_opPageWasSaved(FileId);
  return (status);
}

/*****************************************************************************/
/* @Function: PM_pi_SetAcqMode                                               */
/* @Purpose :                                                                */
/*  The function selects the DAQ acquisition mode for the Page Manager:      */
/*  science data or DAQ setup. All the cached pages are lost and the         */
/*  MMSUManager must be tod not to call the PageWasSaved function for the    */
/*  deleted SRAM pages. By now this means a reset of the MMSUManager save    */
/*  queue                                                                    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* SM_EXITCODE           OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

SM_EXITCODE PM_pi_SetAcqMode(SM_ACQMODE mode)
{
SM_EXITCODE code;

  code = PM_op_SetAcqMode(mode);
  return (code);
}

/*****************************************************************************/
/* @Function: PM_pi_GetAcqMode                                               */
/* @Purpose :                                                                */
/*  The function return the current acquisition mode                         */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* SM_ACQMODE           OUT     acquisition mode                             */
/* @@                                                                        */
/*****************************************************************************/

SM_ACQMODE PM_pi_GetAcqMode(void)
{
SM_ACQMODE mode;

  mode = PM_op_GetAcqMode();
  return (mode);
}

/*****************************************************************************/
/* @Function: PM_pi_GetLostPktCounter                                        */
/* @Purpose :                                                                */
/*  The function return the lost packets counter                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* SM_EXITCODE           OUT     Exit code                                   */
/* @@                                                                        */
/*****************************************************************************/

SM_EXITCODE PM_pi_GetLostPktCounter(UINT32* Counter)
{
SM_EXITCODE code = SM_SUCCESS;

  PM_op_GetLostPktCounter(Counter);
  return (code);
}

/*****************************************************************************/
/* @Function: PM_pi_GetPacket                                                */
/* @Purpose :                                                                */
/*  The function return the last acquired packet                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  SM_PKTSTAT           OUT     Acquisition result                          */
/*  PtrPkt               OUT     Pointer to the caller packet buffer         */
/*  Size                 OUT     Size of the packet copied into buffer       */
/* @@                                                                        */
/*****************************************************************************/

SM_PKTSTAT PM_pi_GetPacket(UINT32* Size, void* PtrPkt)
{
SM_PKTSTAT PktStat;

  PktStat = PM_op_GetPacket(Size, PtrPkt);
  return (PktStat);
}

/*****************************************************************************/
/* @Function: PM_pi_SetExpPktCpyFreq                                         */
/* @Purpose :                                                                */
/*  This functin sets the experiment pkt RAM copy frequency                  */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Freq                 IN      Frequency                                   */
/* @@                                                                        */
/*****************************************************************************/

SM_EXITCODE PM_pi_SetExpPktCpyFlag(BOOL Flag)
{
  SM_EXITCODE code = SM_SUCCESS;
  PM_op_SetExpPktCpyFlag(Flag);
  return (code);
}

/*****************************************************************************/
/* @Function: PM_pi_StorePacket                                              */
/* @Purpose :                                                                */
/*  The function starts all the operations needed to store the given packet  */
/*  in the selected file. If the result is good it only means that the store */
/*  request was successfuly accepted. The store of the packet can still fail.*/
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  SM_STRSTAT           OUT     Store request result result                 */
/*  PtrPkt               IN      Pointer to the caller packet buffer         */
/*  Size                 IN      Size of the packet to be copied into FileId */
/*                                in bytes                                   */
/*  FileID               IN      Destination file                            */
/* @@                                                                        */
/*****************************************************************************/

SM_STRSTAT  PM_pi_StorePacket(UINT32 Size, void* PtrPkt, FS_FILEID FileId)
{
SM_STRSTAT PktStat;

  PktStat = PM_op_StorePacket(Size, PtrPkt, FileId);
  return (PktStat);
}

/*****************************************************************************/
/* @Function: PM_pi_GetAndIncrPckCnt                                         */
/* @Purpose :                                                                */
/*  This function get and increase the packet counter                        */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* UINT32                OUT    return the packet counter                    */
/* @@                                                                        */
/*****************************************************************************/
UINT32 PM_pi_GetAndIncrPckCnt (void)
{
  return (PM_op_GetAndIncrPckCnt());
}

/*****************************************************************************/
/* @Function: PM_pi_CopyToSRAM                                                */
/* @Purpose :                                                                */
/*  This function copy from RAMStartAddr "Size" bytes to Page selected in    */
/*  in SRAM Memory                                                           */
/*  this function update the value of SM_CalDataLenght for the page selected */
/*  with the "size"                                                          */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* SM_STRSTAT           OUT     Store request result                         */
/* Page                 IN      Page to store data buffer                    */
/* RAMStartAddr         IN      Pointer to the caller data buffer            */
/* Size                 IN      Size of the packet to be copied into FileId  */
/*                                in bytes                                   */
/* @@                                                                        */
/*****************************************************************************/
SM_STRSTAT PM_pi_CopyToSRAM (SM_PAGEID Page, void* RAMStartAddr, UINT32 Size)
{
    return PM_op_CopyToSRAM (Page, RAMStartAddr, Size);
}

/*****************************************************************************/
/* @Function: PM_pi_UseCalibrationPage                                       */
/* @Purpose :                                                                */
/*  This function select the page that must be used for next acquisition     */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* Page                 IN      Page to store data buffer                    */
/* @@                                                                        */
/*****************************************************************************/
void PM_pi_UseCalibrationPage (SM_PAGEID Page)
{
  PM_op_UseCalibrationPage (Page);
}



void PM_pi_DisableStore_In_DataTimeOut() {
  PM_opDisableStore_In_DataTimeOut();
}

void PM_pi_EnableStore_In_DataTimeOut() {
  PM_opEnableStore_In_DataTimeOut();
}

UINT32 PM_pi_GetDataLength(SM_PAGEID page)
{
  return SM_opGetDataLength(page);
}

BOOL PM_pi_ExpPageAvail()
{
  return SM_opExpPageAvail();
}

BOOL PM_pi_AllExpPageAvail()
{
  return SM_opAllExpPageAvail();
}

BYTE PM_pi_SetPktType(BYTE pkttype) {
  return PM_opSetPktType(pkttype);
}

BYTE PM_pi_GetPktType() {
  return PM_opGetPktType();
}
