/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       :  MCMDManager                                                
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2003/08/04 09:40:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: MT_TTManager_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: sebastiani $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: MT_TTManager_p.c,v $
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.3  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/
  
#include <src/MCMDManager/TTManager/MT_TTManager_p.h>
#include <src/MCMDManager/TTManager/MT_TTManager_op.h>


/*****************************************************************************/

/*======== T T M a n a g e r    P R O V I D E D    I N T E R F A C E ========*/

/*****************************************************************************/


/*****************************************************************************/
/* @Function: MT_piInitTTManager                                             */
/* @Purpose :                                                                */
/*  Provided Interface to initialize the TTManager object.                   */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*                      IN                                                   */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

status_code MT_piInitTTManager (void)
{
status_code status;

    status =MT_opInitTTManager();
    return (status);

}



/*****************************************************************************/
/* @Function: MT_piSndMsgTTManager                                           */
/* @Purpose :                                                                */
/*  Provided Interface to invoke a specific operation of the TTManager task. */
/*  This is done by sending a message into TTManager mailbox.                */
/*  The sent message has the following structure :                           */
/*  Structure -MsgTsk- :                                                     */
/*  Field -Code-    Code of the task operation                               */
/*  Field -Info-    Buffer that contains the task operation parameters       */
/*  Filed -LlInfo-  Parameters size.                                         */
/*  The operations code and the parameters type of the TTManager task are    */
/*  the following :                                                          */
/*                                                                           */
/*     Code operation         Parameters (Type assigned to -Info- field)     */
/*     MT_CHECK_TIMETAG       TI_TIME structure        (On Board Time (OBT)) */
/*     MT_STORE_TIMETAG_MCMD  MA_HEADER_MCMD structure (MCMD header)         */
/*     MT_DEL_MCMD_QUEUE      MA_HEADER_MCMD structure (MCMD header)         */
/*     MT_TWIN_PARM_SET       MA_HEADER_MCMD structure (MCMD header)         */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  SndMsg               IN      Pointer to task message                     */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MT_piSndMsgTTManager (MsgTsk* SndMsg)
{
status_code status;

    status =MT_opSndMsgTTManager(SndMsg);
    return (status);
}



