/****************************************************************************
 *  F i l e   D a t a                                                        
 *  $Id: LU_SourceFileID_INFN.c,v 1.7 2004/08/31 09:08:35 sebastiani Exp $
 *  $Revision: 1.7 $
 *  $Date: 2004/08/31 09:08:35 $
 *  $RCSfile: LU_SourceFileID_INFN.c,v $
 *                                                                           
 ****************************************************************************
 *  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
 *                                                                           
 *  $Author: sebastiani $
 *               :                                                           
 ****************************************************************************
 *  U p d a t i n g                                                          

 *  $Log: LU_SourceFileID_INFN.c,v $
 *  Revision 1.7  2004/08/31 09:08:35  sebastiani
 *  fix warning
 *
 *  Revision 1.6  2004/08/27 13:13:49  alfarano
 *  High voltage functions
 *
 *  Revision 1.5  2004/08/04 13:25:21  sebastiani
 *  first fix allarm procedure
 *
 *  Revision 1.4  2004/08/02 15:49:47  alfarano
 *  alarm handling , scm & pm communication rewrite
 *
 *  Revision 1.3  2004/06/30 07:26:52  sebastiani
 *  TOF fixing,WS fixing
 *
 *  Revision 1.2  2004/06/24 09:02:55  alfarano
 *  updates
 *
 *  Revision 1.1  2003/10/03 16:12:26  faber
 *  *** empty log message ***
 *
 *                                                                           
 *****************************************************************************/

#include <src/INFN/LU_SourceFileID_INFN.h>
#include <stdio.h>

#ifdef I386
#include <string.h>
#endif 

static const char *LU_SourceStr[LU_FILEID_N]=
{     "NULL",
      "BasicSW/Bus1553B/BI_Bus1553B_int.c",
      "BasicSW/Bus1553B/BI_Bus1553B_op.c",
      "BasicSW/Bus1553B/BI_Bus1553B_p.c",
      "BasicSW/CrimeaDriver/CD_CrimeaDriver_op.c",
      "BasicSW/CrimeaDriver/CD_CrimeaDriver_p.c",
      "BasicSW/InterruptManager/IM_InterruptManager_op.c",
      "BasicSW/InterruptManager/IM_InterruptManager_op.orig.c",
      "BasicSW/InterruptManager/IM_InterruptManager_p.c",
      "BasicSW/PatchDumpManager/PD_PatchDumpManager_int.c",
      "BasicSW/PatchDumpManager/PD_PatchDumpManager_op.c",
      "BasicSW/PatchDumpManager/PD_PatchDumpManager_p.c",
      "BasicSW/RTEMSInterface/OS_rtems_p.c",
      "BasicSW/TimingInfo/TI_TimingInfo_op.c",
      "BasicSW/TimingInfo/TI_TimingInfo_p.c",
      "BootStrap/Boot/mkprom.c",
      "BootStrap/Boot/mon.c",
      "BootStrap/Boot/promload.c",
      "FileManager/FileSystem/FS_FileSystem_op.c",
      "FileManager/FileSystem/FS_FileSystem_p.c",
      "FileManager/MMSUDriver/FD_MMSUDriver_int.c",
      "FileManager/MMSUDriver/FD_MMSUDriver_op.c",
      "FileManager/MMSUDriver/FD_MMSUDriver_p.c",
      "FileManager/MMSUManager/FT_MMSUManager_int.c",
      "FileManager/MMSUManager/FT_MMSUManager_op.c",
      "FileManager/MMSUManager/FT_MMSUManager_p.c",
      "HKManager/HistoryArea/HA_HistoryArea_int.c",
      "HKManager/HistoryArea/HA_HistoryArea_op.c",
      "HKManager/HistoryArea/HA_HistoryArea_p.c",
      "HKManager/ReportGenerator/RG_ReportGenerator_int.c",
      "HKManager/ReportGenerator/RG_ReportGenerator_op.c",
      "HKManager/ReportGenerator/RG_ReportGenerator_p.c",
      "INFN/AC_Anticoincidence_INFN.c",
      "INFN/CAL_Calorimeter_INFN.c",
      "INFN/CH_CommandHandler_INFN_auto.c",
      "INFN/CH_CommandHandler_INFN.c",
      "INFN/CM_Common_INFN.c",
      "INFN/crc.c",
      "INFN/DAQ_IDAQ_INFN.c",
      "INFN/daqtest.c",
      "INFN/Drivers/AC_Driver_INFN.c",
      "INFN/Drivers/AC_generator.c",
      "INFN/Drivers/CAL_Driver_INFN.c",
      "INFN/Drivers/CAL_generator.c",
      "INFN/Drivers/cmdgenerator.c",
      "INFN/Drivers/MISC_generator.c",
      "INFN/Drivers/S4_Driver_INFN.c",
      "INFN/Drivers/S4_generator.c",
      "INFN/Drivers/TOF_Driver_INFN.c",
      "INFN/Drivers/TOF_generator.c",
      "INFN/Drivers/TRD_Driver_INFN.c",
      "INFN/Drivers/TRD_generator.c",
      "INFN/Drivers/TRG_Driver_INFN.c",
      "INFN/Drivers/TRG_generator.c",
      "INFN/Drivers/TRK_Driver_INFN.c",
      "INFN/Drivers/TRK_generator.c",
      "INFN/gen_mcmds.c",
      "INFN/GS_Gas_INFN.c",
      "INFN/HB_HKBuffer_INFN.c",
      "INFN/HK_Manager_INFN.c",
      "INFN/IN_InitManager_INFN_op.c",
      "INFN/IN_InitManager_INFN_p.c",
      "INFN/KHB_Driver_INFN.c",
      "INFN/loganalizer.c",
      "INFN/LU_LogUtility_INFN.c",
      "INFN/LU_SourceFileID_INFN.c",
      "INFN/MCMDS/formatws2.c",
      "INFN/MD_MCMDDispatcher_INFN_op.c",
      "INFN/MD_MCMDDispatcher_INFN_p.c",
      "INFN/MH_ModeHandler_INFN.c",
      "INFN/OS_rtems_INFN_p.c",
      "INFN/PM_PamManager_INFN.c",
      "INFN/PRH_ParamHandler_INFN_auto.c",
      "INFN/PRH_ParamHandler_INFN.c",
      "INFN/PWR_PowerHandler_INFN.c",
      "INFN/RG_ReportGenerator_INFN_op.c",
      "INFN/RG_ReportGenerator_INFN_p.c",
      "INFN/RM_RunManager_INFN.c",
      "INFN/S4_INFN.c",
      "INFN/SCM_Manager_INFN.c",
      "INFN/SMH_SelectModeHandler_INFN.c",
      "INFN/SNS_SensorsBoard_INFN.c",
      "INFN/TOF_TimeOfFlight_INFN.c",
      "INFN/TRD_TransRadDetector_INFN.c",
      "INFN/TRG_Trigger_INFN.c",
      "INFN/TRK_Tracker_INFN.c",
      "INFN/TS_Test_INFN.c",
      "INFN/WS_WorkingSchedule_INFN.c",
      "Initialization/InitManager/IN_InitManager_op.c",
      "Initialization/InitManager/IN_InitManager_p.c",
      "MCMDManager/MCMDArea/MA_MCMDArea_int.c",
      "MCMDManager/MCMDArea/MA_MCMDArea_op.c",
      "MCMDManager/MCMDArea/MA_MCMDArea_p.c",
      "MCMDManager/MCMDDispatcher/MD_MCMDDispatcher_int.c",
      "MCMDManager/MCMDDispatcher/MD_MCMDDispatcher_op.c",
      "MCMDManager/MCMDDispatcher/MD_MCMDDispatcher_p.c",
      "MCMDManager/TTManager/MT_TTManager_int.c",
      "MCMDManager/TTManager/MT_TTManager_op.c",
      "MCMDManager/TTManager/MT_TTManager_p.c",
      "ModeManager/ModeCoordinator/MC_ModeCoordinator_op.c",
      "ModeManager/ModeCoordinator/MC_ModeCoordinator_p.c",
      "QualitySystem/DiagSupervisor/QS_DiagSupervisor_op.c",
      "QualitySystem/DiagSupervisor/QS_DiagSupervisor_p.c",
      "SRAMManager/SRAMDriver/SD_SRAMDriver_op.c",
      "SRAMManager/SRAMDriver/SD_SRAMDriver_p.c",
      "SRAMManager/SRAMPageManager/SM_SRAMPageManager_int.c",
      "SRAMManager/SRAMPageManager/SM_SRAMPageManager_op.c",
      "SRAMManager/SRAMPageManager/SM_SRAMPageManager_p.c",
      "TestUtility/Test/TS_Test_p.c",
      "TM_TCManager/TMTCManager/TM_TMTCManager_op.c",
      "TM_TCManager/TMTCManager/TM_TMTCManager_p.c",
      "INFN/ALM_Alarm_INFN.c",
      "INFN/HV_INFN.c"
};
static const char *LU_NameStr[LU_FILEID_N];

const unsigned char _BI_Bus1553B_int__c = 1;
const unsigned char _BI_Bus1553B_op__c = 2;
const unsigned char _BI_Bus1553B_p__c = 3;
const unsigned char _CD_CrimeaDriver_op__c = 4;
const unsigned char _CD_CrimeaDriver_p__c = 5;
const unsigned char _IM_InterruptManager_op__c = 6;
const unsigned char _IM_InterruptManager_op_orig__c = 7;
const unsigned char _IM_InterruptManager_p__c = 8;
const unsigned char _PD_PatchDumpManager_int__c = 9;
const unsigned char _PD_PatchDumpManager_op__c = 10;
const unsigned char _PD_PatchDumpManager_p__c = 11;
const unsigned char _OS_rtems_p__c = 12;
const unsigned char _TI_TimingInfo_op__c = 13;
const unsigned char _TI_TimingInfo_p__c = 14;
const unsigned char _mkprom__c = 15;
const unsigned char _mon__c = 16;
const unsigned char _promload__c = 17;
const unsigned char _FS_FileSystem_op__c = 18;
const unsigned char _FS_FileSystem_p__c = 19;
const unsigned char _FD_MMSUDriver_int__c = 20;
const unsigned char _FD_MMSUDriver_op__c = 21;
const unsigned char _FD_MMSUDriver_p__c = 22;
const unsigned char _FT_MMSUManager_int__c = 23;
const unsigned char _FT_MMSUManager_op__c = 24;
const unsigned char _FT_MMSUManager_p__c = 25;
const unsigned char _HA_HistoryArea_int__c = 26;
const unsigned char _HA_HistoryArea_op__c = 27;
const unsigned char _HA_HistoryArea_p__c = 28;
const unsigned char _RG_ReportGenerator_int__c = 29;
const unsigned char _RG_ReportGenerator_op__c = 30;
const unsigned char _RG_ReportGenerator_p__c = 31;
const unsigned char _AC_Anticoincidence_INFN__c = 32;
const unsigned char _CAL_Calorimeter_INFN__c = 33;
const unsigned char _CH_CommandHandler_INFN_auto__c = 34;
const unsigned char _CH_CommandHandler_INFN__c = 35;
const unsigned char _CM_Common_INFN__c = 36;
const unsigned char _crc__c = 37;
const unsigned char _DAQ_IDAQ_INFN__c = 38;
const unsigned char _daqtest__c = 39;
const unsigned char _AC_Driver_INFN__c = 40;
const unsigned char _AC_generator__c = 41;
const unsigned char _CAL_Driver_INFN__c = 42;
const unsigned char _CAL_generator__c = 43;
const unsigned char _cmdgenerator__c = 44;
const unsigned char _MISC_generator__c = 45;
const unsigned char _S4_Driver_INFN__c = 46;
const unsigned char _S4_generator__c = 47;
const unsigned char _TOF_Driver_INFN__c = 48;
const unsigned char _TOF_generator__c = 49;
const unsigned char _TRD_Driver_INFN__c = 50;
const unsigned char _TRD_generator__c = 51;
const unsigned char _TRG_Driver_INFN__c = 52;
const unsigned char _TRG_generator__c = 53;
const unsigned char _TRK_Driver_INFN__c = 54;
const unsigned char _TRK_generator__c = 55;
const unsigned char _gen_mcmds__c = 56;
const unsigned char _GS_Gas_INFN__c = 57;
const unsigned char _HB_HKBuffer_INFN__c = 58;
const unsigned char _HK_Manager_INFN__c = 59;
const unsigned char _IN_InitManager_INFN_op__c = 60;
const unsigned char _IN_InitManager_INFN_p__c = 61;
const unsigned char _KHB_Driver_INFN__c = 62;
const unsigned char _loganalizer__c = 63;
const unsigned char _LU_LogUtility_INFN__c = 64;
const unsigned char _LU_SourceFileID_INFN__c = 65;
const unsigned char _formatws2__c = 66;
const unsigned char _MD_MCMDDispatcher_INFN_op__c = 67;
const unsigned char _MD_MCMDDispatcher_INFN_p__c = 68;
const unsigned char _MH_ModeHandler_INFN__c = 69;
const unsigned char _OS_rtems_INFN_p__c = 70;
const unsigned char _PM_PamManager_INFN__c = 71;
const unsigned char _PRH_ParamHandler_INFN_auto__c = 72;
const unsigned char _PRH_ParamHandler_INFN__c = 73;
const unsigned char _PWR_PowerHandler_INFN__c = 74;
const unsigned char _RG_ReportGenerator_INFN_op__c = 75;
const unsigned char _RG_ReportGenerator_INFN_p__c = 76;
const unsigned char _RM_RunManager_INFN__c = 77;
const unsigned char _S4_INFN__c = 78;
const unsigned char _SCM_Manager_INFN__c = 79;
const unsigned char _SMH_SelectModeHandler_INFN__c = 80;
const unsigned char _SNS_SensorsBoard_INFN__c = 81;
const unsigned char _TOF_TimeOfFlight_INFN__c = 82;
const unsigned char _TRD_TransRadDetector_INFN__c = 83;
const unsigned char _TRG_Trigger_INFN__c = 84;
const unsigned char _TRK_Tracker_INFN__c = 85;
const unsigned char _TS_Test_INFN__c = 86;
const unsigned char _WS_WorkingSchedule_INFN__c = 87;
const unsigned char _IN_InitManager_op__c = 88;
const unsigned char _IN_InitManager_p__c = 89;
const unsigned char _MA_MCMDArea_int__c = 90;
const unsigned char _MA_MCMDArea_op__c = 91;
const unsigned char _MA_MCMDArea_p__c = 92;
const unsigned char _MD_MCMDDispatcher_int__c = 93;
const unsigned char _MD_MCMDDispatcher_op__c = 94;
const unsigned char _MD_MCMDDispatcher_p__c = 95;
const unsigned char _MT_TTManager_int__c = 96;
const unsigned char _MT_TTManager_op__c = 97;
const unsigned char _MT_TTManager_p__c = 98;
const unsigned char _MC_ModeCoordinator_op__c = 99;
const unsigned char _MC_ModeCoordinator_p__c = 100;
const unsigned char _QS_DiagSupervisor_op__c = 101;
const unsigned char _QS_DiagSupervisor_p__c = 102;
const unsigned char _SD_SRAMDriver_op__c = 103;
const unsigned char _SD_SRAMDriver_p__c = 104;
const unsigned char _SM_SRAMPageManager_int__c = 105;
const unsigned char _SM_SRAMPageManager_op__c = 106;
const unsigned char _SM_SRAMPageManager_p__c = 107;
const unsigned char _TS_Test_p__c = 108;
const unsigned char _TM_TMTCManager_op__c = 109;
const unsigned char _TM_TMTCManager_p__c = 110;
const unsigned char _ALM_Alarm_INFN__c = 111;
const unsigned char _HV_INFN__c = 112;

void LU_InitNames() {
  const char *p;
  const char *res;
  int i;
  for( i=0;i<LU_FILEID_N;i++) {
    res=p=LU_SourceStr[i];
    for( ; *p != 0; p++)
      if(*p == '/')
	res=p+1;
    LU_NameStr[i]=res;
  }
}

/* return the file name of a given file id */
const char* LU_GetSourceStr(unsigned int id) {
   if(id >= LU_FILEID_N)
     id=0;
   return LU_SourceStr[id];
}

/* return the ID of a given source file name, or zero if not found */
int LU_GetSourceFileID(char *str) {
   int i=0;
   while(i<LU_FILEID_N)
     if(strcmp(str,LU_SourceStr[i])==0)
       return i;
   return 0;
}

void  LU_GetSourceInfo(char *str,unsigned int fileid,unsigned int line) {
  if(fileid< LU_FILEID_N)
    sprintf(str,"%s:%d",LU_NameStr[fileid],line);
}
