
#define I386
#define TEST_I
#include "CM_Common_INFN.c"
#include "DAQ_IDAQ_INFN.c"

DAQ_DECLBUF(idaqbuf,1024);
DAQ_DECLBUF(cmdbuf,1024);
DAQ_DECLBUF(ac_idaqbuf,1024);
DAQ_DECLBUF(data,1024);
DAQ_DECLBUF(data2,1024);
DAQ_DECLBUF(idaq2,1024);
DAQ_DECLBUF(ram_readdata,1);
DAQ_DECLBUF(flash_readdata,1);
DAQ_DECLBUF(dsp_readdata,1);

DAQ_CMD_BUF emptybuf = {0,0,0};

void daqtest_init() {

  DAQ_Init();

  DAQ_BUFFER_INIT(idaqbuf);
  DAQ_BUFFER_INIT(idaq2);
  DAQ_BUFFER_INIT(data);
  DAQ_BUFFER_INIT(data2);
  DAQ_BUFFER_INIT(ram_readdata);
  DAQ_BUFFER_INIT(dsp_readdata);
  DAQ_BUFFER_INIT(flash_readdata);

  DAQ_Format_Ram_ReadData(&ram_readdata);
  DAQ_Format_Dsp_ReadData(&dsp_readdata);
  DAQ_Format_Flash_ReadData(&flash_readdata);
}

int main(void) {
  status_code s=0;  

  daqtest_init();
  s |=   DAQ_Format_Ram_ReadData(&ram_readdata);

  s |=   DAQ_Format_CMD_Fill(&data,300,0xbb);
  s |=   DAQ_Format_CMD_Fill(&data2,3,0xcc);

  s |=   DAQ_Format_Cmd2Ram_SetAddress(&idaqbuf,0);
  s |=   DAQ_Format_Cmd2Ram_WriteData(&idaqbuf,&data2);
  s |=   DAQ_Format_Cmd2Ram_EndBlock(&idaqbuf);
  s |=   DAQ_Format_Ram2Daq(&idaqbuf,&ram_readdata);
  DAQ_BufDump(&idaqbuf);
  exit(0);


  s |=   DAQ_Format_Fe2Daq(&idaqbuf,&data2,DAQ_FE_CAL_4);
  s |=   DAQ_Format_Fe2Ram(&idaqbuf,&data,DAQ_FE_CAL_1);
  s |=   DAQ_Format_Cmd2Ram_EndBlock(&idaqbuf);
  s |=   DAQ_Format_Cmd2Ram_SetAddress(&idaqbuf,200);
  s |=   DAQ_Format_Ram2Daq(&idaqbuf,&ram_readdata);

  s |=   DAQ_Format_Cmd2Dsp_SetAddressPM(&idaqbuf,100);
  s |=   DAQ_Format_Cmd2Dsp_WriteData(&idaqbuf,&data);
  s |=   DAQ_Format_Cmd2Ram_SetAddress(&idaqbuf,1000);
  s |=   DAQ_Format_CMD_Fill(&data2,171,0xee);
  s |=   DAQ_Format_Cmd2Ram_WriteData(&idaqbuf,&data2);
  s |=   DAQ_Format_Cmd2Ram_EndBlock(&idaqbuf);
  s |=   DAQ_Format_Cmd2Ram_SetAddress(&idaqbuf,1100);
  s |=   DAQ_Format_Ram2Daq(&idaqbuf,&ram_readdata);

  s |=   DAQ_Format_Cmd2Dsp_SetAddressDM(&idaqbuf,2048);
  s |=   DAQ_Format_CMD_Fill(&data,100,0xDD);
  s |=   DAQ_Format_Cmd2Dsp_WriteData(&idaqbuf,&data);
  s |=   DAQ_Format_Cmd2Dsp_SetAddressDM(&idaqbuf,2048);
  s |=   DAQ_Format_Dsp2Daq(&idaqbuf,&dsp_readdata);
  s |=   DAQ_Format_Spare(&idaqbuf,&emptybuf);


  s |=   DAQ_Format_Cmd2Ram_WriteData (&idaqbuf,&data);
  s |=   DAQ_Format_Cmd2Ram_EndBlock  (&idaqbuf);

  s |=   DAQ_Format_CMD_Fill(&data,13,0xbb);
  s |=   DAQ_Format_CMD_Fill(&data2,254,0xcc);
   
  s |=   DAQ_Format_Fe2Daq(&idaq2,&data,DAQ_FE_CAL_1);
  s |=   DAQ_Format_Fe2Daq(&idaq2,&data2,DAQ_FE_CAL_4);
   
  DAQ_BufDump(&idaq2);
  exit(0);
}
