/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : BasicSW                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2003/08/04 09:40:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: IM_InterruptManager_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: sebastiani $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: IM_InterruptManager_p.c,v $
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.3  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/

/*============================= Include File ================================*/
  
#include <src/BasicSW/InterruptManager/IM_InterruptManager_p.h>
#include <src/BasicSW/InterruptManager/IM_InterruptManager_op.h>


/*****************************************************************************/

/*I M _ I n t e r r u p t M a n a g e r   P R O V I D E D   I N T E R F A C E*/

/*****************************************************************************/

/*****************************************************************************/
/* @Function: IM_piIntInterruptManager                                       */
/* @Purpose :                                                                */
/*  Provided Interface to implement the InterruptManager object              */
/*  initialization.                                                          */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code IM_piIntInterruptManager (void)
{
status_code status;

    status =IM_opIntInterruptManager();
    return (status);

}


/*****************************************************************************/
/* @Function: IM_ihDataAccessINT                                             */
/* @Purpose :                                                                */
/*  Provided Interface to implement the interrupt handler of the Erc32       */
/*  Data Access exeception.                                                  */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*                      IN                                                   */
/*                      OUT                                                  */
/* @@                                                                        */
/*****************************************************************************/

void  IM_ihDataAccessINT (void)
{
    
    IM_opDataAccessINT();

}



/*****************************************************************************/
/* @Function: IM_ihDataAccessINT                                             */
/* @Purpose :                                                                */
/*  Provided Interface to implement the interrupt handler of the Erc32       */
/*  Instruction Access exeception.                                           */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*                      IN                                                   */
/*                      OUT                                                  */
/* @@                                                                        */
/*****************************************************************************/

void  IM_ihInstructionAccessINT (void)
{
    
    IM_opInstructionAccessINT();

}



/*****************************************************************************/
/* @Function: IM_ihExternalINT1                                              */
/* @Purpose :                                                                */
/*  Provided Interface to implement the interrupt handler of th    e         */
/*  External INT 1. This interrupt is connected to the CRIMEA component.     */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*                      IN                                                   */
/*                      OUT                                                  */
/* @@                                                                        */
/*****************************************************************************/

void  IM_ihExternalINT1 (void)
{
    
    IM_opExternalINT1();

}



/*****************************************************************************/
/* @Function: IM_ihExternalINT2                                              */
/* @Purpose :                                                                */
/*  Provided Interface to implement the interrupt handler of the External    */
/*  INT 2. This interrupt is connected to the DMA Read Controller CH2        */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*                      IN                                                   */
/*                      OUT                                                  */
/* @@                                                                        */
/*****************************************************************************/

void  IM_ihExternalINT2 (void)
{
    
    IM_opExternalINT2();

}



/*****************************************************************************/
/* @Function: IM_ihExternalINT3                                              */
/* @Purpose :                                                                */
/*  Provided Interface to implement the interrupt handler of the External    */
/*  INT 3. This interrupt is connected to the DMA Read Controller CH1        */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*                      IN                                                   */
/*                      OUT                                                  */
/* @@                                                                        */
/*****************************************************************************/

void  IM_ihExternalINT3 (void)
{
    
    IM_opExternalINT3 ();

}



/*****************************************************************************/
/* @Function: IM_ihExternalINT4                                              */
/* @Purpose :                                                                */
/*  Provided Interface to implement the interrupt handler of the External    */
/*  INT 4. This interrupt is connected to the DMA Write Controller.          */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*                      IN                                                   */
/*                      OUT                                                  */
/* @@                                                                        */
/*****************************************************************************/

void  IM_ihExternalINT4 (void)
{
    
    IM_opExternalINT4 ();

}



/*****************************************************************************/
/* @Function: IM_ihExternalINT5                                              */
/* @Purpose :                                                                */
/*  Provided Interface to implement the interrupt handler of the External    */
/*  INT 5. This interrupt is connected to the Cross Coupling Module.         */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*                      IN                                                   */
/*                      OUT                                                  */
/* @@                                                                        */
/*****************************************************************************/

void  IM_ihExternalINT5 (void)
{
    
    IM_opExternalINT5 ();

}


/*****************************************************************************/
/* @Function: IM_ihNullINT                                                   */
/* @Purpose :                                                                */
/*  Provided Interface to implement the interrupt handler that nothing       */
/*  doesn't perform.                                                         */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*                      IN                                                   */
/*                      OUT                                                  */
/* @@                                                                        */
/*****************************************************************************/

void  IM_ihNullINT (void)
{
    
    IM_opNullINT ();

}

