/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       :  ModeManager                                                
/*  C.I. No.     :                                                           
/*  $Revision: 1.8 $
/*  $Date: 2005/03/06 14:57:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: MC_ModeCoordinator_op.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: sebastiani $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: MC_ModeCoordinator_op.c,v $
/*  Revision 1.8  2005/03/06 14:57:21  sebastiani
/*  version running on 06 03 2005
/*
/*  Revision 1.7  2005/02/19 10:20:16  sebastiani
/*  accept all MCMC in all mode
/*
/*  Revision 1.6  2003/12/15 10:57:16  sebastiani
/*  last changes for the acceptance of TM tests in Rome of 9-12/Dec/2003
/*
/*  Revision 1.5  2003/12/07 15:07:11  sebastiani
/*  GAS_TEST renamed to GAS_CONTAINER_PURGE
/*
/*  Revision 1.4  2003/11/18 17:13:15  sebastiani
/*  GPT enabled to print a "\n" every 60s directly on UART, only to check if the CPU is
/*  alive
/*
/*  Revision 1.3  2003/09/10 10:32:37  faber
/*  Large implementation of PamManager/RunManager Pam Sowfare. (compiled,never run)
/*
/*  Revision 1.2  2003/08/25 15:25:13  faber
/*  allow TIME SYNC MCMD also in active mode.
/*  This is becasue the new management of the TIMER(s) in the SOFTWARE,
/*  such that TIME SYNC MCMD doesnt affect the OBT any more.
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.9  2003/05/19 09:12:19  aurora
/*  Fixed eligibility table for TIME_SYNCHRONIZE mcmd
/*
/*  Revision 1.8  2002/11/14 09:50:59  zulia
/*  removed unsed status variable
/*
/*  Revision 1.7  2002/06/11 13:21:02  zulia
/*  promoted Eligibility of Orbital Information at Active and Maintanenance
/*
/*  Revision 1.6  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/

/*============================= Include File ================================*/
  
#include <src/ModeManager/ModeCoordinator/MC_ModeCoordinator_op.h>
#include <src/FileManager/MMSUManager/FT_MMSUManager_p.h>
#include <src/MCMDManager/MCMDArea/MA_MCMDArea_p.h>

/*****************************************************************************/
/*============================= Object variables ============================*/

/*****************************************************************************/
/* @Constant: MC_McmdAbilityExec                                             */
/* @Purpose :                                                                */
/*  Array of MC_MCMD_ABILITY_EXEC structures.                                */
/*  MCMD execution eligibility table                                         */
/*       - order is: NULL / MAINTAINANCE / ACTIVE                            */
/* @@                                                                        */
/*****************************************************************************/
const MC_MCMD_ABILITY_EXEC MC_McmdAbilityExec [] = {
    /*   NULL_MCMD               */  {{0,0,0}},
    /*   DOWN_LINK               */  {{0,1,1}},
    /*   BITE                    */  {{0,1,1}},
    /*   TEST                    */  {{0,1,1}},
    /*   PATCH                   */  {{0,1,1}},
    /*   DUMP                    */  {{0,1,1}},
    /*   REBOOT                  */  {{0,1,1}},
    /*   DIRECT                  */  {{0,1,1}},
    /*   RESET_HISTORY           */  {{0,1,1}},
    /*   DEL_MCMD_QUEUE          */  {{0,1,1}},
    /*   EXE_MEM_CONF            */  {{0,1,1}},
    /*   ABORT                   */  {{0,1,1}},
    /*   PURGE_TRD               */  {{0,1,1}}, // TBD
    /*   GAS_CONTAINER_PURGE     */  {{0,1,1}}, // TBD
    /*   CALIBRATE               */  {{0,1,1}},
    /*   SELECT_MODE             */  {{0,1,1}},
    /*   NEUTRON_DETECTOR        */  {{0,1,1}},
    /*   TIME_SYNCHRONISE        */  {{0,1,1}},
    /*   ORBITAL_INFORMATION     */  {{0,1,1}}, // TBD
    /*   INCLINATION_INFORMATION */  {{0,1,1}}}; // TBD



#if 0

/* old mode, before acceptance test */
const MC_MCMD_ABILITY_EXEC MC_McmdAbilityExec [] = {
    /*   NULL_MCMD               */  {{0,0,0}},
    /*   DOWN_LINK               */  {{0,0,1}},
    /*   BITE                    */  {{0,1,0}},
    /*   TEST                    */  {{0,1,0}},
    /*   PATCH                   */  {{0,1,0}},
    /*   DUMP                    */  {{0,1,0}},
    /*   REBOOT                  */  {{0,1,0}},
    /*   DIRECT                  */  {{0,1,1}},
    /*   RESET_HISTORY           */  {{0,1,1}},
    /*   DEL_MCMD_QUEUE          */  {{0,1,1}},
    /*   EXE_MEM_CONF            */  {{0,1,0}},
    /*   ABORT                   */  {{0,1,1}},
    /*   PURGE_TRD               */  {{0,1,1}}, // TBD
    /*   GAS_CONTAINER_PURGE     */  {{0,1,1}}, // TBD
    /*   CALIBRATE               */  {{0,1,1}},
    /*   SELECT_MODE             */  {{0,1,1}},
    /*   NEUTRON_DETECTOR        */  {{0,1,1}},
    /*   TIME_SYNCHRONISE        */  {{0,1,1}},
    /*   ORBITAL_INFORMATION     */  {{0,1,1}}, // TBD
    /*   INCLINATION_INFORMATION */  {{0,1,1}}}; // TBD

#endif

/*****************************************************************************/
/* @Constant: MC_IdxState                                                    */
/* @Purpose :                                                                */
/*  unsigned int                                                             */
/*  State of the system (MC_STATE type)                                      */
/* @@                                                                        */
/*****************************************************************************/
unsigned int   MC_IdxState;



/*****************************************************************************/

/*= M o d e C o o r d i n a t o r  O P E R A T I O N A L  F U N C T I O N S =*/

/*****************************************************************************/
/* @Function: MC_opInitModeCoordinator                                       */
/* @Purpose :                                                                */
/*  The function initializes the variables which hold the system State,      */
/*  the transition from a state to another , and the active Operational      */
/*  Mode.                                                                    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MC_opInitModeCoordinator(void)
{
unsigned int i;
    
    /* Initialize State a null                 */
    MC_IdxState       =NULL_STATE;              
    
    return (SUCCESSFUL);

}

/*****************************************************************************/
/* @Function: MC_opGetMcmdAbilityExec                                        */
/* @Purpose :                                                                */
/*  The function returns the status code with the result of the check        */
/*  performed to establish the MCDM eligibility execution.                   */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Mcmd                 IN      MCMD type                                   */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MC_opGetMcmdAbilityExec (unsigned int Mcmd)
{
status_code  status;
    
  if (Mcmd < MAX_MCMD)
  {
    /* Verify MCMD execution eligibility   */
    if (MC_McmdAbilityExec[Mcmd].State[MC_IdxState])
    {
      /* Eligibility OK            */
      status =SUCCESSFUL;
    }
    else
    {
      /* Set eligibility error     */
      status =HA_E2_ELIGIBILITY_ERR;
    }
  }
  else
  {
    /* MCMD not identified                 */
    status =HA_E10_MCMD_ERR;
  }
  return (status );
}

/*****************************************************************************/
/* @Function: MC_opSetState                                                  */
/* @Purpose :                                                                */
/*  The function sets the state of the system.                               */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  State                IN      State of the system (MC_STATE type)         */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MC_opSetState (MC_STATE State)
{
status_code status = SUCCESSFUL;

  /* Check if a valid state is selected */
  if (State>NULL_STATE && State<MAX_STATE)
  {
    /* Mode transistion with same edges have no effect*/
    if(MC_IdxState != State)
    {
      /* Perform the mode transition */
      MC_IdxState = State;
      FT_piChangeOpMode(MC_IdxState);
      
    }
  }
  else
  {
    /* State not identified   */
    status =HA_E10_STATE_ERR;
  }
  return (status);
}

/*****************************************************************************/
/* @Function: MC_opGetState                                                  */
/* @Purpose :                                                                */
/*  The function returns the current state of the system.                    */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  State                OUT     State of the system (MC_STATE type)         */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MC_opGetState (MC_STATE* State)
{

  /* Copy current system state into return variable    */
  *State =MC_IdxState;
  return (SUCCESSFUL);
}

