/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       :  MCMDManager                                                
/*  C.I. No.     :                                                           
/*  $Revision: 1.5 $
/*  $Date: 2005/02/21 08:58:29 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: MT_TTManager_op.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: sebastiani $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: MT_TTManager_op.c,v $
/*  Revision 1.5  2005/02/21 08:58:29  sebastiani
/*  all log comments completed
/*
/*  Revision 1.4  2004/09/17 15:01:00  faber
/*  LU_INFN_LOG flags fixing
/*
/*  Revision 1.3  2004/05/10 12:59:17  faber
/*  __FILEID__ right value fixed: many .c files had the wrong value!
/*
/*  Revision 1.2  2003/10/21 16:09:12  alfarano
/*  LU_LOG_INFN replacement for all remaining original log functions
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.3  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/
  
#include <src/MCMDManager/TTManager/MT_TTManager_op.h>
#include <src/MCMDManager/TTManager/MT_TTManager_int.h>

#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _MT_TTManager_op__c
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
#include <src/INFN/PRH_ParamHandler_INFN.h>
#include <src/INFN/LU_LogUtility_INFN.h>

LU_DECL_MASK();

/*============================== Local Variables ============================*/

/*****************************************************************************/
/* @Variable: MT_Twin                                                        */
/* @Purpose :                                                                */
/*   TI_TIME structure                                                       */
/*   MCMD timetag window                                                     */
/* @@                                                                        */
/*****************************************************************************/
static TI_TIME  MT_Twin;


/*****************************************************************************/

/*====== T T M a n a g e r   O P E R E T I O N A L   F U N C T I O N S ======*/

/*****************************************************************************/
/* @Function:  MT_opInitTTManager                                            */
/* @Purpose :                                                                */
/*  The function initializes the TTManager object.  The OS directive are     */
/*  called to set priority and to ready the MCMDDispatcher task. The Twin    */
/*  variable is initialized with the default value.                          */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*                      IN                                                   */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
 
status_code MT_opInitTTManager (void)
{
status_code   status;
unsigned int  OldPriority;

    status  =SUCCESSFUL;

    /* Task initialization                           */
    if (OS_piTaskReady(MT_TASK,MT_tkTTManager) != SUCCESSFUL)
    {
        /*@LOG Task is not correctly started LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_MT,HA_E10_TSK_READY_ERR,status);     */
	LU_INFN_LOG(LU_FATAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
        status  =UNSATISFIED;
    }

    if (OS_piTaskPriority( MT_TASK,TTMANAGER_PRIORITY,&OldPriority) != SUCCESSFUL)
    {

        /*@LOG Task priority is not correctly updated LOG_INFN HA_piLogHistoryEntry10(HA_E10_SW_MT,HA_E10_TSK_PRIORITY_ERR,status);     */
	LU_INFN_LOG(LU_FATAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);
        status  =UNSATISFIED;
    }

    /* Set Twin default value                        */
    MT_Twin =DEF_TWIN;

    return (status);

}



/*****************************************************************************/
/* @Function: MT_opSndMsgTTManager                                           */
/* @Purpose :                                                                */
/*  The function  invokes the directive of the OS to send a message to the   */
/*  TTManager mailbox for task operation. If the task operation is MCMD      */
/*  storing into the timetag queue, first is verified that the MCMD timetag  */
/*  is included in the defined time window and than is verified that the     */
/*  MCMD Timetag queue is not full.                                          */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  SndMsg               IN      Message buffer that contains task operation */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/
 
status_code MT_opSndMsgTTManager (MsgTsk* SndMsg)
{
status_code   status;
unsigned int  queueFullFlag;

    status =SUCCESSFUL;
    /* If task operation is MCMD timetag storing,                        */
    /* check first timetag window and queue full condition               */
    if (SndMsg->Code == MT_STORE_TIMETAG_MCMD)
    {
        /* Check if MCMD timetag is included in the defined time window  */
        status =MT_ifVerifyTimeTag ((MA_HEADER_MCMD* )SndMsg->Info, MT_Twin);
        if (status == SUCCESSFUL)
        {
            /* Check if MCMD timetag queue is full                       */
            MA_piGetMcmdTimetagQueueFull (&queueFullFlag);
            if (queueFullFlag)
            {
            	/* Timetag queue full                                    */
            	status =HA_E1_MCMD_QUEUE_FULL;
            }
        }
    }
    if (status == SUCCESSFUL)
    {
        /* Send message to TTManager mailbox for starting task operation */
        status =OS_piMsgQueueSend(MT_MAILBOX,(void*)SndMsg,sizeof(MsgTsk));
    }

    return (status);
}



/*****************************************************************************/
/* @Function: MT_tkTTManager                                                 */
/* @Purpose :                                                                */
/*  The function is the task handler of the MCMDDispatcher object.           */
/*  When a message is received into task mailbox it wakes up.                */
/*  The information contained in the message (MsgTsk structure) define       */
/*  parameters (Info field), and the operation type that the task performs   */
/*  (Code field).                                                            */
/*  The TTManager task activity is to  manage the timetag MCMD.              */
/*  The operations perform are:                                              */
/*  - Check if a MCMD timetag is expired.                                    */
/*  - Insert MCMD with timetag into the timetag list.                        */
/*  - Delete MCMDs from timetag list.                                        */
/*  - Management of the Twin parameter.                                      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

task MT_tkTTManager (task_argument unused)
{
status_code  status;
MsgTsk       RxMsg;
unsigned int MsgSize;

    
    while( FOREVER ) 
    {
        // Check mailbox queue
        RxMsg.Code =NULL_MSG_MT;
        if ((status =OS_piMsgQueueReceive(MT_MAILBOX,(void*)&RxMsg,
             &MsgSize,WAIT, NO_TIMEOUT)) == SUCCESSFUL)
        {
            switch (RxMsg.Code)
            {
                case MT_CHECK_TIMETAG:     /* Check MCMD timetag elapsed time */
                    MT_ifCheckIfTimetagIsElapsed(*(TI_TIME*)RxMsg.Info);
                    break;
                case MT_STORE_TIMETAG_MCMD:/* Store timetag MCMD              */
                    MT_ifStoreTimetagMcmd ((MA_HEADER_MCMD* )RxMsg.Info);
                    break;
                case MT_DEL_MCMD_QUEUE:    /* Delete MCMD from timetag queue  */
                    MT_ifDeleteMcmdQueue((MA_HEADER_MCMD* )RxMsg.Info);
                    break;
                default:
                break;
            }
        }
    }
}
