/****************************************************************************
 *  F i l e   D a t a                                                        
 *  $Id: formatws2.c,v 1.3 2004/10/13 11:03:20 faber Exp $
 *  $Revision: 1.3 $
 *  $Date: 2004/10/13 11:03:20 $
 *  $RCSfile: formatws2.c,v $
 *                                                                           
 ****************************************************************************
 *  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
 *                                                                           
 *  $Author: faber $
 *               :                                                           
 ****************************************************************************
 *  U p d a t i n g                                                          

 *  $Log: formatws2.c,v $
 *  Revision 1.3  2004/10/13 11:03:20  faber
 *  new format for WS2 TABLE
 *
 *  Revision 1.2  2004/10/12 12:46:43  sebastiani
 *  *** empty log message ***
 *
 *  Revision 1.1  2004/06/22 09:34:38  faber
 *  formatws2 added
 *
 *  Revision 1.1  2003/10/03 16:12:26  faber
 *  *** empty log message ***
 *
 *                                                                           
 *****************************************************************************/

#define I386




#include "../CM_Common_INFN.h"
#include "stdio.h"

//#define DEBUG

unsigned int len;

typedef struct {
  unsigned char mode;
  unsigned char time;
} RECORD;

RECORD table[1000];
unsigned short table_len=0;


int main(int argc, char *argv[]) {
  int status=0;
  unsigned int u;
  int c=1,i;

  static unsigned short int b[3000];
  int b_len;
  unsigned short int *p = b;
  unsigned short int s,u2;
  unsigned int offset=0;
  int line=0;
  char mode=0;
  char *fname;
  FILE *F;
  unsigned int written_bits=0,written_words;
  if(argc != 2) {
    fprintf(stderr,"filename missed");
    return 1;
  }
  fname = argv[1];
  F=fopen(fname,"r");
  if(F == NULL) {
    fprintf(stderr,"error opening file %s",fname);
    return 1;
  }
  
  while( c != EOF ) {
    if(status != 2) 
      c=fscanf(F,"%u\n",&u);
    else
      c=fscanf(F,"%c %u\n",&mode,&u);
    if(c == EOF)
      break;
    line++;
#ifdef DEBUG
    printf("-- status: %d line: %d - u=%u %X\n",status,line,u,u);
#endif

    u2=(unsigned short int)(u);
    switch(status) {
    case 0:
      // first line is the Absolute Moscow Time 4 BYTE integer:
      s=(unsigned short int)(u >> 16);
      CM_WRITE_NEXT_BITS_UINT16(p,offset,16,s);        written_bits+=16;
      CM_WRITE_NEXT_BITS_UINT16(p,offset,16,u2);       written_bits+=16;
      status = 1;
      break;
    case 1:
      // second line is the table number: 0..15
      if(u > 0xF) {
	fprintf(stderr,"line: %d - invalid table number: %d; allowed 0..%d",line,u,0xF);
	return 1;
      }
      CM_WRITE_NEXT_BITS_UINT16(p,offset,4,u2);       written_bits+=4;
      status =2;
      break;
    case 2:
      // record line: format <A|B> <moscow-time-offset in seconds>
      switch(mode) {
      case 'A':
      case 'a':
	table[table_len].mode = 0;
	break;
      case 'B':
      case 'b':
	table[table_len].mode = 1;
	break;
      defualt:
	fprintf(stderr,"line: %d - invalid mode number: %u\n",line,u);
	return 1;
	break;
      }

      if(u > 0xFF) {
	fprintf(stderr,"line: %d - invalid time out of range: %u",line,u);
	return 1;
      }
      table[table_len].time = u;
      table_len++;
      break;
    }
  }
  // complete writing:
  if(table_len & (0xFFFF << 10)) {
    fprintf(stderr,"line: %d - invalid table len out of range. must fit in 10 bit: %X",line,table_len);
    return 1;
  }
  CM_WRITE_NEXT_BITS_UINT16(p,offset,10,table_len);       written_bits+=10;

  for(i=0;i<table_len;i++) {
    s=table[i].mode ? 1 : 0;
    CM_WRITE_NEXT_BITS_UINT16(p,offset,1,s);
    s=table[i].time;
    if(s >> 9) {
      fprintf(stderr,"line: %d - invalid table len out of range. must fit in 10 bit: %X",line,table_len);
      return 1;
    }
    CM_WRITE_NEXT_BITS_UINT16(p,offset,8,s);

    written_bits+=9;

#ifdef DEBUG
    printf("table[%d] mode=%u time=%u %02X\n\n",i,table[i].mode,table[i].time,table[i].time);
#endif

  }
  written_words =(written_bits / 16 ) + (written_bits % 16 != 0);
  for(i=0;i<written_words;i++) {
    printf("$%X ",b[i]);
  }

#ifdef DEBUG
  printf("written bits=%d .written_words=%d\n",written_bits,written_words);
#endif
  return 0;

}
