/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : BasicSW                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2003/08/04 09:40:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: BI_Bus1553B_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: sebastiani $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: BI_Bus1553B_p.c,v $
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.4  2002/05/09 08:16:33  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/

/*============================= Include File ================================*/
  
#include <src/BasicSW/Bus1553B/BI_Bus1553B_p.h>
#include <src/BasicSW/Bus1553B/BI_Bus1553B_op.h>

/*****************************************************************************/

/*========== B u s 1 5 5 3 B   P R O V I D E D    I N T E R F A C E =========*/

/*****************************************************************************/

/*****************************************************************************/
/* @Function: BI_piInitBus1553B                                              */
/* @Purpose :                                                                */
/*  Provided Interface to set the state of init for the SuMMIT  1553         */
/*  Return code can be SUCCESSFUL or UNSATISFIED.                            */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/
status_code BI_piInitBus1553B( void )
{
    return BI_opInitBus1553B();
}


/*****************************************************************************/
/* @Function: BI_pi1553BInterruptHandler                                     */
/* @Purpose :                                                                */
/*  Provided Interface to handle 1553 interrups and to performs the high     */
/*  level protocol for macrocommands and telemetries                         */
/*  Return code can be SUCCESSFUL or UNSATISFIED.                            */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/
status_code BI_pi1553BInterruptHandler( void )
{
    return BI_op1553BInterruptHandler();
}


/*****************************************************************************/
/* @Function: BI_pi1553BWriteHistory                                         */
/* @Purpose :                                                                */
/*  Provided Interface to write History Area Logs into 1553 memory area.     */
/*  Return code can be SUCCESSFUL or UNSATISFIED.                            */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  History              IN      Buffer in RAM from where to reads the data  */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/
status_code BI_pi1553BWriteHistory(unsigned short int* History)
{
    return BI_op1553BWriteHistory(History);
}

/*****************************************************************************/
/* @Function: BI_pi1553BWriteRTFrm                                           */
/* @Purpose :                                                                */
/*  Provided Interface to write Telemetry formats into 1553 memory area.     */
/*  Return code can be SUCCESSFUL or UNSATISFIED.                            */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  tmlf                 IN      Buffer in RAM from where to reads the data  */
/*  nword16              IN      number of 16 bit words to be written        */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/
status_code BI_pi1553BWriteRTFrm(unsigned short int* tmlf, unsigned int nword16)
{
    return BI_op1553BWriteRTFrm(tmlf, nword16);
}



/*****************************************************************************/
/* @Function: BI_pi1553BWriteStatusWord                                      */
/* @Purpose :                                                                */
/*  Provided Interface to write the subsystem staus word directly into       */
/*  the 1553 exchange memory at the fixed address of subaddress TSA2.        */
/*  Return code can be SUCCESSFUL or UNSATISFIED.                            */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  status_word          IN      Input parameter of the subsys. status word  */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/
status_code BI_pi1553BWriteStatusWord(unsigned short int status_word)
{
    return BI_op1553BWriteStatusWord(status_word);
}



/*****************************************************************************/
/* @Function: BI_piGetCCAFormat                                              */
/* @Purpose :                                                                */
/*  Provided Interface to get the CCA format words.                          */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  CCABuffer            IN      CCA buffer                                  */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/
status_code BI_piGetCCAFormat (unsigned short int* CCABuffer)
{
    return BI_opGetCCAFormat(CCABuffer);
}
