/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : HKManager                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2003/08/04 09:40:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: RG_ReportGenerator_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: sebastiani $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: RG_ReportGenerator_p.c,v $
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.3  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/
  
#include <src/HKManager/ReportGenerator/RG_ReportGenerator_p.h>
#include <src/HKManager/ReportGenerator/RG_ReportGenerator_op.h>


/*****************************************************************************/

/*== R e p o r t G e n e r e t o r   P R O V I D E D    I N T E R F A C E ===*/

/*****************************************************************************/


/*****************************************************************************/
/* @Function: RG_piInitReportGenerator                                       */
/* @Purpose :                                                                */
/*  Provided Interface to initialize the Report Generator Object.            */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code RG_piInitReportGenerator (void)
{
    return RG_opInitReportGenerator();
}



/*****************************************************************************/
/* @Function: RG_piSndMsgReportGenerator                                     */
/* @Purpose :                                                                */
/*  Provided Interface to invoke a specific operation of the ReportGenerator */
/*  task.                                                                    */
/*  This is done by sending a message into ReportGenerator mailbox.          */
/*  The sent message has the following structure :                           */
/*  Structure -MsgTsk- :                                                     */
/*  Field -Code-    Code of the task operation                               */
/*  Field -Info-    Buffer that contains the task operation parameters       */
/*  Filed -LlInfo-  Parameters size.                                         */
/*  The operations code and the parameters type of the ReportGenerator       */
/*  task are the following:                                                  */
/*                                                                           */
/*     Code operation         Parameters (Type assigned to -Info- field)     */
/*     RG_RESET               Enumerated                                     */
/*     RG_PREPARE_FRM_RTR     Enumerated                                     */
/*     RG_PREPARE_FRM_RT      Enumerated                                     */
/*     RG_PREPARE_FRM_RTE     Enumerated                                     */
/*     RG_PREPARE_FRM_IDF     Enumerated                                     */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  SndMsg               IN      Pointer to task message                     */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/
status_code RG_piSndMsgReportGenerator( MsgTsk* SndMsg )
{
    return RG_opSndMsg(SndMsg);
}


/*****************************************************************************/
/* @Function: RG_piInitReportGenerator                                       */
/* @Purpose :                                                                */
/*  Provided Interface to get the acquired number of real time format.       */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* tlmcounter           OUT     buffer to retrieve the telemetry counter     */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code RG_piGetTLMRTFCounter(UWORD* tlmcounter)
{
    return RG_opGetTLMRTFCounter(tlmcounter);
}


/*****************************************************************************/
/* @Function: RG_piIncTLMRTFCounter                                          */
/* @Purpose :                                                                */
/*  Provided Interface to increment the counter of acquired real time format */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code RG_piIncTLMRTFCounter( void )
{
    return RG_opIncTLMRTFCounter();
}

/*****************************************************************************/
/* @Function: RG_piGetSubStatusWord                                          */
/* @Purpose :                                                                */
/*  Provided Interface to get the Subsystem Status Word.                     */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* ssw                  OUT     Destination buffer for the Subsystem         */
/*                              Status Word                                  */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code RG_piGetSubStatusWord(unsigned int* StatusWord)
{
    return RG_opGetSubStatusWord(StatusWord);
}

/*****************************************************************************/
/* @Function: RG_piGetTlmBuffer                                              */
/* @Purpose :                                                                */
/*  Provided Interface to get the memory address of the telemetry array      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* ssw                  OUT     Destination buffer for address of the        */
/*                              telemetry array                              */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code RG_piGetTlmBuffer(unsigned short int** tlmbuffer)
{
    return RG_opGetTlmBuffer(tlmbuffer);
}

/*****************************************************************************/
/* @Function: RG_piPrepareHeader                                             */
/* @Purpose :                                                                */
/*  Provided Interface to write the telemetry fixed header                   */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* tlmf                 OUT     Destination buffer for address of the        */
/* tlmf_type            IN      type of telemetry are the following:         */
/*                              RG_FORMAT_RTR                                */
/*                              RG_FORMAT_RT                                 */
/*                              RG_FORMAT_RTE                                */
/*                              RG_FORMAT_HA                                 */
/*                              RG_FORMAT_DUMP                               */
/*                              RG_FORMAT_IDF                                */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/
status_code RG_piPrepareHeader( UWORD* tlmf, UWORD tlmf_type )
{
   return RG_opPrepareHeader( tlmf, tlmf_type );
}
