/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       :  SRAMManager                                                
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2003/08/04 09:40:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: SM_SRAMPageManager_int.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: sebastiani $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: SM_SRAMPageManager_int.c,v $
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.4  2003/06/09 10:18:33  aurora
/*  copy data via PCMCIA with Interrupt preemption enabled
/*
/*  Revision 1.3  2002/05/09 08:16:35  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/

#include <src/SRAMManager/SRAMPageManager/SM_SRAMPageManager_int.h>
#include <src/SRAMManager/SRAMDriver/SD_SRAMDriver_p.h>

/*****************************************************************************/
/*=== S R A M P a g e M a n a g e r   I N T E R N A L   F U N C T I O N S ===*/
/*****************************************************************************/

/*****************************************************************************/
/* @Function: SM_ifCopyFromSRAM                                                  */
/* @Purpose :                                                                */
/*  The function copy Size bytes from the SRAM to the microprocessor memory  */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  SRAMStartAddr        IN      Source address in SRAM                      */
/*  RAMStartAddr         IN      Destination address in RAM                  */
/*  Size                 IN      Size of data to copy                        */
/* @@                                                                        */
/*****************************************************************************/

void SM_ifCopyFromSRAM(UINT32 SRAMStartAddr, void* RAMStartAddr, UINT32 Size)
{
BYTE* target;

  /* Init the source hbus I/O SRAM address */
  SD_piSetSRAMRWAddress(SRAMStartAddr);
  /* Init the destination RAM address*/
  target = RAMStartAddr;
  /* Copy the packet */
  while(Size--)
  {
    *target = (BYTE)SD_piReadSRAM();
    target++;
  }
}

/*****************************************************************************/
/* @Function: SM_ifCopyToSRAM                                                */
/* @Purpose :                                                                */
/*  The function copy Size bytes from the microprocessor memory to the SRAM  */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  SRAMStartAddr        IN      Destination address in SRAM                 */
/*  RAMStartAddr         IN      Source address in RAM                       */
/*  Size                 IN      Size of data to copy                        */
/* @@                                                                        */
/*****************************************************************************/

void SM_ifCopyToSRAM(UINT32 SRAMStartAddr, void* RAMStartAddr, UINT32 Size)
{
BYTE* source;
unsigned int intLevel;

  /* Init the source RAM address*/
  source = RAMStartAddr;
  /* Copy the packet */
  while(Size--)
  {
    OS_piInterDisable(&intLevel);  
    /* write the address to write and data */
    SD_piSetSRAMRWAddress(SRAMStartAddr++);  
    SD_piWriteSRAM(*source);
    source++;
    OS_piInterEnable(intLevel);    
  }
}
