/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       :  MCMDManager                                                
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2003/08/04 09:40:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: MD_MCMDDispatcher_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: sebastiani $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: MD_MCMDDispatcher_p.c,v $
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.3  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/
  
#include <src/MCMDManager/MCMDDispatcher/MD_MCMDDispatcher_p.h>
#include <src/MCMDManager/MCMDDispatcher/MD_MCMDDispatcher_op.h>


/*****************************************************************************/

/*==== M C M D i s p a t c h e r    P R O V I D E D    I N T E R F A C E ====*/

/*****************************************************************************/


/*****************************************************************************/
/* @Function: MD_piInitMCMDDispatcher                                        */
/* @Purpose :                                                                */
/*  Provided Interface to initialize the MCMDDispatcher object.              */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MD_piInitMCMDDispatcher (void)
{
status_code status;

    status =MD_opInitMCMDDispatcher();
    return (status);

}



/*****************************************************************************/
/* @Function: MD_piSndMsgMCMDDispatcher                                      */
/* @Purpose :                                                                */
/*  Provided Interface to invoke a specific operation of the MCMDDispatcher  */
/*  task.  This is done by sending a message into MCMDDispatcher mailbox.    */
/*  The sent message has the following structure :                           */
/*  Structure -MsgTsk- :                                                     */
/*  Field -Code-    Code of the task operation                               */
/*  Field -Info-    Buffer that contains the task operation parameters       */
/*  Filed -LlInfo-  Parameters size.                                         */
/*  The operations code and the parameters type of the MCMDDispatcher task   */
/*  are the following :                                                      */
/*                                                                           */
/*     Code operation     Parameters (Type assigned to -Info- field)         */
/*     MD_MCMD_EXEC       MA_HEADER_MCMD structure  (MCMD header)            */
/*/*                                                                         */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  SndMsg               IN      Pointer to task message                     */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code MD_piSndMsgMCMDDispatcher (MsgTsk* SndMsg)
{
rtems_status_code status;

    status =MD_opSndMsgMCMDDispatcher(SndMsg);
    return (status);

}
