/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       : BasicSW                                                   
/*  C.I. No.     :                                                           
/*  $Revision: 1.3 $
/*  $Date: 2004/03/10 16:21:40 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: CD_CrimeaDriver_op.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: faber $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: CD_CrimeaDriver_op.c,v $
/*  Revision 1.3  2004/03/10 16:21:40  faber
/*  more powered bugfixing about new implementation of TMTC task. In the simulator looks now to be stable.
/*
/*  Revision 1.2  2003/11/18 09:01:14  alfarano
/*  laben patch fixes some problems
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.6  2002/11/14 09:41:58  zulia
/*  Removed unused "status" variable
/*
/*  Revision 1.5  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/


/*============================= Include File ================================*/
  
#include <src/BasicSW/CrimeaDriver/CD_CrimeaDriver_op.h>

/*****************************************************************************/
/*============================= Object variables ============================*/

/*****************************************************************************/
/* @Constant: CD_CrimeaReg                                                   */
/* @Purpose :                                                                */
/*  Array of unsigned short pointer.                                         */
/*  Physical addresses of the component CRIMEA.                              */
/* @@                                                                        */
/*****************************************************************************/
const unsigned short* CD_CrimeaReg[] ={(unsigned short* )(BASE_CRIMEA + 0x0004),
                                       (unsigned short* )(BASE_CRIMEA + 0x0008), 
                                       (unsigned short* )(BASE_CRIMEA + 0x000c), 
                                       (unsigned short* )(BASE_CRIMEA + 0x0010),
                                       (unsigned short* )(BASE_CRIMEA + 0x0014),
                                       (unsigned short* )(BASE_CRIMEA + 0x0018),
                                       (unsigned short* )(BASE_CRIMEA + 0x001c),
                                       (unsigned short* )(BASE_CRIMEA + 0x0020),
                                       (unsigned short* )(BASE_CRIMEA + 0x0024),
                                       (unsigned short* )(BASE_CRIMEA + 0x0028),
                                       (unsigned short* )(BASE_CRIMEA + 0x002c),
                                       (unsigned short* )(BASE_CRIMEA + 0x0030),
                                       (unsigned short* )(BASE_CRIMEA + 0x0034),
                                       (unsigned short* )(BASE_CRIMEA + 0x0038),
                                       (unsigned short* )(BASE_CRIMEA + 0x0040),
                                       (unsigned short* )(BASE_CRIMEA + 0x0044),
                                       (unsigned short* )(BASE_CRIMEA + 0x004c),
                                       (unsigned short* )(BASE_CRIMEA + 0x0050),
                                       (unsigned short* )(BASE_CRIMEA + 0x0054),
                                       (unsigned short* )(BASE_CRIMEA + 0x0058),
                                       (unsigned short* )(BASE_CRIMEA + 0x005c),
                                       (unsigned short* )(BASE_CRIMEA + 0x0060),
                                       (unsigned short* )(BASE_CRIMEA + 0x0064),
                                       (unsigned short* )(BASE_CRIMEA + 0x0068),
                                       (unsigned short* )(BASE_CRIMEA + 0x0100),
                                       (unsigned short* )(BASE_CRIMEA + 0x0104),
                                       (unsigned short* )(BASE_CRIMEA + 0x0108),
                                       (unsigned short* )(BASE_CRIMEA + 0x010c),
                                       (unsigned short* )(BASE_CRIMEA + 0x0110),
                                       (unsigned short* )(BASE_CRIMEA + 0x0114),
                                       (unsigned short* )(BASE_CRIMEA + 0x0118),
                                       (unsigned short* )(BASE_CRIMEA + 0x011c),
                                       (unsigned short* )(BASE_CRIMEA + 0x0120),
                                       (unsigned short* )(BASE_CRIMEA + 0x0124),
                                       (unsigned short* )(BASE_CRIMEA + 0x0128),
                                       (unsigned short* )(BASE_CRIMEA + 0x012c),
                                       (unsigned short* )(BASE_CRIMEA + 0x0130),
                                       (unsigned short* )(BASE_CRIMEA + 0x0134),
                                       (unsigned short* )(BASE_CRIMEA + 0x0138),
                                       (unsigned short* )(BASE_CRIMEA + 0x013c),
                                       (unsigned short* )(BASE_CRIMEA + 0x0140),
                                       (unsigned short* )(BASE_CRIMEA + 0x0144),
                                       (unsigned short* )(BASE_CRIMEA + 0x0300),
                                       (unsigned short* )(BASE_CRIMEA + 0x0304),
                                       (unsigned short* )(BASE_CRIMEA + 0x0310),
                                       (unsigned short* )(BASE_CRIMEA + 0x0320),
                                       (unsigned short* )(BASE_CRIMEA + 0x0340)
                                };
                                
/*****************************************************************************/

/*= C D _ C r i m e a D r i v e r  O P E R A T I O N A L  F U N C T I O N S =*/

/*****************************************************************************/
/* @Function: CD_opInitCrimeaDriver                                          */
/* @Purpose :                                                                */
/*  Initialialization function of the CRIMEA component.                      */
/*  The following register are initialized:                                  */
/*  Exchange Memory Area Select register used to configure the memory access */
/*  by CPU and by SuMMIT.                                                    */
/*  PCMCIA Mode register, PCMCIA B Command register, PCMCIA B Configuration  */
/*  register used to configure the PCMCIA port B for MMSU operation.         */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* status_code          OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

status_code CD_opInitCrimeaDriver(void)
{
#ifndef SIMULATOR
  void*           p;
  unsigned short* pC;
    

  /* Program Exchange Memory Area Selection register     */
  p   =(void* )CD_CrimeaReg[EXC_MEM_AREA_SEL_REG];
  pC  =(unsigned short* )p;
  *pC =(unsigned short)CD_EXCHANG_MEMORY_AREA_CONF;

  /*===== Program PCMCIA port for MMSU operation ========*/
  /*  Setting CRIMEA wait state to zero                 */  
  p   = (void* )CD_CrimeaReg[WAIT_STATE_1553_MEM];  
  pC  = (unsigned short*)p;  
  *pC = (unsigned short)0;   
  /* PCMCIA Mode register                                */
  p   =(void* )CD_CrimeaReg[PCMCIA_MODE_REG];
  pC  =(unsigned short* )p;
  *pC =(unsigned short)CD_CARD_CONFIG;
  /* PCMCIA B Command register                           */
  p   =(void* )CD_CrimeaReg[PCMCIA_B_COMMAND_REG_0];
  pC  =(unsigned short* )p;
  *pC =(unsigned short)CD_TIMING_REGISTER_VALUE;
  /* PCMCIA B Configuration register                     */
  p   =(void* )CD_CrimeaReg[PCMCIA_B_CONFIG_REG];
  pC  =(unsigned short* )p;
  *pC =(unsigned short)CD_ADDRESS_SPACE_ENABLE;

  /* Program Interrupt Sensitivity Register CRIMEA       */
  p   =(void* )CD_CrimeaReg[INTER_SENSITIVITY_REG]; 
  pC  =(unsigned short* )p; 
  *pC =(unsigned short)CD_SENSITIVITY_VALUE; 

  /* Program Interrupt Mask Register CRIMEA              */
  p   =(void* )CD_CrimeaReg[INTER_MASK_REG_HIGH]; 
  pC  =(unsigned short* )p; 
  *pC =(unsigned short)CD_INTERRUPT_MASK; 

  /* Program SBUS90 first 64 kbytes page                  */
  p   =(void* )CD_CrimeaReg[SBUS90_ADDR_PAGE_REG]; 
  pC  =(unsigned short* )p; 
  *pC =(unsigned short)CD_SBUS90_ADDR_PAGE; 

  /* Program EEPROM wait state                            */
  p   =(void* )CD_CrimeaReg[EEPROM_WS_REG];
  pC  =(unsigned short* )p;
  *pC =(unsigned short)CD_EEPROM_WAIT_STATE;

  /* Program increase time between two PCMCIA access      */
  p   =(void* )CD_CrimeaReg[PCMCIA_B_RECOVERY_REG_0];
  pC  =(unsigned short* )p;
  *pC =(unsigned short)CD_INCREASE_TIME;
#endif // SIMULATOR
  return (SUCCESSFUL);

}


/*****************************************************************************/
/* @Function: CD_opWrCrimeaReg                                               */
/* @Purpose :                                                                */
/*  The function writes a generic CRIMEA register. A parameter value is      */
/*  written into specified CRIMEA register.                                  */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Reg                  IN      Crimea register (CD_CRIMEA_REG type)        */
/*  Value                IN      Value to write into the register            */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code CD_opWrCrimeaReg (unsigned int Reg, unsigned int Value)
{
status_code     status;
void*           p;
unsigned short* pC;
    
    /* Check CRIMEA register validity      */
    if (Reg < MAX_CRIMEA_REG)
    {
        /* Write CRIMEA register           */
        p   =(void* )CD_CrimeaReg[Reg];
        pC  =(unsigned short* )p;
        *pC =(unsigned short)Value;
        status =SUCCESSFUL;
    }
    else
    {
        status =INVALID_ADDRESS;
    }
    
    return (status);

}



/*****************************************************************************/
/* @Function: CD_opRdCrimeaReg                                               */
/* @Purpose :                                                                */
/*  The function reads a generic CRIMEA register.  A parameter value is read */
/*  form the specified CRIMEA register.                                      */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  Reg                  IN      Crimea register (CD_CRIMEA_REG type)        */
/*  Value                OUT     Value read                                  */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code CD_opRdCrimeaReg (unsigned int Reg, unsigned int* Value)
{
status_code status;

    /* Check CRIMEA register validity      */
    if (Reg < MAX_CRIMEA_REG)
    {        
        /* Read CRIMEA register            */
        *Value  =(unsigned int)*CD_CrimeaReg[Reg];
        status =SUCCESSFUL;
    }
    else
    {
        status =INVALID_ADDRESS;
    }
    return (status);

}



/*****************************************************************************/
/* @Function: CD_opGetCrimeaInterPending                                     */
/* @Purpose :                                                                */
/*  The function reads the CRIMEA Interrupt Pending value. Two register are  */
/*  read Interrupt Pending High and Interrupt Pending Low for returning a    */
/*  32 bit value.                                                            */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  InterPending         OUT     Interrupt Pending value read                */
/*  status_code          OUT     Return code (always SUCCESSFUL)             */
/* @@                                                                        */
/*****************************************************************************/

status_code CD_opGetCrimeaInterPending (unsigned int* InterPending)
{
unsigned int tmpInterPending;   
    
    /* Read Interrupt Pending High register  */
    tmpInterPending   =(unsigned int)*CD_CrimeaReg[INTER_PENDING_REG_HIGH];
    tmpInterPending <<=16;
    /* Read Interrupt Pending Low register   */
    tmpInterPending  |=(unsigned int)*CD_CrimeaReg[INTER_PENDING_REG_LOW];
    *InterPending     =tmpInterPending;
    return (SUCCESSFUL);

}


/*****************************************************************************/
/* @Function: CD_opSetCrimeaInterClear                                       */
/* @Purpose :                                                                */
/*  The function writes a 32 bit value in two register. The MSW is written   */
/*  into the CRIMEA Interrupt Clear High and the LSW into the CRIMEA         */
/*  Interrupt Clear Low register.                                            */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  InterClear           IN      Interrupt Clear value                       */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code CD_opSetCrimeaInterClear (unsigned int  InterClear)
{
void*           p;
unsigned short* pC;

    /* Write CRIMEA Interrupt Clear Low register  */ 
    p   =(void* )CD_CrimeaReg[INTER_CLEAR_REG_LOW];
    pC  =(unsigned short* )p;
    *pC  =(unsigned short)InterClear;

    /* Write CRIMEA Interrupt Clear High register */
    p   =(void* )CD_CrimeaReg[INTER_CLEAR_REG_HIGH]; 
    pC  =(unsigned short* )p; 
    *pC =(unsigned short)(InterClear >> 16);

    return (SUCCESSFUL);

}



/*****************************************************************************/
/* @Function: CD_opSetCrimeaInterMask                                        */
/* @Purpose :                                                                */
/*  The function writes a 32 bit value in two register. The MSW is written   */
/*  into the CRIMEA Interrupt Mask High and the LSW into the CRIMEA          */
/*  Interrupt Mask Low register.                                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  InterMask            IN      Interrupt mask value                        */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code CD_opSetCrimeaInterMask (unsigned int  InterMask)
{
void*           p;
unsigned short* pC;

    /* Write CRIMEA Interrupt Mask Low register  */ 
    p   =(void* )CD_CrimeaReg[INTER_MASK_REG_LOW]; 
    pC  =(unsigned short*)p; 
    *pC =(unsigned short)InterMask; 

    /* Write CRIMEA Interrupt Mask High register */ 
    p   =(void* )CD_CrimeaReg[INTER_MASK_REG_HIGH]; 
    pC  =(unsigned short* )p; 
    *pC =(unsigned short)(InterMask >> 16); 

    return (SUCCESSFUL);

}



/*****************************************************************************/
/* @Function: CD_opGetCrimeaInterMask                                        */
/* @Purpose :                                                                */
/*  The function reads a 32 bit value in two register. The MSW is read       */
/*  from the CRIMEA Interrupt Mask High and the LSW from the CRIMEA          */
/*  Interrupt Mask Low register.                                             */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*  InterMask            OUT     Interrupt mask value                        */
/*  status_code          OUT     Return code                                 */
/* @@                                                                        */
/*****************************************************************************/

status_code CD_opGetCrimeaInterMask (unsigned int*  InterMask)
{
void*           p;
unsigned short* pC;

    /* Write CRIMEA Interrupt Mask High register */ 
    p   =(void* )CD_CrimeaReg[INTER_MASK_REG_HIGH]; 
    pC  =(unsigned short* )p; 
    *InterMask   =*pC;
    *InterMask <<=16;

    /* Write CRIMEA Interrupt Mask Low register  */ 
    p   =(void* )CD_CrimeaReg[INTER_MASK_REG_LOW]; 
    pC  =(unsigned short* )p; 
    *InterMask |=(*pC & 0x0000ffff);

    return (SUCCESSFUL);

}

