/****************************************************************************
 *  F i l e   D a t a                                                        
 *  $Id: PRH_ParamHandler_INFN.c,v 1.34 2005/03/20 18:23:41 sebastiani Exp $
 *  $Revision: 1.34 $
 *  $Date: 2005/03/20 18:23:41 $
 *  $RCSfile: PRH_ParamHandler_INFN.c,v $
 *                                                                           
 ****************************************************************************
 *  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
 *                                                                           
 *  $Author: sebastiani $
 *               :                                                           
 ****************************************************************************
 *  U p d a t i n g                                                          
 *                                                                           
 *  $Log: PRH_ParamHandler_INFN.c,v $
 *  Revision 1.34  2005/03/20 18:23:41  sebastiani
 *  WS_2_ReadWS2Tables introeduced in PRH_Init
 *
 *  Revision 1.33  2005/03/06 14:54:46  sebastiani
 *  version running on 06 03 2005
 *
 *  Revision 1.32  2005/02/21 08:58:29  sebastiani
 *  all log comments completed
 *
 *  Revision 1.31  2005/02/19 10:19:38  sebastiani
 *  ALM_S4_CALIB_00_HARD,ALM_S4_CALIB_00_SOFT,ALM_S4_128TRIGGER_0 added
 *
 *  Revision 1.30  2005/01/26 18:46:48  sebastiani
 *  new bug fixes for WS
 *
 *  Revision 1.29  2004/09/28 15:36:25  sebastiani
 *  interrupt manager fix
 *
 *  Revision 1.28  2004/09/17 15:01:00  faber
 *  LU_INFN_LOG flags fixing
 *
 *  Revision 1.27  2004/09/14 15:07:08  faber
 *  New development for TimeSync, managed by interrupt. coding completed but never tested.
 *
 *  Revision 1.26  2004/08/02 09:28:29  faber
 *  Stamp management into SMH_SetParam
 *  TS_PamManger TM_RMTest moved respectively into PM and RM as PM_MCMDTest and
 *  RM_MCMDTEst. TS_Test_INFN.c will be deleted soon.
 *
 *  Revision 1.25  2004/07/20 08:58:00  faber
 *  simulator mode for EEPROM procedures
 *
 *  Revision 1.24  2004/07/12 09:51:49  faber
 *  external_data dir added with all commands inside. tgz creation rules remove.
 *  AUTO mode introduced:
 *
 *  Revision 1.23  2004/07/02 15:36:50  faber
 *  *** empty log message ***
 *
 *  Revision 1.22  2004/06/30 07:26:52  sebastiani
 *  TOF fixing,WS fixing
 *
 *  Revision 1.21  2004/06/22 09:34:52  faber
 *  *** empty log message ***
 *
 *  Revision 1.20  2004/06/16 09:35:13  faber
 *  *** empty log message ***
 *
 *  Revision 1.19  2004/06/15 08:20:11  sebastiani
 *  gen_params.pl
 *
 *  Revision 1.18  2004/06/09 11:23:22  alfarano
 *  EEPROM Formatting/Checking/Reading/writing functions. not tested
 *
 *  Revision 1.17  2004/06/08 14:02:43  alfarano
 *  eeprom functions
 *
 *  Revision 1.16  2004/06/03 08:19:23  faber
 *  compilation check about PARAM_ID == 0
 *
 *  Revision 1.15  2004/05/28 10:26:11  alfarano
 *  PARAM_ID introduced in order to check if param.pl has changed. Safe eeprom read assured.
 *
 *  Revision 1.14  2004/05/13 10:47:17  faber
 *  hid the HB_Store funcion in favour of wrapped funcions
 *
 *  Revision 1.13  2004/05/12 14:46:14  faber
 *  *** empty log message ***
 *
 *  Revision 1.12  2004/03/03 11:25:59  tassa
 *  send idaqmcmd tested
 *
 *  Revision 1.11  2004/02/26 11:27:30  faber
 *  PARAMGEN for array/tab/direct idaq command introduced. first implementation. never tested
 *
 *  Revision 1.10  2004/02/17 12:34:51  faber
 *  USERDATA2BUF USERDATA2{ARR,TAB} introduced with CRC.
 *  Never tested.
 *  Some adjustment in Logging in SHM module
 *
 *  Revision 1.9  2004/02/10 16:48:28  faber
 *  *** empty log message ***
 *
 *  Revision 1.8  2004/01/22 10:10:25  faber
 *  *** empty log message ***
 *
 *  Revision 1.7  2003/10/17 10:09:27  sebastiani
 *   PRH_ENABLE_EEPROM_SAVE introduced, scan of the select mode bugfix
 *
 *  Revision 1.6  2003/09/24 14:20:28  carota
 *  fix: SMH_GETPTR_BODYAREA call
 *
 *  Revision 1.5  2003/09/24 14:08:46  faber
 *  fix: CurPtr+=2 after SHM_GETPTR_BODYAREA in PRH_SetParam
 *
 *  Revision 1.4  2003/09/22 09:59:35  faber
 *  new select mode definitions
 *
 *  Revision 1.3  2003/09/19 15:57:35  faber
 *  Large development update INFN software
 *
 *  Revision 1.2  2003/09/12 10:57:41  faber
 *  development in proress (Working schedule module)
 *
 *  Revision 1.1.1.1  2003/08/04 09:40:22  sebastiani
 *  Imported sources laben rel. 19.06.2003 integrated with pam2
 *
 *  Revision 1.1  2003/07/18 13:35:10  sebastiani
 *  PRH_ParamHandler_INFN_int.c sobstitues PRH_ParamHandler_INFN_*.*
 *  introduced DAQTEST directive
 *
 *                                                                           
 *****************************************************************************/


/*============================= Include File ================================*/

#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _PRH_ParamHandler_INFN__c
#include <src/INFN/LU_LogUtility_INFN.h>
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
LU_DECL_MASK();


#include <src/MCMDManager/MCMDArea/MA_MCMDArea_p.h>
#include <src/BasicSW/RTEMSInterface/OS_rtems_p.h>

#include <src/INFN/SMH_SelectModeHandler_INFN.h>

#include <src/INFN/PRH_ParamHandler_INFN.h>
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
#include <src/INFN/PRH_ParamHandler_INFN_autopri.h>
#include <src/INFN/MH_ModeHandler_INFN.h>
#include <src/INFN/PM_PamManager_INFN.h>
#include <src/INFN/HB_HKBuffer_INFN.h>
#include <src/INFN/PRH_Stamp.h>
#include <src/BasicSW/PatchDumpManager/PD_PatchDumpManager_int.h>
#include <src/INFN/WS_WorkingSchedule_INFN.h>

#define PRH_IS_STAMP_OK (PRH_CurrentStamp == PRH_STAMP)
static UINT32 PRH_CurrentStamp;

/*============================ Global define ================================*/



/*============================== global types  ==============================*/



/*****************************************************************************/
/*=========================== Structure define ==============================*/


/*****************************************************************************/
/*============================ Enumerate define =============================*/

/*****************************************************************************/

/*****************************************************************************/

/*=== Param Handler  I N T E R N A L  ==*/

// special check for the Array param size of LOG_MASK

#if PRH_ARR_N_LOG_MASK < LU_FILEID_N
#error "PRH_ARR_N_LOG_MASK > LU_FILEID_N !!! - check the size of LOG_MASK in param.pl"
#endif


/*****************************************************************************/


status_code PRH_Init() {
  status_code status=SUCCESSFUL;
#ifndef SIMULATOR
  PRH_CurrentStamp = *(UINT32*)PRH_EEPROM_STAMP;
#endif SIMULATOR
  PRH_int_init_internal_structure();
#ifndef PRH_DEFAULT_MODE
  status = PRH_ReadCurrentParam();
  if(status != CM_RC_SUCCESSFUL){
    /*@LOG PRH_Init: error reading CurrentParam */
    LU_INFN_LOG(LU_WARNING|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);	    
    status = PRH_ReadDefaultParam();
    if(status != CM_RC_SUCCESSFUL){
      /*@LOG PRH_Init: error reading DefaultParam */      
      LU_INFN_LOG(LU_WARNING|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);	    
    }
    
  }
#endif

  status=WS_2_ReadWS2Tables();
  if(status != CM_RC_SUCCESSFUL){
    /*@LOG PRH_Init: error reading WS2 Tables */      
    LU_INFN_LOG(LU_WARNING|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);	    
    WS_ZeroTableWS2();
  }

  return status;
}

status_code PRH_WriteAll2EEPROM(PRH_EEPROM_REGION region) {
  unsigned int i;
  BOOL old;
  status_code s=CM_RC_SUCCESSFUL;
#ifndef SIMULATOR
  /* TBD: some check for wrong writing here */
  if (!PRH_IS_STAMP_OK)
    {
      /*@LOG WriteAll2EEPROM: Stamp is not ok */
      LU_INFN_LOG(LU_WARNING|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,0);
      return(CM_RC_BAD_EEPROM);
    }

  /* disable automatic log to avoid looging of params not stored in eeprom */
  old = PRH_int_get_automatic_log();

  PRH_int_set_automatic_log(FALSE);
  /* write variables into eeprom: */
  s = CM_RC_SUCCESSFUL;
  for(i=0;i<PRH_VAR_MAX && s == CM_RC_SUCCESSFUL; i++) 
    {
      s= PRH_int_var_write2eeprom(region,i);
      if(s==CM_RC_VAR_NOT_IN_EEPROM)
	s=CM_RC_SUCCESSFUL;
    }
  /*@LOG var eeprom write result - status*/
  LU_INFN_LOG(LU_NORMAL_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,s);
  /* write arrays into eeprom: */
  for(i=0;i<PRH_ARR_MAX &&  s == CM_RC_SUCCESSFUL;i++) 
    {
      s=PRH_int_arr_write2eeprom(region,i);
      if(s==CM_RC_ARR_NOT_IN_EEPROM)
	s=CM_RC_SUCCESSFUL;
    }
  /*@LOG arr eeprom write result - status*/
  LU_INFN_LOG(LU_NORMAL_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,s);
  /* wrtie tables into eeprom: */
  for(i=0;i<PRH_TAB_MAX && s == CM_RC_SUCCESSFUL;i++) 
    {
      s=PRH_int_tab_write2eeprom(region,i);
      if(s==CM_RC_TAB_NOT_IN_EEPROM)
	s=CM_RC_SUCCESSFUL;      
    }
  /*@LOG tab eeprom write result - status*/
  LU_INFN_LOG(LU_NORMAL_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,s);
  /* set the old log mode for the PRH module: */
  PRH_int_set_automatic_log(old);
  if(s)
    /*@LOG  eeprom write error - status*/
    LU_INFN_LOG(LU_NORMAL_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,s);
#endif // SIMULATOR
  return s;
}

status_code PRH_WriteEEPROMStamp(UINT32 stamp) {
#ifdef SIMULATOR
  return CM_RC_SUCCESSFUL;
#else
  return PRH_int_write_eeprom_and_check((void*)PRH_EEPROM_STAMP,(void*)&stamp,1);
#endif
}

status_code PRH_WriteEEPROMBootinfo(UINT32 bootinfo) {
#ifdef SIMULATOR
  return CM_RC_SUCCESSFUL;
#else
  UINT32 eeprom_value;
  status_code s;
  s=PRH_ReadEEPROMBootinfo(&eeprom_value);
  if(s != CM_RC_SUCCESSFUL)
    return s;
  if(eeprom_value != bootinfo)
    return(PRH_IS_STAMP_OK ? 
	   PRH_int_write_eeprom_and_check((void*)PRH_EEPROM_BOOTINFO,(void*)&bootinfo,1) 
	   : CM_RC_BAD_EEPROM);
  else
    return CM_RC_SUCCESSFUL;
#endif
}

status_code PRH_ReadEEPROMBootinfo(UINT32 *bootinfo) {
#ifndef SIMULATOR
  if(PRH_IS_STAMP_OK) 
    *bootinfo = *(UINT32*)PRH_EEPROM_BOOTINFO;
  else
    return CM_RC_BAD_EEPROM;
#endif
  return CM_RC_SUCCESSFUL;
}


status_code PRH_FormatEEPROM()
{
#ifndef SIMULATOR
#ifdef PRH_DEFAULT_MODE
  status_code s;
  if( (s = PRH_WriteEEPROMStamp(0)) != CM_RC_SUCCESSFUL )
    return s;
  
  PRH_CurrentStamp = PRH_STAMP; // Force check to be OK

  if( (s = PRH_WriteEEPROMBootinfo(PRH_BOOTINFO_FORMAT)) != CM_RC_SUCCESSFUL)
    return s;

  if( (s = PRH_WriteAll2EEPROM(PRH_EEPROM_CURRENT)) != CM_RC_SUCCESSFUL)
    return s;

  if( (s = PRH_WriteAll2EEPROM(PRH_EEPROM_DEFAULT)) != CM_RC_SUCCESSFUL)
    return s;

  //WS_ZeroTableWS2();
  if( (s = WS_2_WriteWS2Tables()) != CM_RC_SUCCESSFUL)
    return s;

  if( (s = PRH_WriteEEPROMStamp(PRH_STAMP)) != CM_RC_SUCCESSFUL)
    return s;

#endif  
#endif
  return CM_RC_SUCCESSFUL;
}

status_code PRH_ReadCurrentParam()
{
#ifdef SIMULATOR
  return CM_RC_SUCCESSFUL;
#else
  return(PRH_ReadAllFromEEPROM(PRH_EEPROM_CURRENT));   
#endif
}

status_code PRH_WriteCurrentParam()
{
#ifdef SIMULATOR
  return CM_RC_SUCCESSFUL;
#else
  return(PRH_WriteAll2EEPROM(PRH_EEPROM_CURRENT));   
#endif
}

status_code PRH_ReadDefaultParam()
{
#ifdef SIMULATOR
  return CM_RC_SUCCESSFUL;
#else
  return(PRH_ReadAllFromEEPROM(PRH_EEPROM_DEFAULT));   
#endif
}


status_code PRH_ReadWS2Tables(void *ws2table) {
  if(PRH_IS_STAMP_OK) 
#ifndef SIMULATOR
    memcpy(ws2table,(void*)PRH_EEPROM_WS2TABLE,WS_2_TABLES_SIZE);
#endif
  else
    return CM_RC_BAD_EEPROM;  
  return CM_RC_SUCCESSFUL;
}

status_code PRH_WriteWS2Tables(void *ws2table) {
#ifdef SIMULATOR
  return CM_RC_SUCCESSFUL;
#else
  return PRH_int_write_eeprom_and_check((void*)PRH_EEPROM_WS2TABLE,ws2table,WS_2_TABLES_DWORDS);
#endif
}


status_code PRH_ReadAllFromEEPROM(PRH_EEPROM_REGION region) {
#ifdef SIMULATOR
  return CM_RC_SUCCESSFUL;
#else
  unsigned int i;
  status_code s;
  BOOL old;

  if (!PRH_IS_STAMP_OK)
    {
      /*@LOG Stamp is not ok */
      LU_INFN_LOG(LU_WARNING|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,0);
      return(CM_RC_BAD_EEPROM);
    }

  /* disable automatic log to avoid looging of params not stored in eeprom */
  old = PRH_int_get_automatic_log();
  PRH_int_set_automatic_log(FALSE);

  
  /* read variables from eeprom: */
  s = CM_RC_SUCCESSFUL;

  for(i=0;i<PRH_VAR_MAX &&(s == CM_RC_SUCCESSFUL || s == CM_RC_VAR_NOT_IN_EEPROM);i++)
    s = PRH_int_var_read_eeprom(region,i);

  /* read arrays from eeprom: */
  for(i=0;i<PRH_ARR_MAX && (s == CM_RC_SUCCESSFUL || s == CM_RC_ARR_NOT_IN_EEPROM);i++)
    s = PRH_int_arr_read_eeprom(region,i);

  /* read tables from eeprom: */
  for(i=0;i<PRH_TAB_MAX && (s == CM_RC_SUCCESSFUL || s == CM_RC_TAB_NOT_IN_EEPROM);i++)
    s = PRH_int_tab_read_eeprom(region,i);

  /* set the old log mode for the PRH module: */
  PRH_int_set_automatic_log(old);
  return s;
#endif // SIMULATOR  

}

status_code PRH_SetParam(BYTE mode, MA_HEADER_MCMD *headerMcmd) {
  BYTE  *CurPtr;
  BYTE id,nvar,narr,ntab,i,idx,buf_no,type,tmp;
  UINT16 h,l,c,r;
  UINT16 woffset,wlen,len,crc;
  UINT32 size,stamp;
  PRH_VAR_TYPE varvalue;
  HB_BUF bufid;
  status_code s;
  unsigned char offset;
  BOOL old;
  status_code err=SUCCESSFUL;
  static unsigned int changed_var[256]; 
  static unsigned int changed_arr[256];
  static unsigned int changed_tab[256];
  err = SUCCESSFUL;

  CurPtr = (BYTE*) SMH_GETPTR_SELECTMODEBODY(headerMcmd->PtrMCMD);
  
  CM_READ_BE_UINT32(CurPtr,stamp,tmp);

  if(stamp != PRH_STAMP) {
    /*@LOG SetParam: Stamp is not ok - expected stamp */
    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,PRH_STAMP);       
    /*@LOG SetParam: Stamp is not ok - macrocommand stamp */
    LU_INFN_LOG(LU_WARNING|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,stamp);
    return CM_RC_STAMP_ERROR;
  }

  old=PRH_int_get_automatic_log();
  PRH_int_set_automatic_log(FALSE);
  type=SMH_INFN_SELECTMODE_GET_TYPE(mode);
  switch (type) {
  case SMH_SETPARAM_GEN:
    {

      CM_READ_BE_UINT8(CurPtr,nvar);
      
      // handler var 
      for(i=0;i<nvar && err==SUCCESSFUL;i++) {
	CM_READ_BE_UINT8(CurPtr,id);
	CM_READ_BE_UINT32(CurPtr,varvalue,tmp);
	err=PRH_int_set_var(id,varvalue);
	/*@LOG SMH_SETPARAM_GEN: id */
	LU_INFN_LOG(LU_DEBUG_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,id);
	/*@LOG SMH_SETPARAM_GEN: varvalue */
	LU_INFN_LOG(LU_DEBUG_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,varvalue);
	changed_var[i]=id;
      }
      
      //handler array
      if(err==SUCCESSFUL)
	CM_READ_BE_UINT8(CurPtr,narr);
      for(i=0;i<narr && err==SUCCESSFUL;i++){
	CM_READ_BE_UINT8(CurPtr,id);
#warning this have to be changed: idx should be 16 bit,but also gen_mcmds.pl must be changed!
	CM_READ_BE_UINT8(CurPtr,idx);
	CM_READ_BE_UINT32(CurPtr,varvalue,tmp);
	err=PRH_int_set_arr(id,idx,varvalue);
	/*@LOG SMH_SETPARAM_GEN: id */
	LU_INFN_LOG(LU_DEBUG_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,id);
	/*@LOG SMH_SETPARAM_GEN: idx */
	LU_INFN_LOG(LU_DEBUG_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,idx);
	/*@LOG SMH_SETPARAM_GEN: varvalue */
	LU_INFN_LOG(LU_DEBUG_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,varvalue);
	changed_arr[i]=id;
      }

      //handler table
      if(err==SUCCESSFUL)
	CM_READ_BE_UINT8(CurPtr,ntab);
      for(i=0;i<ntab && err==SUCCESSFUL;i++){
	CM_READ_BE_UINT8(CurPtr,id);
	CM_READ_BE_UINT8(CurPtr,r);
	CM_READ_BE_UINT8(CurPtr,c);
	CM_READ_BE_UINT32(CurPtr,varvalue,tmp);
	err=PRH_int_set_tab(id,r,c,varvalue);
	/*@LOG SMH_SETPARAM_GEN: id */
	LU_INFN_LOG(LU_DEBUG_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,id);
	/*@LOG SMH_SETPARAM_GEN: r */
	LU_INFN_LOG(LU_DEBUG_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,r);
	/*@LOG SMH_SETPARAM_GEN: c */
	LU_INFN_LOG(LU_DEBUG_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,c);
	/*@LOG SMH_SETPARAM_GEN: varvalue */
	LU_INFN_LOG(LU_DEBUG_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,varvalue);
	changed_tab[i]=id;
      }
    }
    break;
  case SMH_SETPARAM_ARRAY_RAW:
    break;
  case SMH_SETPARAM_TABLE_RAW:
    break;
  case SMH_SETPARAM_LOADUSERDATA:
  case SMH_SETPARAM_APPENDUSERDATA:
    CM_READ_BE_UINT8(CurPtr,buf_no);  
    CM_READ_BE_UINT16(CurPtr,len,tmp);
    /*@LOG SMH_SETPARAM_LOADUSERDATA/SMH_SETPARAM_APPENDUSERDATA: buf_no */
    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,buf_no);
    /*@LOG SMH_SETPARAM_LOADUSERDATA/SMH_SETPARAM_APPENDUSERDATA: len */
    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,len);
    if(len > headerMcmd->Length*2 - 9*2 - 1) {
      /*@LOG SMH_SETPARAM_LOADUSERDATA/SMH_SETPARAM_APPENDUSERDATA: length error ! */
      LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,0);
      s=CM_RC_MCMD_FORMAT_ERROR;
    }else{
      if(buf_no >= HB_USERDATA_NO)
	/*@LOG SMH_SETPARAM_LOADUSERDATA/SMH_SETPARAM_APPENDUSERDATA: buf_no error - buf_no */
	LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,buf_no);
      else { 
	bufid=HB_USERDATA0+buf_no;
	if(type == SMH_SETPARAM_LOADUSERDATA) {
	  s=HB_InitBuf(bufid);
	  if(s!=CM_RC_SUCCESSFUL)
	    /*@LOG SMH_SETPARAM_LOADUSERDATA: error init buffer - status */
	    LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,s);
	}
	
	// s=HB_Store(bufid,len,CurPtr,0);
	s=HB_StoreUserData(buf_no,len,CurPtr);
	if(s!=CM_RC_SUCCESSFUL)
	  /*@LOG SMH_SETPARAM_LOADUSERDATA/SMH_SETPARAM_APPENDUSERDATA: StoreUserData error - status */
	  LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,s);
      }
    }
    break;
  case SMH_SETPARAM_USERDATA2ARR:
  case SMH_SETPARAM_USERDATA2TAB:
    CM_READ_BE_UINT8(CurPtr,buf_no);
    if(buf_no >= HB_USERDATA_NO)
      /*@LOG SMH_SETPARAM_USERDATA2ARR/SMH_SETPARAM_USERDATA2TAB: buf_no error - buf_no */
      LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,buf_no);    
    else { 
      CM_READ_BE_UINT16(CurPtr,crc,tmp);
      CM_READ_BE_UINT8(CurPtr,id);
      /*@LOG SMH_SETPARAM_USERDATA2ARR/SMH_SETPARAM_USERDATA2TAB - buf_no */
      LU_INFN_LOG(LU_DEBUG_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,buf_no);
      /*@LOG SMH_SETPARAM_USERDATA2ARR/SMH_SETPARAM_USERDATA2TAB - id */
      LU_INFN_LOG(LU_DEBUG_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,id);

      bufid=HB_USERDATA0+buf_no;
      switch(type) {
      case SMH_SETPARAM_USERDATA2ARR:
	s=HB_Userdata2Arr(bufid,id,crc);
	if(s == CM_RC_SUCCESSFUL)
	  /*@LOG SMH_SETPARAM_USERDATA2ARR: - status  */
	  LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,s);    	
	break;
      case SMH_SETPARAM_USERDATA2TAB:
	s=HB_Userdata2Tab(bufid,id,crc);
	if(s == CM_RC_SUCCESSFUL) 
	  /*@LOG SMH_SETPARAM_USERDATA2TAB: - status  */
	  LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,buf_no);    
	break;
      default:
	/*@LOG SMH_SETPARAM_USERDATA2ARR/SMH_SETPARAM_USERDATA2TAB type error - type */
	LU_INFN_LOG(LU_INTERNAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,type);    
	s=CM_RC_INTERNAL_ERR;
      }
    }
    break;
  case SMH_SETPARAM_READ_DEFAULT_PARAM :
    err=PRH_ReadDefaultParam();
    /*@LOG SMH_SETPARAM_READ_DEFAULT_PARAM - status */
    LU_INFN_LOG(LU_NORMAL_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,err);
    break;  
  case SMH_SETPARAM_SAVE2EEPROM:
    err=PRH_WriteCurrentParam();
    /*@LOG SMH_SETPARAM_SAVE2EEPROM - status  */
    LU_INFN_LOG(LU_NORMAL_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,err);
    break;
  case SMH_SETPARAM_LOADWS2TABLE:
    err=WS_2_SetTable(headerMcmd);
    /*@LOG SMH_SETPARAM_LOADWS2TABLE - status */
    LU_INFN_LOG(LU_NORMAL_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,err);
    break;
  case SMH_SETPARAM_SAVEWS2TABLES:
    /* Write On EEPROM */
    err=WS_2_WriteWS2Tables();
    /*@LOG SMH_SETPARAM_LOADWS2TABLE - status */
    LU_INFN_LOG(LU_NORMAL_TRACE|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,err);
  break;
  case SMH_SETPARAM_SETLOGMASKALL:
    /* set the log mask for all modules to a specified value */
    CM_READ_BE_UINT16(CurPtr,c,tmp);
    /*@LOG SMH_SETPARAM_SETLOGMASKALL - mask value */
    LU_INFN_LOG(LU_DEBUG_TRACE,LU_MASK(__FILEID__),__FILEID__,__LINE__,c);
    LU_SetLogMaskAll(c);
  default:
    break;
  }
  PRH_int_set_automatic_log(old);
  if(err != SUCCESSFUL) {
    /*@LOG tis SetParam family SUBMODE have been failed */
    LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,type);
    /*@LOG this error occurs during SetParam family SUBMODE */
    LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,err);    
  }
  return err;
}


status_code PRH_var_write2eeprom(PRH_EEPROM_REGION region,unsigned int id) {
#ifdef SIMULATOR
  return CM_RC_SUCCESSFUL;
#else
  return (PRH_IS_STAMP_OK ? PRH_int_var_write2eeprom(region,id) : CM_RC_BAD_EEPROM);
#endif
}
status_code PRH_var_read_eeprom(PRH_EEPROM_REGION region,unsigned int id) {
#ifdef SIMULATOR
  return CM_RC_SUCCESSFUL;
#else
  return(PRH_IS_STAMP_OK ? PRH_int_var_read_eeprom(region,id): CM_RC_BAD_EEPROM);
#endif
}
status_code PRH_arr_write2eeprom(PRH_EEPROM_REGION region,unsigned int id) {
#ifdef SIMULATOR
  return CM_RC_SUCCESSFUL;
#else
  return(PRH_IS_STAMP_OK ? PRH_int_arr_write2eeprom(region,id): CM_RC_BAD_EEPROM);
#endif
}
status_code PRH_arr_read_eeprom(PRH_EEPROM_REGION region,unsigned int id) {
#ifdef SIMULATOR
  return CM_RC_SUCCESSFUL;
#else
  return(PRH_IS_STAMP_OK ?PRH_int_arr_read_eeprom(region,id): CM_RC_BAD_EEPROM);
#endif
}
status_code PRH_tab_write2eeprom(PRH_EEPROM_REGION region,unsigned int id) {
#ifdef SIMULATOR
  return CM_RC_SUCCESSFUL;
#else
  return(PRH_IS_STAMP_OK ?PRH_int_tab_write2eeprom(region,id): CM_RC_BAD_EEPROM);
#endif
}
status_code PRH_tab_read_eeprom(PRH_EEPROM_REGION region,unsigned int id) {
#ifdef SIMULATOR
  return CM_RC_SUCCESSFUL;
#else
  return(PRH_IS_STAMP_OK ?PRH_tab_read_eeprom(region,id): CM_RC_BAD_EEPROM);
#endif
}

extern UINT32 PRH_var_dump_len;
extern UINT32 PRH_arr_dump_len;
extern UINT32 PRH_tab_dump_len;

UINT32 PRH_get_var_dump_len() {
  return PRH_var_dump_len;
}
UINT32 PRH_get_arr_dump_len() {
  return PRH_arr_dump_len;
}
UINT32 PRH_get_tab_dump_len() {
  return PRH_tab_dump_len;
}

/*
status_code PRH_var_dump_for_mm(DAQ_CMD_BUF *b) {
  int i;
  BOOL mm;
  PRH_VAR_TYPE var;
  for(i=0;i<PRH_VAR_MAX;i++) {
    PRH_int_var_is_in_mm(i,&mm);
    if(mm) {
      PRH_int_get_var(i,&var);
      if(DAQ_SPACE_LEFT(*b) < PRH_SIZEOF_VAR)
	return CM_RC_NO_SPACE_LEFT;
      DAQ_WRITE_BE_UINT32((*b),var);
    }
  }
  return CM_RC_SUCCESSFUL;
}

status_code PRH_arr_dump_for_mm(DAQ_CMD_BUF *b) {
  int i;
  BOOL mm;
  PRH_VAR_TYPE *arr;
  for(i=0;i<PRH_ARR_MAX;i++) {
    PRH_int_arr_is_in_mm(i,&mm);
    if(mm) {
      PRH_int_get_arr_ptr(i,&arr);
      if(DAQ_SPACE_LEFT(*b) <= PRH_SIZEOF_ARR(i))
	return CM_RC_NO_SPACE_LEFT;
      DAQ_WRITE_BE_UINT32((*b),var);
    }
  }
  return CM_RC_SUCCESSFUL;
}

status_code PRH_tab_dump_for_mm(DAQ_CMD_BUF *b) {
}
*/
